/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.repl;

import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.cli.jvm.repl.EarlierLine;
import org.jetbrains.jet.cli.jvm.repl.ReplClassLoader;
import org.jetbrains.jet.codegen.ClassBuilderFactories;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.di.InjectorForTopDownAnalyzerForJvm;
import org.jetbrains.jet.internal.com.google.common.base.Predicates;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Pair;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.CharsetToolkit;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFileFactory;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiFileFactoryImpl;
import org.jetbrains.jet.internal.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.NamespaceLikeBuilderDummy;
import org.jetbrains.jet.lang.descriptors.ScriptDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.java.CompilerDependencies;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;
import org.jetbrains.jet.plugin.JetLanguage;
import org.jetbrains.jet.utils.ExceptionUtils;
import org.jetbrains.jet.utils.Progress;

public class ReplInterpreter {
    private int lineNumber = 0;
    @Nullable
    private JetScope lastLineScope;
    private List<EarlierLine> earlierLines = Lists.newArrayList();
    private final ReplClassLoader classLoader;
    @NotNull
    private final InjectorForTopDownAnalyzerForJvm injector;
    @NotNull
    private final JetCoreEnvironment jetCoreEnvironment;
    @NotNull
    private final BindingTraceContext trace;
    @NotNull
    private final ModuleDescriptor module;

    public ReplInterpreter(@NotNull Disposable disposable, @NotNull CompilerDependencies compilerDependencies, @NotNull List<File> extraClasspath) {
        this.jetCoreEnvironment = new JetCoreEnvironment(disposable, compilerDependencies);
        Project project = this.jetCoreEnvironment.getProject();
        this.trace = new BindingTraceContext();
        this.module = new ModuleDescriptor(Name.special("<repl>"));
        TopDownAnalysisParameters topDownAnalysisParameters = new TopDownAnalysisParameters(Predicates.<PsiFile>alwaysTrue(), false, true, Collections.<AnalyzerScriptParameter>emptyList());
        this.injector = new InjectorForTopDownAnalyzerForJvm(project, topDownAnalysisParameters, this.trace, this.module, compilerDependencies);
        ArrayList<URL> classpath = Lists.newArrayList();
        try {
            if (compilerDependencies.getRuntimeJar() != null) {
                classpath.add(compilerDependencies.getRuntimeJar().toURI().toURL());
            }
            for (File extra : extraClasspath) {
                classpath.add(extra.toURI().toURL());
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.rethrow(e);
        }
        this.classLoader = new ReplClassLoader(new URLClassLoader(classpath.toArray(new URL[0])));
    }

    public Object eval(@NotNull String line) {
        ++this.lineNumber;
        JvmClassName scriptClassName = JvmClassName.byInternalName("Line" + this.lineNumber);
        LightVirtualFile virtualFile = new LightVirtualFile("line" + this.lineNumber + ".ktscript", JetLanguage.INSTANCE, (CharSequence)line);
        virtualFile.setCharset(CharsetToolkit.UTF8_CHARSET);
        JetFile psiFile = (JetFile)((PsiFileFactoryImpl)PsiFileFactory.getInstance(this.jetCoreEnvironment.getProject())).trySetupPsiForFile(virtualFile, JetLanguage.INSTANCE, true, false);
        AnalyzingUtils.checkForSyntacticErrors(psiFile);
        this.injector.getTopDownAnalyzer().prepareForTheNextReplLine();
        ScriptDescriptor scriptDescriptor = this.doAnalyze(psiFile);
        Progress backendProgress = new Progress(){

            @Override
            public void log(String message) {
            }
        };
        ArrayList<Pair<ScriptDescriptor, JvmClassName>> earierScripts = Lists.newArrayList();
        for (EarlierLine earlierLine : this.earlierLines) {
            earierScripts.add(Pair.create(earlierLine.getScriptDescriptor(), earlierLine.getClassName()));
        }
        GenerationState generationState = new GenerationState(this.jetCoreEnvironment.getProject(), ClassBuilderFactories.binaries(false), backendProgress, AnalyzeExhaust.success(this.trace.getBindingContext(), JetStandardLibrary.getInstance()), Collections.singletonList(psiFile), this.jetCoreEnvironment.getCompilerDependencies().getCompilerSpecialMode());
        generationState.compileScript(psiFile.getScript(), scriptClassName, earierScripts, CompilationErrorHandler.THROW_EXCEPTION);
        for (String file : generationState.getFactory().files()) {
            this.classLoader.addClass(JvmClassName.byInternalName(file.replaceFirst("\\.class$", "")), generationState.getFactory().asBytes(file));
        }
        try {
            Class<?> scriptClass = this.classLoader.loadClass(scriptClassName.getFqName().getFqName());
            Class[] constructorParams = new Class[this.earlierLines.size()];
            Object[] constructorArgs = new Object[this.earlierLines.size()];
            for (int i = 0; i < this.earlierLines.size(); ++i) {
                constructorParams[i] = this.earlierLines.get(i).getScriptClass();
                constructorArgs[i] = this.earlierLines.get(i).getScriptInstance();
            }
            Constructor<?> scriptInstanceConstructor = scriptClass.getConstructor(constructorParams);
            Object scriptInstance = scriptInstanceConstructor.newInstance(constructorArgs);
            Field rvField = scriptClass.getDeclaredField("rv");
            rvField.setAccessible(true);
            Object rv = rvField.get(scriptInstance);
            this.earlierLines.add(new EarlierLine(line, scriptDescriptor, scriptClass, scriptInstance, scriptClassName));
            return rv;
        }
        catch (Throwable e) {
            PrintWriter writer = new PrintWriter(System.err);
            this.classLoader.dumpClasses(writer);
            writer.flush();
            throw ExceptionUtils.rethrow(e);
        }
    }

    private ScriptDescriptor doAnalyze(@NotNull JetFile psiFile) {
        WritableScopeImpl scope = new WritableScopeImpl(JetScope.EMPTY, this.module, new TraceBasedRedeclarationHandler(this.trace), "Root scope in analyzeNamespace");
        scope.changeLockLevel(WritableScope.LockLevel.BOTH);
        NamespaceDescriptorImpl rootNs = this.injector.getNamespaceFactory().createNamespaceDescriptorPathIfNeeded(FqName.ROOT);
        this.injector.getNamespaceFactory().createNamespaceDescriptorPathIfNeeded(JetStandardClasses.STANDARD_CLASSES_FQNAME);
        scope.importScope(rootNs.getMemberScope());
        if (this.lastLineScope != null) {
            scope.importScope(this.lastLineScope);
        }
        scope.changeLockLevel(WritableScope.LockLevel.READING);
        this.injector.getTopDownAnalyzer().doProcess(scope, new NamespaceLikeBuilderDummy(), Collections.singletonList(psiFile));
        AnalyzingUtils.throwExceptionOnErrors(this.trace.getBindingContext());
        ScriptDescriptor scriptDescriptor = this.injector.getTopDownAnalysisContext().getScripts().get(psiFile.getScript());
        this.lastLineScope = this.trace.get(BindingContext.SCRIPT_SCOPE, scriptDescriptor);
        if (this.lastLineScope == null) {
            throw new IllegalStateException("last line scope is not initialized");
        }
        return scriptDescriptor;
    }
}

