/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.repl;

import java.io.File;
import java.util.Collections;
import java.util.List;
import jline.console.ConsoleReader;
import jline.console.history.FileHistory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.jvm.repl.ReplInterpreter;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.lang.resolve.java.CompilerDependencies;
import org.jetbrains.jet.utils.ExceptionUtils;

public class ReplFromTerminal {
    private ReplInterpreter replInterpreter;
    private Throwable replInitializationFailed;
    private final Object waitRepl = new Object();
    private final ConsoleReader consoleReader;

    public ReplFromTerminal(final @NotNull Disposable disposable, final @NotNull CompilerDependencies compilerDependencies) {
        final List extraClasspath = Collections.emptyList();
        new Thread("initialize-repl"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ReplFromTerminal.this.replInterpreter = new ReplInterpreter(disposable, compilerDependencies, extraClasspath);
                }
                catch (Throwable e) {
                    ReplFromTerminal.this.replInitializationFailed = e;
                }
                Object object = ReplFromTerminal.this.waitRepl;
                synchronized (object) {
                    ReplFromTerminal.this.waitRepl.notifyAll();
                }
            }
        }.start();
        try {
            this.consoleReader = new ConsoleReader("kotlin", System.in, System.out, null);
            this.consoleReader.setHistoryEnabled(true);
            this.consoleReader.setHistory(new FileHistory(new File(new File(System.getProperty("user.home")), ".kotlin_history")));
        }
        catch (Exception e) {
            throw ExceptionUtils.rethrow(e);
        }
    }

    private ReplInterpreter getReplInterpreter() {
        if (this.replInterpreter != null) {
            return this.replInterpreter;
        }
        Object object = this.waitRepl;
        synchronized (object) {
            while (this.replInterpreter == null && this.replInitializationFailed == null) {
                try {
                    this.waitRepl.wait();
                }
                catch (Throwable e) {
                    throw ExceptionUtils.rethrow(e);
                }
            }
            if (this.replInterpreter != null) {
                return this.replInterpreter;
            }
            throw ExceptionUtils.rethrow(this.replInitializationFailed);
        }
    }

    private void doRun() {
        try {
            boolean next;
            System.out.println("Kotlin");
            while (next = this.one()) {
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.rethrow(e);
        }
        finally {
            try {
                ((FileHistory)this.consoleReader.getHistory()).flush();
            }
            catch (Exception e) {
                System.err.println("failed to flush history: " + e);
            }
        }
    }

    private boolean one() {
        try {
            String line = this.consoleReader.readLine(">>> ");
            if (line == null) {
                return false;
            }
            Object value = this.getReplInterpreter().eval(line);
            System.out.println(value);
            return true;
        }
        catch (Exception e) {
            throw ExceptionUtils.rethrow(e);
        }
    }

    public static void run(@NotNull Disposable disposable, @NotNull CompilerDependencies compilerDependencies) {
        new ReplFromTerminal(disposable, compilerDependencies).doRun();
    }
}

