/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.repl;

import java.io.PrintWriter;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.org.objectweb.asm.ClassReader;
import org.jetbrains.jet.internal.org.objectweb.asm.util.TraceClassVisitor;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;

public class ReplClassLoader
extends ClassLoader {
    private Map<JvmClassName, byte[]> classes = Maps.newLinkedHashMap();

    public ReplClassLoader(@NotNull ClassLoader parent) {
        super(parent);
    }

    public ReplClassLoader() {
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] classBytes = this.classes.get(JvmClassName.byFqNameWithoutInnerClasses(name));
        if (classBytes != null) {
            return this.defineClass(name, classBytes, 0, classBytes.length);
        }
        return super.findClass(name);
    }

    public void addClass(@NotNull JvmClassName className, @NotNull byte[] bytes) {
        byte[] oldBytes = this.classes.put(className, bytes);
        if (oldBytes != null) {
            throw new IllegalStateException("Rewrite at key " + className);
        }
    }

    public void dumpClasses(@NotNull PrintWriter writer) {
        for (byte[] classBytes : this.classes.values()) {
            new ClassReader(classBytes).accept(new TraceClassVisitor(writer), 0);
        }
    }
}

