/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.base.Predicate;
import org.jetbrains.jet.internal.com.google.common.collect.Collections2;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastServiceImpl;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeUtils;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;

public final class TipsManager {
    private TipsManager() {
    }

    @NotNull
    public static Collection<DeclarationDescriptor> getReferenceVariants(JetSimpleNameExpression expression, BindingContext context) {
        JetExpression receiverExpression = expression.getReceiverExpression();
        if (receiverExpression != null) {
            JetScope resolutionScope = context.get(BindingContext.RESOLUTION_SCOPE, expression);
            JetType expressionType = context.get(BindingContext.EXPRESSION_TYPE, receiverExpression);
            if (expressionType != null && resolutionScope != null) {
                if (!(expressionType instanceof NamespaceType)) {
                    ExpressionReceiver receiverDescriptor = new ExpressionReceiver(receiverExpression, expressionType);
                    HashSet<DeclarationDescriptor> descriptors = new HashSet<DeclarationDescriptor>();
                    DataFlowInfo info = context.get(BindingContext.NON_DEFAULT_EXPRESSION_DATA_FLOW, expression);
                    if (info == null) {
                        info = DataFlowInfo.EMPTY;
                    }
                    AutoCastServiceImpl autoCastService = new AutoCastServiceImpl(info, context);
                    List<ReceiverDescriptor> variantsForExplicitReceiver = autoCastService.getVariantsForReceiver(receiverDescriptor);
                    for (ReceiverDescriptor descriptor : variantsForExplicitReceiver) {
                        descriptors.addAll(TipsManager.includeExternalCallableExtensions(TipsManager.excludePrivateDescriptors(descriptor.getType().getMemberScope().getAllDescriptors()), resolutionScope, descriptor));
                    }
                    return descriptors;
                }
                return TipsManager.includeExternalCallableExtensions(TipsManager.excludePrivateDescriptors(expressionType.getMemberScope().getAllDescriptors()), resolutionScope, new ExpressionReceiver(receiverExpression, expressionType));
            }
            return Collections.emptyList();
        }
        return TipsManager.getVariantsNoReceiver(expression, context);
    }

    public static Collection<DeclarationDescriptor> getVariantsNoReceiver(JetExpression expression, BindingContext context) {
        JetScope resolutionScope = context.get(BindingContext.RESOLUTION_SCOPE, expression);
        if (resolutionScope != null) {
            if (expression.getParent() instanceof JetImportDirective || expression.getParent() instanceof JetNamespaceHeader) {
                return TipsManager.excludeNonPackageDescriptors(resolutionScope.getAllDescriptors());
            }
            HashSet<DeclarationDescriptor> descriptorsSet = Sets.newHashSet();
            ArrayList<ReceiverDescriptor> result = new ArrayList<ReceiverDescriptor>();
            resolutionScope.getImplicitReceiversHierarchy(result);
            for (ReceiverDescriptor receiverDescriptor : result) {
                JetType receiverType = receiverDescriptor.getType();
                descriptorsSet.addAll(receiverType.getMemberScope().getAllDescriptors());
            }
            descriptorsSet.addAll(resolutionScope.getAllDescriptors());
            return TipsManager.excludeNotCallableExtensions(TipsManager.excludePrivateDescriptors(descriptorsSet), resolutionScope);
        }
        return Collections.emptyList();
    }

    @NotNull
    public static Collection<DeclarationDescriptor> getReferenceVariants(JetNamespaceHeader expression, BindingContext context) {
        JetScope resolutionScope = context.get(BindingContext.RESOLUTION_SCOPE, expression);
        if (resolutionScope != null) {
            return TipsManager.excludeNonPackageDescriptors(resolutionScope.getAllDescriptors());
        }
        return Collections.emptyList();
    }

    public static Collection<DeclarationDescriptor> excludePrivateDescriptors(@NotNull Collection<DeclarationDescriptor> descriptors) {
        return Collections2.filter(descriptors, new Predicate<DeclarationDescriptor>(){

            @Override
            public boolean apply(@Nullable DeclarationDescriptor descriptor) {
                return descriptor != null;
            }
        });
    }

    public static Collection<DeclarationDescriptor> excludeNotCallableExtensions(@NotNull Collection<? extends DeclarationDescriptor> descriptors, @NotNull JetScope scope) {
        HashSet<? extends DeclarationDescriptor> descriptorsSet = Sets.newHashSet(descriptors);
        final ArrayList<ReceiverDescriptor> result = new ArrayList<ReceiverDescriptor>();
        scope.getImplicitReceiversHierarchy(result);
        descriptorsSet.removeAll(Collections2.filter(JetScopeUtils.getAllExtensions(scope), new Predicate<CallableDescriptor>(){

            @Override
            public boolean apply(CallableDescriptor callableDescriptor) {
                if (!callableDescriptor.getReceiverParameter().exists()) {
                    return false;
                }
                for (ReceiverDescriptor receiverDescriptor : result) {
                    if (!ExpressionTypingUtils.checkIsExtensionCallable(receiverDescriptor, callableDescriptor)) continue;
                    return false;
                }
                return true;
            }
        }));
        return Lists.newArrayList(descriptorsSet);
    }

    private static Collection<DeclarationDescriptor> excludeNonPackageDescriptors(@NotNull Collection<DeclarationDescriptor> descriptors) {
        return Collections2.filter(descriptors, new Predicate<DeclarationDescriptor>(){

            @Override
            public boolean apply(DeclarationDescriptor declarationDescriptor) {
                return declarationDescriptor instanceof NamespaceDescriptor;
            }
        });
    }

    private static Set<DeclarationDescriptor> includeExternalCallableExtensions(@NotNull Collection<DeclarationDescriptor> descriptors, @NotNull JetScope externalScope, final @NotNull ReceiverDescriptor receiverDescriptor) {
        JetType receiverType = receiverDescriptor.getType();
        if (receiverType instanceof NamespaceType) {
            return new HashSet<DeclarationDescriptor>(descriptors);
        }
        HashSet<DeclarationDescriptor> descriptorsSet = Sets.newHashSet(descriptors);
        descriptorsSet.addAll(Collections2.filter(JetScopeUtils.getAllExtensions(externalScope), new Predicate<CallableDescriptor>(){

            @Override
            public boolean apply(CallableDescriptor callableDescriptor) {
                return ExpressionTypingUtils.checkIsExtensionCallable(receiverDescriptor, callableDescriptor);
            }
        }));
        return descriptorsSet;
    }
}

