/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.List;
import jet.Function0;
import jet.modules.AllModules;
import jet.modules.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.cli.common.CompilerPlugin;
import org.jetbrains.jet.cli.common.CompilerPluginContext;
import org.jetbrains.jet.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.jvm.compiler.CommandLineScriptUtils;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.cli.jvm.compiler.K2JVMCompileEnvironmentConfiguration;
import org.jetbrains.jet.codegen.ClassBuilderFactories;
import org.jetbrains.jet.codegen.ClassFileFactory;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.GeneratedClassLoader;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.codegen.ScriptCodegen;
import org.jetbrains.jet.internal.com.google.common.base.Predicate;
import org.jetbrains.jet.internal.com.google.common.base.Predicates;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.jet.internal.com.intellij.util.LocalTimeCounter;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.java.AnalyzerFacadeForJVM;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.plugin.JetLanguage;
import org.jetbrains.jet.plugin.JetMainDetector;
import org.jetbrains.jet.utils.Progress;

public class KotlinToJVMBytecodeCompiler {
    private KotlinToJVMBytecodeCompiler() {
    }

    @Nullable
    public static ClassFileFactory compileModule(K2JVMCompileEnvironmentConfiguration configuration, Module moduleBuilder, File directory) {
        if (moduleBuilder.getSourceFiles().isEmpty()) {
            throw new CompileEnvironmentException("No source files where defined");
        }
        CompileEnvironmentUtil.addSourcesFromModuleToEnvironment(configuration.getEnvironment(), moduleBuilder, directory);
        for (String classpathRoot : moduleBuilder.getClasspathRoots()) {
            configuration.getEnvironment().addToClasspath(new File(classpathRoot));
        }
        GenerationState generationState = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(configuration);
        if (generationState == null) {
            return null;
        }
        return generationState.getFactory();
    }

    public static boolean compileModules(K2JVMCompileEnvironmentConfiguration configuration, @NotNull List<Module> modules, @NotNull File directory, @Nullable String jarPath, @Nullable String outputDir, boolean jarRuntime) {
        for (Module moduleBuilder : modules) {
            ClassFileFactory moduleFactory;
            if (configuration.getEnvironment().getCompilerDependencies().getRuntimeJar() != null) {
                CompileEnvironmentUtil.addToClasspath(configuration.getEnvironment(), configuration.getEnvironment().getCompilerDependencies().getRuntimeJar());
            }
            if ((moduleFactory = KotlinToJVMBytecodeCompiler.compileModule(configuration, moduleBuilder, directory)) == null) {
                return false;
            }
            if (outputDir != null) {
                CompileEnvironmentUtil.writeToOutputDirectory(moduleFactory, outputDir);
                continue;
            }
            String path = jarPath != null ? jarPath : new File(directory, moduleBuilder.getModuleName() + ".jar").getPath();
            try {
                CompileEnvironmentUtil.writeToJar(moduleFactory, new FileOutputStream(path), null, jarRuntime);
            }
            catch (FileNotFoundException e) {
                throw new CompileEnvironmentException("Invalid jar path " + path, e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean compileBunchOfSources(K2JVMCompileEnvironmentConfiguration configuration, String jar, String outputDir, boolean script, boolean includeRuntime) {
        GenerationState generationState;
        FqName mainClass = null;
        for (JetFile file : configuration.getEnvironment().getSourceFiles()) {
            if (!JetMainDetector.hasMain(file.getDeclarations())) continue;
            FqName fqName = JetPsiUtil.getFQName(file);
            mainClass = fqName.child(Name.identifier("namespace"));
            break;
        }
        if ((generationState = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(configuration)) == null) {
            return false;
        }
        try {
            ClassFileFactory factory = generationState.getFactory();
            if (jar != null) {
                try {
                    CompileEnvironmentUtil.writeToJar(factory, new FileOutputStream(jar), mainClass, includeRuntime);
                }
                catch (FileNotFoundException e) {
                    throw new CompileEnvironmentException("Invalid jar path " + jar, e);
                }
            } else if (outputDir != null) {
                CompileEnvironmentUtil.writeToOutputDirectory(factory, outputDir);
            } else if (script) {
                try {
                    GeneratedClassLoader classLoader = new GeneratedClassLoader(factory, (ClassLoader)new URLClassLoader(new URL[]{configuration.getEnvironment().getCompilerDependencies().getRuntimeJar().toURI().toURL()}, AllModules.class.getClassLoader()));
                    Class<?> scriptClass = classLoader.loadClass(ScriptCodegen.SCRIPT_DEFAULT_CLASS_NAME.getFqName().getFqName());
                    scriptClass.getConstructor(String[].class).newInstance(new Object[]{configuration.getScriptArgs().toArray(new String[0])});
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to evaluate script: " + e, e);
                }
            } else {
                throw new CompileEnvironmentException("Output directory or jar file is not specified - no files will be saved to the disk");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            generationState.destroy();
        }
    }

    public static boolean compileBunchOfSources(K2JVMCompileEnvironmentConfiguration configuration, List<String> sourceFilesOrDirs, String jar, String outputDir, boolean script, boolean includeRuntime) {
        for (String sourceFileOrDir : sourceFilesOrDirs) {
            configuration.getEnvironment().addSources(sourceFileOrDir);
        }
        return KotlinToJVMBytecodeCompiler.compileBunchOfSources(configuration, jar, outputDir, script, includeRuntime);
    }

    public static boolean compileBunchOfSourceDirectories(K2JVMCompileEnvironmentConfiguration configuration, List<String> sources, String jar, String outputDir, boolean script, boolean includeRuntime) {
        for (String source : sources) {
            configuration.getEnvironment().addSources(source);
        }
        return KotlinToJVMBytecodeCompiler.compileBunchOfSources(configuration, jar, outputDir, script, includeRuntime);
    }

    @Nullable
    public static ClassLoader compileText(K2JVMCompileEnvironmentConfiguration configuration, String code) {
        configuration.getEnvironment().addSources(new LightVirtualFile("script" + LocalTimeCounter.currentTime() + ".kt", JetLanguage.INSTANCE, (CharSequence)code));
        GenerationState generationState = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(configuration);
        if (generationState == null) {
            return null;
        }
        return new GeneratedClassLoader(generationState.getFactory());
    }

    @Nullable
    public static GenerationState analyzeAndGenerate(K2JVMCompileEnvironmentConfiguration configuration) {
        return KotlinToJVMBytecodeCompiler.analyzeAndGenerate(configuration, configuration.getEnvironment().getCompilerDependencies().getCompilerSpecialMode().isStubs());
    }

    @Nullable
    public static GenerationState analyzeAndGenerate(K2JVMCompileEnvironmentConfiguration configuration, boolean stubs) {
        AnalyzeExhaust exhaust = KotlinToJVMBytecodeCompiler.analyze(configuration, configuration.isScript(), stubs);
        if (exhaust == null) {
            return null;
        }
        exhaust.throwIfError();
        return KotlinToJVMBytecodeCompiler.generate(configuration, exhaust, stubs);
    }

    @Nullable
    private static AnalyzeExhaust analyze(final K2JVMCompileEnvironmentConfiguration configuration, boolean script, boolean stubs) {
        final JetCoreEnvironment environment = configuration.getEnvironment();
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(configuration.getMessageCollector());
        final Predicate filesToAnalyzeCompletely = stubs ? Predicates.alwaysFalse() : Predicates.alwaysTrue();
        final List<AnalyzerScriptParameter> scriptParameters = script ? CommandLineScriptUtils.scriptParameters() : Collections.emptyList();
        analyzerWithCompilerReport.analyzeAndReport(new Function0<AnalyzeExhaust>(){

            @Override
            @NotNull
            public AnalyzeExhaust invoke() {
                return AnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration(environment.getProject(), environment.getSourceFiles(), scriptParameters, filesToAnalyzeCompletely, configuration.getEnvironment().getCompilerDependencies());
            }
        }, environment.getSourceFiles());
        return analyzerWithCompilerReport.hasErrors() ? null : analyzerWithCompilerReport.getAnalyzeExhaust();
    }

    @NotNull
    private static GenerationState generate(final K2JVMCompileEnvironmentConfiguration configuration, AnalyzeExhaust exhaust, boolean stubs) {
        JetCoreEnvironment environment = configuration.getEnvironment();
        Project project = environment.getProject();
        Progress backendProgress = new Progress(){

            @Override
            public void log(String message) {
                configuration.getMessageCollector().report(CompilerMessageSeverity.LOGGING, message, CompilerMessageLocation.NO_LOCATION);
            }
        };
        GenerationState generationState = new GenerationState(project, ClassBuilderFactories.binaries(stubs), backendProgress, exhaust, environment.getSourceFiles(), configuration.getEnvironment().getCompilerDependencies().getCompilerSpecialMode());
        generationState.compileCorrectFiles(CompilationErrorHandler.THROW_EXCEPTION);
        List<CompilerPlugin> plugins = configuration.getCompilerPlugins();
        if (plugins != null) {
            CompilerPluginContext context = new CompilerPluginContext(project, exhaust.getBindingContext(), environment.getSourceFiles());
            for (CompilerPlugin plugin : plugins) {
                plugin.processFiles(context);
            }
        }
        return generationState;
    }
}

