/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.compiler;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.asJava.JavaElementFinder;
import org.jetbrains.jet.cli.jvm.compiler.CliJetFilesProvider;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.jet.internal.com.intellij.core.JavaCoreEnvironment;
import org.jetbrains.jet.internal.com.intellij.lang.java.JavaParserDefinition;
import org.jetbrains.jet.internal.com.intellij.mock.MockApplication;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.extensions.Extensions;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFinder;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.lang.parsing.JetParserDefinition;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.java.CompilerDependencies;
import org.jetbrains.jet.lang.resolve.java.CompilerSpecialMode;
import org.jetbrains.jet.lang.resolve.java.JetFilesProvider;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;
import org.jetbrains.jet.plugin.JetFileType;

public class JetCoreEnvironment
extends JavaCoreEnvironment {
    private final List<JetFile> sourceFiles = new ArrayList<JetFile>();
    @NotNull
    private final CompilerDependencies compilerDependencies;

    @NotNull
    public static JetCoreEnvironment getCoreEnvironmentForJS(Disposable disposable) {
        return new JetCoreEnvironment(disposable, CompilerDependencies.compilerDependenciesForProduction(CompilerSpecialMode.JS));
    }

    @NotNull
    public static JetCoreEnvironment getCoreEnvironmentForJVM(Disposable disposable, @NotNull CompilerDependencies dependencies) {
        return new JetCoreEnvironment(disposable, dependencies);
    }

    public JetCoreEnvironment(Disposable parentDisposable, @NotNull CompilerDependencies compilerDependencies) {
        super(parentDisposable);
        this.compilerDependencies = compilerDependencies;
        this.registerFileType(JetFileType.INSTANCE, "kt");
        this.registerFileType(JetFileType.INSTANCE, "kts");
        this.registerFileType(JetFileType.INSTANCE, "ktm");
        this.registerFileType(JetFileType.INSTANCE, "ktscript");
        this.registerFileType(JetFileType.INSTANCE, "jet");
        this.registerParserDefinition(new JavaParserDefinition());
        this.registerParserDefinition(new JetParserDefinition());
        this.myProject.registerService(JetFilesProvider.class, new CliJetFilesProvider(this));
        Extensions.getArea(this.myProject).getExtensionPoint(PsiElementFinder.EP_NAME).registerExtension(new JavaElementFinder(this.myProject));
        CompilerSpecialMode compilerSpecialMode = compilerDependencies.getCompilerSpecialMode();
        if (compilerSpecialMode.includeJdk()) {
            this.addToClasspath(compilerDependencies.getJdkJar());
        }
        if (compilerSpecialMode.includeJdkHeaders()) {
            for (VirtualFile root : compilerDependencies.getJdkHeaderRoots()) {
                this.addLibraryRoot(root);
            }
        }
        if (compilerSpecialMode.includeKotlinRuntime()) {
            this.addToClasspath(compilerDependencies.getRuntimeJar());
        }
        JetStandardLibrary.initialize(this.getProject());
    }

    public MockApplication getApplication() {
        return this.myApplication;
    }

    private void addSources(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            if (files != null) {
                for (File child : files) {
                    this.addSources(child);
                }
            }
        } else {
            PsiFile psiFile;
            VirtualFile fileByPath = this.getLocalFileSystem().findFileByPath(file.getAbsolutePath());
            if (fileByPath != null && (psiFile = PsiManager.getInstance(this.getProject()).findFile(fileByPath)) instanceof JetFile) {
                this.sourceFiles.add((JetFile)psiFile);
            }
        }
    }

    public void addSources(VirtualFile vFile) {
        PsiFile psiFile;
        if (vFile.isDirectory()) {
            for (VirtualFile virtualFile : vFile.getChildren()) {
                this.addSources(virtualFile);
            }
        } else if (vFile.getFileType() == JetFileType.INSTANCE && (psiFile = PsiManager.getInstance(this.getProject()).findFile(vFile)) instanceof JetFile) {
            this.sourceFiles.add((JetFile)psiFile);
        }
    }

    public void addSources(String path) {
        if (path == null) {
            return;
        }
        VirtualFile vFile = this.getLocalFileSystem().findFileByPath(path);
        if (vFile == null) {
            throw new CompileEnvironmentException("File/directory not found: " + path);
        }
        if (!vFile.isDirectory() && vFile.getFileType() != JetFileType.INSTANCE) {
            throw new CompileEnvironmentException("Not a Kotlin file: " + path);
        }
        this.addSources(new File(path));
    }

    public List<JetFile> getSourceFiles() {
        return this.sourceFiles;
    }

    public void addToClasspathFromClassLoader(ClassLoader loader) {
        ClassLoader parent = loader.getParent();
        if (parent != null) {
            this.addToClasspathFromClassLoader(parent);
        }
        if (loader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                File file = new File(url.getPath());
                if (!file.exists() || file.isFile() && !file.getPath().endsWith(".jar")) continue;
                this.addToClasspath(file);
            }
        }
    }

    @NotNull
    public CompilerDependencies getCompilerDependencies() {
        return this.compilerDependencies;
    }
}

