/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import jet.modules.AllModules;
import jet.modules.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.cli.jvm.compiler.K2JVMCompileEnvironmentConfiguration;
import org.jetbrains.jet.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.jet.cli.jvm.compiler.ModuleExecutionException;
import org.jetbrains.jet.codegen.ClassFileFactory;
import org.jetbrains.jet.codegen.GeneratedClassLoader;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Disposer;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.jet.internal.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.jet.internal.com.intellij.util.Processor;
import org.jetbrains.jet.lang.resolve.java.CompilerDependencies;
import org.jetbrains.jet.lang.resolve.java.CompilerSpecialMode;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.utils.PathUtil;

public class CompileEnvironmentUtil {
    public static Disposable createMockDisposable() {
        return new Disposable(){

            @Override
            public void dispose() {
            }
        };
    }

    @Nullable
    public static File getUnpackedRuntimePath() {
        URL url = K2JVMCompileEnvironmentConfiguration.class.getClassLoader().getResource("jet/JetObject.class");
        if (url != null && url.getProtocol().equals("file")) {
            return new File(url.getPath()).getParentFile().getParentFile();
        }
        return null;
    }

    @Nullable
    public static File getRuntimeJarPath() {
        URL url = K2JVMCompileEnvironmentConfiguration.class.getClassLoader().getResource("jet/JetObject.class");
        if (url != null && url.getProtocol().equals("jar")) {
            String path = url.getPath();
            return new File(path.substring(path.indexOf(":") + 1, path.indexOf("!/")));
        }
        return null;
    }

    public static void ensureKotlinRuntime(JetCoreEnvironment env) {
        if (JavaPsiFacade.getInstance(env.getProject()).findClass("jet.JetObject", GlobalSearchScope.allScope(env.getProject())) == null) {
            File kotlin = PathUtil.getDefaultRuntimePath();
            if (!(kotlin != null && kotlin.exists() || (kotlin = CompileEnvironmentUtil.getUnpackedRuntimePath()) != null)) {
                kotlin = CompileEnvironmentUtil.getRuntimeJarPath();
            }
            if (kotlin == null) {
                throw new IllegalStateException("kotlin runtime not found");
            }
            env.addToClasspath(kotlin);
        }
    }

    public static void ensureJdkRuntime(JetCoreEnvironment env) {
        if (JavaPsiFacade.getInstance(env.getProject()).findClass("java.lang.Object", GlobalSearchScope.allScope(env.getProject())) == null) {
            env.addToClasspath(CompileEnvironmentUtil.findRtJar());
        }
    }

    public static File findRtJar() {
        File rtJar;
        String javaHome = System.getProperty("java.home");
        if ("jre".equals(new File(javaHome).getName())) {
            javaHome = new File(javaHome).getParent();
        }
        if ((rtJar = CompileEnvironmentUtil.findRtJar(javaHome)) == null || !rtJar.exists()) {
            throw new CompileEnvironmentException("No JDK rt.jar found under " + javaHome);
        }
        return rtJar;
    }

    private static File findRtJar(String javaHome) {
        File rtJar = new File(javaHome, "jre/lib/rt.jar");
        if (rtJar.exists()) {
            return rtJar;
        }
        File classesJar = new File(new File(javaHome).getParentFile().getAbsolutePath(), "Classes/classes.jar");
        if (classesJar.exists()) {
            return classesJar;
        }
        return null;
    }

    public static List<Module> loadModuleScript(String moduleScriptFile, MessageCollector messageCollector) {
        Disposable disposable = new Disposable(){

            @Override
            public void dispose() {
            }
        };
        CompilerDependencies dependencies = CompilerDependencies.compilerDependenciesForProduction(CompilerSpecialMode.REGULAR);
        JetCoreEnvironment scriptEnvironment = JetCoreEnvironment.getCoreEnvironmentForJVM(disposable, dependencies);
        scriptEnvironment.addSources(moduleScriptFile);
        GenerationState generationState = KotlinToJVMBytecodeCompiler.analyzeAndGenerate(new K2JVMCompileEnvironmentConfiguration(scriptEnvironment, messageCollector, false, Collections.<String>emptyList()), false);
        if (generationState == null) {
            return null;
        }
        List<Module> modules = CompileEnvironmentUtil.runDefineModules(dependencies, moduleScriptFile, generationState.getFactory());
        Disposer.dispose(disposable);
        if (modules == null) {
            throw new CompileEnvironmentException("Module script " + moduleScriptFile + " compilation failed");
        }
        if (modules.isEmpty()) {
            throw new CompileEnvironmentException("No modules where defined by " + moduleScriptFile);
        }
        return modules;
    }

    private static List<Module> runDefineModules(CompilerDependencies compilerDependencies, String moduleFile, ClassFileFactory factory) {
        GeneratedClassLoader loader;
        File stdlibJar = compilerDependencies.getRuntimeJar();
        if (stdlibJar != null) {
            try {
                loader = new GeneratedClassLoader(factory, (ClassLoader)new URLClassLoader(new URL[]{stdlibJar.toURI().toURL()}, AllModules.class.getClassLoader()));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        } else {
            loader = new GeneratedClassLoader(factory, K2JVMCompileEnvironmentConfiguration.class.getClassLoader());
        }
        try {
            Class<?> namespaceClass = loader.loadClass("namespace");
            Method method = namespaceClass.getDeclaredMethod("project", new Class[0]);
            if (method == null) {
                throw new CompileEnvironmentException("Module script " + moduleFile + " must define project() function");
            }
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
            ArrayList<Module> answer = new ArrayList<Module>((Collection)AllModules.modules.get());
            AllModules.modules.get().clear();
            ArrayList<Module> arrayList = answer;
            return arrayList;
        }
        catch (Exception e) {
            throw new ModuleExecutionException(e);
        }
        finally {
            loader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToJar(ClassFileFactory factory, OutputStream fos, @Nullable FqName mainClass, boolean includeRuntime) {
        try {
            Manifest manifest = new Manifest();
            Attributes mainAttributes = manifest.getMainAttributes();
            mainAttributes.putValue("Manifest-Version", "1.0");
            mainAttributes.putValue("Created-By", "JetBrains Kotlin");
            if (mainClass != null) {
                mainAttributes.putValue("Main-Class", mainClass.getFqName());
            }
            JarOutputStream stream = new JarOutputStream(fos, manifest);
            try {
                for (String file : factory.files()) {
                    stream.putNextEntry(new JarEntry(file));
                    stream.write(factory.asBytes(file));
                }
                if (includeRuntime) {
                    CompileEnvironmentUtil.writeRuntimeToJar(stream);
                }
            }
            finally {
                stream.close();
                fos.close();
            }
        }
        catch (IOException e) {
            throw new CompileEnvironmentException("Failed to generate jar file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRuntimeToJar(final JarOutputStream stream) throws IOException {
        block8: {
            final File unpackedRuntimePath = CompileEnvironmentUtil.getUnpackedRuntimePath();
            if (unpackedRuntimePath != null) {
                FileUtil.processFilesRecursively(unpackedRuntimePath, new Processor<File>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public boolean process(File file) {
                        if (file.isDirectory()) {
                            return true;
                        }
                        String relativePath = FileUtil.getRelativePath(unpackedRuntimePath, file);
                        try {
                            stream.putNextEntry(new JarEntry(FileUtil.toSystemIndependentName(relativePath)));
                            FileInputStream fis = new FileInputStream(file);
                            try {
                                FileUtil.copy(fis, stream);
                            }
                            finally {
                                fis.close();
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        return true;
                    }
                });
            } else {
                File runtimeJarPath = CompileEnvironmentUtil.getRuntimeJarPath();
                if (runtimeJarPath != null) {
                    JarInputStream jis = new JarInputStream(new FileInputStream(runtimeJarPath));
                    try {
                        while (true) {
                            JarEntry e;
                            if ((e = jis.getNextJarEntry()) == null) {
                                break block8;
                            }
                            if (!FileUtil.getExtension(e.getName()).equals("class")) continue;
                            stream.putNextEntry(e);
                            FileUtil.copy(jis, stream);
                        }
                    }
                    finally {
                        jis.close();
                    }
                }
                throw new CompileEnvironmentException("Couldn't find runtime library");
            }
        }
    }

    public static void writeToOutputDirectory(ClassFileFactory factory, String outputDir) {
        List<String> files = factory.files();
        for (String file : files) {
            File target = new File(outputDir, file);
            try {
                FileUtil.writeToFile(target, factory.asBytes(file));
            }
            catch (IOException e) {
                throw new CompileEnvironmentException(e);
            }
        }
    }

    public static void addToClasspath(JetCoreEnvironment environment, File ... paths) {
        for (File path : paths) {
            if (!path.exists()) {
                throw new CompileEnvironmentException("'" + path + "' does not exist");
            }
            environment.addToClasspath(path);
        }
    }

    public static void addToClasspath(JetCoreEnvironment environment, String ... paths) {
        for (String path : paths) {
            CompileEnvironmentUtil.addToClasspath(environment, new File(path));
        }
    }

    public static void addSourcesFromModuleToEnvironment(@NotNull JetCoreEnvironment environment, @NotNull Module module, @NotNull File moduleDirectory) {
        for (String sourceFile : module.getSourceFiles()) {
            File source = new File(sourceFile);
            if (!source.isAbsolute()) {
                source = new File(moduleDirectory, sourceFile);
            }
            if (!source.exists()) {
                throw new CompileEnvironmentException("'" + source + "' does not exist");
            }
            environment.addSources(source.getPath());
        }
    }
}

