/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.jvm;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jet.modules.Module;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.CLICompiler;
import org.jetbrains.jet.cli.common.ExitCode;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageRenderer;
import org.jetbrains.jet.cli.common.messages.MessageUtil;
import org.jetbrains.jet.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.jet.cli.jvm.K2JVMCompilerArguments;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.cli.jvm.compiler.K2JVMCompileEnvironmentConfiguration;
import org.jetbrains.jet.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.jet.cli.jvm.repl.ReplFromTerminal;
import org.jetbrains.jet.codegen.CompilationException;
import org.jetbrains.jet.internal.com.google.common.base.Splitter;
import org.jetbrains.jet.internal.com.google.common.collect.Iterables;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.lang.resolve.java.CompilerDependencies;
import org.jetbrains.jet.lang.resolve.java.CompilerSpecialMode;
import org.jetbrains.jet.utils.PathUtil;

public class K2JVMCompiler
extends CLICompiler<K2JVMCompilerArguments, K2JVMCompileEnvironmentConfiguration> {
    public static void main(String ... args) {
        K2JVMCompiler.doMain(new K2JVMCompiler(), args);
    }

    @Override
    @NotNull
    protected ExitCode doExecute(K2JVMCompilerArguments arguments, PrintingMessageCollector messageCollector, Disposable rootDisposable) {
        CompilerSpecialMode mode = K2JVMCompiler.parseCompilerSpecialMode(arguments);
        File jdkHeadersJar = mode.includeJdkHeaders() ? (arguments.jdkHeaders != null ? new File(arguments.jdkHeaders) : PathUtil.getAltHeadersPath()) : null;
        File runtimeJar = mode.includeKotlinRuntime() ? (arguments.stdlib != null ? new File(arguments.stdlib) : PathUtil.getDefaultRuntimePath()) : null;
        CompilerDependencies dependencies = new CompilerDependencies(mode, CompilerDependencies.findRtJar(), jdkHeadersJar, runtimeJar);
        List<String> argumentsSourceDirs = arguments.getSourceDirs();
        if (!arguments.script && arguments.module == null && arguments.src == null && arguments.freeArgs.isEmpty() && (argumentsSourceDirs == null || argumentsSourceDirs.size() == 0)) {
            ReplFromTerminal.run(rootDisposable, dependencies);
            return ExitCode.OK;
        }
        JetCoreEnvironment environment = JetCoreEnvironment.getCoreEnvironmentForJVM(rootDisposable, dependencies);
        List<String> scriptArgs = arguments.script ? arguments.freeArgs.subList(1, arguments.freeArgs.size()) : Collections.emptyList();
        K2JVMCompileEnvironmentConfiguration configuration = new K2JVMCompileEnvironmentConfiguration(environment, messageCollector, arguments.script, scriptArgs);
        messageCollector.report(CompilerMessageSeverity.LOGGING, "Configuring the compilation environment", CompilerMessageLocation.NO_LOCATION);
        try {
            boolean noErrors;
            this.configureEnvironment(configuration, arguments);
            if (arguments.module != null) {
                boolean oldVerbose = messageCollector.isVerbose();
                messageCollector.setVerbose(false);
                List<Module> modules = CompileEnvironmentUtil.loadModuleScript(arguments.module, messageCollector);
                messageCollector.setVerbose(oldVerbose);
                File directory = new File(arguments.module).getParentFile();
                noErrors = KotlinToJVMBytecodeCompiler.compileModules(configuration, modules, directory, arguments.jar, arguments.outputDir, arguments.includeRuntime);
            } else if (arguments.getSourceDirs() != null) {
                noErrors = KotlinToJVMBytecodeCompiler.compileBunchOfSourceDirectories(configuration, arguments.getSourceDirs(), arguments.jar, arguments.outputDir, arguments.script, arguments.includeRuntime);
            } else {
                ArrayList<String> sources = Lists.newArrayList();
                if (arguments.src != null) {
                    sources.add(arguments.src);
                }
                if (arguments.script) {
                    sources.add((String)arguments.freeArgs.get(0));
                } else {
                    sources.addAll(arguments.freeArgs);
                }
                noErrors = KotlinToJVMBytecodeCompiler.compileBunchOfSources(configuration, sources, arguments.jar, arguments.outputDir, arguments.script, arguments.includeRuntime);
            }
            return noErrors ? ExitCode.OK : ExitCode.COMPILATION_ERROR;
        }
        catch (CompilationException e) {
            messageCollector.report(CompilerMessageSeverity.EXCEPTION, MessageRenderer.PLAIN.renderException(e), MessageUtil.psiElementToMessageLocation(e.getElement()));
            return ExitCode.INTERNAL_ERROR;
        }
        catch (Throwable t) {
            messageCollector.report(CompilerMessageSeverity.EXCEPTION, MessageRenderer.PLAIN.renderException(t), CompilerMessageLocation.NO_LOCATION);
            return ExitCode.INTERNAL_ERROR;
        }
    }

    @NotNull
    private static CompilerSpecialMode parseCompilerSpecialMode(@NotNull K2JVMCompilerArguments arguments) {
        if (arguments.mode == null) {
            return CompilerSpecialMode.REGULAR;
        }
        for (CompilerSpecialMode variant : CompilerSpecialMode.values()) {
            if (!arguments.mode.equalsIgnoreCase(variant.name().replaceAll("_", ""))) continue;
            return variant;
        }
        throw new IllegalArgumentException("unknown compiler mode: " + arguments.mode);
    }

    @Override
    @NotNull
    protected K2JVMCompilerArguments createArguments() {
        return new K2JVMCompilerArguments();
    }

    @Override
    @NotNull
    public ExitCode exec(PrintStream errStream, K2JVMCompilerArguments arguments) {
        return super.exec(errStream, arguments);
    }

    @Override
    protected void configureEnvironment(@NotNull K2JVMCompileEnvironmentConfiguration configuration, @NotNull K2JVMCompilerArguments arguments) {
        super.configureEnvironment(configuration, arguments);
        if (configuration.getEnvironment().getCompilerDependencies().getRuntimeJar() != null) {
            CompileEnvironmentUtil.addToClasspath(configuration.getEnvironment(), configuration.getEnvironment().getCompilerDependencies().getRuntimeJar());
        }
        if (arguments.classpath != null) {
            Iterable<String> classpath = Splitter.on(File.pathSeparatorChar).split(arguments.classpath);
            CompileEnvironmentUtil.addToClasspath(configuration.getEnvironment(), Iterables.toArray(classpath, String.class));
        }
    }
}

