/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.js;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.jet.cli.common.CompilerArguments;
import org.jetbrains.jet.internal.com.sampullara.cli.Argument;
import org.jetbrains.k2js.facade.MainCallParameters;

public class K2JSCompilerArguments
extends CompilerArguments {
    @Argument(value="output", description="Output file path")
    public String outputFile;
    @Argument(value="libzip", description="Path to zipped lib sources")
    public String libzip;
    @Argument(value="srcdir", description="Sources directory")
    public String srcdir;
    @Argument(value="target", description="Generate js files for specific ECMA version (3 or 5, default ECMA 3)")
    public String target;
    @Argument(value="tags", description="Demarcate each compilation message (error, warning, etc) with an open and close tag")
    public boolean tags;
    @Argument(value="verbose", description="Enable verbose logging output")
    public boolean verbose;
    @Argument(value="version", description="Display compiler version")
    public boolean version;
    @Argument(value="mainCall", description="Whether a main function should be invoked; either 'main' or 'mainWithArgs'")
    public String mainCall;
    @Argument(value="help", alias="h", description="Show help")
    public boolean help;
    public List<String> sourceFiles;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public boolean isTags() {
        return this.tags;
    }

    @Override
    public boolean isVersion() {
        return this.version;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public String getSrc() {
        if (this.sourceFiles != null) {
            return this.sourceFiles.toString();
        }
        return this.srcdir;
    }

    public MainCallParameters createMainCallParameters() {
        if (this.mainCall != null) {
            if (this.mainCall.equals("main")) {
                return MainCallParameters.mainWithoutArguments();
            }
            if (this.mainCall.equals("mainWithArgs")) {
                return MainCallParameters.mainWithArguments(new ArrayList<String>());
            }
        }
        return MainCallParameters.noCall();
    }
}

