/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.js;

import java.util.List;
import jet.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.cli.common.CLICompiler;
import org.jetbrains.jet.cli.common.ExitCode;
import org.jetbrains.jet.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.jet.cli.js.K2JSCompileEnvironmentConfiguration;
import org.jetbrains.jet.cli.js.K2JSCompilerArguments;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.internal.com.google.common.base.Function;
import org.jetbrains.jet.internal.com.google.common.base.Joiner;
import org.jetbrains.jet.internal.com.google.common.base.Predicates;
import org.jetbrains.jet.internal.com.google.common.collect.Iterables;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.k2js.analyze.AnalyzerFacadeForJS;
import org.jetbrains.k2js.config.ClassPathLibraryDefintionsConfig;
import org.jetbrains.k2js.config.ClassPathLibrarySourcesLoader;
import org.jetbrains.k2js.config.Config;
import org.jetbrains.k2js.config.EcmaVersion;
import org.jetbrains.k2js.config.ZippedLibrarySourcesConfig;
import org.jetbrains.k2js.facade.K2JSTranslator;
import org.jetbrains.k2js.facade.MainCallParameters;

public class K2JSCompiler
extends CLICompiler<K2JSCompilerArguments, K2JSCompileEnvironmentConfiguration> {
    public static void main(String ... args) {
        K2JSCompiler.doMain(new K2JSCompiler(), args);
    }

    @Override
    @NotNull
    protected K2JSCompilerArguments createArguments() {
        return new K2JSCompilerArguments();
    }

    @Override
    @NotNull
    protected ExitCode doExecute(K2JSCompilerArguments arguments, PrintingMessageCollector messageCollector, Disposable rootDisposable) {
        if (arguments.srcdir == null && arguments.sourceFiles == null) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Specify sources location via -srcdir", CompilerMessageLocation.NO_LOCATION);
            return ExitCode.INTERNAL_ERROR;
        }
        JetCoreEnvironment environmentForJS = JetCoreEnvironment.getCoreEnvironmentForJS(rootDisposable);
        if (arguments.srcdir != null) {
            environmentForJS.addSources(arguments.srcdir);
        }
        if (arguments.sourceFiles != null) {
            for (String sourceFile : arguments.sourceFiles) {
                environmentForJS.addSources(sourceFile);
            }
        }
        Project project = environmentForJS.getProject();
        ClassPathLibrarySourcesLoader sourceLoader = new ClassPathLibrarySourcesLoader(project);
        List<JetFile> sourceFiles = sourceLoader.findSourceFiles();
        environmentForJS.getSourceFiles().addAll(sourceFiles);
        if (arguments.isVerbose()) {
            K2JSCompiler.reportCompiledSourcesList(messageCollector, environmentForJS);
        }
        Config config = K2JSCompiler.getConfig(arguments, project);
        if (K2JSCompiler.analyzeAndReportErrors(messageCollector, environmentForJS.getSourceFiles(), config)) {
            return ExitCode.COMPILATION_ERROR;
        }
        String outputFile = arguments.outputFile;
        if (outputFile == null) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Specify output file via -output", CompilerMessageLocation.NO_LOCATION);
            return ExitCode.INTERNAL_ERROR;
        }
        MainCallParameters mainCallParameters = arguments.createMainCallParameters();
        return K2JSCompiler.translateAndGenerateOutputFile(mainCallParameters, messageCollector, environmentForJS, config, outputFile);
    }

    private static void reportCompiledSourcesList(@NotNull PrintingMessageCollector messageCollector, @NotNull JetCoreEnvironment environmentForJS) {
        Iterable<String> fileNames = Iterables.transform(environmentForJS.getSourceFiles(), new Function<JetFile, String>(){

            @Override
            public String apply(@Nullable JetFile file) {
                assert (file != null);
                return file.getName();
            }
        });
        messageCollector.report(CompilerMessageSeverity.LOGGING, "Compiling source files: " + Joiner.on(", ").join(fileNames), CompilerMessageLocation.NO_LOCATION);
    }

    @NotNull
    private static ExitCode translateAndGenerateOutputFile(@NotNull MainCallParameters mainCall, @NotNull PrintingMessageCollector messageCollector, @NotNull JetCoreEnvironment environmentForJS, @NotNull Config config, @NotNull String outputFile) {
        try {
            K2JSTranslator.translateWithMainCallParametersAndSaveToFile(mainCall, environmentForJS.getSourceFiles(), outputFile, config);
        }
        catch (Exception e) {
            messageCollector.report(CompilerMessageSeverity.ERROR, "Exception while translating:\n" + e.getMessage(), CompilerMessageLocation.NO_LOCATION);
            return ExitCode.INTERNAL_ERROR;
        }
        return ExitCode.OK;
    }

    private static boolean analyzeAndReportErrors(@NotNull PrintingMessageCollector messageCollector, final @NotNull List<JetFile> sources, final @NotNull Config config) {
        AnalyzerWithCompilerReport analyzerWithCompilerReport = new AnalyzerWithCompilerReport(messageCollector);
        analyzerWithCompilerReport.analyzeAndReport(new Function0<AnalyzeExhaust>(){

            @Override
            public AnalyzeExhaust invoke() {
                return AnalyzerFacadeForJS.analyzeFiles(sources, Predicates.<PsiFile>alwaysTrue(), config);
            }
        }, sources);
        return analyzerWithCompilerReport.hasErrors();
    }

    @NotNull
    private static Config getConfig(@NotNull K2JSCompilerArguments arguments, @NotNull Project project) {
        EcmaVersion ecmaVersion = EcmaVersion.fromString(arguments.target);
        if (arguments.libzip == null) {
            return new ClassPathLibraryDefintionsConfig(project, ecmaVersion);
        }
        return new ZippedLibrarySourcesConfig(project, arguments.libzip, ecmaVersion);
    }
}

