/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.messages;

import java.io.PrintStream;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.common.messages.MessageRenderer;
import org.jetbrains.jet.internal.com.google.common.collect.LinkedHashMultimap;
import org.jetbrains.jet.internal.com.google.common.collect.Multimap;

public class PrintingMessageCollector
implements MessageCollector {
    private boolean verbose;
    private final PrintStream errStream;
    private final MessageRenderer messageRenderer;
    private final Multimap<String, String> groupedMessages = LinkedHashMultimap.create();

    public PrintingMessageCollector(PrintStream errStream, MessageRenderer messageRenderer, boolean verbose) {
        this.verbose = verbose;
        this.errStream = errStream;
        this.messageRenderer = messageRenderer;
    }

    @Override
    public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
        String text = this.messageRenderer.render(severity, message, location);
        if (severity == CompilerMessageSeverity.LOGGING) {
            if (!this.verbose) {
                return;
            }
            this.errStream.println(text);
        }
        this.groupedMessages.put(location.getPath(), text);
    }

    public void printToErrStream() {
        if (!this.groupedMessages.isEmpty()) {
            for (String path : this.groupedMessages.keySet()) {
                Collection<String> messageTexts = this.groupedMessages.get(path);
                for (String text : messageTexts) {
                    this.errStream.println(text);
                }
            }
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

