/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.messages;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;

public interface MessageRenderer {
    public static final MessageRenderer TAGS = new MessageRenderer(){

        @Override
        public String renderPreamble() {
            return "<MESSAGES>";
        }

        @Override
        public String render(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
            StringBuilder out = new StringBuilder();
            out.append("<").append(severity.toString());
            if (location.getPath() != null) {
                out.append(" path=\"").append(this.e(location.getPath())).append("\"");
                out.append(" line=\"").append(location.getLine()).append("\"");
                out.append(" column=\"").append(location.getColumn()).append("\"");
            }
            out.append(">");
            out.append(this.e(message));
            out.append("</").append(severity.toString()).append(">\n");
            return out.toString();
        }

        private String e(String str) {
            return StringUtil.escapeXml(str);
        }

        @Override
        public String renderException(@NotNull Throwable e) {
            return this.render(CompilerMessageSeverity.EXCEPTION, PLAIN.renderException(e), CompilerMessageLocation.NO_LOCATION);
        }

        @Override
        public String renderConclusion() {
            return "</MESSAGES>";
        }
    };
    public static final MessageRenderer PLAIN = new MessageRenderer(){

        @Override
        public String renderPreamble() {
            return "";
        }

        @Override
        public String render(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
            String path = location.getPath();
            String position = path == null ? "" : path + ": (" + location.getLine() + ", " + location.getColumn() + ") ";
            return (Object)((Object)severity) + ": " + position + message;
        }

        @Override
        public String renderException(@NotNull Throwable e) {
            StringWriter out = new StringWriter();
            e.printStackTrace(new PrintWriter(out));
            return out.toString();
        }

        @Override
        public String renderConclusion() {
            return "";
        }
    };

    public String renderPreamble();

    public String render(@NotNull CompilerMessageSeverity var1, @NotNull String var2, @NotNull CompilerMessageLocation var3);

    public String renderException(@NotNull Throwable var1);

    public String renderConclusion();
}

