/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common.messages;

import java.util.Collection;
import jet.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.internal.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiErrorElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.diagnostics.Severity;
import org.jetbrains.jet.lang.diagnostics.SimpleDiagnostic;
import org.jetbrains.jet.lang.diagnostics.SimpleDiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.rendering.DefaultErrorMessages;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;

public final class AnalyzerWithCompilerReport {
    @NotNull
    private static final SimpleDiagnosticFactory<PsiErrorElement> SYNTAX_ERROR_FACTORY = SimpleDiagnosticFactory.create(Severity.ERROR);
    private boolean hasErrors = false;
    @NotNull
    private final MessageCollector messageCollectorWrapper;
    @Nullable
    private AnalyzeExhaust analyzeExhaust = null;

    @NotNull
    private static CompilerMessageSeverity convertSeverity(@NotNull Severity severity) {
        switch (severity) {
            case INFO: {
                return CompilerMessageSeverity.INFO;
            }
            case ERROR: {
                return CompilerMessageSeverity.ERROR;
            }
            case WARNING: {
                return CompilerMessageSeverity.WARNING;
            }
        }
        throw new IllegalStateException("Unknown severity: " + (Object)((Object)severity));
    }

    public AnalyzerWithCompilerReport(final @NotNull MessageCollector collector) {
        this.messageCollectorWrapper = new MessageCollector(){

            @Override
            public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
                if (CompilerMessageSeverity.ERRORS.contains((Object)severity)) {
                    AnalyzerWithCompilerReport.this.hasErrors = true;
                }
                collector.report(severity, message, location);
            }
        };
    }

    private void reportDiagnostic(@NotNull Diagnostic diagnostic) {
        if (!diagnostic.isValid()) {
            return;
        }
        DiagnosticUtils.LineAndColumn lineAndColumn = DiagnosticUtils.getLineAndColumn(diagnostic);
        VirtualFile virtualFile = diagnostic.getPsiFile().getVirtualFile();
        String path = virtualFile == null ? null : virtualFile.getPath();
        String render = diagnostic.getFactory() == SYNTAX_ERROR_FACTORY ? ((SyntaxErrorDiagnostic)diagnostic).message : DefaultErrorMessages.RENDERER.render(diagnostic);
        this.messageCollectorWrapper.report(AnalyzerWithCompilerReport.convertSeverity(diagnostic.getSeverity()), render, CompilerMessageLocation.create(path, lineAndColumn.getLine(), lineAndColumn.getColumn()));
    }

    private void reportIncompleteHierarchies() {
        assert (this.analyzeExhaust != null);
        Collection<ClassDescriptor> incompletes = this.analyzeExhaust.getBindingContext().getKeys(BindingContext.INCOMPLETE_HIERARCHY);
        if (!incompletes.isEmpty()) {
            StringBuilder message = new StringBuilder("The following classes have incomplete hierarchies:\n");
            for (ClassDescriptor incomplete : incompletes) {
                String fqName = DescriptorUtils.getFQName(incomplete).getFqName();
                message.append("    ").append(fqName).append("\n");
            }
            this.messageCollectorWrapper.report(CompilerMessageSeverity.ERROR, message.toString(), CompilerMessageLocation.NO_LOCATION);
        }
    }

    private void reportDiagnostics() {
        assert (this.analyzeExhaust != null);
        for (Diagnostic diagnostic : this.analyzeExhaust.getBindingContext().getDiagnostics()) {
            this.reportDiagnostic(diagnostic);
        }
    }

    private void reportSyntaxErrors(@NotNull Collection<JetFile> files) {
        for (JetFile file : files) {
            file.accept(new PsiRecursiveElementWalkingVisitor(){

                @Override
                public void visitErrorElement(PsiErrorElement element) {
                    String description = element.getErrorDescription();
                    String message = StringUtil.isEmpty(description) ? "Syntax error" : description;
                    SyntaxErrorDiagnostic diagnostic = new SyntaxErrorDiagnostic(element, Severity.ERROR, message);
                    AnalyzerWithCompilerReport.this.reportDiagnostic(diagnostic);
                }
            });
        }
    }

    @Nullable
    public AnalyzeExhaust getAnalyzeExhaust() {
        return this.analyzeExhaust;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public void analyzeAndReport(@NotNull Function0<AnalyzeExhaust> analyzer, @NotNull Collection<JetFile> files) {
        this.reportSyntaxErrors(files);
        this.analyzeExhaust = analyzer.invoke();
        this.reportDiagnostics();
        this.reportIncompleteHierarchies();
    }

    public static class SyntaxErrorDiagnostic
    extends SimpleDiagnostic<PsiErrorElement> {
        private String message;

        public SyntaxErrorDiagnostic(@NotNull PsiErrorElement psiElement, @NotNull Severity severity, String message) {
            super(psiElement, SYNTAX_ERROR_FACTORY, severity);
            this.message = message;
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }
}

