/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.cli.common;

import java.io.PrintStream;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.cli.common.CompileEnvironmentConfiguration;
import org.jetbrains.jet.cli.common.CompilerArguments;
import org.jetbrains.jet.cli.common.CompilerPlugin;
import org.jetbrains.jet.cli.common.ExitCode;
import org.jetbrains.jet.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.jet.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.jet.cli.common.messages.MessageRenderer;
import org.jetbrains.jet.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.jet.internal.com.intellij.openapi.Disposable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Disposer;
import org.jetbrains.jet.internal.com.sampullara.cli.Args;

public abstract class CLICompiler<A extends CompilerArguments, C extends CompileEnvironmentConfiguration> {
    @NotNull
    public ExitCode exec(@NotNull PrintStream errStream, String ... args) {
        A arguments = this.createArguments();
        if (!this.parseArguments(errStream, arguments, args)) {
            return ExitCode.INTERNAL_ERROR;
        }
        return this.exec(errStream, arguments);
    }

    protected boolean parseArguments(@NotNull PrintStream errStream, @NotNull A arguments, @NotNull String[] args) {
        try {
            ((CompilerArguments)arguments).freeArgs = Args.parse(arguments, args);
            return true;
        }
        catch (IllegalArgumentException e) {
            this.usage(errStream);
        }
        catch (Throwable t) {
            errStream.println(MessageRenderer.TAGS.renderException(t));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void usage(@NotNull PrintStream target) {
        PrintStream oldErr = System.err;
        System.setErr(target);
        try {
            Args.usage(this.createArguments());
        }
        finally {
            System.setErr(oldErr);
        }
    }

    protected void configureEnvironment(@NotNull C configuration, @NotNull A arguments) {
        List<CompilerPlugin> plugins = ((CompilerArguments)arguments).getCompilerPlugins();
        ((CompileEnvironmentConfiguration)configuration).getCompilerPlugins().addAll(plugins);
    }

    @NotNull
    protected abstract A createArguments();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ExitCode exec(PrintStream errStream, A arguments) {
        if (((CompilerArguments)arguments).isHelp()) {
            this.usage(errStream);
            return ExitCode.OK;
        }
        System.setProperty("java.awt.headless", "true");
        MessageRenderer messageRenderer = this.getMessageRenderer(arguments);
        errStream.print(messageRenderer.renderPreamble());
        this.printVersionIfNeeded(errStream, arguments, messageRenderer);
        PrintingMessageCollector messageCollector = new PrintingMessageCollector(errStream, messageRenderer, ((CompilerArguments)arguments).isVerbose());
        Disposable rootDisposable = CompileEnvironmentUtil.createMockDisposable();
        try {
            ExitCode exitCode = this.doExecute(arguments, messageCollector, rootDisposable);
            return exitCode;
        }
        finally {
            messageCollector.printToErrStream();
            errStream.print(messageRenderer.renderConclusion());
            Disposer.dispose(rootDisposable);
        }
    }

    @NotNull
    protected abstract ExitCode doExecute(A var1, PrintingMessageCollector var2, Disposable var3);

    @NotNull
    protected MessageRenderer getMessageRenderer(@NotNull A arguments) {
        return ((CompilerArguments)arguments).isTags() ? MessageRenderer.TAGS : MessageRenderer.PLAIN;
    }

    protected void printVersionIfNeeded(@NotNull PrintStream errStream, @NotNull A arguments, @NotNull MessageRenderer messageRenderer) {
        if (((CompilerArguments)arguments).isVersion()) {
            String versionMessage = messageRenderer.render(CompilerMessageSeverity.INFO, "Kotlin Compiler version 0.1.2580", CompilerMessageLocation.NO_LOCATION);
            errStream.println(versionMessage);
        }
    }

    public static void doMain(@NotNull CLICompiler compiler, @NotNull String[] args) {
        try {
            ExitCode rc = compiler.exec(System.out, args);
            if (rc != ExitCode.OK) {
                System.err.println("exec() finished with " + (Object)((Object)rc) + " return code");
                System.exit(rc.getCode());
            }
        }
        catch (CompileEnvironmentException e) {
            System.err.println(e.getMessage());
            System.exit(ExitCode.INTERNAL_ERROR.getCode());
        }
    }
}

