/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.base.Predicate;
import org.jetbrains.jet.internal.com.google.common.collect.Collections2;
import org.jetbrains.jet.internal.com.google.common.collect.HashMultiset;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Multiset;
import org.jetbrains.jet.internal.com.intellij.openapi.util.TextRange;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiErrorElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.lang.diagnostics.AbstractDiagnosticFactory;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.diagnostics.Severity;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;

public class CheckerTestUtil {
    public static final Comparator<Diagnostic> DIAGNOSTIC_COMPARATOR = new Comparator<Diagnostic>(){

        @Override
        public int compare(Diagnostic o1, Diagnostic o2) {
            List<TextRange> ranges1 = o1.getTextRanges();
            List<TextRange> ranges2 = o2.getTextRanges();
            if (ranges1.size() != ranges2.size()) {
                return ranges1.size() - ranges2.size();
            }
            for (int i = 0; i < ranges1.size(); ++i) {
                int endOffset2;
                int startOffset2;
                TextRange range1 = ranges1.get(i);
                TextRange range2 = ranges2.get(i);
                int startOffset1 = range1.getStartOffset();
                if (startOffset1 != (startOffset2 = range2.getStartOffset())) {
                    return startOffset1 - range2.getStartOffset();
                }
                int endOffset1 = range1.getEndOffset();
                if (endOffset1 == (endOffset2 = range2.getEndOffset())) continue;
                return endOffset2 - endOffset1;
            }
            return 0;
        }
    };
    private static final Pattern RANGE_START_OR_END_PATTERN = Pattern.compile("(<!\\w+(,\\s*\\w+)*!>)|(<!>)");
    private static final Pattern INDIVIDUAL_DIAGNOSTIC_PATTERN = Pattern.compile("\\w+");

    public static List<Diagnostic> getDiagnosticsIncludingSyntaxErrors(BindingContext bindingContext, PsiElement root) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        diagnostics.addAll(bindingContext.getDiagnostics());
        for (PsiErrorElement errorElement : AnalyzingUtils.getSyntaxErrorRanges(root)) {
            diagnostics.add(new SyntaxErrorDiagnostic(errorElement));
        }
        return diagnostics;
    }

    public static void diagnosticsDiff(List<DiagnosedRange> expected, Collection<Diagnostic> actual, DiagnosticDiffCallbacks callbacks) {
        Iterator<DiagnosedRange> expectedDiagnostics = expected.iterator();
        List<DiagnosticDescriptor> sortedDiagnosticDescriptors = CheckerTestUtil.getSortedDiagnosticDescriptors(actual);
        Iterator<DiagnosticDescriptor> actualDiagnostics = sortedDiagnosticDescriptors.iterator();
        DiagnosedRange currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
        DiagnosticDescriptor currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
        while (currentExpected != null || currentActual != null) {
            if (currentExpected != null) {
                Multiset<String> expectedDiagnosticTypes;
                if (currentActual == null) {
                    CheckerTestUtil.missingDiagnostics(callbacks, currentExpected);
                    currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                    continue;
                }
                int expectedStart = currentExpected.getStart();
                int actualStart = currentActual.getStart();
                int expectedEnd = currentExpected.getEnd();
                int actualEnd = currentActual.getEnd();
                if (expectedStart < actualStart) {
                    CheckerTestUtil.missingDiagnostics(callbacks, currentExpected);
                    currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                    continue;
                }
                if (expectedStart > actualStart) {
                    CheckerTestUtil.unexpectedDiagnostics(currentActual.getDiagnostics(), callbacks);
                    currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
                    continue;
                }
                if (expectedEnd > actualEnd) {
                    assert (expectedStart == actualStart);
                    CheckerTestUtil.missingDiagnostics(callbacks, currentExpected);
                    currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                    continue;
                }
                if (expectedEnd < actualEnd) {
                    assert (expectedStart == actualStart);
                    CheckerTestUtil.unexpectedDiagnostics(currentActual.getDiagnostics(), callbacks);
                    currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
                    continue;
                }
                assert (expectedStart == actualStart && expectedEnd == actualEnd);
                Multiset<String> actualDiagnosticTypes = currentActual.getDiagnosticTypeStrings();
                if (!((Object)actualDiagnosticTypes).equals(expectedDiagnosticTypes = currentExpected.getDiagnostics())) {
                    HashMultiset<String> expectedCopy = HashMultiset.create(expectedDiagnosticTypes);
                    expectedCopy.removeAll(actualDiagnosticTypes);
                    HashMultiset<String> actualCopy = HashMultiset.create(actualDiagnosticTypes);
                    actualCopy.removeAll(expectedDiagnosticTypes);
                    for (String type : expectedCopy) {
                        callbacks.missingDiagnostic(type, expectedStart, expectedEnd);
                    }
                    for (String type : actualCopy) {
                        callbacks.unexpectedDiagnostic(type, actualStart, actualEnd);
                    }
                }
                currentExpected = CheckerTestUtil.safeAdvance(expectedDiagnostics);
                currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
                continue;
            }
            if (currentActual == null) break;
            CheckerTestUtil.unexpectedDiagnostics(currentActual.getDiagnostics(), callbacks);
            currentActual = CheckerTestUtil.safeAdvance(actualDiagnostics);
        }
    }

    private static void unexpectedDiagnostics(List<Diagnostic> actual, DiagnosticDiffCallbacks callbacks) {
        for (Diagnostic diagnostic : actual) {
            if (!diagnostic.getPsiFile().equals(callbacks.getFile())) continue;
            List<TextRange> textRanges = diagnostic.getTextRanges();
            for (TextRange textRange : textRanges) {
                callbacks.unexpectedDiagnostic(diagnostic.getFactory().getName(), textRange.getStartOffset(), textRange.getEndOffset());
            }
        }
    }

    private static void missingDiagnostics(DiagnosticDiffCallbacks callbacks, DiagnosedRange currentExpected) {
        for (String type : currentExpected.getDiagnostics()) {
            if (!currentExpected.getFile().equals(callbacks.getFile())) {
                return;
            }
            callbacks.missingDiagnostic(type, currentExpected.getStart(), currentExpected.getEnd());
        }
    }

    private static <T> T safeAdvance(Iterator<T> iterator) {
        return iterator.hasNext() ? (T)iterator.next() : null;
    }

    public static String parseDiagnosedRanges(String text, List<DiagnosedRange> result) {
        Matcher matcher = RANGE_START_OR_END_PATTERN.matcher(text);
        Stack<DiagnosedRange> opened = new Stack<DiagnosedRange>();
        int offsetCompensation = 0;
        while (matcher.find()) {
            int effectiveOffset = matcher.start() - offsetCompensation;
            String matchedText = matcher.group();
            if ("<!>".equals(matchedText)) {
                ((DiagnosedRange)opened.pop()).setEnd(effectiveOffset);
            } else {
                Matcher diagnosticTypeMatcher = INDIVIDUAL_DIAGNOSTIC_PATTERN.matcher(matchedText);
                DiagnosedRange range = new DiagnosedRange(effectiveOffset);
                while (diagnosticTypeMatcher.find()) {
                    range.addDiagnostic(diagnosticTypeMatcher.group());
                }
                opened.push(range);
                result.add(range);
            }
            offsetCompensation += matchedText.length();
        }
        assert (opened.isEmpty()) : "Stack is not empty";
        matcher.reset();
        return matcher.replaceAll("");
    }

    public static StringBuffer addDiagnosticMarkersToText(PsiFile psiFile, BindingContext bindingContext, List<PsiErrorElement> syntaxErrors) {
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        diagnostics.addAll(bindingContext.getDiagnostics());
        for (PsiErrorElement syntaxError : syntaxErrors) {
            diagnostics.add(new SyntaxErrorDiagnostic(syntaxError));
        }
        return CheckerTestUtil.addDiagnosticMarkersToText(psiFile, diagnostics);
    }

    public static StringBuffer addDiagnosticMarkersToText(final @NotNull PsiFile psiFile, Collection<Diagnostic> diagnostics) {
        StringBuffer result = new StringBuffer();
        String text = psiFile.getText();
        if (!(diagnostics = Collections2.filter(diagnostics, new Predicate<Diagnostic>(){

            @Override
            public boolean apply(@Nullable Diagnostic diagnostic) {
                return diagnostic != null && psiFile.equals(diagnostic.getPsiFile());
            }
        })).isEmpty()) {
            List<DiagnosticDescriptor> diagnosticDescriptors = CheckerTestUtil.getSortedDiagnosticDescriptors(diagnostics);
            Stack<DiagnosticDescriptor> opened = new Stack<DiagnosticDescriptor>();
            ListIterator<DiagnosticDescriptor> iterator = diagnosticDescriptors.listIterator();
            DiagnosticDescriptor currentDescriptor = iterator.next();
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                while (!opened.isEmpty() && i == ((DiagnosticDescriptor)opened.peek()).end) {
                    CheckerTestUtil.closeDiagnosticString(result);
                    opened.pop();
                }
                while (currentDescriptor != null && i == currentDescriptor.start) {
                    CheckerTestUtil.openDiagnosticsString(result, currentDescriptor);
                    if (currentDescriptor.getEnd() == i) {
                        CheckerTestUtil.closeDiagnosticString(result);
                    } else {
                        opened.push(currentDescriptor);
                    }
                    if (iterator.hasNext()) {
                        currentDescriptor = iterator.next();
                        continue;
                    }
                    currentDescriptor = null;
                }
                result.append(c);
            }
            if (currentDescriptor != null) {
                assert (currentDescriptor.start == text.length());
                assert (currentDescriptor.end == text.length());
                CheckerTestUtil.openDiagnosticsString(result, currentDescriptor);
                opened.push(currentDescriptor);
            }
            while (!opened.isEmpty() && text.length() == ((DiagnosticDescriptor)opened.peek()).end) {
                CheckerTestUtil.closeDiagnosticString(result);
                opened.pop();
            }
            assert (opened.isEmpty()) : "Stack is not empty: " + opened;
        } else {
            result.append(text);
        }
        return result;
    }

    private static void openDiagnosticsString(StringBuffer result, DiagnosticDescriptor currentDescriptor) {
        result.append("<!");
        Iterator iterator = currentDescriptor.diagnostics.iterator();
        while (iterator.hasNext()) {
            Diagnostic diagnostic = (Diagnostic)iterator.next();
            result.append(diagnostic.getFactory().getName());
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
        result.append("!>");
    }

    private static void closeDiagnosticString(StringBuffer result) {
        result.append("<!>");
    }

    private static List<DiagnosticDescriptor> getSortedDiagnosticDescriptors(Collection<Diagnostic> diagnostics) {
        ArrayList<Diagnostic> list = Lists.newArrayList(diagnostics);
        Collections.sort(list, DIAGNOSTIC_COMPARATOR);
        ArrayList<DiagnosticDescriptor> diagnosticDescriptors = Lists.newArrayList();
        DiagnosticDescriptor currentDiagnosticDescriptor = null;
        for (Diagnostic diagnostic : list) {
            List<TextRange> textRanges = diagnostic.getTextRanges();
            if (!diagnostic.isValid()) continue;
            TextRange textRange = textRanges.get(0);
            if (currentDiagnosticDescriptor != null && currentDiagnosticDescriptor.equalRange(textRange)) {
                currentDiagnosticDescriptor.diagnostics.add(diagnostic);
                continue;
            }
            currentDiagnosticDescriptor = new DiagnosticDescriptor(textRange.getStartOffset(), textRange.getEndOffset(), diagnostic);
            diagnosticDescriptors.add(currentDiagnosticDescriptor);
        }
        return diagnosticDescriptors;
    }

    public static class DiagnosedRange {
        private final int start;
        private int end;
        private final Multiset<String> diagnostics = HashMultiset.create();
        private PsiFile file;

        private DiagnosedRange(int start) {
            this.start = start;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public Multiset<String> getDiagnostics() {
            return this.diagnostics;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public void addDiagnostic(String diagnostic) {
            this.diagnostics.add(diagnostic);
        }

        public void setFile(@NotNull PsiFile file) {
            this.file = file;
        }

        @NotNull
        public PsiFile getFile() {
            return this.file;
        }
    }

    private static class DiagnosticDescriptor {
        private final int start;
        private final int end;
        private final List<Diagnostic> diagnostics = Lists.newArrayList();

        DiagnosticDescriptor(int start, int end, Diagnostic diagnostic) {
            this.start = start;
            this.end = end;
            this.diagnostics.add(diagnostic);
        }

        public boolean equalRange(TextRange textRange) {
            return this.start == textRange.getStartOffset() && this.end == textRange.getEndOffset();
        }

        public Multiset<String> getDiagnosticTypeStrings() {
            HashMultiset<String> actualDiagnosticTypes = HashMultiset.create();
            for (Diagnostic diagnostic : this.diagnostics) {
                actualDiagnosticTypes.add(diagnostic.getFactory().getName());
            }
            return actualDiagnosticTypes;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public List<Diagnostic> getDiagnostics() {
            return this.diagnostics;
        }

        public TextRange getTextRange() {
            return new TextRange(this.start, this.end);
        }
    }

    public static class SyntaxErrorDiagnostic
    implements Diagnostic {
        private final PsiErrorElement errorElement;

        public SyntaxErrorDiagnostic(@NotNull PsiErrorElement errorElement) {
            this.errorElement = errorElement;
        }

        @Override
        @NotNull
        public AbstractDiagnosticFactory getFactory() {
            return SyntaxErrorDiagnosticFactory.instance;
        }

        @Override
        @NotNull
        public Severity getSeverity() {
            throw new IllegalStateException();
        }

        @Override
        @NotNull
        public PsiErrorElement getPsiElement() {
            return this.errorElement;
        }

        @Override
        @NotNull
        public List<TextRange> getTextRanges() {
            return Collections.singletonList(this.errorElement.getTextRange());
        }

        @Override
        @NotNull
        public PsiFile getPsiFile() {
            return this.errorElement.getContainingFile();
        }

        @Override
        public boolean isValid() {
            return true;
        }
    }

    private static class SyntaxErrorDiagnosticFactory
    extends AbstractDiagnosticFactory {
        private static final SyntaxErrorDiagnosticFactory instance = new SyntaxErrorDiagnosticFactory();

        private SyntaxErrorDiagnosticFactory() {
        }

        @Override
        @NotNull
        public String getName() {
            return "SYNTAX";
        }
    }

    public static interface DiagnosticDiffCallbacks {
        @NotNull
        public PsiFile getFile();

        public void missingDiagnostic(String var1, int var2, int var3);

        public void unexpectedDiagnostic(String var1, int var2, int var3);
    }
}

