/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.asJava;

import java.util.Collection;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.asJava.ClsWrapperStubPsiFactory;
import org.jetbrains.jet.asJava.StubClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilder;
import org.jetbrains.jet.codegen.ClassBuilderFactory;
import org.jetbrains.jet.codegen.ClassBuilderMode;
import org.jetbrains.jet.codegen.CompilationErrorHandler;
import org.jetbrains.jet.codegen.GenerationState;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentation;
import org.jetbrains.jet.internal.com.intellij.navigation.ItemPresentationProviders;
import org.jetbrains.jet.internal.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Comparing;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Key;
import org.jetbrains.jet.internal.com.intellij.psi.ClassFileViewProvider;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiClassImplUtil;
import org.jetbrains.jet.internal.com.intellij.psi.impl.PsiManagerImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsFileImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiClassStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import org.jetbrains.jet.internal.com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import org.jetbrains.jet.internal.com.intellij.psi.impl.light.AbstractLightClass;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.PsiClassHolderFileStub;
import org.jetbrains.jet.internal.com.intellij.psi.stubs.StubElement;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValue;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.jet.internal.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.internal.com.intellij.util.containers.Stack;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.java.AnalyzerFacadeForJVM;
import org.jetbrains.jet.lang.resolve.java.CompilerDependencies;
import org.jetbrains.jet.lang.resolve.java.CompilerSpecialMode;
import org.jetbrains.jet.lang.resolve.java.JetFilesProvider;
import org.jetbrains.jet.lang.resolve.java.JetJavaMirrorMarker;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.plugin.JetLanguage;
import org.jetbrains.jet.util.QualifiedNamesUtil;
import org.jetbrains.jet.utils.Progress;

public class JetLightClass
extends AbstractLightClass
implements JetJavaMirrorMarker {
    private static final Logger LOG = Logger.getInstance("#org.jetbrains.jet.asJava.JetLightClass");
    private static final Key<CachedValue<PsiJavaFileStub>> JAVA_API_STUB = Key.create("JAVA_API_STUB");
    private final JetFile file;
    private final FqName qualifiedName;
    private PsiClass delegate;

    public JetLightClass(PsiManager manager, JetFile file, FqName qualifiedName) {
        super(manager, JetLanguage.INSTANCE);
        this.file = file;
        this.qualifiedName = qualifiedName;
    }

    @Override
    public String getName() {
        return QualifiedNamesUtil.fqnToShortName(this.qualifiedName).getName();
    }

    @Override
    public PsiElement copy() {
        return new JetLightClass(this.getManager(), this.file, this.qualifiedName);
    }

    @Override
    @NotNull
    public PsiClass getDelegate() {
        if (this.delegate == null) {
            this.delegate = JetLightClass.findClass(this.qualifiedName, this.getStub());
            if (this.delegate == null) {
                throw new IllegalStateException("Class not found for qualified name: " + this.qualifiedName);
            }
        }
        return this.delegate;
    }

    @Override
    public PsiFile getContainingFile() {
        return this.file;
    }

    private static PsiClass findClass(FqName fqn, StubElement<?> stub) {
        if (stub instanceof PsiClassStub && Comparing.equal(fqn.getFqName(), ((PsiClassStub)stub).getQualifiedName())) {
            return (PsiClass)stub.getPsi();
        }
        for (StubElement child : stub.getChildrenStubs()) {
            PsiClass answer = JetLightClass.findClass(fqn, child);
            if (answer == null) continue;
            return answer;
        }
        return null;
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName.getFqName();
    }

    public FqName getFqName() {
        return this.qualifiedName;
    }

    private PsiJavaFileStub getStub() {
        CachedValue<PsiJavaFileStub> answer = this.file.getUserData(JAVA_API_STUB);
        if (answer == null) {
            answer = CachedValuesManager.getManager(this.getProject()).createCachedValue(new CachedValueProvider<PsiJavaFileStub>(){

                @Override
                public CachedValueProvider.Result<PsiJavaFileStub> compute() {
                    return CachedValueProvider.Result.create(JetLightClass.this.calcStub(), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
                }
            }, false);
            this.file.putUserData(JAVA_API_STUB, answer);
        }
        return answer.getValue();
    }

    private PsiJavaFileStub calcStub() {
        final PsiJavaFileStubImpl answer = new PsiJavaFileStubImpl(JetPsiUtil.getFQName(this.file).getFqName(), true);
        final Project project = this.getProject();
        final Stack stubStack = new Stack();
        ClassBuilderFactory builderFactory = new ClassBuilderFactory(){

            @Override
            @NotNull
            public ClassBuilderMode getClassBuilderMode() {
                return ClassBuilderMode.SIGNATURES;
            }

            @Override
            public ClassBuilder newClassBuilder() {
                return new StubClassBuilder(stubStack);
            }

            @Override
            public String asText(ClassBuilder builder) {
                throw new UnsupportedOperationException("asText is not implemented");
            }

            @Override
            public byte[] asBytes(ClassBuilder builder) {
                throw new UnsupportedOperationException("asBytes is not implemented");
            }
        };
        AnalyzeExhaust context = AnalyzerFacadeForJVM.shallowAnalyzeFiles(JetFilesProvider.getInstance(project).sampleToAllFilesInModule().fun(this.file), CompilerSpecialMode.REGULAR, CompilerDependencies.compilerDependenciesForProduction(CompilerSpecialMode.REGULAR));
        if (context.isError()) {
            throw new IllegalStateException("failed to analyze: " + context.getError(), context.getError());
        }
        GenerationState state = new GenerationState(project, builderFactory, context, Collections.singletonList(this.file)){

            @Override
            protected void generateNamespace(FqName fqName, Collection<JetFile> namespace, CompilationErrorHandler errorHandler, Progress progress) {
                PsiManager manager = PsiManager.getInstance(project);
                stubStack.push(answer);
                answer.setPsiFactory(new ClsWrapperStubPsiFactory());
                ClsFileImpl fakeFile = new ClsFileImpl((PsiManagerImpl)manager, new ClassFileViewProvider(manager, JetLightClass.this.file.getVirtualFile())){

                    @Override
                    @NotNull
                    public PsiClassHolderFileStub getStub() {
                        return answer;
                    }
                };
                fakeFile.setPhysical(false);
                answer.setPsi(fakeFile);
                super.generateNamespace(fqName, namespace, errorHandler, progress);
                StubElement pop = (StubElement)stubStack.pop();
                if (pop != answer) {
                    LOG.error("Unbalanced stack operations: " + pop);
                }
            }
        };
        state.compileCorrectFiles(CompilationErrorHandler.THROW_EXCEPTION);
        state.getFactory().files();
        return answer;
    }

    @Override
    public ItemPresentation getPresentation() {
        return ItemPresentationProviders.getItemPresentation(this);
    }

    @Override
    public boolean isEquivalentTo(PsiElement another) {
        return another instanceof PsiClass && Comparing.equal(((PsiClass)another).getQualifiedName(), this.getQualifiedName());
    }

    @Override
    public Icon getElementIcon(int flags) {
        return PsiClassImplUtil.getClassIcon(flags, this);
    }

    @Override
    public String toString() {
        try {
            return JetLightClass.class.getSimpleName() + ":" + this.getQualifiedName();
        }
        catch (Throwable e) {
            return JetLightClass.class.getSimpleName() + ":" + e.toString();
        }
    }

    public static JetLightClass wrapDelegate(JetClass jetClass) {
        return new JetLightClass(jetClass.getManager(), (JetFile)jetClass.getContainingFile(), JetPsiUtil.getFQName(jetClass));
    }

    public static PsiMethod wrapMethod(JetFunction function) {
        JetClass containingClass = PsiTreeUtil.getParentOfType((PsiElement)function, JetClass.class);
        JetLightClass wrapper = JetLightClass.wrapDelegate(containingClass);
        for (PsiMethod method : wrapper.getMethods()) {
            if (!(method instanceof PsiCompiledElement) || ((PsiCompiledElement)((Object)method)).getMirror() != function) continue;
            return method;
        }
        return null;
    }
}

