/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.asJava;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.asJava.JetLightClass;
import org.jetbrains.jet.asJava.JetLightPackage;
import org.jetbrains.jet.codegen.JetTypeMapper;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileCopyEvent;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileEvent;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileListener;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileMoveEvent;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFinder;
import org.jetbrains.jet.internal.com.intellij.psi.PsiManager;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPackage;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.jet.internal.com.intellij.util.SmartList;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.resolve.java.JavaPsiFacadeKotlinHacks;
import org.jetbrains.jet.lang.resolve.java.JetFilesProvider;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.util.QualifiedNamesUtil;

public class JavaElementFinder
extends PsiElementFinder
implements JavaPsiFacadeKotlinHacks.KotlinFinderMarker {
    private final Project project;
    private final PsiManager psiManager;
    private WeakHashMap<GlobalSearchScope, List<JetFile>> jetFiles = new WeakHashMap();

    public JavaElementFinder(Project project) {
        this.project = project;
        this.psiManager = PsiManager.getInstance(project);
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){

            @Override
            public void fileCreated(VirtualFileEvent event) {
                JavaElementFinder.this.invalidateJetFilesCache();
            }

            @Override
            public void fileDeleted(VirtualFileEvent event) {
                JavaElementFinder.this.invalidateJetFilesCache();
            }

            @Override
            public void fileMoved(VirtualFileMoveEvent event) {
                JavaElementFinder.this.invalidateJetFilesCache();
            }

            @Override
            public void fileCopied(VirtualFileCopyEvent event) {
                JavaElementFinder.this.invalidateJetFilesCache();
            }

            @Override
            public void propertyChanged(VirtualFilePropertyEvent event) {
            }

            @Override
            public void contentsChanged(VirtualFileEvent event) {
            }

            @Override
            public void beforePropertyChange(VirtualFilePropertyEvent event) {
            }

            @Override
            public void beforeContentsChange(VirtualFileEvent event) {
            }

            @Override
            public void beforeFileDeletion(VirtualFileEvent event) {
            }

            @Override
            public void beforeFileMovement(VirtualFileMoveEvent event) {
            }
        });
    }

    @Override
    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        PsiClass[] allClasses = this.findClasses(qualifiedName, scope);
        return allClasses.length > 0 ? allClasses[0] : null;
    }

    @Override
    @NotNull
    public PsiClass[] findClasses(@NotNull String qualifiedNameString, @NotNull GlobalSearchScope scope) {
        if (!FqName.isValid(qualifiedNameString)) {
            return PsiClass.EMPTY_ARRAY;
        }
        FqName qualifiedName = new FqName(qualifiedNameString);
        if (qualifiedName.getFqName().startsWith("java.")) {
            return PsiClass.EMPTY_ARRAY;
        }
        SmartList<PsiClass> answer = new SmartList<PsiClass>();
        List<JetFile> filesInScope = this.collectProjectJetFiles(this.project, scope);
        for (JetFile file : filesInScope) {
            FqName packageName = JetPsiUtil.getFQName(file);
            if (packageName == null || !qualifiedName.getFqName().startsWith(packageName.getFqName())) continue;
            if (qualifiedName.equals(QualifiedNamesUtil.combine(packageName, Name.identifier("namespace")))) {
                answer.add(new JetLightClass(this.psiManager, file, qualifiedName));
                continue;
            }
            for (JetDeclaration declaration : file.getDeclarations()) {
                this.scanClasses(answer, declaration, qualifiedName, packageName, file);
            }
        }
        return answer.toArray(new PsiClass[answer.size()]);
    }

    private void scanClasses(List<PsiClass> answer, JetDeclaration declaration, FqName qualifiedName, FqName containerFqn, JetFile file) {
        if (declaration instanceof JetClassOrObject) {
            String localName = JavaElementFinder.getLocalName(declaration);
            if (localName != null) {
                FqName fqn = QualifiedNamesUtil.combine(containerFqn, Name.identifier(localName));
                if (qualifiedName.equals(fqn)) {
                    answer.add(new JetLightClass(this.psiManager, file, qualifiedName));
                } else {
                    for (JetDeclaration child : ((JetClassOrObject)((Object)declaration)).getDeclarations()) {
                        this.scanClasses(answer, child, qualifiedName, fqn, file);
                    }
                }
            }
        } else if (declaration instanceof JetClassObject) {
            this.scanClasses(answer, ((JetClassObject)declaration).getObjectDeclaration(), qualifiedName, containerFqn, file);
        }
    }

    @Nullable
    private static String getLocalName(JetDeclaration declaration) {
        String given = declaration.getName();
        if (given != null) {
            return given;
        }
        if (declaration instanceof JetObjectDeclaration) {
            return JetTypeMapper.getLocalNameForObject((JetObjectDeclaration)declaration);
        }
        return null;
    }

    @Override
    public Set<String> getClassNames(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        HashSet<String> answer = new HashSet<String>();
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        for (JetFile psiFile : this.collectProjectJetFiles(this.project, GlobalSearchScope.allScope(this.project))) {
            if (!packageFQN.equals(JetPsiUtil.getFQName(psiFile))) continue;
            answer.add("namespace");
            for (JetDeclaration declaration : psiFile.getDeclarations()) {
                if (!(declaration instanceof JetClassOrObject)) continue;
                answer.add(JavaElementFinder.getLocalName(declaration));
            }
        }
        return answer;
    }

    @Override
    public PsiPackage findPackage(@NotNull String qualifiedNameString) {
        if (!FqName.isValid(qualifiedNameString)) {
            return null;
        }
        FqName fqName = new FqName(qualifiedNameString);
        List<JetFile> psiFiles = this.collectProjectJetFiles(this.project, GlobalSearchScope.allScope(this.project));
        for (JetFile psiFile : psiFiles) {
            if (!QualifiedNamesUtil.isSubpackageOf(JetPsiUtil.getFQName(psiFile), fqName)) continue;
            return new JetLightPackage(this.psiManager, fqName, psiFile.getNamespaceHeader());
        }
        return null;
    }

    @Override
    @NotNull
    public PsiPackage[] getSubPackages(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        List<JetFile> psiFiles = this.collectProjectJetFiles(this.project, GlobalSearchScope.allScope(this.project));
        HashSet<JetLightPackage> answer = new HashSet<JetLightPackage>();
        for (JetFile psiFile : psiFiles) {
            FqName jetRootNamespace = JetPsiUtil.getFQName(psiFile);
            FqName subPackageFQN = QualifiedNamesUtil.plusOneSegment(new FqName(psiPackage.getQualifiedName()), jetRootNamespace);
            if (subPackageFQN == null) continue;
            answer.add(new JetLightPackage(this.psiManager, subPackageFQN, psiFile.getNamespaceHeader()));
        }
        return answer.toArray(new PsiPackage[answer.size()]);
    }

    @Override
    @NotNull
    public PsiClass[] getClasses(@NotNull PsiPackage psiPackage, @NotNull GlobalSearchScope scope) {
        SmartList<JetLightClass> answer = new SmartList<JetLightClass>();
        List<JetFile> filesInScope = this.collectProjectJetFiles(this.project, scope);
        FqName packageFQN = new FqName(psiPackage.getQualifiedName());
        for (JetFile file : filesInScope) {
            if (!packageFQN.equals(JetPsiUtil.getFQName(file))) continue;
            answer.add(new JetLightClass(this.psiManager, file, QualifiedNamesUtil.combine(packageFQN, Name.identifier("namespace"))));
            for (JetDeclaration declaration : file.getDeclarations()) {
                String localName;
                if (!(declaration instanceof JetClassOrObject) || (localName = JavaElementFinder.getLocalName(declaration)) == null) continue;
                answer.add(new JetLightClass(this.psiManager, file, QualifiedNamesUtil.combine(packageFQN, Name.identifier(localName))));
            }
        }
        return answer.toArray(new PsiClass[answer.size()]);
    }

    private synchronized void invalidateJetFilesCache() {
        this.jetFiles.clear();
    }

    private synchronized List<JetFile> collectProjectJetFiles(Project project, @NotNull GlobalSearchScope scope) {
        List<JetFile> cachedFiles = this.jetFiles.get(scope);
        if (cachedFiles == null) {
            cachedFiles = JetFilesProvider.getInstance(project).allInScope(scope);
            this.jetFiles.put(scope, cachedFiles);
        }
        return cachedFiles;
    }
}

