/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.analyzer;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;

public class AnalyzeExhaust {
    @NotNull
    private final BindingContext bindingContext;
    private final JetStandardLibrary standardLibrary;
    private final Throwable error;
    @Nullable
    private final BodiesResolveContext bodiesResolveContext;

    private AnalyzeExhaust(@NotNull BindingContext bindingContext, @Nullable JetStandardLibrary standardLibrary, @Nullable BodiesResolveContext bodiesResolveContext, @Nullable Throwable error) {
        this.bindingContext = bindingContext;
        this.standardLibrary = standardLibrary;
        this.error = error;
        this.bodiesResolveContext = bodiesResolveContext;
    }

    public static AnalyzeExhaust success(@NotNull BindingContext bindingContext, @NotNull JetStandardLibrary standardLibrary) {
        return new AnalyzeExhaust(bindingContext, standardLibrary, null, null);
    }

    public static AnalyzeExhaust success(@NotNull BindingContext bindingContext, @NotNull JetStandardLibrary standardLibrary, BodiesResolveContext bodiesResolveContext) {
        return new AnalyzeExhaust(bindingContext, standardLibrary, bodiesResolveContext, null);
    }

    public static AnalyzeExhaust error(@NotNull BindingContext bindingContext, @NotNull Throwable error) {
        return new AnalyzeExhaust(bindingContext, null, null, error);
    }

    @Nullable
    public BodiesResolveContext getBodiesResolveContext() {
        return this.bodiesResolveContext;
    }

    @NotNull
    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    public JetStandardLibrary getStandardLibrary() {
        return this.standardLibrary;
    }

    @NotNull
    public Throwable getError() {
        return this.error;
    }

    public boolean isError() {
        return this.error != null;
    }

    public void throwIfError() {
        if (this.isError()) {
            throw new IllegalStateException("failed to analyze: " + this.error, this.error);
        }
    }
}

