/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jline.Terminal;
import jline.TerminalFactory;
import jline.internal.Configuration;
import jline.internal.Log;

public abstract class TerminalSupport
implements Terminal {
    private Thread shutdownHook;
    private boolean shutdownHookEnabled;
    private boolean supported;
    private boolean echoEnabled;
    private boolean ansiSupported;

    protected TerminalSupport(boolean supported) {
        this.supported = supported;
        this.shutdownHookEnabled = Configuration.getBoolean("jline.shutdownhook", false);
    }

    @Override
    public void init() throws Exception {
        this.installShutdownHook(new RestoreHook());
    }

    public void restore() throws Exception {
        TerminalFactory.resetIf(this);
        this.removeShutdownHook();
    }

    protected void installShutdownHook(Thread hook) {
        if (!this.shutdownHookEnabled) {
            Log.debug("Not install shutdown hook " + hook + " because they are disabled.");
            return;
        }
        assert (hook != null);
        if (this.shutdownHook != null) {
            throw new IllegalStateException("Shutdown hook already installed");
        }
        try {
            Runtime.getRuntime().addShutdownHook(hook);
            this.shutdownHook = hook;
        }
        catch (AbstractMethodError e) {
            Log.trace("Failed to register shutdown hook: ", e);
        }
    }

    protected void removeShutdownHook() {
        if (!this.shutdownHookEnabled) {
            return;
        }
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (AbstractMethodError e) {
                Log.trace("Failed to remove shutdown hook: ", e);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.shutdownHook = null;
        }
    }

    @Override
    public final boolean isSupported() {
        return this.supported;
    }

    @Override
    public synchronized boolean isAnsiSupported() {
        return this.ansiSupported;
    }

    protected synchronized void setAnsiSupported(boolean supported) {
        this.ansiSupported = supported;
        Log.debug("Ansi supported: ", supported);
    }

    @Override
    public OutputStream wrapOutIfNeeded(OutputStream out) {
        return out;
    }

    @Override
    public boolean hasWeirdWrap() {
        return true;
    }

    @Override
    public int getWidth() {
        return 80;
    }

    @Override
    public int getHeight() {
        return 24;
    }

    @Override
    public synchronized boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    public synchronized void setEchoEnabled(boolean enabled) {
        this.echoEnabled = enabled;
        Log.debug("Echo enabled: ", enabled);
    }

    @Override
    public InputStream wrapInIfNeeded(InputStream in) throws IOException {
        return in;
    }

    protected class RestoreHook
    extends Thread {
        protected RestoreHook() {
        }

        @Override
        public void start() {
            try {
                TerminalSupport.this.restore();
            }
            catch (Exception e) {
                Log.trace("Failed to restore: ", e);
            }
        }
    }
}

