/*
 * Decompiled with CFR 0.152.
 */
package jet.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jet.Function0;

public class Intrinsics {
    private Intrinsics() {
    }

    public static String stringPlus(String self, Object other) {
        return (self == null ? "null" : self) + (other == null ? "null" : other.toString());
    }

    public static void throwNpe() {
        throw new JetNullPointerException();
    }

    public static <T> Class<T> getJavaClass(T self) {
        return self.getClass();
    }

    public static int compare(long thisVal, long anotherVal) {
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public static int compare(int thisVal, int anotherVal) {
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    public static int compare(boolean thisVal, boolean anotherVal) {
        return thisVal == anotherVal ? 0 : (anotherVal ? 1 : -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R stupidSync(Object lock, Function0<R> block) {
        Object object = lock;
        synchronized (object) {
            return block.invoke();
        }
    }

    private static Throwable sanitizeStackTrace(Throwable throwable) {
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
        boolean skip = true;
        for (StackTraceElement ste : stackTrace) {
            if (!skip) {
                list.add(ste);
                continue;
            }
            if (!"jet.runtime.Intrinsics".equals(ste.getClassName()) || !"throwNpe".equals(ste.getMethodName())) continue;
            skip = false;
        }
        throwable.setStackTrace(list.toArray(new StackTraceElement[list.size()]));
        return throwable;
    }

    public static class SpreadBuilder
    extends ArrayList {
        public void addSpread(Object array) {
            if (array != null) {
                if (array instanceof Object[]) {
                    Object[] arr = (Object[])array;
                    if (arr.length > 0) {
                        this.ensureCapacity(this.size() + arr.length);
                        for (int i = 0; i < arr.length; ++i) {
                            this.add(arr[i]);
                        }
                    }
                } else if (array instanceof Collection) {
                    this.addAll((Collection)array);
                } else if (array instanceof Iterable) {
                    Iterator iterator = ((Iterable)array).iterator();
                    while (iterator.hasNext()) {
                        this.add(iterator.next());
                    }
                } else if (array instanceof Iterator) {
                    Iterator iterator = (Iterator)array;
                    while (iterator.hasNext()) {
                        this.add(iterator.next());
                    }
                } else {
                    throw new UnsupportedOperationException("Don't know how to spread " + array.getClass());
                }
            }
        }
    }

    private static class JetNullPointerException
    extends NullPointerException {
        private JetNullPointerException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            super.fillInStackTrace();
            return Intrinsics.sanitizeStackTrace(this);
        }
    }
}

