/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.LongIterable;
import jet.LongIterator;
import jet.Range;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

@AssertInvisibleInResolver
public final class LongRange
implements LongIterable,
Range<Long> {
    private final long start;
    private final long count;
    public static final LongRange empty = new LongRange(0L, 0L);

    public LongRange(long startValue, long count) {
        this.start = startValue;
        this.count = count;
    }

    public LongIterator step(long step) {
        if (step < 0L) {
            return new MyIterator(this.getEnd(), -this.count, -step);
        }
        return new MyIterator(this.start, this.count, step);
    }

    @Override
    public boolean contains(Long item) {
        if (item == null) {
            return false;
        }
        if (this.count >= 0L) {
            return item >= this.start && item < this.start + this.count;
        }
        return item <= this.start && item > this.start + this.count;
    }

    public boolean getIsReversed() {
        return this.count < 0L;
    }

    public long getStart() {
        return this.start;
    }

    public long getIteratorStart() {
        return this.count == 0L ? 1L : this.start;
    }

    public long getEnd() {
        return this.count < 0L ? this.start + this.count + 1L : (this.count == 0L ? 0L : this.start + this.count - 1L);
    }

    public long getSize() {
        return this.count < 0L ? -this.count : this.count;
    }

    public LongRange minus() {
        return new LongRange(this.getEnd(), -this.count);
    }

    @Override
    public LongIterator iterator() {
        return new MyIterator(this.start, this.count, 1L);
    }

    public static LongRange count(int length) {
        return new LongRange(0L, length);
    }

    private static class MyIterator
    extends LongIterator {
        private long cur;
        private long step;
        private long count;
        private final boolean reversed;

        public MyIterator(long startValue, long count, long step) {
            this.cur = startValue;
            this.step = step;
            if (count < 0L) {
                this.reversed = true;
                count = -count;
                startValue += count;
            } else {
                this.reversed = false;
            }
            this.count = count;
        }

        @Override
        public boolean getHasNext() {
            return this.count > 0L;
        }

        @Override
        public long nextLong() {
            this.count -= this.step;
            if (this.reversed) {
                this.cur -= this.step;
                return this.cur + this.step;
            }
            this.cur += this.step;
            return this.cur - this.step;
        }
    }
}

