/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.IntIterable;
import jet.IntIterator;
import jet.Range;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

@AssertInvisibleInResolver
public final class IntRange
implements IntIterable,
Range<Integer> {
    private final int start;
    private final int count;
    public static final IntRange empty = new IntRange(0, 0);

    public IntRange(int startValue, int count) {
        this.start = startValue;
        this.count = count;
    }

    @Override
    public boolean contains(Integer item) {
        if (item == null) {
            return false;
        }
        if (this.count >= 0) {
            return item >= this.start && item < this.start + this.count;
        }
        return item <= this.start && item > this.start + this.count;
    }

    public IntIterator step(int step) {
        if (step < 0) {
            return new MyIterator(this.getEnd(), -this.count, -step);
        }
        return new MyIterator(this.start, this.count, step);
    }

    public boolean getIsReversed() {
        return this.count < 0;
    }

    public int getIteratorStart() {
        return this.count == 0 ? 1 : this.start;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.count < 0 ? this.start + this.count + 1 : (this.count == 0 ? 0 : this.start + this.count - 1);
    }

    public int getSize() {
        return this.count < 0 ? -this.count : this.count;
    }

    public IntRange minus() {
        return new IntRange(this.getEnd(), -this.count);
    }

    @Override
    public IntIterator iterator() {
        return new MyIterator(this.start, this.count, 1);
    }

    public static IntRange count(int length) {
        return new IntRange(0, length);
    }

    private static class MyIterator
    extends IntIterator {
        private int cur;
        private int step;
        private int count;
        private final boolean reversed;

        public MyIterator(int startValue, int count, int step) {
            this.cur = startValue;
            this.step = step;
            if (count < 0) {
                this.reversed = true;
                count = -count;
                startValue += count;
            } else {
                this.reversed = false;
            }
            this.count = count;
        }

        @Override
        public boolean getHasNext() {
            return this.count > 0;
        }

        @Override
        public int nextInt() {
            this.count -= this.step;
            if (this.reversed) {
                this.cur -= this.step;
                return this.cur + this.step;
            }
            this.cur += this.step;
            return this.cur - this.step;
        }
    }
}

