/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.FloatIterator;
import jet.Range;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

@AssertInvisibleInResolver
public final class FloatRange
implements Range<Float> {
    private final float start;
    private final float size;

    public FloatRange(float startValue, float size) {
        this.start = startValue;
        this.size = size;
    }

    @Override
    public boolean contains(Float item) {
        if (item == null) {
            return false;
        }
        if (this.size >= 0.0f) {
            return item.floatValue() >= this.start && item.floatValue() < this.start + this.size;
        }
        return item.floatValue() <= this.start && item.floatValue() > this.start + this.size;
    }

    public FloatIterator step(float step) {
        if (step < 0.0f) {
            return new MyIterator(this.getEnd(), -this.size, -step);
        }
        return new MyIterator(this.start, this.size, step);
    }

    public boolean getIsReversed() {
        return this.size < 0.0f;
    }

    public float getStart() {
        return this.start;
    }

    public float getEnd() {
        return this.size < 0.0f ? this.start + this.size : this.start + this.size;
    }

    public float getSize() {
        return this.size < 0.0f ? -this.size : this.size;
    }

    public FloatRange minus() {
        return new FloatRange(this.getEnd(), -this.size);
    }

    public static FloatRange count(int length) {
        return new FloatRange(0.0f, length);
    }

    private static class MyIterator
    extends FloatIterator {
        private float cur;
        private float step;
        private final float end;
        private final boolean reversed;

        public MyIterator(float startValue, float size, float step) {
            this.cur = startValue;
            this.step = step;
            if (size < 0.0f) {
                this.reversed = true;
                this.end = startValue - size;
                startValue -= size;
            } else {
                this.reversed = false;
                this.end = startValue + size;
            }
        }

        @Override
        public boolean getHasNext() {
            if (this.reversed) {
                return this.cur >= this.end;
            }
            return this.cur <= this.end;
        }

        @Override
        public float nextFloat() {
            if (this.reversed) {
                this.cur -= this.step;
                return this.cur + this.step;
            }
            this.cur += this.step;
            return this.cur - this.step;
        }
    }
}

