/*
 * Decompiled with CFR 0.152.
 */
package jet;

import jet.DoubleIterator;
import jet.Range;
import org.jetbrains.jet.rt.annotation.AssertInvisibleInResolver;

@AssertInvisibleInResolver
public final class DoubleRange
implements Range<Double> {
    private final double start;
    private final double size;

    public DoubleRange(double startValue, double size) {
        this.start = startValue;
        this.size = size;
    }

    @Override
    public boolean contains(Double item) {
        if (item == null) {
            return false;
        }
        if (this.size >= 0.0) {
            return item >= this.start && item < this.start + this.size;
        }
        return item <= this.start && item > this.start + this.size;
    }

    public DoubleIterator step(double step) {
        if (step < 0.0) {
            return new MyIterator(this.getEnd(), -this.size, -step);
        }
        return new MyIterator(this.start, this.size, step);
    }

    public boolean getIsReversed() {
        return this.size < 0.0;
    }

    public double getStart() {
        return this.start;
    }

    public double getEnd() {
        return this.size < 0.0 ? this.start + this.size : this.start + this.size;
    }

    public double getSize() {
        return this.size < 0.0 ? -this.size : this.size;
    }

    public DoubleRange minus() {
        return new DoubleRange(this.getEnd(), -this.size);
    }

    public static DoubleRange count(int length) {
        return new DoubleRange(0.0, length);
    }

    private static class MyIterator
    extends DoubleIterator {
        private double cur;
        private double step;
        private final double end;
        private final boolean reversed;

        public MyIterator(double startValue, double size, double step) {
            this.cur = startValue;
            this.step = step;
            if (size < 0.0) {
                this.reversed = true;
                this.end = startValue - size;
                startValue -= size;
            } else {
                this.reversed = false;
                this.end = startValue + size;
            }
        }

        @Override
        public boolean getHasNext() {
            if (this.reversed) {
                return this.cur >= this.end;
            }
            return this.cur <= this.end;
        }

        @Override
        public double nextDouble() {
            if (this.reversed) {
                this.cur -= this.step;
                return this.cur + this.step;
            }
            this.cur += this.step;
            return this.cur - this.step;
        }
    }
}

