/*
 * Decompiled with CFR 0.152.
 */
package closurecompiler.internal.com.google.common.io;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.io.Closeables;
import closurecompiler.internal.com.google.common.io.InputSupplier;
import closurecompiler.internal.com.google.common.io.LineReader;
import closurecompiler.internal.com.google.common.io.OutputSupplier;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public final class CharStreams {
    public static InputSupplier<InputStreamReader> newReaderSupplier(final InputSupplier<? extends InputStream> in, final Charset charset) {
        Preconditions.checkNotNull(in);
        Preconditions.checkNotNull(charset);
        return new InputSupplier<InputStreamReader>(){

            @Override
            public InputStreamReader getInput() throws IOException {
                return new InputStreamReader((InputStream)in.getInput(), charset);
            }
        };
    }

    public static OutputSupplier<OutputStreamWriter> newWriterSupplier(final OutputSupplier<? extends OutputStream> out, final Charset charset) {
        Preconditions.checkNotNull(out);
        Preconditions.checkNotNull(charset);
        return new OutputSupplier<OutputStreamWriter>(){

            @Override
            public OutputStreamWriter getOutput() throws IOException {
                return new OutputStreamWriter((OutputStream)out.getOutput(), charset);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <W extends Appendable & Closeable> void write(CharSequence from, OutputSupplier<W> to) throws IOException {
        Preconditions.checkNotNull(from);
        boolean threw = true;
        Appendable out = (Appendable)to.getOutput();
        try {
            out.append(from);
            threw = false;
        }
        finally {
            Closeables.close((Closeable)((Object)out), threw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Readable & Closeable> long copy(InputSupplier<R> from, Appendable to) throws IOException {
        boolean threw = true;
        Readable in = (Readable)from.getInput();
        try {
            long count = CharStreams.copy(in, to);
            threw = false;
            long l = count;
            return l;
        }
        finally {
            Closeables.close((Closeable)((Object)in), threw);
        }
    }

    public static long copy(Readable from, Appendable to) throws IOException {
        int r;
        CharBuffer buf = CharBuffer.allocate(2048);
        long total = 0L;
        while ((r = from.read(buf)) != -1) {
            buf.flip();
            to.append(buf, 0, r);
            total += (long)r;
        }
        return total;
    }

    public static String toString(Readable r) throws IOException {
        return CharStreams.toStringBuilder(r).toString();
    }

    private static StringBuilder toStringBuilder(Readable r) throws IOException {
        StringBuilder sb = new StringBuilder();
        CharStreams.copy(r, (Appendable)sb);
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R extends Readable & Closeable> List<String> readLines(InputSupplier<R> supplier) throws IOException {
        boolean threw = true;
        Readable r = (Readable)supplier.getInput();
        try {
            List<String> result = CharStreams.readLines(r);
            threw = false;
            List<String> list = result;
            return list;
        }
        finally {
            Closeables.close((Closeable)((Object)r), threw);
        }
    }

    public static List<String> readLines(Readable r) throws IOException {
        String line;
        ArrayList<String> result = new ArrayList<String>();
        LineReader lineReader = new LineReader(r);
        while ((line = lineReader.readLine()) != null) {
            result.add(line);
        }
        return result;
    }
}

