/*
 * Decompiled with CFR 0.152.
 */
package closurecompiler.internal.com.google.common.collect;

import closurecompiler.internal.com.google.common.base.Preconditions;
import closurecompiler.internal.com.google.common.base.Supplier;
import closurecompiler.internal.com.google.common.collect.Collections2;
import closurecompiler.internal.com.google.common.collect.ForwardingMapEntry;
import closurecompiler.internal.com.google.common.collect.ImmutableEntry;
import closurecompiler.internal.com.google.common.collect.Iterators;
import closurecompiler.internal.com.google.common.collect.Maps;
import closurecompiler.internal.com.google.common.collect.Table;
import closurecompiler.internal.com.google.common.collect.Tables;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class StandardTable<R, C, V>
implements Table<R, C, V>,
Serializable {
    final Map<R, Map<C, V>> backingMap;
    final Supplier<? extends Map<C, V>> factory;
    private transient CellSet cellSet;
    private transient RowKeySet rowKeySet;
    private transient Values values;
    private transient RowMap rowMap;

    StandardTable(Map<R, Map<C, V>> backingMap, Supplier<? extends Map<C, V>> factory) {
        this.backingMap = backingMap;
        this.factory = factory;
    }

    public boolean containsRow(Object rowKey) {
        return rowKey != null && Maps.safeContainsKey(this.backingMap, rowKey);
    }

    @Override
    public V get(Object rowKey, Object columnKey) {
        if (rowKey == null || columnKey == null) {
            return null;
        }
        Map<C, V> map = Maps.safeGet(this.backingMap, rowKey);
        return map == null ? null : (V)Maps.safeGet(map, columnKey);
    }

    public int size() {
        int size = 0;
        for (Map<C, V> map : this.backingMap.values()) {
            size += map.size();
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Table) {
            Table other = (Table)obj;
            return ((Object)this.cellSet()).equals(other.cellSet());
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.cellSet()).hashCode();
    }

    public String toString() {
        return this.rowMap().toString();
    }

    private Map<C, V> getOrCreate(R rowKey) {
        Map<C, V> map = this.backingMap.get(rowKey);
        if (map == null) {
            map = this.factory.get();
            this.backingMap.put(rowKey, map);
        }
        return map;
    }

    @Override
    public V put(R rowKey, C columnKey, V value) {
        Preconditions.checkNotNull(rowKey);
        Preconditions.checkNotNull(columnKey);
        Preconditions.checkNotNull(value);
        return this.getOrCreate(rowKey).put(columnKey, value);
    }

    @Override
    public V remove(Object rowKey, Object columnKey) {
        if (rowKey == null || columnKey == null) {
            return null;
        }
        Map<C, V> map = Maps.safeGet(this.backingMap, rowKey);
        if (map == null) {
            return null;
        }
        V value = map.remove(columnKey);
        if (map.isEmpty()) {
            this.backingMap.remove(rowKey);
        }
        return value;
    }

    private boolean containsMapping(Object rowKey, Object columnKey, Object value) {
        return value != null && value.equals(this.get(rowKey, columnKey));
    }

    private boolean removeMapping(Object rowKey, Object columnKey, Object value) {
        if (this.containsMapping(rowKey, columnKey, value)) {
            this.remove(rowKey, columnKey);
            return true;
        }
        return false;
    }

    @Override
    public Set<Table.Cell<R, C, V>> cellSet() {
        CellSet result = this.cellSet;
        return result == null ? (this.cellSet = new CellSet()) : result;
    }

    public Map<C, V> row(R rowKey) {
        return new Row(rowKey);
    }

    public Set<R> rowKeySet() {
        RowKeySet result = this.rowKeySet;
        return result == null ? (this.rowKeySet = new RowKeySet()) : result;
    }

    @Override
    public Collection<V> values() {
        Values result = this.values;
        return result == null ? (this.values = new Values()) : result;
    }

    public Map<R, Map<C, V>> rowMap() {
        RowMap result = this.rowMap;
        return result == null ? (this.rowMap = new RowMap()) : result;
    }

    static <K, V> Iterator<K> keyIteratorImpl(Map<K, V> map) {
        final Iterator<Map.Entry<K, V>> entryIterator = map.entrySet().iterator();
        return new Iterator<K>(){

            @Override
            public boolean hasNext() {
                return entryIterator.hasNext();
            }

            @Override
            public K next() {
                return ((Map.Entry)entryIterator.next()).getKey();
            }

            @Override
            public void remove() {
                entryIterator.remove();
            }
        };
    }

    class RowMap
    extends Maps.ImprovedAbstractMap<R, Map<C, V>> {
        RowMap() {
        }

        @Override
        public boolean containsKey(Object key) {
            return StandardTable.this.containsRow(key);
        }

        @Override
        public Map<C, V> get(Object key) {
            return StandardTable.this.containsRow(key) ? StandardTable.this.row(key) : null;
        }

        @Override
        public Set<R> keySet() {
            return StandardTable.this.rowKeySet();
        }

        @Override
        public Map<C, V> remove(Object key) {
            return key == null ? null : StandardTable.this.backingMap.remove(key);
        }

        @Override
        protected Set<Map.Entry<R, Map<C, V>>> createEntrySet() {
            return new EntrySet();
        }

        class EntryIterator
        implements Iterator<Map.Entry<R, Map<C, V>>> {
            final Iterator<R> delegate;

            EntryIterator() {
                this.delegate = StandardTable.this.backingMap.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            @Override
            public Map.Entry<R, Map<C, V>> next() {
                Object rowKey = this.delegate.next();
                return new ImmutableEntry(rowKey, StandardTable.this.row(rowKey));
            }

            @Override
            public void remove() {
                this.delegate.remove();
            }
        }

        class EntrySet
        extends TableSet<Map.Entry<R, Map<C, V>>> {
            EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<R, Map<C, V>>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return StandardTable.this.backingMap.size();
            }

            @Override
            public boolean contains(Object obj) {
                if (obj instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)obj;
                    return entry.getKey() != null && entry.getValue() instanceof Map && Collections2.safeContains(StandardTable.this.backingMap.entrySet(), entry);
                }
                return false;
            }

            @Override
            public boolean remove(Object obj) {
                if (obj instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)obj;
                    return entry.getKey() != null && entry.getValue() instanceof Map && StandardTable.this.backingMap.entrySet().remove(entry);
                }
                return false;
            }
        }
    }

    private class Values
    extends TableCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            final Iterator cellIterator = StandardTable.this.cellSet().iterator();
            return new Iterator<V>(){

                @Override
                public boolean hasNext() {
                    return cellIterator.hasNext();
                }

                @Override
                public V next() {
                    return ((Table.Cell)cellIterator.next()).getValue();
                }

                @Override
                public void remove() {
                    cellIterator.remove();
                }
            };
        }

        @Override
        public int size() {
            return StandardTable.this.size();
        }
    }

    class RowKeySet
    extends TableSet<R> {
        RowKeySet() {
        }

        @Override
        public Iterator<R> iterator() {
            return StandardTable.keyIteratorImpl(StandardTable.this.rowMap());
        }

        @Override
        public int size() {
            return StandardTable.this.backingMap.size();
        }

        @Override
        public boolean contains(Object obj) {
            return StandardTable.this.containsRow(obj);
        }

        @Override
        public boolean remove(Object obj) {
            return obj != null && StandardTable.this.backingMap.remove(obj) != null;
        }
    }

    class Row
    extends AbstractMap<C, V> {
        final R rowKey;
        Map<C, V> backingRowMap;
        Set<C> keySet;
        Set<Map.Entry<C, V>> entrySet;

        Row(R rowKey) {
            this.rowKey = Preconditions.checkNotNull(rowKey);
        }

        Map<C, V> backingRowMap() {
            Map map;
            if (this.backingRowMap == null || this.backingRowMap.isEmpty() && StandardTable.this.backingMap.containsKey(this.rowKey)) {
                this.backingRowMap = this.computeBackingRowMap();
                map = this.backingRowMap;
            } else {
                map = this.backingRowMap;
            }
            return map;
        }

        Map<C, V> computeBackingRowMap() {
            return StandardTable.this.backingMap.get(this.rowKey);
        }

        void maintainEmptyInvariant() {
            if (this.backingRowMap() != null && this.backingRowMap.isEmpty()) {
                StandardTable.this.backingMap.remove(this.rowKey);
                this.backingRowMap = null;
            }
        }

        @Override
        public boolean containsKey(Object key) {
            Map backingRowMap = this.backingRowMap();
            return key != null && backingRowMap != null && Maps.safeContainsKey(backingRowMap, key);
        }

        @Override
        public V get(Object key) {
            Map backingRowMap = this.backingRowMap();
            return key != null && backingRowMap != null ? (Object)Maps.safeGet(backingRowMap, key) : null;
        }

        @Override
        public V put(C key, V value) {
            Preconditions.checkNotNull(key);
            Preconditions.checkNotNull(value);
            if (this.backingRowMap != null && !this.backingRowMap.isEmpty()) {
                return this.backingRowMap.put(key, value);
            }
            return StandardTable.this.put(this.rowKey, key, value);
        }

        @Override
        public V remove(Object key) {
            try {
                Map backingRowMap = this.backingRowMap();
                if (backingRowMap == null) {
                    return null;
                }
                Object result = backingRowMap.remove(key);
                this.maintainEmptyInvariant();
                return result;
            }
            catch (ClassCastException e) {
                return null;
            }
        }

        @Override
        public void clear() {
            Map backingRowMap = this.backingRowMap();
            if (backingRowMap != null) {
                backingRowMap.clear();
            }
            this.maintainEmptyInvariant();
        }

        @Override
        public Set<C> keySet() {
            Set result = this.keySet;
            if (result == null) {
                this.keySet = new Maps.KeySet<C, V>(){

                    @Override
                    Map<C, V> map() {
                        return Row.this;
                    }
                };
                return this.keySet;
            }
            return result;
        }

        @Override
        public Set<Map.Entry<C, V>> entrySet() {
            Set result = this.entrySet;
            if (result == null) {
                this.entrySet = new RowEntrySet();
                return this.entrySet;
            }
            return result;
        }

        private class RowEntrySet
        extends Maps.EntrySet<C, V> {
            private RowEntrySet() {
            }

            @Override
            Map<C, V> map() {
                return Row.this;
            }

            @Override
            public int size() {
                Map map = Row.this.backingRowMap();
                return map == null ? 0 : map.size();
            }

            @Override
            public Iterator<Map.Entry<C, V>> iterator() {
                Map map = Row.this.backingRowMap();
                if (map == null) {
                    return Iterators.emptyModifiableIterator();
                }
                final Iterator iterator = map.entrySet().iterator();
                return new Iterator<Map.Entry<C, V>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<C, V> next() {
                        final Map.Entry entry = (Map.Entry)iterator.next();
                        return new ForwardingMapEntry<C, V>(){

                            @Override
                            protected Map.Entry<C, V> delegate() {
                                return entry;
                            }

                            @Override
                            public V setValue(V value) {
                                return super.setValue(Preconditions.checkNotNull(value));
                            }

                            @Override
                            public boolean equals(Object object) {
                                return this.standardEquals(object);
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                        Row.this.maintainEmptyInvariant();
                    }
                };
            }
        }
    }

    private class CellIterator
    implements Iterator<Table.Cell<R, C, V>> {
        final Iterator<Map.Entry<R, Map<C, V>>> rowIterator;
        Map.Entry<R, Map<C, V>> rowEntry;
        Iterator<Map.Entry<C, V>> columnIterator;

        private CellIterator() {
            this.rowIterator = StandardTable.this.backingMap.entrySet().iterator();
            this.columnIterator = Iterators.emptyModifiableIterator();
        }

        @Override
        public boolean hasNext() {
            return this.rowIterator.hasNext() || this.columnIterator.hasNext();
        }

        @Override
        public Table.Cell<R, C, V> next() {
            if (!this.columnIterator.hasNext()) {
                this.rowEntry = this.rowIterator.next();
                this.columnIterator = this.rowEntry.getValue().entrySet().iterator();
            }
            Map.Entry columnEntry = this.columnIterator.next();
            return Tables.immutableCell(this.rowEntry.getKey(), columnEntry.getKey(), columnEntry.getValue());
        }

        @Override
        public void remove() {
            this.columnIterator.remove();
            if (this.rowEntry.getValue().isEmpty()) {
                this.rowIterator.remove();
            }
        }
    }

    private class CellSet
    extends TableSet<Table.Cell<R, C, V>> {
        private CellSet() {
        }

        @Override
        public Iterator<Table.Cell<R, C, V>> iterator() {
            return new CellIterator();
        }

        @Override
        public int size() {
            return StandardTable.this.size();
        }

        @Override
        public boolean contains(Object obj) {
            if (obj instanceof Table.Cell) {
                Table.Cell cell = (Table.Cell)obj;
                return StandardTable.this.containsMapping(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
            }
            return false;
        }

        @Override
        public boolean remove(Object obj) {
            if (obj instanceof Table.Cell) {
                Table.Cell cell = (Table.Cell)obj;
                return StandardTable.this.removeMapping(cell.getRowKey(), cell.getColumnKey(), cell.getValue());
            }
            return false;
        }
    }

    private abstract class TableSet<T>
    extends AbstractSet<T> {
        private TableSet() {
        }

        @Override
        public boolean isEmpty() {
            return StandardTable.this.backingMap.isEmpty();
        }

        @Override
        public void clear() {
            StandardTable.this.backingMap.clear();
        }
    }

    private abstract class TableCollection<T>
    extends AbstractCollection<T> {
        private TableCollection() {
        }

        @Override
        public boolean isEmpty() {
            return StandardTable.this.backingMap.isEmpty();
        }

        @Override
        public void clear() {
            StandardTable.this.backingMap.clear();
        }
    }
}

