/*
 * Decompiled with CFR 0.152.
 */
package closurecompiler.internal.com.google.common.collect;

import closurecompiler.internal.com.google.common.collect.AbstractSetMultimap;
import closurecompiler.internal.com.google.common.collect.Maps;
import closurecompiler.internal.com.google.common.collect.Multimap;
import closurecompiler.internal.com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Set;

public final class HashMultimap<K, V>
extends AbstractSetMultimap<K, V> {
    transient int expectedValuesPerKey = 8;

    public static <K, V> HashMultimap<K, V> create() {
        return new HashMultimap<K, V>();
    }

    public static <K, V> HashMultimap<K, V> create(Multimap<? extends K, ? extends V> multimap) {
        return new HashMultimap<K, V>(multimap);
    }

    private HashMultimap() {
        super(new HashMap());
    }

    private HashMultimap(Multimap<? extends K, ? extends V> multimap) {
        super(Maps.newHashMapWithExpectedSize(multimap.keySet().size()));
        this.putAll(multimap);
    }

    @Override
    Set<V> createCollection() {
        return Sets.newHashSetWithExpectedSize(this.expectedValuesPerKey);
    }
}

