/*
 * Decompiled with CFR 0.152.
 */
package closurecompiler.internal.com.google.common.cache;

import closurecompiler.internal.com.google.common.base.Ascii;
import closurecompiler.internal.com.google.common.base.Equivalence;
import closurecompiler.internal.com.google.common.base.Objects;
import closurecompiler.internal.com.google.common.base.Supplier;
import closurecompiler.internal.com.google.common.base.Suppliers;
import closurecompiler.internal.com.google.common.cache.AbstractCache;
import closurecompiler.internal.com.google.common.cache.CacheStats;
import closurecompiler.internal.com.google.common.cache.CustomConcurrentHashMap;
import closurecompiler.internal.com.google.common.cache.RemovalListener;

public final class CacheBuilder<K, V> {
    static final Supplier<? extends AbstractCache.StatsCounter> DEFAULT_STATS_COUNTER = Suppliers.ofInstance(new AbstractCache.StatsCounter(){

        @Override
        public void recordEviction() {
        }
    });
    static final CacheStats EMPTY_STATS = new CacheStats(0L, 0L, 0L, 0L, 0L, 0L);
    static final Supplier<AbstractCache.SimpleStatsCounter> CACHE_STATS_COUNTER = new Supplier<AbstractCache.SimpleStatsCounter>(){

        @Override
        public AbstractCache.SimpleStatsCounter get() {
            return new AbstractCache.SimpleStatsCounter();
        }
    };
    int initialCapacity = -1;
    int concurrencyLevel = -1;
    int maximumSize = -1;
    CustomConcurrentHashMap.Strength keyStrength;
    CustomConcurrentHashMap.Strength valueStrength;
    long expireAfterWriteNanos = -1L;
    long expireAfterAccessNanos = -1L;
    Equivalence<Object> keyEquivalence;
    Equivalence<Object> valueEquivalence;
    RemovalListener<? super K, ? super V> removalListener;

    CacheBuilder() {
    }

    public static CacheBuilder<Object, Object> newBuilder() {
        return new CacheBuilder<Object, Object>();
    }

    public String toString() {
        Objects.ToStringHelper s = Objects.toStringHelper(this);
        if (this.initialCapacity != -1) {
            s.add("initialCapacity", this.initialCapacity);
        }
        if (this.concurrencyLevel != -1) {
            s.add("concurrencyLevel", this.concurrencyLevel);
        }
        if (this.maximumSize != -1) {
            s.add("maximumSize", this.maximumSize);
        }
        if (this.expireAfterWriteNanos != -1L) {
            s.add("expireAfterWrite", this.expireAfterWriteNanos + "ns");
        }
        if (this.expireAfterAccessNanos != -1L) {
            s.add("expireAfterAccess", this.expireAfterAccessNanos + "ns");
        }
        if (this.keyStrength != null) {
            s.add("keyStrength", Ascii.toLowerCase(this.keyStrength.toString()));
        }
        if (this.valueStrength != null) {
            s.add("valueStrength", Ascii.toLowerCase(this.valueStrength.toString()));
        }
        if (this.keyEquivalence != null) {
            s.addValue("keyEquivalence");
        }
        if (this.valueEquivalence != null) {
            s.addValue("valueEquivalence");
        }
        if (this.removalListener != null) {
            s.addValue("removalListener");
        }
        return s.toString();
    }
}

