/*
 * Decompiled with CFR 0.152.
 */
package closurecompiler.internal.com.google.common.cache;

import closurecompiler.internal.com.google.common.cache.Cache;
import closurecompiler.internal.com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {
    public V getUnchecked(K key) {
        try {
            return this.get(key);
        }
        catch (ExecutionException e) {
            throw new UncheckedExecutionException(e.getCause());
        }
    }

    @Override
    public final V apply(K key) {
        return this.getUnchecked(key);
    }

    public static class SimpleStatsCounter
    implements StatsCounter {
        private final AtomicLong hitCount = new AtomicLong();
        private final AtomicLong missCount = new AtomicLong();
        private final AtomicLong loadSuccessCount = new AtomicLong();
        private final AtomicLong loadExceptionCount = new AtomicLong();
        private final AtomicLong totalLoadTime = new AtomicLong();
        private final AtomicLong evictionCount = new AtomicLong();

        @Override
        public void recordEviction() {
            this.evictionCount.incrementAndGet();
        }
    }

    public static interface StatsCounter {
        public void recordEviction();
    }
}

