/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.kotlin;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;
import org.codehaus.griffon.kotlin.LoggingHelper;
import org.jetbrains.jet.buildtools.core.BytecodeCompiler;
import org.jetbrains.jet.buildtools.core.Util;
import org.jetbrains.jet.cli.common.messages.MessageCollector;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentException;
import org.jetbrains.jet.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.jet.cli.jvm.compiler.JetCoreEnvironment;
import org.jetbrains.jet.cli.jvm.compiler.K2JVMCompileEnvironmentConfiguration;
import org.jetbrains.jet.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.jet.lang.resolve.java.CompilerDependencies;
import org.jetbrains.jet.lang.resolve.java.CompilerSpecialMode;

public class KotlincTask
extends MatchingTask {
    protected final LoggingHelper log = new LoggingHelper((Task)this);
    protected File output;
    protected File jar;
    protected File stdlib;
    protected Path src;
    protected File module;
    protected Path compileClasspath;
    protected boolean includeRuntime = true;
    protected boolean force;

    public void setOutput(File output) {
        this.output = output;
    }

    public void setJar(File jar) {
        this.jar = jar;
    }

    public void setStdlib(File stdlib) {
        this.stdlib = stdlib;
    }

    public void setModule(File module) {
        this.module = module;
    }

    public void setIncludeRuntime(boolean includeRuntime) {
        this.includeRuntime = includeRuntime;
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    public void setSrcdir(Path dir) {
        assert (dir != null);
        if (this.src == null) {
            this.src = dir;
        } else {
            this.src.append(dir);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public void setClasspathRef(Reference ref) {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        this.compileClasspath.createPath().setRefid(ref);
    }

    public void addConfiguredClasspath(Path classpath) {
        this.setClasspath(classpath);
    }

    public void execute() {
        GlobPatternMapper mapper = new GlobPatternMapper();
        mapper.setFrom("*.kt");
        mapper.setTo("*.class");
        int count = 0;
        String[] list = this.src.list();
        ArrayList<String> sources = new ArrayList<String>();
        for (int i = 0; i < list.length; ++i) {
            File basedir = this.getProject().resolveFile(list[i]);
            if (!basedir.exists()) {
                throw new CompileEnvironmentException("Source directory does not exist: " + basedir);
            }
            DirectoryScanner scanner = this.getDirectoryScanner(basedir);
            String[] includes = scanner.getIncludedFiles();
            if (this.force) {
                this.log.debug("Forcefully including all files from: " + basedir);
                for (int j = 0; j < includes.length; ++j) {
                    File file = new File(basedir, includes[j]);
                    this.log.debug("    " + file);
                    sources.add(file.getAbsolutePath());
                    ++count;
                }
                continue;
            }
            this.log.debug("Including changed files from: " + basedir);
            SourceFileScanner sourceScanner = new SourceFileScanner((Task)this);
            File[] files = sourceScanner.restrictAsFiles(includes, basedir, this.output, (FileNameMapper)mapper);
            for (int j = 0; j < files.length; ++j) {
                this.log.debug("    " + files[j]);
                sources.add(files[j].getAbsolutePath());
                ++count;
            }
        }
        if (count > 0) {
            this.log.info("Compiling " + count + " source file" + (count > 1 ? "s" : "") + " to " + this.output);
            this.compile(sources);
        } else {
            this.log.info("No sources found to compile");
        }
    }

    private void compile(List<String> sources) {
        System.out.println("==============");
        System.out.println(sources);
        System.out.println("==============");
        BytecodeCompiler compiler = new BytecodeCompiler();
        String stdlibPath = this.stdlib != null ? Util.getPath((File)this.stdlib) : null;
        String[] classpath = this.compileClasspath != null ? this.compileClasspath.list() : null;
        try {
            K2JVMCompileEnvironmentConfiguration configuration = this.env(compiler, stdlibPath, classpath);
            boolean success = KotlinToJVMBytecodeCompiler.compileBunchOfSourceDirectories((K2JVMCompileEnvironmentConfiguration)configuration, sources, null, (String)this.output.getAbsolutePath(), (boolean)false, (boolean)true);
            if (!success) {
                throw new BuildException(KotlincTask.errorMessage(false));
            }
        }
        catch (Exception e) {
            throw new BuildException(KotlincTask.errorMessage(true), (Throwable)e);
        }
    }

    private K2JVMCompileEnvironmentConfiguration env(BytecodeCompiler compiler, String stdlib, String[] classpath) {
        CompilerDependencies dependencies = CompilerDependencies.compilerDependenciesForProduction((CompilerSpecialMode)CompilerSpecialMode.REGULAR);
        JetCoreEnvironment environment = new JetCoreEnvironment(CompileEnvironmentUtil.createMockDisposable(), dependencies);
        K2JVMCompileEnvironmentConfiguration env = new K2JVMCompileEnvironmentConfiguration(environment, MessageCollector.PLAIN_TEXT_TO_SYSTEM_ERR, false, Collections.emptyList());
        if (stdlib != null && stdlib.trim().length() > 0) {
            File file = new File(stdlib);
            CompileEnvironmentUtil.addToClasspath((JetCoreEnvironment)env.getEnvironment(), (File[])new File[]{file});
        }
        if (classpath != null && classpath.length > 0) {
            CompileEnvironmentUtil.addToClasspath((JetCoreEnvironment)env.getEnvironment(), (String[])classpath);
        }
        env.getCompilerPlugins().addAll(compiler.getCompilerPlugins());
        return env;
    }

    private static String errorMessage(boolean exceptionThrown) {
        return String.format("Compilation failed" + (exceptionThrown ? "" : ", see \"ERROR:\" messages above for more details."), new Object[0]);
    }
}

