/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.runner;

import com.google.dart.runner.JavaScriptLauncher;
import com.google.dart.runner.RunnerError;
import com.google.dart.runner.RunnerOptions;
import java.io.PrintStream;
import java.lang.reflect.Member;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class RhinoLauncher
implements JavaScriptLauncher {
    @Override
    public void execute(String jsScript, String sourceName, String[] args, RunnerOptions options, PrintStream stdout, PrintStream stderr) throws RunnerError {
        try {
            Context ctx = Context.enter();
            ScriptableObject scope = ctx.initStandardObjects();
            scope.put("assert", (Scriptable)scope, (Object)new AssertFunction());
            scope.put("native_Expect__throwException", (Scriptable)scope, (Object)new ThrowException("Expect__throwException", ThrowException.class.getMethod("throwException", Object.class), (Scriptable)scope));
            scope.put("write", (Scriptable)scope, (Object)new Write("write", Write.class.getMethod("write", Object.class), (Scriptable)scope, stderr));
            scope.put("arguments", (Scriptable)scope, Context.javaToJS((Object)args, (Scriptable)scope));
            ctx.evaluateString((Scriptable)scope, jsScript, sourceName, 1, null);
        }
        catch (NoSuchMethodException e) {
            throw new RunnerError(e);
        }
        catch (RhinoException e) {
            if (options.verbose()) {
                stdout.println(jsScript);
                stdout.flush();
            }
            StringBuffer msg = new StringBuffer();
            msg.append(e.sourceName());
            msg.append(" (" + e.lineNumber() + ":" + e.columnNumber() + ")");
            msg.append(" : " + e.details());
            stderr.println(msg.toString());
            throw e;
        }
        finally {
            Context.exit();
        }
    }

    private static abstract class SimpleFunction
    implements Function {
        private SimpleFunction() {
        }

        public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
            return null;
        }

        public void delete(int index) {
        }

        public void delete(String name) {
        }

        public Object get(int index, Scriptable start) {
            return null;
        }

        public Object get(String name, Scriptable start) {
            return null;
        }

        public String getClassName() {
            return "Function";
        }

        public Object getDefaultValue(Class<?> hint) {
            return null;
        }

        public Object[] getIds() {
            return null;
        }

        public Scriptable getParentScope() {
            return null;
        }

        public Scriptable getPrototype() {
            return null;
        }

        public boolean has(int index, Scriptable start) {
            return false;
        }

        public boolean has(String name, Scriptable start) {
            return false;
        }

        public boolean hasInstance(Scriptable instance) {
            return false;
        }

        public void put(int index, Scriptable start, Object value) {
        }

        public void put(String name, Scriptable start, Object value) {
        }

        public void setParentScope(Scriptable parent) {
        }

        public void setPrototype(Scriptable prototype) {
        }
    }

    public static class Write
    extends FunctionObject {
        private PrintStream out;

        public Write(String name, Member methodOrConstructor, Scriptable scope, PrintStream out) {
            super(name, methodOrConstructor, scope);
            this.out = out;
        }

        public Object call(Context ctx, Scriptable scope, Scriptable thisObj, Object[] args) {
            this.write(args[0]);
            return Undefined.instance;
        }

        public void write(Object arg0) {
            this.out.print(arg0);
        }
    }

    public static class ThrowException
    extends FunctionObject {
        public ThrowException(String name, Member methodOrConstructor, Scriptable scope) {
            super(name, methodOrConstructor, scope);
        }

        public Object call(Context ctx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args.length != 1) {
                Context.reportError((String)"Invalid call to Expect_throwException(e)");
            }
            this.throwException(args[0]);
            return Undefined.instance;
        }

        public void throwException(Object arg0) {
            Context.reportError((String)arg0.toString());
        }
    }

    private static class AssertFunction
    extends SimpleFunction {
        private AssertFunction() {
        }

        public Object call(Context ctx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args.length < 1 || args.length > 2) {
                Context.reportError((String)("Invalid call to assertThat(" + args + ")"));
            }
            if (!(args[0] instanceof Boolean)) {
                Context.reportError((String)"Argument 0 must be of type boolean");
            }
            if (args.length == 2 && !(args[1] instanceof String)) {
                Context.reportError((String)"Argument 1 must be of type String");
            }
            if (!((Boolean)args[0]).booleanValue()) {
                Context.reportError((String)("assert() failed" + (args.length == 2 ? ": " + args[1] : "")));
            }
            return null;
        }
    }
}

