/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.runner;

import com.google.dart.compiler.DartSource;
import com.google.dart.compiler.LibrarySource;
import com.google.dart.compiler.UrlDartSource;
import com.google.dart.compiler.UrlSource;
import java.net.URISyntaxException;

class BundleLibrarySource
extends UrlSource
implements LibrarySource {
    private final ClassLoader loader;
    private final String basePath;
    private final String filename;

    public BundleLibrarySource(ClassLoader loader, String basePath, String filename) throws URISyntaxException {
        super(loader.getResource(basePath + filename).toURI());
        this.loader = loader;
        this.basePath = basePath;
        this.filename = filename;
    }

    @Override
    public LibrarySource getImportFor(String filename) {
        try {
            return new BundleLibrarySource(this.loader, this.basePath, filename);
        }
        catch (URISyntaxException e) {
            throw new AssertionError();
        }
    }

    @Override
    public DartSource getSourceFor(String relPath) {
        try {
            return new BundleDartSource(this.loader, this.basePath, relPath);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public String getName() {
        return this.basePath + this.filename;
    }

    private final class BundleDartSource
    extends UrlDartSource {
        private BundleDartSource(ClassLoader loader, String basePath, String filename) throws URISyntaxException {
            super(loader.getResource(basePath + filename).toURI(), filename, BundleLibrarySource.this);
        }

        @Override
        public String getName() {
            return BundleLibrarySource.this.basePath + this.getRelativePath();
        }
    }
}

