/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.util;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class Paths {
    public static String relativePathFor(File baseFile, File relFile) {
        int index;
        String baseFilePath = baseFile.getPath().replace(File.separatorChar, '/');
        String relFilePath = relFile.getPath().replace(File.separatorChar, '/');
        int baseFilePathLen = baseFilePath.length();
        int relFilePathLen = relFilePath.length();
        if (baseFilePathLen == 0 && relFilePathLen == 0) {
            return relFilePath;
        }
        for (index = 0; index < baseFilePathLen - 1 && index < relFilePathLen - 1 && baseFilePath.charAt(index) == relFilePath.charAt(index); ++index) {
        }
        while (index >= 0 && (baseFilePath.charAt(index) != '/' || relFilePath.charAt(index) != '/')) {
            --index;
        }
        int commonStart = index;
        StringBuilder relPath = new StringBuilder(baseFilePathLen + relFilePathLen - commonStart * 2);
        index = commonStart + 1;
        while ((index = baseFilePath.indexOf(47, index)) != -1) {
            relPath.append("../");
            ++index;
        }
        relPath.append(relFilePath.substring(commonStart + 1));
        return relPath.toString();
    }

    public static File relativePathToFile(File baseFile, String relPath) {
        if (relPath.startsWith("/")) {
            return new File(relPath);
        }
        File parentFile = baseFile.getParentFile();
        String name = parentFile == null ? "." : parentFile.getPath().replace(File.separatorChar, '/');
        name = URI.create(name + "/" + relPath).normalize().getPath();
        return new File(name);
    }

    public static List<File> toFiles(List<String> filePaths) {
        ArrayList<File> files = new ArrayList<File>();
        for (String path : filePaths) {
            files.add(new File(path));
        }
        return files;
    }
}

