/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class Maps {
    private static final Class<?> MULTI_MAP_CLASS = HashMap.class;
    private static final Class<?> SINGLETON_MAP_CLASS = Collections.singletonMap(null, null).getClass();

    public static <K, V> Map<K, V> create() {
        return Collections.emptyMap();
    }

    public static <K, V> Map<K, V> create(K key, V value) {
        return Collections.singletonMap(key, value);
    }

    public static <K, V> Map<K, V> normalize(Map<K, V> map) {
        switch (map.size()) {
            case 0: {
                return Maps.create();
            }
            case 1: {
                if (map.getClass() == SINGLETON_MAP_CLASS) {
                    return map;
                }
                K key = map.keySet().iterator().next();
                return Maps.create(key, map.get(key));
            }
        }
        if (map.getClass() == MULTI_MAP_CLASS) {
            return map;
        }
        return new HashMap<K, V>(map);
    }

    public static <K, V> Map<K, V> normalizeUnmodifiable(Map<K, V> map) {
        if (map.size() < 2) {
            return Maps.normalize(map);
        }
        return Collections.unmodifiableMap(Maps.normalize(map));
    }

    public static <K, V> Map<K, V> put(Map<K, V> map, K key, V value) {
        switch (map.size()) {
            case 0: {
                return Collections.singletonMap(key, value);
            }
            case 1: {
                if (map.containsKey(key)) {
                    return Maps.create(key, value);
                }
                HashMap<K, V> result = new HashMap<K, V>();
                result.put(map.keySet().iterator().next(), map.values().iterator().next());
                result.put(key, value);
                return result;
            }
        }
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> putAll(Map<K, V> map, Map<K, V> toAdd) {
        switch (toAdd.size()) {
            case 0: {
                return map;
            }
            case 1: {
                K key = toAdd.keySet().iterator().next();
                return Maps.put(map, key, toAdd.get(key));
            }
        }
        switch (map.size()) {
            case 0: {
                return new HashMap<K, V>(toAdd);
            }
            case 1: {
                HashMap<K, V> result = new HashMap<K, V>();
                K key = map.keySet().iterator().next();
                result.put(key, map.get(key));
                result.putAll(toAdd);
                return result;
            }
        }
        map.putAll(toAdd);
        return map;
    }

    public static <K, V> Map<K, V> putOrdered(Map<K, V> map, K key, V value) {
        switch (map.size()) {
            case 0: {
                return Collections.singletonMap(key, value);
            }
            case 1: {
                if (map.containsKey(key)) {
                    return Maps.create(key, value);
                }
                LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
                result.put(map.keySet().iterator().next(), map.values().iterator().next());
                result.put(key, value);
                return result;
            }
        }
        map.put(key, value);
        return map;
    }

    public static <K, V> Map<K, V> remove(Map<K, V> map, K key) {
        switch (map.size()) {
            case 0: {
                return map;
            }
            case 1: {
                if (map.containsKey(key)) {
                    return Maps.create();
                }
                return map;
            }
            case 2: {
                if (map.containsKey(key)) {
                    map.remove(key);
                    key = map.keySet().iterator().next();
                    return Maps.create(key, map.get(key));
                }
                return map;
            }
        }
        map.remove(key);
        return map;
    }
}

