/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.type;

import com.google.dart.compiler.resolver.Element;
import com.google.dart.compiler.resolver.TypeVariableElement;
import com.google.dart.compiler.type.AbstractType;
import com.google.dart.compiler.type.Type;
import com.google.dart.compiler.type.TypeKind;
import com.google.dart.compiler.type.TypeVariable;
import java.util.Iterator;
import java.util.List;

class TypeVariableImplementation
extends AbstractType
implements TypeVariable {
    private final TypeVariableElement element;

    public TypeVariableImplementation(TypeVariableElement element) {
        this.element = element;
    }

    @Override
    public TypeVariableElement getElement() {
        return this.element;
    }

    @Override
    public TypeVariableElement getTypeVariableElement() {
        return this.getElement();
    }

    public String toString() {
        Element owner = this.element.getDeclaringElement();
        if (owner == null) {
            return this.element.getName();
        }
        return owner.getName() + "." + this.element.getName();
    }

    @Override
    public Type subst(List<? extends Type> arguments, List<? extends Type> parameters) {
        Iterator<? extends Type> itA = arguments.iterator();
        Iterator<? extends Type> itP = parameters.iterator();
        while (itA.hasNext() && itP.hasNext()) {
            Type argument = itA.next();
            Type parameter = itP.next();
            if (!this.equals(parameter)) continue;
            return argument;
        }
        assert (itA.hasNext() == itP.hasNext()) : "arguments: " + arguments + " parameters: " + parameters;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TypeVariable) {
            TypeVariable other = (TypeVariable)obj;
            return this.element.equals(other.getElement());
        }
        return false;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.VARIABLE;
    }
}

