/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.type;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.dart.compiler.DartCompilationError;
import com.google.dart.compiler.DartCompilationPhase;
import com.google.dart.compiler.DartCompilerContext;
import com.google.dart.compiler.ErrorCode;
import com.google.dart.compiler.ast.DartArrayAccess;
import com.google.dart.compiler.ast.DartArrayLiteral;
import com.google.dart.compiler.ast.DartAssertion;
import com.google.dart.compiler.ast.DartBinaryExpression;
import com.google.dart.compiler.ast.DartBlock;
import com.google.dart.compiler.ast.DartBooleanLiteral;
import com.google.dart.compiler.ast.DartBreakStatement;
import com.google.dart.compiler.ast.DartCase;
import com.google.dart.compiler.ast.DartCatchBlock;
import com.google.dart.compiler.ast.DartClass;
import com.google.dart.compiler.ast.DartConditional;
import com.google.dart.compiler.ast.DartContinueStatement;
import com.google.dart.compiler.ast.DartDeclaration;
import com.google.dart.compiler.ast.DartDefault;
import com.google.dart.compiler.ast.DartDoWhileStatement;
import com.google.dart.compiler.ast.DartDoubleLiteral;
import com.google.dart.compiler.ast.DartEmptyStatement;
import com.google.dart.compiler.ast.DartExprStmt;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartField;
import com.google.dart.compiler.ast.DartFieldDefinition;
import com.google.dart.compiler.ast.DartForInStatement;
import com.google.dart.compiler.ast.DartForStatement;
import com.google.dart.compiler.ast.DartFunction;
import com.google.dart.compiler.ast.DartFunctionExpression;
import com.google.dart.compiler.ast.DartFunctionObjectInvocation;
import com.google.dart.compiler.ast.DartFunctionTypeAlias;
import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartIfStatement;
import com.google.dart.compiler.ast.DartImportDirective;
import com.google.dart.compiler.ast.DartInitializer;
import com.google.dart.compiler.ast.DartIntegerLiteral;
import com.google.dart.compiler.ast.DartInvocation;
import com.google.dart.compiler.ast.DartLabel;
import com.google.dart.compiler.ast.DartLibraryDirective;
import com.google.dart.compiler.ast.DartLiteral;
import com.google.dart.compiler.ast.DartMapLiteral;
import com.google.dart.compiler.ast.DartMapLiteralEntry;
import com.google.dart.compiler.ast.DartMethodDefinition;
import com.google.dart.compiler.ast.DartMethodInvocation;
import com.google.dart.compiler.ast.DartNamedExpression;
import com.google.dart.compiler.ast.DartNativeBlock;
import com.google.dart.compiler.ast.DartNativeDirective;
import com.google.dart.compiler.ast.DartNewExpression;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartNodeTraverser;
import com.google.dart.compiler.ast.DartNullLiteral;
import com.google.dart.compiler.ast.DartParameter;
import com.google.dart.compiler.ast.DartParameterizedTypeNode;
import com.google.dart.compiler.ast.DartParenthesizedExpression;
import com.google.dart.compiler.ast.DartPlainVisitor;
import com.google.dart.compiler.ast.DartPropertyAccess;
import com.google.dart.compiler.ast.DartRedirectConstructorInvocation;
import com.google.dart.compiler.ast.DartResourceDirective;
import com.google.dart.compiler.ast.DartReturnStatement;
import com.google.dart.compiler.ast.DartSourceDirective;
import com.google.dart.compiler.ast.DartStringInterpolation;
import com.google.dart.compiler.ast.DartStringLiteral;
import com.google.dart.compiler.ast.DartSuperConstructorInvocation;
import com.google.dart.compiler.ast.DartSuperExpression;
import com.google.dart.compiler.ast.DartSwitchStatement;
import com.google.dart.compiler.ast.DartSyntheticErrorExpression;
import com.google.dart.compiler.ast.DartSyntheticErrorStatement;
import com.google.dart.compiler.ast.DartThisExpression;
import com.google.dart.compiler.ast.DartThrowStatement;
import com.google.dart.compiler.ast.DartTryStatement;
import com.google.dart.compiler.ast.DartTypeExpression;
import com.google.dart.compiler.ast.DartTypeNode;
import com.google.dart.compiler.ast.DartTypeParameter;
import com.google.dart.compiler.ast.DartUnaryExpression;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.ast.DartUnqualifiedInvocation;
import com.google.dart.compiler.ast.DartVariable;
import com.google.dart.compiler.ast.DartVariableStatement;
import com.google.dart.compiler.ast.DartWhileStatement;
import com.google.dart.compiler.ast.ElementReference;
import com.google.dart.compiler.ast.Modifiers;
import com.google.dart.compiler.parser.Token;
import com.google.dart.compiler.resolver.ClassElement;
import com.google.dart.compiler.resolver.ConstructorElement;
import com.google.dart.compiler.resolver.CoreTypeProvider;
import com.google.dart.compiler.resolver.CyclicDeclarationException;
import com.google.dart.compiler.resolver.DuplicatedInterfaceException;
import com.google.dart.compiler.resolver.Element;
import com.google.dart.compiler.resolver.ElementKind;
import com.google.dart.compiler.resolver.Elements;
import com.google.dart.compiler.resolver.EnclosingElement;
import com.google.dart.compiler.resolver.FieldElement;
import com.google.dart.compiler.resolver.MethodElement;
import com.google.dart.compiler.resolver.ResolverErrorCode;
import com.google.dart.compiler.resolver.TypeErrorCode;
import com.google.dart.compiler.resolver.VariableElement;
import com.google.dart.compiler.type.DynamicType;
import com.google.dart.compiler.type.FunctionAliasType;
import com.google.dart.compiler.type.FunctionType;
import com.google.dart.compiler.type.InterfaceType;
import com.google.dart.compiler.type.Type;
import com.google.dart.compiler.type.TypeKind;
import com.google.dart.compiler.type.TypeVariable;
import com.google.dart.compiler.type.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TypeAnalyzer
implements DartCompilationPhase {
    private final ConcurrentHashMap<ClassElement, List<Element>> unimplementedElements = new ConcurrentHashMap();
    private final Set<ClassElement> diagnosedAbstractClasses = Collections.newSetFromMap(new ConcurrentHashMap());

    public static Type analyze(DartNode node, CoreTypeProvider typeProvider, DartCompilerContext context, InterfaceType currentClass) {
        ConcurrentHashMap<ClassElement, List<Element>> unimplementedElements = new ConcurrentHashMap<ClassElement, List<Element>>();
        Set<ClassElement> diagnosed = Collections.newSetFromMap(new ConcurrentHashMap());
        Analyzer analyzer = new Analyzer(context, typeProvider, unimplementedElements, diagnosed);
        analyzer.setCurrentClass(currentClass);
        return node.accept(analyzer);
    }

    @Override
    public DartUnit exec(DartUnit unit, DartCompilerContext context, CoreTypeProvider typeProvider) {
        unit.accept(new Analyzer(context, typeProvider, this.unimplementedElements, this.diagnosedAbstractClasses));
        return unit;
    }

    @VisibleForTesting
    static class Analyzer
    implements DartPlainVisitor<Type> {
        private final DynamicType dynamicType;
        private final Type stringType;
        private final InterfaceType defaultLiteralMapType;
        private final Type voidType;
        private final DartCompilerContext context;
        private final Types types;
        private Type expected;
        private InterfaceType currentClass;
        private final ConcurrentHashMap<ClassElement, List<Element>> unimplementedElements;
        private final InterfaceType boolType;
        private final InterfaceType numType;
        private final InterfaceType intType;
        private final Type nullType;
        private final InterfaceType functionType;
        private final InterfaceType dynamicIteratorType;
        private int catchDepth = 0;

        Analyzer(DartCompilerContext context, CoreTypeProvider typeProvider, ConcurrentHashMap<ClassElement, List<Element>> unimplementedElements, Set<ClassElement> diagnosedAbstractClasses) {
            this.context = context;
            this.unimplementedElements = unimplementedElements;
            this.types = Types.getInstance(typeProvider);
            this.dynamicType = typeProvider.getDynamicType();
            this.stringType = typeProvider.getStringType();
            this.defaultLiteralMapType = typeProvider.getMapType(this.stringType, this.dynamicType);
            this.voidType = typeProvider.getVoidType();
            this.boolType = typeProvider.getBoolType();
            this.numType = typeProvider.getNumType();
            this.intType = typeProvider.getIntType();
            this.nullType = typeProvider.getNullType();
            this.functionType = typeProvider.getFunctionType();
            this.dynamicIteratorType = typeProvider.getIteratorType(this.dynamicType);
        }

        @VisibleForTesting
        void setCurrentClass(InterfaceType type) {
            this.currentClass = type;
        }

        private InterfaceType getCurrentClass() {
            return this.currentClass;
        }

        private DynamicType typeError(DartNode node, ErrorCode code, Object ... arguments) {
            this.onError(node, code, arguments);
            return this.dynamicType;
        }

        private void onError(DartNode node, ErrorCode code, Object ... arguments) {
            this.context.onError(new DartCompilationError(node, code, arguments));
        }

        AssertionError internalError(DartNode node, String message, Object ... arguments) {
            message = String.format(message, arguments);
            this.context.onError(new DartCompilationError(node, (ErrorCode)TypeErrorCode.INTERNAL_ERROR, message));
            return new AssertionError((Object)("Internal error: " + message));
        }

        private Type typeOfLiteral(DartLiteral node) {
            return node.getType();
        }

        private Token getBasicOperator(DartNode diagnosticNode, Token op) {
            switch (op) {
                case INC: {
                    return Token.ADD;
                }
                case DEC: {
                    return Token.SUB;
                }
                case ASSIGN_BIT_OR: {
                    return Token.BIT_OR;
                }
                case ASSIGN_BIT_XOR: {
                    return Token.BIT_XOR;
                }
                case ASSIGN_BIT_AND: {
                    return Token.BIT_AND;
                }
                case ASSIGN_SHL: {
                    return Token.SHL;
                }
                case ASSIGN_SAR: {
                    return Token.SAR;
                }
                case ASSIGN_SHR: {
                    return Token.SHR;
                }
                case ASSIGN_ADD: {
                    return Token.ADD;
                }
                case ASSIGN_SUB: {
                    return Token.SUB;
                }
                case ASSIGN_MUL: {
                    return Token.MUL;
                }
                case ASSIGN_DIV: {
                    return Token.DIV;
                }
                case ASSIGN_MOD: {
                    return Token.MOD;
                }
                case ASSIGN_TRUNC: {
                    return Token.TRUNC;
                }
            }
            this.internalError(diagnosticNode, "unexpected operator %s", op.name());
            return null;
        }

        @Override
        public Type visitRedirectConstructorInvocation(DartRedirectConstructorInvocation node) {
            return this.checkConstructorForwarding(node, node.getSymbol());
        }

        private String methodNameForUnaryOperator(DartNode diagnosticNode, Token operator) {
            if (operator == Token.SUB) {
                return "operator negate";
            }
            if (operator == Token.BIT_NOT) {
                return "operator ~";
            }
            return "operator " + this.getBasicOperator(diagnosticNode, operator).getSyntax();
        }

        private String methodNameForBinaryOperator(Token operator) {
            return "operator " + operator.getSyntax();
        }

        private Type analyzeBinaryOperator(ElementReference node, Type lhs, Token operator, DartNode diagnosticNode, DartExpression rhs) {
            Type rhsType = this.nonVoidTypeOf(rhs);
            String methodName = this.methodNameForBinaryOperator(operator);
            InterfaceType.Member member = this.lookupMember(lhs, methodName, diagnosticNode);
            if (member != null) {
                node.setReferencedElement(member.getElement());
                return this.analyzeMethodInvocation(lhs, member, methodName, diagnosticNode, Collections.singletonList(rhsType), Collections.singletonList(rhs));
            }
            return this.dynamicType;
        }

        @Override
        public Type visitBinaryExpression(DartBinaryExpression node) {
            DartExpression lhsNode = node.getArg1();
            Type lhs = this.nonVoidTypeOf(lhsNode);
            DartExpression rhsNode = node.getArg2();
            Token operator = node.getOperator();
            switch (operator) {
                case ASSIGN: {
                    Type rhs = this.nonVoidTypeOf(rhsNode);
                    this.checkAssignable(rhsNode, lhs, rhs);
                    return rhs;
                }
                case ASSIGN_SHR: 
                case ASSIGN_ADD: 
                case ASSIGN_SUB: 
                case ASSIGN_MUL: 
                case ASSIGN_DIV: 
                case ASSIGN_MOD: 
                case ASSIGN_TRUNC: {
                    Token basicOperator = this.getBasicOperator(node, operator);
                    Type type = this.analyzeBinaryOperator(node, lhs, basicOperator, lhsNode, rhsNode);
                    this.checkAssignable(node, lhs, type);
                    return type;
                }
                case OR: 
                case AND: {
                    this.checkAssignable(lhsNode, this.boolType, lhs);
                    this.checkAssignable(this.boolType, rhsNode);
                    return this.boolType;
                }
                case ASSIGN_BIT_OR: 
                case ASSIGN_BIT_XOR: 
                case ASSIGN_BIT_AND: 
                case ASSIGN_SHL: 
                case ASSIGN_SAR: {
                    if (lhs.equals(this.numType)) {
                        this.checkAssignable(rhsNode, this.numType, this.typeOf(rhsNode));
                        return this.intType;
                    }
                    Token basicOperator = this.getBasicOperator(node, operator);
                    Type type = this.analyzeBinaryOperator(node, lhs, basicOperator, lhsNode, rhsNode);
                    this.checkAssignable(node, lhs, type);
                    return type;
                }
                case BIT_OR: 
                case BIT_XOR: 
                case BIT_AND: 
                case SHL: 
                case SAR: {
                    if (lhs.equals(this.numType)) {
                        this.checkAssignable(rhsNode, this.numType, this.typeOf(rhsNode));
                        return this.intType;
                    }
                    return this.analyzeBinaryOperator(node, lhs, operator, lhsNode, rhsNode);
                }
                case SHR: 
                case ADD: 
                case SUB: 
                case MUL: 
                case DIV: 
                case TRUNC: 
                case MOD: 
                case LT: 
                case GT: 
                case LTE: 
                case GTE: {
                    return this.analyzeBinaryOperator(node, lhs, operator, lhsNode, rhsNode);
                }
                case EQ: 
                case NE: 
                case EQ_STRICT: 
                case NE_STRICT: {
                    this.nonVoidTypeOf(rhsNode);
                    return this.boolType;
                }
                case IS: {
                    if (rhsNode instanceof DartUnaryExpression) {
                        assert (((DartUnaryExpression)rhsNode).getOperator() == Token.NOT);
                        this.nonVoidTypeOf(((DartUnaryExpression)rhsNode).getArg());
                    } else {
                        this.nonVoidTypeOf(rhsNode);
                    }
                    return this.boolType;
                }
                case COMMA: {
                    return this.typeOf(rhsNode);
                }
            }
            throw new AssertionError((Object)("Unknown operator: " + (Object)((Object)operator)));
        }

        @Override
        public Type visitVariableStatement(DartVariableStatement node) {
            Type type = this.typeOf(node.getTypeNode());
            this.visit(node.getVariables());
            return type;
        }

        private List<Type> analyzeArgumentTypes(List<? extends DartExpression> argumentNodes) {
            ArrayList<Type> argumentTypes = new ArrayList<Type>(argumentNodes.size());
            for (DartExpression dartExpression : argumentNodes) {
                argumentTypes.add(this.nonVoidTypeOf(dartExpression));
            }
            return argumentTypes;
        }

        private InterfaceType.Member lookupMember(Type receiver, String methodName, DartNode diagnosticNode) {
            InterfaceType itype = this.types.getInterfaceType(receiver);
            if (itype == null) {
                this.diagnoseNonInterfaceType(diagnosticNode, receiver);
                return null;
            }
            InterfaceType.Member member = itype.lookupMember(methodName);
            if (member == null) {
                this.typeError(diagnosticNode, TypeErrorCode.INTERFACE_HAS_NO_METHOD_NAMED, receiver, methodName);
                return null;
            }
            return member;
        }

        private void checkAssignable(DartNode node, Type t, Type s) {
            t.getClass();
            s.getClass();
            if (!this.types.isAssignable(t, s)) {
                this.typeError(node, TypeErrorCode.TYPE_NOT_ASSIGNMENT_COMPATIBLE, s, t);
            }
        }

        private void checkAssignable(Type targetType, DartExpression node) {
            this.checkAssignable(node, targetType, this.nonVoidTypeOf(node));
        }

        private Type analyzeMethodInvocation(Type receiver, InterfaceType.Member member, String name, DartNode diagnosticNode, List<Type> argumentTypes, List<? extends DartExpression> argumentNodes) {
            FunctionType ftype;
            if (member == null) {
                return this.dynamicType;
            }
            Element element = member.getElement();
            block0 : switch (ElementKind.of(element)) {
                case METHOD: {
                    MethodElement method = (MethodElement)element;
                    if (method.getModifiers().isStatic()) {
                        return this.typeError(diagnosticNode, TypeErrorCode.IS_STATIC_METHOD_IN, name, receiver);
                    }
                    ftype = (FunctionType)member.getType();
                    break;
                }
                case FIELD: {
                    FieldElement field = (FieldElement)element;
                    if (field.getModifiers().isStatic()) {
                        return this.typeError(diagnosticNode, TypeErrorCode.IS_STATIC_FIELD_IN, name, receiver);
                    }
                    switch (TypeKind.of(member.getType())) {
                        case FUNCTION: {
                            ftype = (FunctionType)member.getType();
                            break block0;
                        }
                        case FUNCTION_ALIAS: {
                            ftype = this.types.asFunctionType((FunctionAliasType)member.getType());
                            break block0;
                        }
                        case DYNAMIC: {
                            return member.getType();
                        }
                    }
                    return this.typeError(diagnosticNode, TypeErrorCode.USE_ASSIGNMENT_ON_SETTER, name, receiver);
                }
                default: {
                    return this.typeError(diagnosticNode, TypeErrorCode.NOT_A_METHOD_IN, name, receiver);
                }
            }
            return this.checkArguments(diagnosticNode, argumentNodes, argumentTypes.iterator(), ftype);
        }

        private Type diagnoseNonInterfaceType(DartNode node, Type type) {
            switch (TypeKind.of(type)) {
                case DYNAMIC: {
                    return type;
                }
                case FUNCTION: 
                case FUNCTION_ALIAS: 
                case INTERFACE: 
                case VARIABLE: {
                    throw this.internalError(node, type.toString(), new Object[0]);
                }
                case NONE: {
                    throw this.internalError(node, "type is null", new Object[0]);
                }
                case VOID: {
                    return this.typeError(node, TypeErrorCode.VOID, new Object[0]);
                }
            }
            throw this.internalError(node, type.getKind().name(), new Object[0]);
        }

        private Type checkArguments(DartNode diagnosticNode, List<? extends DartExpression> argumentNodes, Iterator<Type> argumentTypes, FunctionType ftype) {
            int argumentCount = 0;
            List<? extends Type> parameterTypes = ftype.getParameterTypes();
            for (Type type : parameterTypes) {
                if (argumentTypes.hasNext()) {
                    this.checkAssignable(argumentNodes.get(argumentCount), type, argumentTypes.next());
                    ++argumentCount;
                    continue;
                }
                this.typeError(diagnosticNode, TypeErrorCode.MISSING_ARGUMENT, type);
            }
            Map<String, Type> namedParameterTypes = ftype.getNamedParameterTypes();
            Iterator<Type> iterator = namedParameterTypes.values().iterator();
            while (iterator.hasNext() && argumentTypes.hasNext()) {
                this.checkAssignable(argumentNodes.get(argumentCount), iterator.next(), argumentTypes.next());
                ++argumentCount;
            }
            while (ftype.hasRest() && argumentTypes.hasNext()) {
                this.checkAssignable(argumentNodes.get(argumentCount), ftype.getRest(), argumentTypes.next());
                ++argumentCount;
            }
            while (argumentTypes.hasNext()) {
                argumentTypes.next();
                this.typeError(argumentNodes.get(argumentCount), TypeErrorCode.EXTRA_ARGUMENT, new Object[0]);
                ++argumentCount;
            }
            return ftype.getReturnType();
        }

        @Override
        public Type visitTypeNode(DartTypeNode node) {
            return this.validateTypeNode(node, false);
        }

        private Type validateTypeNode(DartTypeNode node, boolean badBoundIsError) {
            Type type = node.getType();
            switch (TypeKind.of(type)) {
                case NONE: {
                    return this.typeError(node, TypeErrorCode.INTERNAL_ERROR, String.format("type \"%s\" is null", node));
                }
                case INTERFACE: {
                    InterfaceType itype = (InterfaceType)type;
                    this.validateBounds(node.getTypeArguments(), itype.getArguments(), itype.getElement().getTypeParameters(), badBoundIsError);
                    return itype;
                }
            }
            return type;
        }

        private void validateBounds(List<? extends DartNode> diagnosticNodes, List<? extends Type> arguments, List<? extends Type> parameters, boolean badBoundIsError) {
            if (arguments.size() == parameters.size() && arguments.size() == diagnosticNodes.size()) {
                List<Object> bounds = new ArrayList(parameters.size());
                for (Type type : parameters) {
                    TypeVariable variable = (TypeVariable)type;
                    Type bound = variable.getTypeVariableElement().getBound();
                    if (bound == null) {
                        this.internalError(variable.getElement().getNode(), "bound is null", new Object[0]);
                    }
                    bounds.add(bound);
                }
                bounds = Types.subst(bounds, arguments, parameters);
                for (int i = 0; i < arguments.size(); ++i) {
                    Type s;
                    Type type = (Type)bounds.get(i);
                    if (this.types.isAssignable(type, s = arguments.get(i))) continue;
                    if (badBoundIsError) {
                        this.onError(diagnosticNodes.get(i), ResolverErrorCode.TYPE_NOT_ASSIGNMENT_COMPATIBLE, s, type);
                        continue;
                    }
                    this.onError(diagnosticNodes.get(i), TypeErrorCode.TYPE_NOT_ASSIGNMENT_COMPATIBLE, s, type);
                }
            }
        }

        Type typeOf(DartNode node) {
            if (node == null) {
                return this.dynamicType;
            }
            return node.accept(this);
        }

        private Type nonVoidTypeOf(DartNode node) {
            Type type = this.typeOf(node);
            if (type.getKind().equals((Object)TypeKind.VOID)) {
                return this.typeError(node, TypeErrorCode.VOID, new Object[0]);
            }
            return type;
        }

        @Override
        public Type visitArrayAccess(DartArrayAccess node) {
            Type target = this.typeOf(node.getTarget());
            return this.analyzeBinaryOperator(node, target, Token.INDEX, node, node.getKey());
        }

        @Override
        public Type visitAssertion(DartAssertion node) {
            DartExpression conditionNode = node.getExpression();
            Type condition = this.nonVoidTypeOf(conditionNode);
            switch (condition.getKind()) {
                case FUNCTION: {
                    FunctionType ftype = (FunctionType)condition;
                    Type returnType = ftype.getReturnType();
                    if (returnType.getKind().equals((Object)TypeKind.VOID)) {
                        this.typeError(conditionNode, TypeErrorCode.VOID, new Object[0]);
                    }
                    this.checkAssignable(conditionNode, this.boolType, returnType);
                    break;
                }
                default: {
                    this.checkAssignable(conditionNode, this.boolType, condition);
                }
            }
            return this.voidType;
        }

        @Override
        public Type visitBlock(DartBlock node) {
            return this.typeAsVoid(node);
        }

        private Type typeAsVoid(DartNode node) {
            node.visitChildren(this);
            return this.voidType;
        }

        @Override
        public Type visitBreakStatement(DartBreakStatement node) {
            return this.voidType;
        }

        @Override
        public Type visitFunctionObjectInvocation(DartFunctionObjectInvocation node) {
            node.setReferencedElement(this.functionType.getElement());
            return this.checkInvocation(node, node, null, this.typeOf(node.getTarget()));
        }

        @Override
        public Type visitMethodInvocation(DartMethodInvocation node) {
            String name = node.getFunctionNameString();
            Element element = (Element)node.getTargetSymbol();
            if (element != null && (element.getModifiers().isStatic() || Elements.isTopLevel(element))) {
                node.setReferencedElement(element);
                return this.checkInvocation(node, node, name, element.getType());
            }
            Type receiver = this.nonVoidTypeOf(node.getTarget());
            List<DartExpression> arguments = node.getArgs();
            InterfaceType.Member member = this.lookupMember(receiver, name, node);
            if (member != null) {
                node.setReferencedElement(member.getElement());
            }
            return this.analyzeMethodInvocation(receiver, member, name, node.getFunctionName(), this.analyzeArgumentTypes(arguments), arguments);
        }

        @Override
        public Type visitSuperConstructorInvocation(DartSuperConstructorInvocation node) {
            return this.checkConstructorForwarding(node, node.getSymbol());
        }

        private Type checkConstructorForwarding(DartInvocation node, ConstructorElement element) {
            if (element == null) {
                this.visit(node.getArgs());
                return this.voidType;
            }
            node.setReferencedElement(element);
            this.checkInvocation(node, node, null, this.typeAsMemberOf(element, this.currentClass));
            return this.voidType;
        }

        @Override
        public Type visitCase(DartCase node) {
            node.visitChildren(this);
            return this.voidType;
        }

        @Override
        public Type visitClass(DartClass node) {
            ClassElement cls;
            List<Element> unimplementedMembers;
            ClassElement element = node.getSymbol();
            InterfaceType type = element.getType();
            this.findUnimplementedMembers(element);
            this.setCurrentClass(type);
            this.visit(node.getTypeParameters());
            if (node.getSuperclass() != null) {
                this.validateTypeNode(node.getSuperclass(), true);
            }
            if (node.getInterfaces() != null) {
                for (DartTypeNode interfaceNode : node.getInterfaces()) {
                    this.validateTypeNode(interfaceNode, true);
                }
            }
            this.visit(node.getMembers());
            this.checkInterfaceConstructors(element);
            if (!node.isAbstract() && (unimplementedMembers = this.findUnimplementedMembers(cls = node.getSymbol())).size() > 0) {
                StringBuilder sb = this.getUnimplementedMembersMessage(cls, unimplementedMembers);
                this.typeError((DartNode)node.getName(), TypeErrorCode.ABSTRACT_CLASS_WITHOUT_ABSTRACT_MODIFIER, cls.getName(), sb);
            }
            this.setCurrentClass(null);
            return type;
        }

        private void checkInterfaceConstructors(ClassElement interfaceElement) {
            if (interfaceElement.getDefaultClass() == null) {
                return;
            }
            String interfaceClassName = interfaceElement.getName();
            String defaultClassName = interfaceElement.getDefaultClass().getElement().getName();
            for (ConstructorElement interfaceConstructor : interfaceElement.getConstructors()) {
                ConstructorElement defaultConstructor = interfaceConstructor.getDefaultConstructor();
                if (defaultConstructor == null) continue;
                List<String> interfaceTypes = Elements.getParameterTypeNames(interfaceConstructor);
                List<String> defaultTypes = Elements.getParameterTypeNames(defaultConstructor);
                if (interfaceTypes.size() != defaultTypes.size() || ((Object)interfaceTypes).equals(defaultTypes)) continue;
                this.onError(interfaceConstructor.getNode(), TypeErrorCode.DEFAULT_CONSTRUCTOR_TYPES, Elements.getRawMethodName(interfaceConstructor), interfaceClassName, Joiner.on((String)",").join(interfaceTypes), Elements.getRawMethodName(defaultConstructor), defaultClassName, Joiner.on((String)",").join(defaultTypes));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Element> findUnimplementedMembers(ClassElement element) {
            if (element.isInterface()) {
                element.getNode().accept(new AbstractMethodFinder(element.getType()));
                return Collections.emptyList();
            }
            List<Element> members = this.unimplementedElements.get(element);
            if (members != null) {
                return members;
            }
            ClassElement classElement = element;
            synchronized (classElement) {
                members = this.unimplementedElements.get(element);
                if (members != null) {
                    return members;
                }
                AbstractMethodFinder finder = new AbstractMethodFinder(element.getType());
                element.getNode().accept(finder);
                this.unimplementedElements.put(element, finder.unimplementedElements);
                return finder.unimplementedElements;
            }
        }

        @Override
        public Type visitConditional(DartConditional node) {
            this.checkCondition(node.getCondition());
            Type left = this.typeOf(node.getThenExpression());
            Type right = this.typeOf(node.getElseExpression());
            return this.types.leastUpperBound(left, right);
        }

        private Type checkCondition(DartExpression condition) {
            Type type = this.nonVoidTypeOf(condition);
            this.checkAssignable(condition, this.boolType, type);
            return type;
        }

        @Override
        public Type visitContinueStatement(DartContinueStatement node) {
            return this.voidType;
        }

        @Override
        public Type visitDefault(DartDefault node) {
            node.visitChildren(this);
            return this.typeAsVoid(node);
        }

        @Override
        public Type visitDoWhileStatement(DartDoWhileStatement node) {
            this.checkCondition(node.getCondition());
            this.typeOf(node.getBody());
            return this.voidType;
        }

        @Override
        public Type visitEmptyStatement(DartEmptyStatement node) {
            return this.typeAsVoid(node);
        }

        @Override
        public Type visitExprStmt(DartExprStmt node) {
            this.typeOf(node.getExpression());
            return this.voidType;
        }

        @Override
        public Type visitFieldDefinition(DartFieldDefinition node) {
            node.visitChildren(this);
            return this.voidType;
        }

        @Override
        public Type visitForInStatement(DartForInStatement node) {
            Type variableType = node.introducesVariable() ? this.typeOf(node.getVariableStatement()) : this.typeOf(node.getIdentifier());
            DartExpression iterableExpression = node.getIterable();
            Type iterableType = this.typeOf(iterableExpression);
            InterfaceType.Member iteratorMember = this.lookupMember(iterableType, "iterator", iterableExpression);
            if (iteratorMember != null) {
                if (TypeKind.of(iteratorMember.getType()) == TypeKind.FUNCTION) {
                    FunctionType iteratorMethod = (FunctionType)iteratorMember.getType();
                    InterfaceType asInstanceOf = this.types.asInstanceOf(iteratorMethod.getReturnType(), this.dynamicIteratorType.getElement());
                    if (asInstanceOf != null) {
                        this.checkAssignable(iterableExpression, variableType, asInstanceOf.getArguments().get(0));
                    } else {
                        InterfaceType expectedIteratorType = this.dynamicIteratorType.subst(Arrays.asList(variableType), this.dynamicIteratorType.getElement().getTypeParameters());
                        this.typeError(iterableExpression, TypeErrorCode.FOR_IN_WITH_INVALID_ITERATOR_RETURN_TYPE, expectedIteratorType);
                    }
                } else {
                    this.typeError(iterableExpression, TypeErrorCode.FOR_IN_WITH_ITERATOR_FIELD, new Object[0]);
                }
            }
            return this.typeAsVoid(node);
        }

        @Override
        public Type visitForStatement(DartForStatement node) {
            this.typeOf(node.getInit());
            this.checkCondition(node.getCondition());
            this.typeOf(node.getIncrement());
            this.typeOf(node.getBody());
            return this.voidType;
        }

        @Override
        public Type visitFunction(DartFunction node) {
            Type previous = this.expected;
            this.visit(node.getParams());
            this.expected = this.typeOf(node.getReturnTypeNode());
            this.typeOf(node.getBody());
            this.expected = previous;
            return this.voidType;
        }

        @Override
        public Type visitFunctionExpression(DartFunctionExpression node) {
            node.visitChildren(this);
            return node.getSymbol().getType();
        }

        @Override
        public Type visitFunctionTypeAlias(DartFunctionTypeAlias node) {
            return this.typeAsVoid(node);
        }

        @Override
        public Type visitIdentifier(DartIdentifier node) {
            Type type;
            Element element = node.getTargetSymbol();
            switch (ElementKind.of(element)) {
                case VARIABLE: 
                case PARAMETER: 
                case FUNCTION_OBJECT: {
                    type = element.getType();
                    break;
                }
                case METHOD: 
                case FIELD: {
                    type = this.typeAsMemberOf(element, this.currentClass);
                    break;
                }
                case NONE: {
                    return this.typeError(node, TypeErrorCode.CANNOT_BE_RESOLVED, node.getTargetName());
                }
                case DYNAMIC: {
                    return element.getType();
                }
                default: {
                    return this.voidType;
                }
            }
            node.setReferencedElement(element);
            return type;
        }

        @Override
        public Type visitIfStatement(DartIfStatement node) {
            this.checkCondition(node.getCondition());
            this.typeOf(node.getThenStatement());
            this.typeOf(node.getElseStatement());
            return this.voidType;
        }

        @Override
        public Type visitInitializer(DartInitializer node) {
            DartIdentifier name = node.getName();
            if (name != null) {
                this.checkAssignable(this.typeOf(name), node.getValue());
            } else {
                this.typeOf(node.getValue());
            }
            return this.voidType;
        }

        @Override
        public Type visitLabel(DartLabel node) {
            return this.typeAsVoid(node);
        }

        @Override
        public Type visitMapLiteral(DartMapLiteral node) {
            this.visit(node.getTypeArguments());
            InterfaceType type = node.getType();
            this.checkAssignable(node, type, this.defaultLiteralMapType);
            Type valueType = type.getArguments().get(1);
            for (DartMapLiteralEntry literalEntry : node.getEntries()) {
                this.checkAssignable(literalEntry, this.typeOf(literalEntry), valueType);
            }
            return type;
        }

        @Override
        public Type visitMapLiteralEntry(DartMapLiteralEntry node) {
            this.nonVoidTypeOf(node.getKey());
            return this.nonVoidTypeOf(node.getValue());
        }

        @Override
        public Type visitMethodDefinition(DartMethodDefinition node) {
            MethodElement methodElement = node.getSymbol();
            if (methodElement.getModifiers().isFactory()) {
                this.analyzeFactory((DartExpression)node.getName(), (ConstructorElement)methodElement);
            }
            return this.typeAsVoid(node);
        }

        private void analyzeFactory(DartExpression name, ConstructorElement methodElement) {
            DartNodeTraverser<Void> visitor = new DartNodeTraverser<Void>(){

                @Override
                public Void visitParameterizedTypeNode(DartParameterizedTypeNode node) {
                    DartExpression expression = node.getExpression();
                    Element e = null;
                    if (expression instanceof DartIdentifier) {
                        e = ((DartIdentifier)expression).getTargetSymbol();
                    } else if (expression instanceof DartPropertyAccess) {
                        e = ((DartPropertyAccess)expression).getTargetSymbol();
                    }
                    if (!ElementKind.of(e).equals((Object)ElementKind.CLASS)) {
                        return null;
                    }
                    List<DartTypeParameter> parameterNodes = node.getTypeParameters();
                    assert (parameterNodes.size() == 0);
                    return null;
                }
            };
            name.accept(visitor);
        }

        @Override
        public Type visitNewExpression(DartNewExpression node) {
            InterfaceType itype;
            ClassElement interfaceElement;
            InterfaceType defaultClassType;
            ConstructorElement constructorElement = node.getSymbol();
            node.setReferencedElement(constructorElement);
            DartTypeNode typeNode = Types.constructorTypeNode(node);
            Type type = null;
            if (TypeKind.of(typeNode.getType()).equals((Object)TypeKind.INTERFACE) && ((InterfaceType)typeNode.getType()).getElement().isInterface() && (defaultClassType = (interfaceElement = (itype = (InterfaceType)typeNode.getType()).getElement()).getDefaultClass()) != null && defaultClassType.getElement() != null) {
                this.validateBounds(typeNode.getTypeArguments(), itype.getArguments(), defaultClassType.getElement().getTypeParameters(), false);
                type = itype;
            }
            if (type == null) {
                type = this.validateTypeNode(typeNode, false);
            }
            DartNode typeName = typeNode.getIdentifier();
            if (constructorElement == null) {
                this.visit(node.getArgs());
            } else {
                ClassElement cls = (ClassElement)constructorElement.getEnclosingElement();
                if (cls.isAbstract()) {
                    TypeErrorCode errorCode = constructorElement.getModifiers().isFactory() ? TypeErrorCode.INSTANTIATION_OF_ABSTRACT_CLASS_USING_FACTORY : TypeErrorCode.INSTANTIATION_OF_ABSTRACT_CLASS;
                    this.typeError(typeName, errorCode, cls.getName());
                } else {
                    List<Element> unimplementedMembers = this.findUnimplementedMembers(cls);
                    if (unimplementedMembers.size() > 0) {
                        StringBuilder sb = this.getUnimplementedMembersMessage(cls, unimplementedMembers);
                        this.typeError(typeName, TypeErrorCode.INSTANTIATION_OF_CLASS_WITH_UNIMPLEMENTED_MEMBERS, cls.getName(), sb);
                    }
                }
                FunctionType ftype = (FunctionType)constructorElement.getType();
                if (ftype != null && TypeKind.of(type).equals((Object)TypeKind.INTERFACE)) {
                    InterfaceType ifaceType = (InterfaceType)type;
                    List<? extends Type> substParams = ifaceType.getElement().isInterface() ? ((ClassElement)constructorElement.getEnclosingElement()).getType().getArguments() : ifaceType.getElement().getTypeParameters();
                    List<? extends Type> arguments = ifaceType.getArguments();
                    ftype = (FunctionType)ftype.subst(arguments, substParams);
                    this.checkInvocation(node, node, null, ftype);
                }
            }
            return type;
        }

        private StringBuilder getUnimplementedMembersMessage(ClassElement cls, List<Element> unimplementedMembers) {
            ArrayListMultimap membersByTypes = ArrayListMultimap.create();
            for (Element member : unimplementedMembers) {
                ClassElement enclosingElement = (ClassElement)member.getEnclosingElement();
                InterfaceType instance = this.types.asInstanceOf(cls.getType(), enclosingElement);
                Type memberType = member.getType().subst(instance.getArguments(), enclosingElement.getTypeParameters());
                if (memberType.getKind().equals((Object)TypeKind.FUNCTION)) {
                    FunctionType ftype = (FunctionType)memberType;
                    StringBuilder sb = new StringBuilder();
                    sb.append(ftype.getReturnType());
                    sb.append(" ");
                    sb.append(member.getName());
                    String string = ftype.toString();
                    sb.append(string, 0, string.lastIndexOf(" -> "));
                    membersByTypes.put((Object)enclosingElement.getName(), (Object)sb.toString());
                    continue;
                }
                StringBuilder sb = new StringBuilder();
                sb.append(memberType);
                sb.append(" ");
                sb.append(member.getName());
                membersByTypes.put((Object)enclosingElement.getName(), (Object)sb.toString());
            }
            StringBuilder sb = new StringBuilder();
            for (String typeName : membersByTypes.keySet()) {
                sb.append("\n    # From ");
                sb.append(typeName);
                sb.append(":");
                for (String memberString : membersByTypes.get((Object)typeName)) {
                    sb.append("\n        ");
                    sb.append(memberString);
                }
            }
            return sb;
        }

        @Override
        public Type visitNullLiteral(DartNullLiteral node) {
            return this.nullType;
        }

        @Override
        public Type visitParameter(DartParameter node) {
            VariableElement parameter = node.getSymbol();
            FieldElement initializerElement = parameter.getParameterInitializerElement();
            if (initializerElement != null) {
                this.checkAssignable(node, parameter.getType(), initializerElement.getType());
            }
            return this.checkInitializedDeclaration(node, node.getDefaultExpr());
        }

        @Override
        public Type visitParenthesizedExpression(DartParenthesizedExpression node) {
            return node.getExpression().accept(this);
        }

        @Override
        public Type visitPropertyAccess(DartPropertyAccess node) {
            Element element = node.getTargetSymbol();
            node.setReferencedElement(element);
            if (element != null && (element.getModifiers().isStatic() || Elements.isTopLevel(element))) {
                return element.getType();
            }
            DartNode qualifier = node.getQualifier();
            Type receiver = this.nonVoidTypeOf(qualifier);
            InterfaceType cls = this.types.getInterfaceType(receiver);
            if (cls == null) {
                return this.diagnoseNonInterfaceType(qualifier, receiver);
            }
            String name = node.getPropertyName();
            InterfaceType.Member member = cls.lookupMember(name);
            if (member == null) {
                return this.typeError(node.getName(), TypeErrorCode.NOT_A_MEMBER_OF, name, cls);
            }
            element = member.getElement();
            node.setReferencedElement(element);
            Modifiers modifiers = element.getModifiers();
            if (modifiers.isStatic()) {
                return this.typeError(node.getName(), TypeErrorCode.STATIC_MEMBER_ACCESSED_THROUGH_INSTANCE, name, element.getName());
            }
            switch (element.getKind()) {
                case CONSTRUCTOR: {
                    return this.typeError(node.getName(), TypeErrorCode.MEMBER_IS_A_CONSTRUCTOR, name, element.getName());
                }
                case METHOD: 
                case FIELD: {
                    return member.getType();
                }
            }
            throw this.internalError(node.getName(), "unexpected kind %s", new Object[]{element.getKind()});
        }

        @Override
        public Type visitReturnStatement(DartReturnStatement node) {
            DartExpression value = node.getValue();
            if (value == null) {
                if (!this.types.isSubtype(this.voidType, this.expected)) {
                    this.typeError(node, TypeErrorCode.MISSING_RETURN_VALUE, this.expected);
                }
            } else {
                this.checkAssignable(value == null ? node : value, this.expected, this.typeOf(value));
            }
            return this.voidType;
        }

        @Override
        public Type visitSuperExpression(DartSuperExpression node) {
            if (this.currentClass == null) {
                return this.dynamicType;
            }
            return this.currentClass.getElement().getSupertype();
        }

        @Override
        public Type visitSwitchStatement(DartSwitchStatement node) {
            return this.typeAsVoid(node);
        }

        @Override
        public Type visitSyntheticErrorExpression(DartSyntheticErrorExpression node) {
            return this.dynamicType;
        }

        @Override
        public Type visitSyntheticErrorStatement(DartSyntheticErrorStatement node) {
            return this.dynamicType;
        }

        @Override
        public Type visitThisExpression(DartThisExpression node) {
            return this.getCurrentClass();
        }

        @Override
        public Type visitThrowStatement(DartThrowStatement node) {
            if (this.catchDepth == 0 && node.getException() == null) {
                this.context.onError(new DartCompilationError(node, (ErrorCode)ResolverErrorCode.RETHROW_NOT_IN_CATCH, new Object[0]));
            }
            return this.typeAsVoid(node);
        }

        @Override
        public Type visitCatchBlock(DartCatchBlock node) {
            ++this.catchDepth;
            this.typeOf(node.getException());
            this.typeOf(node.getStackTrace());
            this.typeOf(node.getBlock());
            --this.catchDepth;
            return this.voidType;
        }

        @Override
        public Type visitTryStatement(DartTryStatement node) {
            return this.typeAsVoid(node);
        }

        @Override
        public Type visitUnaryExpression(DartUnaryExpression node) {
            DartExpression expression = node.getArg();
            Type type = this.nonVoidTypeOf(expression);
            Token operator = node.getOperator();
            switch (operator) {
                case BIT_NOT: {
                    if (type.equals(this.numType)) {
                        return this.intType;
                    }
                    String name = this.methodNameForUnaryOperator(node, operator);
                    InterfaceType.Member member = this.lookupMember(type, name, node);
                    if (member != null) {
                        node.setReferencedElement(member.getElement());
                        return this.analyzeMethodInvocation(type, member, name, node, Collections.<Type>emptyList(), Collections.emptyList());
                    }
                    return this.dynamicType;
                }
                case NOT: {
                    this.checkAssignable(this.boolType, expression);
                    return this.boolType;
                }
                case INC: 
                case DEC: 
                case SUB: {
                    String operatorMethodName;
                    if (type.getElement().isDynamic()) {
                        return type;
                    }
                    InterfaceType itype = this.types.getInterfaceType(type);
                    InterfaceType.Member member = itype.lookupMember(operatorMethodName = this.methodNameForUnaryOperator(node, operator));
                    if (member == null) {
                        return this.typeError(expression, TypeErrorCode.CANNOT_BE_RESOLVED, operatorMethodName);
                    }
                    MethodElement element = (MethodElement)member.getElement();
                    node.setReferencedElement(element);
                    Type returnType = ((FunctionType)member.getType()).getReturnType();
                    if (operator == Token.INC || operator == Token.DEC) {
                        Iterator<VariableElement> it = element.getParameters().iterator();
                        if (!this.types.isAssignable(this.numType, it.next().getType())) {
                            this.typeError(node, TypeErrorCode.OPERATOR_WRONG_OPERAND_TYPE, operatorMethodName, this.numType.toString());
                        }
                        this.checkAssignable(node, type, returnType);
                    }
                    return node.isPrefix() ? returnType : type;
                }
            }
            throw this.internalError(node, "unknown operator %s", operator.toString());
        }

        @Override
        public Type visitUnit(DartUnit node) {
            return this.typeAsVoid(node);
        }

        @Override
        public Type visitUnqualifiedInvocation(DartUnqualifiedInvocation node) {
            Type type;
            DartIdentifier target = node.getTarget();
            String name = target.getTargetName();
            Element element = target.getTargetSymbol();
            node.setReferencedElement(element);
            switch (ElementKind.of(element)) {
                case METHOD: 
                case FIELD: {
                    type = this.typeAsMemberOf(element, this.currentClass);
                    break;
                }
                case NONE: {
                    return this.typeError(target, TypeErrorCode.NOT_A_METHOD_IN, name, this.currentClass);
                }
                default: {
                    type = element.getType();
                }
            }
            return this.checkInvocation(node, target, name, type);
        }

        private Type checkInvocation(DartInvocation node, DartNode diagnosticNode, String name, Type type) {
            List<DartExpression> argumentNodes = node.getArgs();
            ArrayList<Type> argumentTypes = new ArrayList<Type>(argumentNodes.size());
            for (DartExpression argumentNode : argumentNodes) {
                argumentTypes.add(this.nonVoidTypeOf(argumentNode));
            }
            switch (TypeKind.of(type)) {
                case FUNCTION_ALIAS: {
                    return this.checkArguments(node, argumentNodes, argumentTypes.iterator(), this.types.asFunctionType((FunctionAliasType)type));
                }
                case FUNCTION: {
                    return this.checkArguments(node, argumentNodes, argumentTypes.iterator(), (FunctionType)type);
                }
                case DYNAMIC: {
                    return type;
                }
            }
            if (this.types.isAssignable(this.functionType, type)) {
                return this.dynamicType;
            }
            if (name == null) {
                return this.typeError(diagnosticNode, TypeErrorCode.NOT_A_FUNCTION, type);
            }
            return this.typeError(diagnosticNode, TypeErrorCode.NOT_A_METHOD_IN, name, this.currentClass);
        }

        private Type typeAsMemberOf(Element member, InterfaceType subtype) {
            EnclosingElement holder = member.getEnclosingElement();
            if (!ElementKind.of(holder).equals((Object)ElementKind.CLASS)) {
                return member.getType();
            }
            ClassElement superclass = (ClassElement)holder;
            InterfaceType supertype = this.types.asInstanceOf(subtype, superclass);
            Type type = member.getType().subst(supertype.getArguments(), supertype.getElement().getTypeParameters());
            return type;
        }

        @Override
        public Type visitVariable(DartVariable node) {
            return this.checkInitializedDeclaration(node, node.getValue());
        }

        @Override
        public Type visitWhileStatement(DartWhileStatement node) {
            this.checkCondition(node.getCondition());
            this.typeOf(node.getBody());
            return this.voidType;
        }

        @Override
        public Type visitNamedExpression(DartNamedExpression node) {
            return node.getExpression().accept(this);
        }

        @Override
        public Type visitTypeExpression(DartTypeExpression node) {
            return this.typeOf(node.getTypeNode());
        }

        @Override
        public Type visitTypeParameter(DartTypeParameter node) {
            if (node.getBound() != null) {
                this.validateTypeNode(node.getBound(), true);
            }
            return this.voidType;
        }

        @Override
        public Type visitNativeBlock(DartNativeBlock node) {
            return this.typeAsVoid(node);
        }

        @Override
        public void visit(List<? extends DartNode> nodes) {
            if (nodes != null) {
                for (DartNode dartNode : nodes) {
                    dartNode.accept(this);
                }
            }
        }

        @Override
        public Type visitArrayLiteral(DartArrayLiteral node) {
            this.visit(node.getTypeArguments());
            InterfaceType type = node.getType();
            Type elementType = type.getArguments().get(0);
            for (DartExpression expression : node.getExpressions()) {
                this.checkAssignable(elementType, expression);
            }
            return type;
        }

        @Override
        public Type visitBooleanLiteral(DartBooleanLiteral node) {
            return this.typeOfLiteral(node);
        }

        @Override
        public Type visitDoubleLiteral(DartDoubleLiteral node) {
            return this.typeOfLiteral(node);
        }

        @Override
        public Type visitField(DartField node) {
            DartMethodDefinition accessor = node.getAccessor();
            if (accessor != null) {
                return this.typeOf(accessor);
            }
            return this.checkInitializedDeclaration(node, node.getValue());
        }

        private Type checkInitializedDeclaration(DartDeclaration<?> node, DartExpression value) {
            if (value != null) {
                this.checkAssignable(node.getSymbol().getType(), value);
            }
            return this.voidType;
        }

        @Override
        public Type visitIntegerLiteral(DartIntegerLiteral node) {
            return this.typeOfLiteral(node);
        }

        @Override
        public Type visitStringLiteral(DartStringLiteral node) {
            return this.typeOfLiteral(node);
        }

        @Override
        public Type visitStringInterpolation(DartStringInterpolation node) {
            this.visit(node.getExpressions());
            return this.typeOfLiteral(node);
        }

        @Override
        public Type visitParameterizedTypeNode(DartParameterizedTypeNode node) {
            this.visit(node.getTypeParameters());
            return node.getType();
        }

        @Override
        public Type visitImportDirective(DartImportDirective node) {
            return this.typeAsVoid(node);
        }

        @Override
        public Type visitLibraryDirective(DartLibraryDirective node) {
            return this.typeAsVoid(node);
        }

        @Override
        public Type visitNativeDirective(DartNativeDirective node) {
            return this.typeAsVoid(node);
        }

        @Override
        public Type visitResourceDirective(DartResourceDirective node) {
            return this.typeAsVoid(node);
        }

        @Override
        public Type visitSourceDirective(DartSourceDirective node) {
            return this.typeAsVoid(node);
        }

        private class AbstractMethodFinder
        extends DartNodeTraverser<Void> {
            private final InterfaceType currentClass;
            private final Multimap<String, Element> superMembers;
            private final List<Element> unimplementedElements;

            private AbstractMethodFinder(InterfaceType currentClass) {
                this.currentClass = currentClass;
                this.superMembers = LinkedListMultimap.create();
                this.unimplementedElements = new ArrayList<Element>();
            }

            @Override
            public Void visitNode(DartNode node) {
                throw new AssertionError();
            }

            @Override
            public Void visitClass(DartClass node) {
                assert (node.getSymbol().getType() == this.currentClass);
                List<Object> supertypes = Collections.emptyList();
                boolean hasCyclicDeclaration = false;
                try {
                    supertypes = this.currentClass.getElement().getAllSupertypes();
                }
                catch (CyclicDeclarationException e) {
                    hasCyclicDeclaration = true;
                }
                catch (DuplicatedInterfaceException e) {
                    // empty catch block
                }
                EnclosingElement currentLibrary = this.currentClass.getElement().getEnclosingElement();
                for (InterfaceType interfaceType : supertypes) {
                    for (Element member : interfaceType.getElement().getMembers()) {
                        String name = member.getName();
                        if (name.startsWith("_") && currentLibrary != member.getEnclosingElement().getEnclosingElement()) continue;
                        this.superMembers.put((Object)name, (Object)member);
                    }
                }
                this.visit(node.getMembers());
                if (this.currentClass.getElement().isInterface()) {
                    return null;
                }
                if (hasCyclicDeclaration) {
                    return null;
                }
                InterfaceType supertype = this.currentClass.getElement().getSupertype();
                while (supertype != null) {
                    ClassElement classElement = supertype.getElement();
                    for (Element member : classElement.getMembers()) {
                        if (member.getModifiers().isAbstract()) continue;
                        this.superMembers.removeAll((Object)member.getName());
                    }
                    supertype = supertype.getElement().getSupertype();
                }
                block7: for (String name : this.superMembers.keys()) {
                    Collection elements = this.superMembers.removeAll((Object)name);
                    for (Element element : elements) {
                        if (element.getModifiers().isStatic()) continue;
                        this.unimplementedElements.add(element);
                        continue block7;
                    }
                }
                return null;
            }

            @Override
            public Void visitFieldDefinition(DartFieldDefinition node) {
                this.visit(node.getFields());
                return null;
            }

            @Override
            public Void visitField(DartField node) {
                if (this.superMembers != null) {
                    FieldElement field = node.getSymbol();
                    String name = field.getName();
                    ArrayList overridden = new ArrayList(this.superMembers.removeAll((Object)name));
                    block4: for (Element element : overridden) {
                        if (!this.canOverride((DartExpression)node.getName(), field.getModifiers(), element)) continue;
                        switch (element.getKind()) {
                            case FIELD: {
                                this.checkOverride((DartExpression)node.getName(), field, element);
                                continue block4;
                            }
                            case METHOD: {
                                Analyzer.this.typeError(node, TypeErrorCode.SUPERTYPE_HAS_METHOD, new Object[]{name, element.getEnclosingElement().getName()});
                                continue block4;
                            }
                        }
                        Analyzer.this.typeError(node, TypeErrorCode.INTERNAL_ERROR, new Object[]{element});
                    }
                }
                return null;
            }

            @Override
            public Void visitMethodDefinition(DartMethodDefinition node) {
                MethodElement method = node.getSymbol();
                String name = method.getName();
                if (this.superMembers != null && !method.isConstructor()) {
                    Collection overridden = this.superMembers.removeAll((Object)name);
                    block4: for (Element element : overridden) {
                        if (!this.canOverride((DartExpression)node.getName(), method.getModifiers(), element)) continue;
                        switch (element.getKind()) {
                            case METHOD: {
                                this.checkOverride((DartExpression)node.getName(), method, element);
                                continue block4;
                            }
                            case FIELD: {
                                Analyzer.this.typeError(node, TypeErrorCode.SUPERTYPE_HAS_FIELD, new Object[]{element.getName(), element.getEnclosingElement().getName()});
                                continue block4;
                            }
                        }
                        Analyzer.this.typeError(node, TypeErrorCode.INTERNAL_ERROR, new Object[]{element});
                    }
                }
                return null;
            }

            private boolean canOverride(DartExpression node, Modifiers modifiers, Element element) {
                if (element.getModifiers().isStatic()) {
                    Analyzer.this.onError(node, ResolverErrorCode.CANNOT_OVERRIDE_STATIC_MEMBER, new Object[]{element.getName(), element.getEnclosingElement().getName()});
                    return false;
                }
                if (modifiers.isStatic()) {
                    Analyzer.this.onError(node, ResolverErrorCode.CANNOT_OVERRIDE_INSTANCE_MEMBER, new Object[]{element.getName(), element.getEnclosingElement().getName()});
                    return false;
                }
                return true;
            }

            private void checkOverride(DartExpression node, Element member, Element superElement) {
                String name = member.getName();
                Type superMember = Analyzer.this.typeAsMemberOf(superElement, this.currentClass);
                if (member.getKind() == ElementKind.METHOD && superElement.getKind() == ElementKind.METHOD) {
                    MethodElement method = (MethodElement)member;
                    MethodElement superMethod = (MethodElement)superElement;
                    List<VariableElement> parameters = method.getParameters();
                    List<VariableElement> superParameters = superMethod.getParameters();
                    if (superParameters.size() != parameters.size()) {
                        Analyzer.this.onError(node, ResolverErrorCode.CANNOT_OVERRIDE_METHOD_WRONG_NUM_PARAMS, new Object[]{member.getName()});
                    } else {
                        ArrayList<VariableElement> named = new ArrayList<VariableElement>();
                        for (VariableElement v : parameters) {
                            if (!v.isNamed()) continue;
                            named.add(v);
                        }
                        ArrayList<VariableElement> superNamed = new ArrayList<VariableElement>();
                        for (VariableElement v : superParameters) {
                            if (!v.isNamed()) continue;
                            superNamed.add(v);
                        }
                        if (named.size() != superNamed.size()) {
                            Analyzer.this.onError(node, ResolverErrorCode.CANNOT_OVERRIDE_METHOD_NUM_NAMED_PARAMS, new Object[]{member.getName()});
                        } else {
                            boolean errorFound = false;
                            while (!named.isEmpty()) {
                                VariableElement v1 = (VariableElement)named.remove(0);
                                VariableElement v2 = (VariableElement)superNamed.remove(0);
                                if (v1.getName().equals(v2.getName())) continue;
                                Analyzer.this.onError(v1.getNode(), ResolverErrorCode.CANNOT_OVERRIDE_METHOD_ORDER_NAMED_PARAMS, new Object[]{member.getName()});
                                errorFound = true;
                                break;
                            }
                            if (!errorFound && !Analyzer.this.types.isSubtype(member.getType(), superMember) && method.getParameters().size() == superMethod.getParameters().size()) {
                                Analyzer.this.typeError(node, TypeErrorCode.CANNOT_OVERRIDE_METHOD_NOT_SUBTYPE, new Object[]{name, superElement.getEnclosingElement().getName(), member.getType(), superMember});
                            }
                        }
                    }
                } else if (!Analyzer.this.types.isAssignable(superMember, member.getType())) {
                    Analyzer.this.typeError(node, TypeErrorCode.CANNOT_OVERRIDE_TYPED_MEMBER, new Object[]{name, superElement.getEnclosingElement().getName(), member.getType(), superMember});
                }
            }
        }
    }
}

