/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.type;

import com.google.dart.compiler.resolver.ClassElement;
import com.google.dart.compiler.type.AbstractType;
import com.google.dart.compiler.type.FunctionType;
import com.google.dart.compiler.type.Type;
import com.google.dart.compiler.type.TypeKind;
import com.google.dart.compiler.type.Types;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class FunctionTypeImplementation
extends AbstractType
implements FunctionType {
    private static final Map<String, Type> EMPTY_MAP = Collections.emptyMap();
    private final ClassElement classElement;
    private final List<Type> parameterTypes;
    private final Type returnType;
    private final Map<String, Type> namedParameterTypes;
    private final Type rest;

    private FunctionTypeImplementation(ClassElement element, List<Type> parameterTypes, Map<String, Type> namedParameterTypes, Type rest, Type returnType) {
        this.classElement = element;
        this.parameterTypes = parameterTypes;
        this.namedParameterTypes = namedParameterTypes == null ? EMPTY_MAP : namedParameterTypes;
        this.rest = rest;
        this.returnType = returnType;
    }

    @Override
    public Type subst(List<? extends Type> arguments, List<? extends Type> parameters) {
        List<Type> substitutedParameterTypes = Types.subst(this.getParameterTypes(), arguments, parameters);
        LinkedHashMap<String, Type> substitutedNamedParameterTypes = null;
        if (!this.getNamedParameterTypes().isEmpty()) {
            substitutedNamedParameterTypes = new LinkedHashMap<String, Type>();
            for (Map.Entry<String, Type> entry : this.getNamedParameterTypes().entrySet()) {
                substitutedNamedParameterTypes.put(entry.getKey(), entry.getValue().subst(arguments, parameters));
            }
        }
        Type substitutedRest = null;
        if (this.getRest() != null) {
            substitutedRest = this.getRest().subst(arguments, parameters);
        }
        Type substitutedReturnType = this.getReturnType().subst(arguments, parameters);
        return new FunctionTypeImplementation(this.getElement(), substitutedParameterTypes, substitutedNamedParameterTypes, substitutedRest, substitutedReturnType);
    }

    @Override
    public ClassElement getElement() {
        return this.classElement;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public List<? extends Type> getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.FUNCTION;
    }

    @Override
    public Map<String, Type> getNamedParameterTypes() {
        return this.namedParameterTypes;
    }

    @Override
    public Type getRest() {
        return this.rest;
    }

    @Override
    public boolean hasRest() {
        return this.rest != null;
    }

    public String toString() {
        Map<String, Type> map;
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean first = true;
        for (Type type : this.getParameterTypes()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(type);
            first = false;
        }
        Type rest = this.getRest();
        if (rest != null) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(rest);
            sb.append("...");
            first = false;
        }
        if (!(map = this.getNamedParameterTypes()).isEmpty()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("[");
            first = true;
            for (Map.Entry<String, Type> entry : map.entrySet()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(entry.getValue());
                sb.append(" ");
                sb.append(entry.getKey());
                first = false;
            }
            sb.append("]");
        }
        sb.append(") -> ");
        sb.append(this.getReturnType());
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof FunctionType) {
            FunctionType other = (FunctionType)o;
            return this.getElement().equals(other.getElement()) && this.getReturnType().equals(other.getReturnType()) && ((Object)this.getParameterTypes()).equals(other.getParameterTypes()) && this.hasRest() == other.hasRest() && (!this.hasRest() || this.getRest().equals(other.getRest())) && ((Object)this.getNamedParameterTypes()).equals(other.getNamedParameterTypes());
        }
        return false;
    }

    public int hashCode() {
        Type rest = this.getRest();
        Map<String, Type> namedParameterTypes = this.getNamedParameterTypes();
        return this.getElement().hashCode() + this.getReturnType().hashCode() + ((Object)this.getParameterTypes()).hashCode() + (rest == null ? 0 : rest.hashCode()) + (namedParameterTypes == null ? 0 : ((Object)namedParameterTypes).hashCode());
    }

    static FunctionType of(ClassElement element, List<Type> parameterTypes, Map<String, Type> namedParameterTypes, Type rest, Type returnType) {
        assert (element.isDynamic() || element.getName().equals("Function"));
        return new FunctionTypeImplementation(element, parameterTypes, namedParameterTypes, rest, returnType);
    }
}

