/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.testing;

import com.google.dart.compiler.CompilerConfiguration;
import com.google.dart.compiler.DartCompilationError;
import com.google.dart.compiler.DartCompilerContext;
import com.google.dart.compiler.DartCompilerListener;
import com.google.dart.compiler.DartSource;
import com.google.dart.compiler.ErrorCode;
import com.google.dart.compiler.ErrorSeverity;
import com.google.dart.compiler.LibrarySource;
import com.google.dart.compiler.Source;
import com.google.dart.compiler.SubSystem;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.ast.LibraryUnit;
import com.google.dart.compiler.metrics.CompilerMetrics;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class TestCompilerContext
implements DartCompilerListener,
DartCompilerContext {
    private final Set<EventKind> ignoredEvents;
    final List<ErrorCode> errors;
    private int typeErrorCount;
    private int warningCount;
    private int errorCount;

    public TestCompilerContext(EventKind ... ignored) {
        EnumSet<EventKind> set = EnumSet.noneOf(EventKind.class);
        for (EventKind kind : ignored) {
            set.add(kind);
        }
        this.ignoredEvents = Collections.unmodifiableSet(set);
        this.errors = new ArrayList<ErrorCode>();
    }

    @Override
    public LibraryUnit getApplicationUnit() {
        throw new AssertionError();
    }

    @Override
    public LibraryUnit getAppLibraryUnit() {
        throw new AssertionError();
    }

    @Override
    public LibraryUnit getLibraryUnit(LibrarySource lib) {
        throw new AssertionError((Object)lib.getName());
    }

    @Override
    public void onError(DartCompilationError event) {
        if (event.getErrorCode().getSubSystem() == SubSystem.STATIC_TYPE) {
            ++this.typeErrorCount;
            this.handleEvent(event, EventKind.TYPE_ERROR);
        } else if (event.getErrorCode().getErrorSeverity() == ErrorSeverity.ERROR) {
            ++this.errorCount;
            this.handleEvent(event, EventKind.ERROR);
        } else if (event.getErrorCode().getErrorSeverity() == ErrorSeverity.WARNING) {
            ++this.warningCount;
            this.handleEvent(event, EventKind.WARNING);
        }
    }

    protected void handleEvent(DartCompilationError event, EventKind kind) {
        this.errors.add(event.getErrorCode());
        if (!this.ignoredEvents.contains((Object)kind)) {
            System.err.println("Unexpected Event: " + event + " of kind " + (Object)((Object)kind));
            throw new AssertionError(event);
        }
    }

    @Override
    public Reader getArtifactReader(Source source, String part, String extension) throws IOException {
        throw new AssertionError((Object)(source.getName() + " " + part + "." + extension));
    }

    @Override
    public URI getArtifactUri(DartSource source, String part, String extension) {
        throw new AssertionError((Object)(source.getName() + " " + part + "." + extension));
    }

    @Override
    public Writer getArtifactWriter(Source source, String part, String extension) throws IOException {
        throw new AssertionError((Object)(source.getName() + " " + part + "." + extension));
    }

    @Override
    public boolean isOutOfDate(Source source, Source base, String extension) {
        throw new AssertionError((Object)(source.getName() + " " + base.getName() + " " + extension));
    }

    @Override
    public CompilerMetrics getCompilerMetrics() {
        return null;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    public int getTypeErrorCount() {
        return this.typeErrorCount;
    }

    public List<ErrorCode> getErrorCodes() {
        return this.errors;
    }

    @Override
    public boolean shouldWarnOnNoSuchType() {
        return false;
    }

    @Override
    public CompilerConfiguration getCompilerConfiguration() {
        return null;
    }

    @Override
    public LibrarySource getSystemLibraryFor(String importSpec) {
        return null;
    }

    @Override
    public void unitAboutToCompile(DartSource source, boolean diet) {
    }

    @Override
    public void unitCompiled(DartUnit unit) {
    }

    public static enum EventKind {
        ERROR,
        TYPE_ERROR,
        WARNING;

    }
}

