/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.resolver;

import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartTypeParameter;
import com.google.dart.compiler.resolver.AbstractElement;
import com.google.dart.compiler.resolver.Element;
import com.google.dart.compiler.resolver.ElementKind;
import com.google.dart.compiler.resolver.TypeVariableElement;
import com.google.dart.compiler.type.Type;
import com.google.dart.compiler.type.TypeVariable;
import com.google.dart.compiler.type.Types;

class TypeVariableElementImplementation
extends AbstractElement
implements TypeVariableElement {
    private final Element owner;
    private TypeVariable type;
    private Type bound;

    TypeVariableElementImplementation(DartNode node, String name, Element owner) {
        super(node, name);
        this.owner = owner;
    }

    @Override
    public TypeVariable getType() {
        return this.type;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.TYPE_VARIABLE;
    }

    static TypeVariableElementImplementation fromNode(DartTypeParameter node, Element owner) {
        TypeVariableElementImplementation element = new TypeVariableElementImplementation(node, ((DartIdentifier)node.getName()).getTargetName(), owner);
        element.setType(Types.typeVariable(element));
        return element;
    }

    @Override
    public TypeVariable getTypeVariable() {
        return this.getType();
    }

    @Override
    void setType(Type type) {
        this.type = (TypeVariable)type;
    }

    @Override
    public void setBound(Type bound) {
        this.bound = bound;
    }

    @Override
    public Type getBound() {
        return this.bound;
    }

    @Override
    public Element getDeclaringElement() {
        return this.owner;
    }
}

