/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.resolver;

import com.google.dart.compiler.DartCompilerContext;
import com.google.dart.compiler.ast.DartClass;
import com.google.dart.compiler.ast.DartFunctionTypeAlias;
import com.google.dart.compiler.ast.DartNodeTraverser;
import com.google.dart.compiler.ast.DartTypeNode;
import com.google.dart.compiler.ast.DartTypeParameter;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.resolver.ClassElement;
import com.google.dart.compiler.resolver.CoreTypeProvider;
import com.google.dart.compiler.resolver.Element;
import com.google.dart.compiler.resolver.ElementKind;
import com.google.dart.compiler.resolver.Elements;
import com.google.dart.compiler.resolver.ResolutionContext;
import com.google.dart.compiler.resolver.ResolverErrorCode;
import com.google.dart.compiler.resolver.Scope;
import com.google.dart.compiler.resolver.TypeVariableElement;
import com.google.dart.compiler.type.InterfaceType;
import com.google.dart.compiler.type.Type;

public class SupertypeResolver {
    private ResolutionContext topLevelContext;
    private CoreTypeProvider typeProvider;

    public void exec(DartUnit unit, DartCompilerContext context, CoreTypeProvider typeProvider) {
        this.exec(unit, context, unit.getLibrary().getElement().getScope(), typeProvider);
    }

    public void exec(DartUnit unit, DartCompilerContext compilerContext, Scope libraryScope, CoreTypeProvider typeProvider) {
        this.typeProvider = typeProvider;
        this.topLevelContext = new ResolutionContext(libraryScope, compilerContext, typeProvider);
        unit.accept(new ClassElementResolver());
    }

    private class ClassElementResolver
    extends DartNodeTraverser<Void> {
        private ClassElementResolver() {
        }

        @Override
        public Void visitClass(DartClass node) {
            Element defaultClassElement;
            InterfaceType supertype;
            ClassElement classElement = node.getSymbol();
            ResolutionContext classContext = SupertypeResolver.this.topLevelContext.extend(classElement);
            DartTypeNode superclassNode = node.getSuperclass();
            if (superclassNode == null) {
                supertype = SupertypeResolver.this.typeProvider.getObjectType();
                if (supertype.equals(classElement.getType())) {
                    supertype = null;
                }
            } else {
                supertype = classContext.resolveClass(superclassNode, false, false);
                supertype.getClass();
            }
            if (supertype != null) {
                classElement.setSupertype(supertype);
            } else assert (classElement.getName().equals("Object")) : classElement;
            if (node.getDefaultClass() != null && ElementKind.of(defaultClassElement = classContext.resolveName(node.getDefaultClass().getExpression())).equals((Object)ElementKind.CLASS)) {
                Elements.setDefaultClass(classElement, (InterfaceType)defaultClassElement.getType());
                node.getDefaultClass().setType(defaultClassElement.getType());
            }
            if (node.getInterfaces() != null) {
                for (DartTypeNode dartTypeNode : node.getInterfaces()) {
                    Elements.addInterface(classElement, classContext.resolveInterface(dartTypeNode, false, false));
                }
            }
            for (Type type : classElement.getTypeParameters()) {
                Type bound;
                TypeVariableElement variable = (TypeVariableElement)type.getElement();
                DartTypeParameter typeParameterNode = (DartTypeParameter)variable.getNode();
                DartTypeNode boundNode = typeParameterNode.getBound();
                if (boundNode != null) {
                    bound = classContext.resolveType(boundNode, false, false, ResolverErrorCode.NO_SUCH_TYPE);
                    boundNode.setType(bound);
                } else {
                    bound = SupertypeResolver.this.typeProvider.getObjectType();
                }
                variable.setBound(bound);
            }
            return null;
        }

        @Override
        public Void visitFunctionTypeAlias(DartFunctionTypeAlias node) {
            Elements.addInterface(node.getSymbol(), SupertypeResolver.this.typeProvider.getFunctionType());
            return null;
        }
    }
}

