/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.resolver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.google.dart.compiler.DartCompilationPhase;
import com.google.dart.compiler.DartCompilerContext;
import com.google.dart.compiler.ErrorCode;
import com.google.dart.compiler.ast.DartArrayLiteral;
import com.google.dart.compiler.ast.DartBinaryExpression;
import com.google.dart.compiler.ast.DartBlock;
import com.google.dart.compiler.ast.DartBooleanLiteral;
import com.google.dart.compiler.ast.DartBreakStatement;
import com.google.dart.compiler.ast.DartCatchBlock;
import com.google.dart.compiler.ast.DartClass;
import com.google.dart.compiler.ast.DartDoWhileStatement;
import com.google.dart.compiler.ast.DartDoubleLiteral;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartField;
import com.google.dart.compiler.ast.DartFieldDefinition;
import com.google.dart.compiler.ast.DartForInStatement;
import com.google.dart.compiler.ast.DartForStatement;
import com.google.dart.compiler.ast.DartFunction;
import com.google.dart.compiler.ast.DartFunctionExpression;
import com.google.dart.compiler.ast.DartFunctionObjectInvocation;
import com.google.dart.compiler.ast.DartFunctionTypeAlias;
import com.google.dart.compiler.ast.DartGotoStatement;
import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartIfStatement;
import com.google.dart.compiler.ast.DartInitializer;
import com.google.dart.compiler.ast.DartIntegerLiteral;
import com.google.dart.compiler.ast.DartInvocation;
import com.google.dart.compiler.ast.DartLabel;
import com.google.dart.compiler.ast.DartMapLiteral;
import com.google.dart.compiler.ast.DartMethodDefinition;
import com.google.dart.compiler.ast.DartMethodInvocation;
import com.google.dart.compiler.ast.DartNamedExpression;
import com.google.dart.compiler.ast.DartNewExpression;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartParameter;
import com.google.dart.compiler.ast.DartParameterizedTypeNode;
import com.google.dart.compiler.ast.DartPropertyAccess;
import com.google.dart.compiler.ast.DartRedirectConstructorInvocation;
import com.google.dart.compiler.ast.DartReturnStatement;
import com.google.dart.compiler.ast.DartStatement;
import com.google.dart.compiler.ast.DartStringInterpolation;
import com.google.dart.compiler.ast.DartStringLiteral;
import com.google.dart.compiler.ast.DartSuperConstructorInvocation;
import com.google.dart.compiler.ast.DartSuperExpression;
import com.google.dart.compiler.ast.DartSwitchMember;
import com.google.dart.compiler.ast.DartSwitchStatement;
import com.google.dart.compiler.ast.DartThisExpression;
import com.google.dart.compiler.ast.DartTryStatement;
import com.google.dart.compiler.ast.DartTypeNode;
import com.google.dart.compiler.ast.DartTypeParameter;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.ast.DartUnqualifiedInvocation;
import com.google.dart.compiler.ast.DartVariable;
import com.google.dart.compiler.ast.DartVariableStatement;
import com.google.dart.compiler.ast.DartWhileStatement;
import com.google.dart.compiler.ast.Modifiers;
import com.google.dart.compiler.resolver.ClassElement;
import com.google.dart.compiler.resolver.ConstructorElement;
import com.google.dart.compiler.resolver.CoreTypeProvider;
import com.google.dart.compiler.resolver.CyclicDeclarationException;
import com.google.dart.compiler.resolver.DuplicatedInterfaceException;
import com.google.dart.compiler.resolver.Element;
import com.google.dart.compiler.resolver.ElementKind;
import com.google.dart.compiler.resolver.Elements;
import com.google.dart.compiler.resolver.EnclosingElement;
import com.google.dart.compiler.resolver.FieldElement;
import com.google.dart.compiler.resolver.LabelElement;
import com.google.dart.compiler.resolver.LibraryElement;
import com.google.dart.compiler.resolver.MethodElement;
import com.google.dart.compiler.resolver.ResolutionContext;
import com.google.dart.compiler.resolver.ResolveVisitor;
import com.google.dart.compiler.resolver.ResolverErrorCode;
import com.google.dart.compiler.resolver.Scope;
import com.google.dart.compiler.resolver.SuperElement;
import com.google.dart.compiler.resolver.SyntheticDefaultConstructorElement;
import com.google.dart.compiler.resolver.TypeErrorCode;
import com.google.dart.compiler.resolver.TypeVariableElement;
import com.google.dart.compiler.resolver.VariableElement;
import com.google.dart.compiler.type.DynamicType;
import com.google.dart.compiler.type.InterfaceType;
import com.google.dart.compiler.type.Type;
import com.google.dart.compiler.type.TypeVariable;
import com.google.dart.compiler.util.StringUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Resolver {
    private final ResolutionContext topLevelContext;
    private final CoreTypeProvider typeProvider;
    private final InterfaceType rawArrayType;
    private final InterfaceType defaultLiteralMapType;
    private static final EnumSet<ElementKind> INVOKABLE_ELEMENTS = EnumSet.of(ElementKind.FIELD, ElementKind.PARAMETER, ElementKind.VARIABLE, ElementKind.FUNCTION_OBJECT, ElementKind.METHOD);

    @VisibleForTesting
    public Resolver(DartCompilerContext compilerContext, Scope libraryScope, CoreTypeProvider typeProvider) {
        compilerContext.getClass();
        libraryScope.getClass();
        typeProvider.getClass();
        this.topLevelContext = new ResolutionContext(libraryScope, compilerContext, typeProvider);
        this.typeProvider = typeProvider;
        DynamicType dynamicType = typeProvider.getDynamicType();
        InterfaceType stringType = typeProvider.getStringType();
        this.defaultLiteralMapType = typeProvider.getMapType(stringType, dynamicType);
        this.rawArrayType = typeProvider.getArrayType(dynamicType);
    }

    @VisibleForTesting
    public DartUnit exec(DartUnit unit) {
        LibraryElement library = unit.getLibrary() != null ? unit.getLibrary().getElement() : null;
        unit.accept(new ResolveElementsVisitor(this.topLevelContext, (EnclosingElement)library));
        return unit;
    }

    public void resolveMember(ClassElement classElement, Element member, ResolutionContext context) {
        ResolveElementsVisitor visitor;
        if (member == null) {
            return;
        }
        switch (member.getKind()) {
            case CONSTRUCTOR: 
            case METHOD: {
                ResolutionContext methodContext = context.extend(member.getName());
                visitor = new ResolveElementsVisitor(methodContext, (EnclosingElement)classElement, (MethodElement)member);
                break;
            }
            case FIELD: {
                ResolutionContext fieldContext = context;
                if (member.getModifiers().isAbstractField()) {
                    fieldContext = context.extend(member.getName());
                }
                visitor = new ResolveElementsVisitor(fieldContext, (EnclosingElement)classElement);
                break;
            }
            default: {
                throw this.topLevelContext.internalError(member.getNode(), "unexpected element kind: %s", new Object[]{member.getKind()});
            }
        }
        member.getNode().accept(visitor);
    }

    private void checkRedirectConstructorCycle(List<ConstructorElement> constructors, ResolutionContext context) {
        for (ConstructorElement element : constructors) {
            if (!this.hasRedirectedConstructorCycle(element)) continue;
            context.onError(element.getNode(), ResolverErrorCode.REDIRECTED_CONSTRUCTOR_CYCLE, new Object[0]);
        }
    }

    private boolean hasRedirectedConstructorCycle(ConstructorElement constructorElement) {
        ConstructorElement next = this.getNextConstructorInvocation(constructorElement);
        while (next != null) {
            if (constructorElement.getName().equals(next.getName())) {
                return true;
            }
            next = this.getNextConstructorInvocation(next);
        }
        return false;
    }

    private ConstructorElement getNextConstructorInvocation(ConstructorElement constructor) {
        Element element;
        List<DartInitializer> inits = ((DartMethodDefinition)constructor.getNode()).getInitializers();
        if (inits.size() == 1 && ElementKind.of(element = (Element)inits.get(0).getValue().getSymbol()).equals((Object)ElementKind.CONSTRUCTOR)) {
            ConstructorElement nextConstructorElement = (ConstructorElement)element;
            ClassElement nextClass = (ClassElement)nextConstructorElement.getEnclosingElement();
            ClassElement currentClass = (ClassElement)constructor.getEnclosingElement();
            if (nextClass.getName().equals(currentClass.getName())) {
                return nextConstructorElement;
            }
        }
        return null;
    }

    public static class Phase
    implements DartCompilationPhase {
        @Override
        public DartUnit exec(DartUnit unit, DartCompilerContext context, CoreTypeProvider typeProvider) {
            Scope unitScope = unit.getLibrary().getElement().getScope();
            return new Resolver(context, unitScope, typeProvider).exec(unit);
        }
    }

    @VisibleForTesting
    public class ResolveElementsVisitor
    extends ResolveVisitor {
        private EnclosingElement currentHolder;
        private MethodElement currentMethod;
        private boolean inInitializer;
        private MethodElement innermostFunction;
        private ResolutionContext context;
        private LabelElement currentLabel;
        private Set<LabelElement> referencedLabels;
        private Set<LabelElement> labelsInScopes;
        private Set<String> finalsNeedingInitializing;

        @VisibleForTesting
        public ResolveElementsVisitor(ResolutionContext context, EnclosingElement currentHolder, MethodElement currentMethod) {
            super(Resolver.this.typeProvider);
            this.referencedLabels = Sets.newHashSet();
            this.labelsInScopes = Sets.newHashSet();
            this.finalsNeedingInitializing = Sets.newHashSet();
            this.context = context;
            this.currentMethod = currentMethod;
            this.innermostFunction = currentMethod;
            this.currentHolder = currentHolder;
            this.inInitializer = false;
        }

        private ResolveElementsVisitor(ResolutionContext context, EnclosingElement currentHolder) {
            this(context, currentHolder, (MethodElement)null);
        }

        @Override
        ResolutionContext getContext() {
            return this.context;
        }

        @Override
        public Element visitUnit(DartUnit unit) {
            for (DartNode node : unit.getTopLevelNodes()) {
                node.accept(this);
            }
            return null;
        }

        @Override
        public Element visitFunctionTypeAlias(DartFunctionTypeAlias alias) {
            this.getContext().pushFunctionAliasScope(alias);
            this.resolveFunctionAlias(alias);
            this.getContext().popScope();
            return null;
        }

        @Override
        public Element visitClass(DartClass cls) {
            assert (this.currentMethod == null) : "nested class?";
            ClassElement classElement = cls.getSymbol();
            try {
                classElement.getAllSupertypes();
            }
            catch (CyclicDeclarationException e) {
                DartNode node = e.getElement().getNode();
                if (node == null) {
                    node = cls;
                }
                this.onError(node, ResolverErrorCode.CYCLIC_CLASS, e.getElement().getName());
            }
            catch (DuplicatedInterfaceException e) {
                this.onError(cls, ResolverErrorCode.DUPLICATED_INTERFACE, e.getFirst(), e.getSecond());
            }
            this.checkClassTypeVariables(classElement);
            ResolutionContext previousContext = this.context;
            EnclosingElement previousHolder = this.currentHolder;
            this.currentHolder = classElement;
            this.context = Resolver.this.topLevelContext.extend(classElement);
            this.finalsNeedingInitializing.clear();
            for (Element element : classElement.getMembers()) {
                element.getNode().accept(this);
            }
            for (ConstructorElement constructorElement : classElement.getConstructors()) {
                constructorElement.getNode().accept(this);
            }
            Resolver.this.checkRedirectConstructorCycle(classElement.getConstructors(), this.context);
            if (Elements.needsImplicitDefaultConstructor(classElement)) {
                this.checkImplicitDefaultDefaultSuperInvocation(cls, classElement);
            }
            if (cls.getDefaultClass() != null && classElement.getDefaultClass() == null) {
                this.onError(cls.getDefaultClass(), ResolverErrorCode.NO_SUCH_TYPE, cls.getDefaultClass());
            } else if (classElement.getDefaultClass() != null) {
                this.bindDefaultTypeParameters(classElement.getDefaultClass().getElement().getTypeParameters(), cls.getDefaultClass().getTypeParameters(), this.context);
                this.checkDefaultClassTypeParamsToDefaultDecl(classElement.getDefaultClass(), cls.getDefaultClass());
                ClassElement defaultClass = classElement.getDefaultClass().getElement();
                if (defaultClass.isInterface()) {
                    this.onError(cls.getDefaultClass(), ResolverErrorCode.DEFAULT_MUST_SPECIFY_CLASS, new Object[0]);
                }
                this.checkInterfaceTypeParamsToDefault(classElement, defaultClass);
                this.checkInteraceConstructors(classElement);
            } else if (classElement.isInterface() && classElement.getConstructors() != null) {
                for (ConstructorElement constructorElement : classElement.getConstructors()) {
                    DartMethodDefinition methodNode = (DartMethodDefinition)constructorElement.getNode();
                    this.onError((DartNode)methodNode.getName(), ResolverErrorCode.ILLEGAL_CONSTRUCTOR_NO_DEFAULT_IN_INTERFACE, new Object[0]);
                }
            }
            this.context = previousContext;
            this.currentHolder = previousHolder;
            return classElement;
        }

        private void bindDefaultTypeParameters(List<? extends Type> parameterTypes, List<DartTypeParameter> parameterNodes, ResolutionContext classContext) {
            Iterator<? extends Type> typeIterator = parameterTypes.iterator();
            Iterator<DartTypeParameter> nodeIterator = parameterNodes.iterator();
            while (typeIterator.hasNext() && nodeIterator.hasNext()) {
                Type bound;
                Type type = typeIterator.next();
                DartTypeParameter node = nodeIterator.next();
                if (type.getElement().getName().equals(((DartIdentifier)node.getName()).getTargetName())) {
                    node.setType(type);
                } else {
                    node.setType(Resolver.this.typeProvider.getDynamicType());
                }
                TypeVariableElement variable = (TypeVariableElement)type.getElement();
                DartTypeNode boundNode = node.getBound();
                if (boundNode != null) {
                    bound = classContext.resolveType(boundNode, false, false, ResolverErrorCode.NO_SUCH_TYPE);
                    boundNode.setType(bound);
                } else {
                    bound = Resolver.this.typeProvider.getObjectType();
                }
                variable.setBound(bound);
            }
            while (nodeIterator.hasNext()) {
                DartTypeParameter node = nodeIterator.next();
                node.setType(Resolver.this.typeProvider.getDynamicType());
            }
        }

        private void checkDefaultClassTypeParamsToDefaultDecl(InterfaceType defaultClassType, DartParameterizedTypeNode defaultClassRef) {
            if (defaultClassRef.getTypeParameters().isEmpty()) {
                return;
            }
            DartClass defaultClass = (DartClass)defaultClassType.getElement().getNode();
            boolean match = true;
            if (defaultClass.getTypeParameters().isEmpty()) {
                match = false;
            } else {
                String defaultClassSource;
                DartParameterizedTypeNode temp = new DartParameterizedTypeNode((DartExpression)defaultClass.getName(), defaultClass.getTypeParameters());
                String refSource = defaultClassRef.toSource();
                if (!refSource.equals(defaultClassSource = temp.toSource())) {
                    match = false;
                }
            }
            if (!match) {
                this.onError(defaultClassRef, ResolverErrorCode.TYPE_PARAMETERS_MUST_MATCH_EXACTLY, new Object[0]);
            }
        }

        private void checkInterfaceTypeParamsToDefault(ClassElement interfaceElement, ClassElement defaultClassElement) {
            List<? extends Type> interfaceTypeParams = interfaceElement.getTypeParameters();
            List<? extends Type> defaultTypeParams = defaultClassElement.getTypeParameters();
            if (defaultTypeParams.size() != interfaceTypeParams.size()) {
                this.onError((DartNode)((DartClass)interfaceElement.getNode()).getName(), ResolverErrorCode.DEFAULT_CLASS_MUST_HAVE_SAME_TYPE_PARAMS, new Object[0]);
            } else {
                Iterator<? extends Type> interfaceIterator = interfaceTypeParams.iterator();
                Iterator<? extends Type> defaultIterator = defaultTypeParams.iterator();
                while (interfaceIterator.hasNext()) {
                    String dVarName;
                    Type iVar = interfaceIterator.next();
                    Type dVar = defaultIterator.next();
                    String iVarName = iVar.getElement().getName();
                    if (iVarName.equals(dVarName = dVar.getElement().getName())) continue;
                    this.onError(iVar.getElement().getNode(), ResolverErrorCode.TYPE_VARIABLE_DOES_NOT_MATCH, iVarName, dVarName, defaultClassElement.getName());
                }
            }
        }

        private void checkClassTypeVariables(ClassElement classElement) {
            Scope scope = this.context.getScope();
            HashSet declaredVariableNames = Sets.newHashSet();
            for (Type type : classElement.getTypeParameters()) {
                Element existingElement;
                if (!(type instanceof TypeVariable)) continue;
                Element typeVariableElement = type.getElement();
                String name = typeVariableElement.getName();
                if (declaredVariableNames.contains(name)) {
                    this.onError(typeVariableElement.getNode(), ResolverErrorCode.DUPLICATE_TYPE_VARIABLE, name);
                } else {
                    declaredVariableNames.add(name);
                }
                if ((existingElement = scope.findElement(scope.getLibrary(), name)) == null) continue;
                this.onError(typeVariableElement.getNode(), ResolverErrorCode.DUPLICATE_TYPE_VARIABLE_WARNING, name, existingElement, Elements.getRelativeElementLocation(typeVariableElement, existingElement));
            }
        }

        private void checkInteraceConstructors(ClassElement interfaceElement) {
            String interfaceClassName = interfaceElement.getName();
            String defaultClassName = interfaceElement.getDefaultClass().getElement().getName();
            for (ConstructorElement interfaceConstructor : interfaceElement.getConstructors()) {
                List<String> defaultNames;
                List<String> interfaceNames;
                ConstructorElement defaultConstructor = this.resolveInterfaceConstructorInDefaultClass(interfaceConstructor.getNode(), interfaceConstructor);
                if (defaultConstructor == null) continue;
                interfaceConstructor.setDefaultConstructor(defaultConstructor);
                int numReqInterface = Elements.getNumberOfRequiredParameters(interfaceConstructor);
                int numReqDefault = Elements.getNumberOfRequiredParameters(defaultConstructor);
                if (numReqInterface != numReqDefault) {
                    this.onError(interfaceConstructor.getNode(), ResolverErrorCode.DEFAULT_CONSTRUCTOR_NUMBER_OF_REQUIRED_PARAMETERS, Elements.getRawMethodName(interfaceConstructor), interfaceClassName, numReqInterface, Elements.getRawMethodName(defaultConstructor), defaultClassName, numReqDefault);
                }
                if (((Object)(interfaceNames = Elements.getNamedParameters(interfaceConstructor))).equals(defaultNames = Elements.getNamedParameters(defaultConstructor))) continue;
                this.onError(interfaceConstructor.getNode(), ResolverErrorCode.DEFAULT_CONSTRUCTOR_NAMED_PARAMETERS, Elements.getRawMethodName(interfaceConstructor), interfaceClassName, interfaceNames, Elements.getRawMethodName(defaultConstructor), defaultClassName, defaultNames);
            }
        }

        boolean hasDefaultConstructor(ClassElement classElement) {
            if (Elements.needsImplicitDefaultConstructor(classElement)) {
                return true;
            }
            ConstructorElement defaultCtor = Elements.lookupConstructor(classElement, "");
            if (defaultCtor != null) {
                return defaultCtor.getParameters().isEmpty();
            }
            return false;
        }

        private void checkImplicitDefaultDefaultSuperInvocation(DartClass cls, ClassElement classElement) {
            ConstructorElement superCtor;
            ClassElement superElement;
            assert (Elements.needsImplicitDefaultConstructor(classElement));
            InterfaceType supertype = classElement.getSupertype();
            if (supertype != null && !(superElement = supertype.getElement()).isDynamic() && (superCtor = Elements.lookupConstructor(superElement, "")) != null && !superCtor.getParameters().isEmpty()) {
                this.onError((DartNode)cls.getName(), ResolverErrorCode.CANNOT_RESOLVE_IMPLICIT_CALL_TO_SUPER_CONSTRUCTOR, cls.getSuperclass());
            }
        }

        private Element resolve(DartNode node) {
            if (node == null) {
                return null;
            }
            return node.accept(this);
        }

        @Override
        public MethodElement visitMethodDefinition(DartMethodDefinition node) {
            MethodElement member = node.getSymbol();
            ResolutionContext previousContext = this.context;
            this.context = this.context.extend(member.getName());
            assert (this.currentMethod == null) : "Nested methods?";
            this.innermostFunction = this.currentMethod = member;
            DartFunction functionNode = node.getFunction();
            List<DartParameter> parameters = functionNode.getParams();
            HashSet initalizedFinals = Sets.newHashSet();
            for (DartParameter parameter : parameters) {
                assert (parameter.getSymbol() != null);
                if (parameter.getQualifier() instanceof DartThisExpression) {
                    this.checkParameterInitializer(node, parameter);
                    if (initalizedFinals.add(parameter.getParameterName())) continue;
                    this.onError(parameter, ResolverErrorCode.DUPLICATE_PARAMETER, parameter.getName());
                    continue;
                }
                this.getContext().declare(parameter.getSymbol(), ResolverErrorCode.DUPLICATE_PARAMETER, ResolverErrorCode.DUPLICATE_PARAMETER_WARNING);
            }
            for (DartParameter parameter : parameters) {
                this.resolve(parameter.getDefaultExpr());
            }
            if (!(functionNode.getBody() != null || Elements.isNonFactoryConstructor(member) || member.getModifiers().isAbstract() || member.getEnclosingElement().isInterface())) {
                this.onError(functionNode, ResolverErrorCode.METHOD_MUST_HAVE_BODY, new Object[0]);
            }
            this.resolve(functionNode.getBody());
            if (Elements.isNonFactoryConstructor(member)) {
                this.resolveInitializers(node, initalizedFinals);
                if (!(this.currentHolder.isInterface() || member.getModifiers().isRedirectedConstructor() || ((Object)this.finalsNeedingInitializing).equals(initalizedFinals))) {
                    for (String field : this.finalsNeedingInitializing) {
                        if (initalizedFinals.contains(field)) continue;
                        this.onError((DartNode)node.getName(), ResolverErrorCode.FINAL_FIELD_MUST_BE_INITIALIZED, field);
                    }
                }
            }
            if (ElementKind.of(this.currentHolder).equals((Object)ElementKind.CLASS)) {
                ClassElement classElement = (ClassElement)this.currentHolder;
                try {
                    block6: for (InterfaceType supertype : classElement.getAllSupertypes()) {
                        Element superElement;
                        InterfaceType.Member superMember = supertype.lookupMember(member.getName());
                        if (superMember == null || !ElementKind.of(superElement = superMember.getElement()).equals((Object)ElementKind.METHOD)) continue;
                        MethodElement superMethod = (MethodElement)superElement;
                        if (DartIdentifier.isPrivateName(member.getName()) && Elements.getLibraryElement(superMethod) != Elements.getLibraryElement(member)) continue;
                        List<VariableElement> superParameters = superMethod.getParameters();
                        if (superParameters.size() != parameters.size()) {
                            this.onError((DartNode)node.getName(), ResolverErrorCode.CANNOT_OVERRIDE_METHOD_WRONG_NUM_PARAMS, member.getName());
                            continue;
                        }
                        ArrayList<VariableElement> named = new ArrayList<VariableElement>();
                        for (VariableElement v : member.getParameters()) {
                            if (!v.isNamed()) continue;
                            named.add(v);
                        }
                        ArrayList<VariableElement> superNamed = new ArrayList<VariableElement>();
                        for (VariableElement v : superParameters) {
                            if (!v.isNamed()) continue;
                            superNamed.add(v);
                        }
                        if (named.size() != superNamed.size()) {
                            this.onError((DartNode)node.getName(), ResolverErrorCode.CANNOT_OVERRIDE_METHOD_NUM_NAMED_PARAMS, member.getName());
                            continue;
                        }
                        while (!named.isEmpty()) {
                            VariableElement v1 = (VariableElement)named.remove(0);
                            VariableElement v2 = (VariableElement)superNamed.remove(0);
                            if (v1.getName().equals(v2.getName())) continue;
                            this.onError(v1.getNode(), ResolverErrorCode.CANNOT_OVERRIDE_METHOD_ORDER_NAMED_PARAMS, member.getName());
                            continue block6;
                        }
                    }
                }
                catch (CyclicDeclarationException ignored) {
                }
                catch (DuplicatedInterfaceException ignored) {
                    // empty catch block
                }
            }
            this.context = previousContext;
            this.currentMethod = null;
            this.innermostFunction = null;
            return member;
        }

        @Override
        public Element visitField(DartField node) {
            DartExpression expression = node.getValue();
            Modifiers modifiers = node.getModifiers();
            boolean isStatic = modifiers.isStatic();
            boolean isFinal = modifiers.isFinal();
            boolean isTopLevel = ElementKind.of(this.currentHolder).equals((Object)ElementKind.LIBRARY);
            if (isTopLevel && isFinal) {
                modifiers.makeStatic();
            }
            if (expression != null) {
                this.resolve(expression);
                FieldElement element = node.getSymbol();
                if (expression.getType() != null) {
                    Elements.setType(element, expression.getType());
                }
            } else if (isFinal) {
                if (isStatic) {
                    this.onError(node, ResolverErrorCode.STATIC_FINAL_REQUIRES_VALUE, new Object[0]);
                } else {
                    this.finalsNeedingInitializing.add(((DartIdentifier)node.getName()).getTargetName());
                }
            }
            FieldElement field = node.getSymbol();
            if (field.getGetter() != null) {
                this.resolve(field.getGetter().getNode());
            }
            if (field.getSetter() != null) {
                this.resolve(field.getSetter().getNode());
            }
            return null;
        }

        @Override
        public Element visitFieldDefinition(DartFieldDefinition node) {
            this.visit(node.getFields());
            return null;
        }

        @Override
        public Element visitFunction(DartFunction node) {
            throw this.context.internalError(node, "should not be called.", new Object[0]);
        }

        @Override
        public Element visitParameter(DartParameter x) {
            Element element = super.visitParameter(x);
            this.resolve(x.getDefaultExpr());
            this.getContext().declare(element, ResolverErrorCode.DUPLICATE_PARAMETER, ResolverErrorCode.DUPLICATE_PARAMETER_WARNING);
            return element;
        }

        public Element resolveVariable(DartVariable x, Modifiers modifiers) {
            this.resolve(x.getValue());
            VariableElement element = Elements.variableElement(x, x.getVariableName(), modifiers);
            this.getContext().declare(this.recordElement(x, element), ResolverErrorCode.DUPLICATE_LOCAL_VARIABLE_ERROR, ResolverErrorCode.DUPLICATE_LOCAL_VARIABLE_WARNING);
            return element;
        }

        @Override
        public Element visitVariableStatement(DartVariableStatement node) {
            this.resolveVariableStatement(node, false);
            return null;
        }

        private void resolveVariableStatement(DartVariableStatement node, boolean isImplicitlyInitialized) {
            Type type = this.resolveType(node.getTypeNode(), this.inStaticContext(this.currentMethod), this.inFactoryContext(this.currentMethod), TypeErrorCode.NO_SUCH_TYPE);
            for (DartVariable variable : node.getVariables()) {
                Elements.setType(this.resolveVariable(variable, node.getModifiers()), type);
                this.checkVariableStatement(node, variable, isImplicitlyInitialized);
            }
        }

        @Override
        public Element visitLabel(DartLabel x) {
            LabelElement previousLabel = this.currentLabel;
            this.currentLabel = Elements.labelElement(x, x.getName(), this.innermostFunction);
            this.recordElement(x, this.currentLabel);
            x.visitChildren(this);
            if (!this.labelsInScopes.contains(this.currentLabel) || !this.referencedLabels.contains(this.currentLabel)) {
                // empty if block
            }
            this.currentLabel = previousLabel;
            return null;
        }

        @Override
        public Element visitFunctionExpression(DartFunctionExpression x) {
            MethodElement element;
            if (x.isStatement()) {
                element = this.getContext().declareFunction(x);
                this.getContext().pushFunctionScope(x);
            } else {
                this.getContext().pushFunctionScope(x);
                element = this.getContext().declareFunction(x);
            }
            MethodElement previousFunction = this.innermostFunction;
            this.innermostFunction = element;
            DartFunction functionNode = x.getFunction();
            this.resolveFunction(functionNode, element);
            this.resolve(functionNode.getBody());
            this.innermostFunction = previousFunction;
            this.getContext().popScope();
            return this.recordElement(x, element);
        }

        @Override
        public Element visitBlock(DartBlock x) {
            this.getContext().pushScope("<block>");
            this.addLabelToStatement(x);
            x.visitChildren(this);
            this.getContext().popScope();
            return null;
        }

        @Override
        public Element visitBreakStatement(DartBreakStatement x) {
            DartNode parent = x.getParent();
            if (parent instanceof DartLabel && x.getLabel() != null && ((DartLabel)parent).getLabel().getTargetName().equals(x.getLabel().getTargetName())) {
                this.getContext().pushScope("<break>");
                this.addLabelToStatement(x);
                this.visitGotoStatement(x);
                this.getContext().popScope();
                return null;
            }
            return this.visitGotoStatement(x);
        }

        @Override
        public Element visitTryStatement(DartTryStatement x) {
            this.getContext().pushScope("<try>");
            this.addLabelToStatement(x);
            x.visitChildren(this);
            this.getContext().popScope();
            return null;
        }

        @Override
        public Element visitCatchBlock(DartCatchBlock x) {
            this.getContext().pushScope("<block>");
            this.addLabelToStatement(x);
            x.visitChildren(this);
            this.getContext().popScope();
            return null;
        }

        @Override
        public Element visitDoWhileStatement(DartDoWhileStatement x) {
            this.getContext().pushScope("<do>");
            this.addLabelToStatement(x);
            x.visitChildren(this);
            this.getContext().popScope();
            return null;
        }

        @Override
        public Element visitWhileStatement(DartWhileStatement x) {
            this.getContext().pushScope("<while>");
            this.addLabelToStatement(x);
            x.visitChildren(this);
            this.getContext().popScope();
            return null;
        }

        @Override
        public Element visitIfStatement(DartIfStatement x) {
            this.getContext().pushScope("<if>");
            this.addLabelToStatement(x);
            x.visitChildren(this);
            this.getContext().popScope();
            return null;
        }

        @Override
        public Element visitForInStatement(DartForInStatement x) {
            this.getContext().pushScope("<for in>");
            this.addLabelToStatement(x);
            if (x.introducesVariable()) {
                this.resolveVariableStatement(x.getVariableStatement(), true);
            } else {
                x.getIdentifier().accept(this);
            }
            x.getIterable().accept(this);
            x.getBody().accept(this);
            this.getContext().popScope();
            return null;
        }

        private void addLabelToStatement(DartStatement x) {
            DartNode parent;
            if (this.currentLabel != null && (parent = x.getParent()) instanceof DartLabel) {
                this.getContext().getScope().setLabel(this.currentLabel);
                this.labelsInScopes.add(this.currentLabel);
            }
        }

        @Override
        public Element visitForStatement(DartForStatement x) {
            this.getContext().pushScope("<for>");
            this.addLabelToStatement(x);
            x.visitChildren(this);
            this.getContext().popScope();
            return null;
        }

        @Override
        public Element visitSwitchStatement(DartSwitchStatement x) {
            this.getContext().pushScope("<switch>");
            this.addLabelToStatement(x);
            x.visitChildren(this);
            this.getContext().popScope();
            return null;
        }

        @Override
        public Element visitSwitchMember(DartSwitchMember x) {
            this.getContext().pushScope("<switch member>");
            x.visitChildren(this);
            this.getContext().popScope();
            return null;
        }

        @Override
        public Element visitThisExpression(DartThisExpression x) {
            if (ElementKind.of(this.currentHolder).equals((Object)ElementKind.LIBRARY)) {
                this.onError(x, ResolverErrorCode.THIS_ON_TOP_LEVEL, new Object[0]);
            } else if (this.currentMethod == null) {
                this.onError(x, ResolverErrorCode.THIS_OUTSIDE_OF_METHOD, new Object[0]);
            } else if (this.currentMethod.getModifiers().isStatic()) {
                this.onError(x, ResolverErrorCode.THIS_IN_STATIC_METHOD, new Object[0]);
            } else if (this.currentMethod.getModifiers().isFactory()) {
                this.onError(x, ResolverErrorCode.THIS_IN_FACTORY_CONSTRUCTOR, new Object[0]);
            }
            return null;
        }

        @Override
        public Element visitSuperExpression(DartSuperExpression x) {
            if (ElementKind.of(this.currentHolder).equals((Object)ElementKind.LIBRARY)) {
                this.onError(x, ResolverErrorCode.SUPER_ON_TOP_LEVEL, new Object[0]);
            } else if (this.currentMethod == null) {
                this.onError(x, ResolverErrorCode.SUPER_OUTSIDE_OF_METHOD, new Object[0]);
            } else if (this.currentMethod.getModifiers().isStatic()) {
                this.onError(x, ResolverErrorCode.SUPER_IN_STATIC_METHOD, new Object[0]);
            } else if (this.currentMethod.getModifiers().isFactory()) {
                this.onError(x, ResolverErrorCode.SUPER_IN_FACTORY_CONSTRUCTOR, new Object[0]);
            } else {
                return this.recordElement(x, Elements.superElement(x, ((ClassElement)this.currentHolder).getSupertype().getElement()));
            }
            return null;
        }

        @Override
        public Element visitSuperConstructorInvocation(DartSuperConstructorInvocation x) {
            ConstructorElement element;
            this.visit(x.getArgs());
            String name = x.getName() == null ? "" : x.getName().getTargetName();
            InterfaceType supertype = ((ClassElement)this.currentHolder).getSupertype();
            ConstructorElement constructorElement = element = supertype == null ? null : Elements.lookupConstructor(supertype.getElement(), name);
            if (element == null) {
                this.onError(x, ResolverErrorCode.CANNOT_RESOLVE_SUPER_CONSTRUCTOR, name);
            }
            return this.recordElement(x, element);
        }

        @Override
        public Element visitNamedExpression(DartNamedExpression node) {
            return node.getExpression().accept(this);
        }

        @Override
        public Element visitIdentifier(DartIdentifier x) {
            return this.resolveIdentifier(x, false);
        }

        private Element resolveIdentifier(DartIdentifier x, boolean isQualifier) {
            Scope scope = this.getContext().getScope();
            String name = x.getTargetName();
            Element element = scope.findElement(scope.getLibrary(), name);
            if (element == null) {
                Element found;
                if (DartIdentifier.isPrivateName(name) && (found = scope.findElement(null, name)) != null) {
                    EnclosingElement enclosingElement = found.getEnclosingElement();
                    String referencedElementName = enclosingElement == null ? name : String.format("%s.%s", enclosingElement.getName(), name);
                    this.onError(x, ResolverErrorCode.ILLEGAL_ACCESS_TO_PRIVATE_MEMBER, name, referencedElementName);
                }
                if (this.isStaticContextOrInitializer() && !this.context.shouldWarnOnNoSuchType()) {
                    this.onError(x, ResolverErrorCode.CANNOT_BE_RESOLVED, name);
                }
            } else {
                switch (element.getKind()) {
                    case FIELD: {
                        if (!this.inStaticContext(this.currentMethod) || this.inStaticContext(element)) break;
                        this.onError(x, ResolverErrorCode.ILLEGAL_FIELD_ACCESS_FROM_STATIC, name);
                        break;
                    }
                    case METHOD: {
                        if (!this.inStaticContext(this.currentMethod) || this.inStaticContext(element)) break;
                        this.onError(x, ResolverErrorCode.ILLEGAL_METHOD_ACCESS_FROM_STATIC, name);
                        break;
                    }
                    case CLASS: {
                        if (isQualifier) break;
                        this.onError(x, ResolverErrorCode.IS_A_CLASS, name);
                        break;
                    }
                }
            }
            if (this.inInitializer && element != null && element.getKind().equals((Object)ElementKind.FIELD) && !element.getModifiers().isStatic() && !Elements.isTopLevel(element)) {
                this.onError(x, ResolverErrorCode.CANNOT_ACCESS_FIELD_IN_INIT, new Object[0]);
            }
            return this.recordElement(x, element);
        }

        @Override
        public Element visitTypeNode(DartTypeNode x) {
            return this.resolveType(x, this.inStaticContext(this.currentMethod), this.inFactoryContext(this.currentMethod), ResolverErrorCode.NO_SUCH_TYPE).getElement();
        }

        @Override
        public Element visitPropertyAccess(DartPropertyAccess x) {
            Element qualifier = this.resolveQualifier(x.getQualifier());
            Element element = null;
            block0 : switch (ElementKind.of(qualifier)) {
                case CLASS: {
                    element = Elements.findElement((ClassElement)qualifier, x.getPropertyName());
                    switch (ElementKind.of(element)) {
                        case FIELD: {
                            FieldElement field = (FieldElement)element;
                            if (field.getModifiers().isStatic()) break block0;
                            this.onError(x.getName(), ResolverErrorCode.NOT_A_STATIC_FIELD, x.getPropertyName());
                            break;
                        }
                        case NONE: {
                            this.onError(x.getName(), ResolverErrorCode.CANNOT_BE_RESOLVED, x.getPropertyName());
                            break;
                        }
                        case METHOD: {
                            MethodElement method = (MethodElement)element;
                            if (method.getModifiers().isStatic()) break block0;
                            this.onError(x.getName(), ResolverErrorCode.NOT_A_STATIC_METHOD, x.getPropertyName());
                            break;
                        }
                        default: {
                            this.onError(x.getName(), ResolverErrorCode.EXPECTED_STATIC_FIELD, new Object[]{element.getKind()});
                            break;
                        }
                    }
                    break;
                }
                case SUPER: {
                    ClassElement cls = ((SuperElement)qualifier).getClassElement();
                    InterfaceType.Member member = cls.getType().lookupMember(x.getPropertyName());
                    if (member != null) {
                        element = member.getElement();
                    }
                    switch (ElementKind.of(element)) {
                        case FIELD: {
                            FieldElement field = (FieldElement)element;
                            if (!field.getModifiers().isStatic()) break block0;
                            this.onError(x.getName(), ResolverErrorCode.NOT_AN_INSTANCE_FIELD, x.getPropertyName());
                            break;
                        }
                        case METHOD: {
                            MethodElement method = (MethodElement)element;
                            if (!method.isStatic()) break block0;
                            this.onError(x.getName(), ResolverErrorCode.NOT_AN_INSTANCE_FIELD, x.getPropertyName());
                            break;
                        }
                        case NONE: {
                            this.onError(x.getName(), ResolverErrorCode.CANNOT_BE_RESOLVED, x.getPropertyName());
                            break;
                        }
                        default: {
                            this.onError(x.getName(), ResolverErrorCode.EXPECTED_AN_INSTANCE_FIELD_IN_SUPER_CLASS, new Object[]{element.getKind()});
                            break;
                        }
                    }
                    break;
                }
                case LIBRARY: {
                    Scope scope = ((LibraryElement)qualifier).getScope();
                    element = scope.findElement(scope.getLibrary(), x.getPropertyName());
                    if (element != null) break;
                    this.onError(x, ResolverErrorCode.CANNOT_BE_RESOLVED_LIBRARY, x.getPropertyName(), qualifier.getName());
                    break;
                }
            }
            return this.recordElement(x, element);
        }

        private Element resolveQualifier(DartNode qualifier) {
            return qualifier instanceof DartIdentifier ? this.resolveIdentifier((DartIdentifier)qualifier, true) : qualifier.accept(this);
        }

        @Override
        public Element visitMethodInvocation(DartMethodInvocation x) {
            Element target = this.resolveQualifier(x.getTarget());
            Element element = null;
            switch (ElementKind.of(target)) {
                case CLASS: {
                    ClassElement classElement = (ClassElement)target;
                    element = Elements.lookupLocalMethod(classElement, x.getFunctionNameString());
                    if (element == null) {
                        element = Elements.lookupLocalField(classElement, x.getFunctionNameString());
                    }
                    if (element != null && element.getModifiers().isStatic()) break;
                    this.diagnoseErrorInMethodInvocation(x, (ClassElement)target, element);
                    break;
                }
                case SUPER: {
                    ClassElement classElement = ((SuperElement)target).getClassElement();
                    InterfaceType type = classElement.getType();
                    InterfaceType.Member member = type.lookupMember(x.getFunctionNameString());
                    if (member == null || member.getElement().getModifiers().isStatic()) break;
                    element = member.getElement();
                    break;
                }
                case LIBRARY: {
                    LibraryElement library = (LibraryElement)target;
                    element = library.getScope().findElement(this.context.getScope().getLibrary(), x.getFunctionNameString());
                    if (element == null) {
                        this.diagnoseErrorInMethodInvocation(x, null, null);
                        break;
                    }
                    x.getFunctionName().setSymbol(element);
                }
            }
            this.checkInvocationTarget(x, this.currentMethod, target);
            this.visit(x.getArgs());
            return this.recordElement(x, element);
        }

        @Override
        public Element visitUnqualifiedInvocation(DartUnqualifiedInvocation x) {
            Scope scope = this.getContext().getScope();
            Element element = scope.findElement(scope.getLibrary(), x.getTarget().getTargetName());
            ElementKind kind = ElementKind.of(element);
            if (!INVOKABLE_ELEMENTS.contains((Object)kind)) {
                this.diagnoseErrorInUnqualifiedInvocation(x);
            } else {
                this.checkInvocationTarget(x, this.currentMethod, element);
            }
            this.recordElement(x.getTarget(), element);
            this.visit(x.getArgs());
            return null;
        }

        @Override
        public Element visitFunctionObjectInvocation(DartFunctionObjectInvocation x) {
            x.getTarget().accept(this);
            this.visit(x.getArgs());
            return null;
        }

        @Override
        public Element visitNewExpression(DartNewExpression x) {
            this.visit(x.getArgs());
            Element element = x.getConstructor().accept(new ResolutionContext.Selector(this.getContext()){

                @Override
                public Element visitTypeNode(DartTypeNode type) {
                    return ResolveElementsVisitor.this.recordType(type, ResolveElementsVisitor.this.resolveType(type, ResolveElementsVisitor.this.inStaticContext(ResolveElementsVisitor.this.currentMethod), ResolveElementsVisitor.this.inFactoryContext(ResolveElementsVisitor.this.currentMethod), ResolverErrorCode.NO_SUCH_TYPE));
                }

                @Override
                public Element visitPropertyAccess(DartPropertyAccess node) {
                    Element element = node.getQualifier().accept(this);
                    if (ElementKind.of(element).equals((Object)ElementKind.CLASS)) {
                        return Elements.lookupConstructor((ClassElement)element, node.getPropertyName());
                    }
                    return null;
                }
            });
            switch (ElementKind.of(element)) {
                case CLASS: {
                    ClassElement classElement = (ClassElement)element;
                    element = Elements.lookupConstructor(classElement, "");
                    if (element != null || !x.getArgs().isEmpty() || !Elements.needsImplicitDefaultConstructor(classElement)) break;
                    element = new SyntheticDefaultConstructorElement(null, classElement, Resolver.this.typeProvider);
                    break;
                }
                case TYPE_VARIABLE: {
                    this.onError(x.getConstructor(), ResolverErrorCode.NEW_EXPRESSION_CANT_USE_TYPE_VAR, new Object[0]);
                    return null;
                }
            }
            ConstructorElement constructor = this.checkIsConstructor(x, element);
            constructor = this.resolveInterfaceConstructorInDefaultClass(x.getConstructor(), constructor);
            if (constructor != null && x.isConst() && !constructor.getModifiers().isConstant()) {
                this.onError(x, ResolverErrorCode.CONST_AND_NONCONST_CONSTRUCTOR, new Object[0]);
            }
            return this.recordElement(x, constructor);
        }

        private ConstructorElement resolveInterfaceConstructorInDefaultClass(DartNode errorTargetNode, ConstructorElement constructor) {
            if (constructor == null || constructor.getConstructorType().getDefaultClass() == null) {
                return constructor;
            }
            ClassElement originalClass = constructor.getConstructorType();
            ClassElement defaultClass = originalClass.getDefaultClass().getElement();
            String originalClassName = originalClass.getName();
            String defaultClassName = defaultClass.getName();
            String rawOriginalMethodName = Elements.getRawMethodName(constructor);
            int originalDotIndex = rawOriginalMethodName.indexOf(46);
            String originalQualifier = StringUtils.substringBefore(rawOriginalMethodName, ".");
            String originalName = StringUtils.substringAfter(rawOriginalMethodName, ".");
            boolean factoryImplementsInterface = Elements.implementsType(defaultClass, originalClass);
            if (factoryImplementsInterface) {
                for (ConstructorElement defaultConstructor : defaultClass.getConstructors()) {
                    int defaultDotIndex;
                    String rawDefaultMethodName = Elements.getRawMethodName(defaultConstructor);
                    if (rawOriginalMethodName.equals(originalClassName) && rawDefaultMethodName.equals(defaultClassName)) {
                        return defaultConstructor;
                    }
                    if (originalDotIndex == -1 || (defaultDotIndex = rawDefaultMethodName.indexOf(46)) == -1) continue;
                    String defaultQualifier = StringUtils.substringBefore(rawDefaultMethodName, ".");
                    String defaultName = StringUtils.substringAfter(rawDefaultMethodName, ".");
                    if (!defaultQualifier.equals(defaultClassName) || !originalQualifier.equals(originalClassName) || !defaultName.equals(originalName)) continue;
                    return defaultConstructor;
                }
            } else {
                for (ConstructorElement defaultConstructor : defaultClass.getConstructors()) {
                    String rawDefaultMethodName = Elements.getRawMethodName(defaultConstructor);
                    if (!rawDefaultMethodName.equals(rawOriginalMethodName)) continue;
                    return defaultConstructor;
                }
            }
            if (constructor.getParameters().isEmpty() && Elements.needsImplicitDefaultConstructor(defaultClass)) {
                return new SyntheticDefaultConstructorElement(null, defaultClass, Resolver.this.typeProvider);
            }
            String expectedFactoryConstructorName = factoryImplementsInterface ? (originalDotIndex == -1 ? defaultClassName : defaultClassName + "." + originalName) : rawOriginalMethodName;
            this.onError(errorTargetNode, ResolverErrorCode.DEFAULT_CONSTRUCTOR_UNRESOLVED, expectedFactoryConstructorName, defaultClassName);
            return null;
        }

        @Override
        public Element visitGotoStatement(DartGotoStatement x) {
            if (x.getTargetName() != null) {
                LabelElement labelElement;
                MethodElement enclosingFunction;
                Element element = this.getContext().getScope().findLabel(x.getTargetName(), this.innermostFunction);
                if (ElementKind.of(element).equals((Object)ElementKind.LABEL) && (enclosingFunction = (labelElement = (LabelElement)element).getEnclosingFunction()) == this.innermostFunction) {
                    this.referencedLabels.add(labelElement);
                    return this.recordElement(x, element);
                }
                this.diagnoseErrorInGotoStatement(x, element);
            }
            return null;
        }

        public void diagnoseErrorInGotoStatement(DartGotoStatement x, Element element) {
            if (element == null) {
                this.onError(x.getLabel(), ResolverErrorCode.CANNOT_RESOLVE_LABEL, x.getTargetName());
            } else if (ElementKind.of(element).equals((Object)ElementKind.LABEL)) {
                this.onError(x.getLabel(), ResolverErrorCode.CANNOT_ACCESS_OUTER_LABEL, x.getTargetName());
            } else {
                this.onError(x.getLabel(), ResolverErrorCode.NOT_A_LABEL, x.getTargetName());
            }
        }

        private void diagnoseErrorInMethodInvocation(DartMethodInvocation node, ClassElement klass, Element element) {
            String name = node.getFunctionNameString();
            ElementKind kind = ElementKind.of(element);
            DartIdentifier errorNode = node.getFunctionName();
            switch (kind) {
                case NONE: {
                    this.onError(errorNode, ResolverErrorCode.CANNOT_RESOLVE_METHOD, name);
                    break;
                }
                case CONSTRUCTOR: {
                    this.onError(errorNode, ResolverErrorCode.IS_A_CONSTRUCTOR, klass.getName(), name);
                    break;
                }
                case METHOD: {
                    assert (!((MethodElement)element).getModifiers().isStatic());
                    this.onError(errorNode, ResolverErrorCode.IS_AN_INSTANCE_METHOD, klass.getName(), name);
                    break;
                }
                default: {
                    throw this.context.internalError(errorNode, "Unexpected kind of element: %s", new Object[]{kind});
                }
            }
        }

        private void diagnoseErrorInUnqualifiedInvocation(DartUnqualifiedInvocation node) {
            String name = node.getTarget().getTargetName();
            Scope scope = this.getContext().getScope();
            Element element = scope.findElement(scope.getLibrary(), name);
            ElementKind kind = ElementKind.of(element);
            switch (kind) {
                case NONE: {
                    if (!this.isStaticContextOrInitializer()) break;
                    this.onError(node, ResolverErrorCode.CANNOT_RESOLVE_METHOD, name);
                    break;
                }
                case CONSTRUCTOR: {
                    this.onError(node, ResolverErrorCode.DID_YOU_MEAN_NEW, name, "constructor");
                    break;
                }
                case CLASS: {
                    this.onError(node, ResolverErrorCode.DID_YOU_MEAN_NEW, name, "class");
                    break;
                }
                case TYPE_VARIABLE: {
                    this.onError(node, ResolverErrorCode.DID_YOU_MEAN_NEW, name, "type variable");
                    break;
                }
                case LABEL: {
                    this.onError(node, ResolverErrorCode.CANNOT_CALL_LABEL, new Object[0]);
                    break;
                }
                default: {
                    throw this.context.internalError(node, "Unexpected kind of element: %s", new Object[]{kind});
                }
            }
        }

        private void diagnoseErrorInInitializer(DartIdentifier x) {
            String name = x.getTargetName();
            Scope scope = this.getContext().getScope();
            Element element = scope.findElement(scope.getLibrary(), name);
            ElementKind kind = ElementKind.of(element);
            switch (kind) {
                case NONE: {
                    this.onError(x, ResolverErrorCode.CANNOT_RESOLVE_FIELD, name);
                    break;
                }
                case FIELD: {
                    FieldElement field = (FieldElement)element;
                    if (field.isStatic()) {
                        this.onError(x, ResolverErrorCode.CANNOT_INIT_STATIC_FIELD_IN_INITIALIZER, new Object[0]);
                        break;
                    }
                    if (field.getModifiers().isAbstractField()) {
                        this.onError(x, ResolverErrorCode.CANNOT_INIT_STATIC_FIELD_IN_INITIALIZER, new Object[0]);
                        break;
                    }
                    this.onError(x, ResolverErrorCode.CANNOT_INIT_FIELD_FROM_SUPERCLASS, new Object[0]);
                    break;
                }
                case METHOD: {
                    this.onError(x, ResolverErrorCode.EXPECTED_FIELD_NOT_METHOD, name);
                    break;
                }
                case CLASS: {
                    this.onError(x, ResolverErrorCode.EXPECTED_FIELD_NOT_CLASS, name);
                    break;
                }
                case PARAMETER: {
                    this.onError(x, ResolverErrorCode.EXPECTED_FIELD_NOT_PARAMETER, name);
                    break;
                }
                case TYPE_VARIABLE: {
                    this.onError(x, ResolverErrorCode.EXPECTED_FIELD_NOT_TYPE_VAR, name);
                    break;
                }
                default: {
                    throw this.context.internalError(x, "Unexpected kind of element: %s", new Object[]{kind});
                }
            }
        }

        @Override
        public Element visitInitializer(DartInitializer x) {
            Element element;
            if (x.getName() != null) {
                element = Elements.lookupLocalField((ClassElement)this.currentHolder, x.getName().getTargetName());
                if (element == null || element.isStatic() || element.getModifiers().isAbstractField()) {
                    this.diagnoseErrorInInitializer(x.getName());
                }
                this.recordElement(x.getName(), element);
            }
            assert (!this.inInitializer);
            this.inInitializer = true;
            element = x.getValue().accept(this);
            this.inInitializer = false;
            return element;
        }

        @Override
        public Element visitRedirectConstructorInvocation(DartRedirectConstructorInvocation x) {
            this.visit(x.getArgs());
            String name = x.getName() != null ? x.getName().getTargetName() : "";
            ConstructorElement element = Elements.lookupConstructor((ClassElement)this.currentHolder, name);
            if (element == null) {
                this.onError(x, ResolverErrorCode.CANNOT_RESOLVE_CONSTRUCTOR, name);
            }
            return this.recordElement(x, element);
        }

        @Override
        public Element visitReturnStatement(DartReturnStatement x) {
            if (x.getValue() != null) {
                if (this.currentMethod == this.innermostFunction && Elements.isNonFactoryConstructor(this.currentMethod)) {
                    this.onError(x, ResolverErrorCode.INVALID_RETURN_IN_CONSTRUCTOR, new Object[0]);
                }
                return x.getValue().accept(this);
            }
            return null;
        }

        @Override
        public Element visitIntegerLiteral(DartIntegerLiteral node) {
            this.recordType(node, Resolver.this.typeProvider.getIntType());
            return null;
        }

        @Override
        public Element visitDoubleLiteral(DartDoubleLiteral node) {
            this.recordType(node, Resolver.this.typeProvider.getDoubleType());
            return null;
        }

        @Override
        public Element visitBooleanLiteral(DartBooleanLiteral node) {
            this.recordType(node, Resolver.this.typeProvider.getBoolType());
            return null;
        }

        @Override
        public Element visitStringLiteral(DartStringLiteral node) {
            this.recordType(node, Resolver.this.typeProvider.getStringType());
            return null;
        }

        @Override
        public Element visitStringInterpolation(DartStringInterpolation node) {
            node.visitChildren(this);
            this.recordType(node, Resolver.this.typeProvider.getStringType());
            return null;
        }

        Element recordType(DartNode node, Type type) {
            node.setType(type);
            return type.getElement();
        }

        @Override
        public Element visitBinaryExpression(DartBinaryExpression node) {
            Element lhs = this.resolve(node.getArg1());
            this.resolve(node.getArg2());
            if (node.getOperator().isAssignmentOperator()) {
                switch (ElementKind.of(lhs)) {
                    case FIELD: 
                    case PARAMETER: 
                    case VARIABLE: {
                        if (!lhs.getModifiers().isFinal()) break;
                        Resolver.this.topLevelContext.onError(node, ResolverErrorCode.CANNOT_ASSIGN_TO_FINAL, lhs.getName());
                    }
                }
            }
            return null;
        }

        @Override
        public Element visitMapLiteral(DartMapLiteral node) {
            List<DartTypeNode> typeArgs = node.getTypeArguments();
            InterfaceType type = Resolver.this.topLevelContext.instantiateParameterizedType(Resolver.this.defaultLiteralMapType.getElement(), node, typeArgs, this.inStaticContext(this.currentMethod), this.inFactoryContext(this.currentMethod), ResolverErrorCode.NO_SUCH_TYPE);
            this.recordType(node, type);
            this.visit(node.getEntries());
            return null;
        }

        @Override
        public Element visitArrayLiteral(DartArrayLiteral node) {
            List<DartTypeNode> typeArgs = node.getTypeArguments();
            InterfaceType type = Resolver.this.topLevelContext.instantiateParameterizedType(Resolver.this.rawArrayType.getElement(), node, typeArgs, this.inStaticContext(this.currentMethod), this.inFactoryContext(this.currentMethod), ResolverErrorCode.NO_SUCH_TYPE);
            this.recordType(node, type);
            this.visit(node.getExpressions());
            return null;
        }

        private ConstructorElement checkIsConstructor(DartNewExpression source, Element element) {
            if (!ElementKind.of(element).equals((Object)ElementKind.CONSTRUCTOR)) {
                if (!this.context.shouldWarnOnNoSuchType()) {
                    this.onError(source.getConstructor(), ResolverErrorCode.NEW_EXPRESSION_NOT_CONSTRUCTOR, new Object[0]);
                }
                return null;
            }
            return (ConstructorElement)element;
        }

        private void checkConstructor(DartMethodDefinition node, ConstructorElement superCall) {
            InterfaceType supertype;
            ClassElement currentClass = (ClassElement)this.currentHolder;
            if (superCall == null && (supertype = currentClass.getSupertype()) != null) {
                superCall = Elements.lookupConstructor(supertype.getElement(), "");
            }
            if (superCall == null && !currentClass.isObject() && !currentClass.isObjectChild()) {
                ClassElement superElement;
                supertype = currentClass.getSupertype();
                if (supertype != null && (superElement = supertype.getElement()) != null && !this.hasDefaultConstructor(superElement)) {
                    this.onError(node, ResolverErrorCode.CANNOT_RESOLVE_IMPLICIT_CALL_TO_SUPER_CONSTRUCTOR, superElement.getName());
                }
            } else if (superCall != null && node.getModifiers().isConstant() && !superCall.getModifiers().isConstant()) {
                this.onError(node, ResolverErrorCode.CONST_CONSTRUCTOR_MUST_CALL_CONST_SUPER, new Object[0]);
            }
        }

        private void checkInvocationTarget(DartInvocation node, MethodElement callSite, Element target) {
            if (callSite != null && callSite.isStatic() && ElementKind.of(target).equals((Object)ElementKind.METHOD) && !target.getModifiers().isStatic() && !Elements.isTopLevel(target)) {
                this.onError(node, ResolverErrorCode.INSTANCE_METHOD_FROM_STATIC, new Object[0]);
            }
        }

        private void checkVariableStatement(DartVariableStatement node, DartVariable variable, boolean isImplicitlyInitialized) {
            Modifiers modifiers = node.getModifiers();
            if (modifiers.isFinal()) {
                if (!isImplicitlyInitialized && variable.getValue() == null) {
                    this.onError((DartNode)variable.getName(), ResolverErrorCode.CONSTANTS_MUST_BE_INITIALIZED, new Object[0]);
                } else if (isImplicitlyInitialized && variable.getValue() != null) {
                    this.onError((DartNode)variable.getName(), ResolverErrorCode.CANNOT_BE_INITIALIZED, new Object[0]);
                } else if (modifiers.isStatic() && modifiers.isFinal() && variable.getValue() != null) {
                    this.resolve(variable.getValue());
                    node.setType(variable.getValue().getType());
                }
            }
        }

        private void checkParameterInitializer(DartMethodDefinition method, DartParameter parameter) {
            if (Elements.isNonFactoryConstructor(method.getSymbol())) {
                FieldElement element;
                if (method.getModifiers().isRedirectedConstructor()) {
                    this.onError((DartNode)parameter.getName(), ResolverErrorCode.PARAMETER_INIT_WITH_REDIR_CONSTRUCTOR, new Object[0]);
                }
                if ((element = Elements.lookupLocalField((ClassElement)this.currentHolder, parameter.getParameterName())) == null) {
                    this.onError(parameter, ResolverErrorCode.PARAMETER_NOT_MATCH_FIELD, parameter.getName());
                } else if (element.isStatic()) {
                    this.onError(parameter, ResolverErrorCode.PARAMETER_INIT_STATIC_FIELD, parameter.getName());
                }
                Elements.setParameterInitializerElement(parameter.getSymbol(), element);
                DartPropertyAccess prop = (DartPropertyAccess)parameter.getName();
                prop.setReferencedElement(element);
                prop.getName().setReferencedElement(element);
                if (parameter.getTypeNode() == null && element != null) {
                    Elements.setType(parameter.getSymbol(), element.getType());
                }
            } else {
                this.onError((DartNode)parameter.getName(), ResolverErrorCode.PARAMETER_INIT_OUTSIDE_CONSTRUCTOR, new Object[0]);
            }
        }

        private void resolveInitializers(DartMethodDefinition node, Set<String> intializedFields) {
            Iterator<DartInitializer> initializers = node.getInitializers().iterator();
            ConstructorElement constructorElement = null;
            while (initializers.hasNext()) {
                DartInitializer initializer = initializers.next();
                Element element = this.resolve(initializer);
                if (ElementKind.of(element) == ElementKind.CONSTRUCTOR && initializer.isInvocation()) {
                    constructorElement = (ConstructorElement)element;
                    continue;
                }
                if (initializer.getName() == null || initializer.getName().getSymbol() == null || initializer.getName().getSymbol().getModifiers() == null || !initializer.getName().getSymbol().getModifiers().isFinal() || intializedFields.add(initializer.getName().getTargetName())) continue;
                this.onError(initializer, ResolverErrorCode.DUPLICATE_PARAMETER, initializer.getName());
            }
            this.checkConstructor(node, constructorElement);
        }

        private void onError(DartNode node, ErrorCode errorCode, Object ... arguments) {
            this.context.onError(node, errorCode, arguments);
        }

        private boolean inStaticContext(Element element) {
            return element == null || Elements.isTopLevel(element) || element.getModifiers().isStatic() || element.getModifiers().isFactory();
        }

        private boolean inFactoryContext(Element element) {
            if (element != null) {
                return element.getModifiers().isFactory();
            }
            return false;
        }

        @Override
        boolean isStaticContext() {
            return this.inStaticContext(this.currentMethod);
        }

        @Override
        boolean isFactoryContext() {
            return this.inFactoryContext(this.currentMethod);
        }

        boolean isStaticContextOrInitializer() {
            return this.inStaticContext(this.currentMethod) || this.inInitializer;
        }
    }
}

