/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.resolver;

import com.google.common.annotations.VisibleForTesting;
import com.google.dart.compiler.DartCompilerContext;
import com.google.dart.compiler.ErrorCode;
import com.google.dart.compiler.ast.DartClass;
import com.google.dart.compiler.ast.DartDeclaration;
import com.google.dart.compiler.ast.DartField;
import com.google.dart.compiler.ast.DartFieldDefinition;
import com.google.dart.compiler.ast.DartFunctionTypeAlias;
import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartMethodDefinition;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartNodeTraverser;
import com.google.dart.compiler.ast.DartParameter;
import com.google.dart.compiler.ast.DartParameterizedTypeNode;
import com.google.dart.compiler.ast.DartPropertyAccess;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.ast.Modifiers;
import com.google.dart.compiler.resolver.ClassElement;
import com.google.dart.compiler.resolver.ConstructorElement;
import com.google.dart.compiler.resolver.CoreTypeProvider;
import com.google.dart.compiler.resolver.Element;
import com.google.dart.compiler.resolver.ElementKind;
import com.google.dart.compiler.resolver.Elements;
import com.google.dart.compiler.resolver.EnclosingElement;
import com.google.dart.compiler.resolver.FieldElement;
import com.google.dart.compiler.resolver.FieldElementImplementation;
import com.google.dart.compiler.resolver.FunctionAliasElement;
import com.google.dart.compiler.resolver.LibraryElement;
import com.google.dart.compiler.resolver.MethodElement;
import com.google.dart.compiler.resolver.ResolutionContext;
import com.google.dart.compiler.resolver.ResolveVisitor;
import com.google.dart.compiler.resolver.ResolverErrorCode;
import com.google.dart.compiler.resolver.Scope;
import com.google.dart.compiler.resolver.TypeErrorCode;
import com.google.dart.compiler.resolver.VariableElement;
import com.google.dart.compiler.type.Type;
import com.google.dart.compiler.type.Types;
import java.util.ArrayList;
import java.util.List;

public class MemberBuilder {
    private ResolutionContext topLevelContext;
    private LibraryElement libraryElement;

    public void exec(DartUnit unit, DartCompilerContext context, CoreTypeProvider typeProvider) {
        Scope scope = unit.getLibrary().getElement().getScope();
        this.exec(unit, context, scope, typeProvider);
    }

    @VisibleForTesting
    public void exec(DartUnit unit, DartCompilerContext compilerContext, Scope scope, CoreTypeProvider typeProvider) {
        this.libraryElement = unit.getLibrary().getElement();
        this.topLevelContext = new ResolutionContext(scope, compilerContext, typeProvider);
        unit.accept(new MemberElementBuilder(typeProvider));
    }

    private class MemberElementBuilder
    extends ResolveVisitor {
        EnclosingElement currentHolder;
        private ResolutionContext context;
        private boolean isStatic;
        private boolean isFactory;

        MemberElementBuilder(CoreTypeProvider typeProvider) {
            super(typeProvider);
            this.context = MemberBuilder.this.topLevelContext;
            this.currentHolder = MemberBuilder.this.libraryElement;
        }

        @Override
        ResolutionContext getContext() {
            return this.context;
        }

        @Override
        boolean isStaticContext() {
            return this.isStatic;
        }

        @Override
        boolean isFactoryContext() {
            return this.isFactory;
        }

        @Override
        public Element visitClass(DartClass node) {
            assert (!ElementKind.of(this.currentHolder).equals((Object)ElementKind.CLASS)) : "nested class?";
            this.beginClassContext(node);
            this.visit(node.getMembers());
            this.endClassContext();
            return null;
        }

        @Override
        public Element visitFunctionTypeAlias(DartFunctionTypeAlias node) {
            this.isStatic = false;
            this.isFactory = false;
            assert (!ElementKind.of(this.currentHolder).equals((Object)ElementKind.CLASS)) : "nested class?";
            FunctionAliasElement element = node.getSymbol();
            this.currentHolder = element;
            this.context = this.context.extend((ClassElement)this.currentHolder);
            this.visit(node.getTypeParameters());
            ArrayList<VariableElement> parameters = new ArrayList<VariableElement>();
            for (DartParameter parameter : node.getParameters()) {
                parameters.add((VariableElement)parameter.accept(this));
            }
            Type returnType = this.resolveType(node.getReturnTypeNode(), false, false, TypeErrorCode.NO_SUCH_TYPE);
            ClassElement functionElement = this.getTypeProvider().getFunctionType().getElement();
            element.setFunctionType(Types.makeFunctionType(this.getContext(), functionElement, parameters, returnType));
            this.currentHolder = MemberBuilder.this.libraryElement;
            this.context = MemberBuilder.this.topLevelContext;
            return null;
        }

        @Override
        public Element visitMethodDefinition(DartMethodDefinition method) {
            this.isFactory = method.getModifiers().isFactory();
            this.isStatic = method.getModifiers().isStatic() || this.isFactory;
            MethodElement element = method.getSymbol();
            if (element == null) {
                switch (this.getMethodKind(method)) {
                    case NONE: 
                    case CONSTRUCTOR: {
                        element = this.buildConstructor(method);
                        this.checkConstructor(element, method);
                        this.addConstructor((ClassElement)this.currentHolder, (ConstructorElement)element);
                        break;
                    }
                    case METHOD: {
                        element = Elements.methodFromMethodNode(method, this.currentHolder);
                        this.addMethod(this.currentHolder, element);
                    }
                }
            } else {
                Elements.addMethod(this.currentHolder, element);
                this.assertTopLevel(method);
            }
            if (element != null) {
                this.checkModifiers(element, method);
                this.recordElement(method, element);
                ResolutionContext previous = this.context;
                this.context = this.context.extend(element.getName());
                this.resolveFunction(method.getFunction(), element);
                this.context = previous;
            }
            return null;
        }

        @Override
        public Element visitFieldDefinition(DartFieldDefinition node) {
            this.isStatic = false;
            this.isFactory = false;
            for (DartField fieldNode : node.getFields()) {
                if (!fieldNode.getModifiers().isStatic()) continue;
                this.isStatic = true;
            }
            Type type = this.resolveType(node.getTypeNode(), this.isStatic, false, TypeErrorCode.NO_SUCH_TYPE);
            for (DartField fieldNode : node.getFields()) {
                if (fieldNode.getModifiers().isAbstractField()) {
                    this.buildAbstractField(fieldNode);
                    continue;
                }
                this.buildField(fieldNode, type);
            }
            return null;
        }

        private void beginClassContext(DartClass node) {
            assert (!ElementKind.of(this.currentHolder).equals((Object)ElementKind.CLASS)) : "nested class?";
            this.currentHolder = node.getSymbol();
            this.context = this.context.extend((ClassElement)this.currentHolder);
        }

        private void endClassContext() {
            this.currentHolder = MemberBuilder.this.libraryElement;
            this.context = MemberBuilder.this.topLevelContext;
        }

        private Element resolveConstructorName(final DartMethodDefinition method) {
            return ((DartNode)method.getName()).accept(new DartNodeTraverser<Element>(){

                @Override
                public Element visitPropertyAccess(DartPropertyAccess node) {
                    Element element = node.getQualifier().accept(this);
                    if (ElementKind.of(element).equals((Object)ElementKind.CLASS)) {
                        return Elements.constructorFromMethodNode(method, node.getPropertyName(), (ClassElement)MemberElementBuilder.this.currentHolder, (ClassElement)element);
                    }
                    return MemberElementBuilder.this.getTypeProvider().getDynamicType().getElement();
                }

                @Override
                public Element visitIdentifier(DartIdentifier node) {
                    return MemberElementBuilder.this.context.resolveType(node, node, null, true, false, ResolverErrorCode.NO_SUCH_TYPE_CONSTRUCTOR).getElement();
                }

                @Override
                public Element visitParameterizedTypeNode(DartParameterizedTypeNode node) {
                    Element element = node.getExpression().accept(this);
                    if (ElementKind.of(element).equals((Object)ElementKind.CONSTRUCTOR)) {
                        MemberElementBuilder.this.recordElement(node.getExpression(), MemberElementBuilder.this.currentHolder);
                    } else {
                        MemberElementBuilder.this.recordElement(node.getExpression(), element);
                    }
                    return element;
                }

                @Override
                public Element visitNode(DartNode node) {
                    throw new RuntimeException("Unexpected node " + node);
                }
            });
        }

        private MethodElement buildConstructor(DartMethodDefinition method) {
            Element e = this.resolveConstructorName(method);
            switch (ElementKind.of(e)) {
                default: {
                    this.resolutionError((DartNode)method.getName(), ResolverErrorCode.INVALID_TYPE_NAME_IN_CONSTRUCTOR, new Object[0]);
                    break;
                }
                case DYNAMIC: 
                case CLASS: {
                    break;
                }
                case CONSTRUCTOR: {
                    return (ConstructorElement)e;
                }
            }
            return Elements.constructorFromMethodNode(method, "", (ClassElement)this.currentHolder, (ClassElement)e);
        }

        private FieldElement buildField(DartField fieldNode, Type type) {
            FieldElement fieldElement;
            assert (!fieldNode.getModifiers().isAbstractField());
            Modifiers modifiers = fieldNode.getModifiers();
            if (modifiers.isFinal() && (modifiers.isStatic() || this.context == MemberBuilder.this.topLevelContext)) {
                modifiers = modifiers.makeStatic();
                modifiers = modifiers.makeConstant();
            }
            if ((fieldElement = fieldNode.getSymbol()) == null) {
                fieldElement = Elements.fieldFromNode(fieldNode, this.currentHolder, modifiers);
                this.addField(this.currentHolder, fieldElement);
            } else {
                Elements.addField(this.currentHolder, fieldElement);
                this.assertTopLevel(fieldNode);
            }
            fieldElement.setType(type);
            return this.recordElement(fieldNode, fieldElement);
        }

        private void assertTopLevel(DartNode node) throws AssertionError {
            if (!this.currentHolder.getKind().equals((Object)ElementKind.LIBRARY)) {
                throw MemberBuilder.this.topLevelContext.internalError(node, "expected top-level node", new Object[0]);
            }
        }

        private FieldElement buildAbstractField(DartField fieldNode) {
            assert (fieldNode.getModifiers().isAbstractField());
            boolean topLevelDefinition = fieldNode.getParent().getParent() instanceof DartUnit;
            DartMethodDefinition accessorNode = fieldNode.getAccessor();
            MethodElement accessorElement = Elements.methodFromMethodNode(accessorNode, this.currentHolder);
            this.recordElement(accessorNode, accessorElement);
            this.resolveFunction(accessorNode.getFunction(), accessorElement);
            String name = ((DartIdentifier)fieldNode.getName()).getTargetName();
            Element element = null;
            element = this.currentHolder != null ? this.currentHolder.lookupLocalElement(name) : MemberBuilder.this.topLevelContext.getScope().findElement(this.context.getScope().getLibrary(), name);
            FieldElementImplementation fieldElement = null;
            if (element == null || element.getKind().equals((Object)ElementKind.FIELD) && element.getModifiers().isAbstractField()) {
                fieldElement = (FieldElementImplementation)element;
            }
            if (fieldElement == null) {
                fieldElement = Elements.fieldFromNode(fieldNode, this.currentHolder, fieldNode.getModifiers());
                this.addField(this.currentHolder, fieldElement);
            }
            if (accessorNode.getModifiers().isGetter()) {
                if (fieldElement.getGetter() != null) {
                    if (!topLevelDefinition) {
                        this.reportDuplicateDeclaration(ResolverErrorCode.DUPLICATE_MEMBER, fieldElement.getGetter());
                        this.reportDuplicateDeclaration(ResolverErrorCode.DUPLICATE_MEMBER, accessorElement);
                    }
                } else {
                    fieldElement.setGetter(accessorElement);
                    fieldElement.setType(accessorElement.getReturnType());
                }
            } else if (accessorNode.getModifiers().isSetter()) {
                if (fieldElement.getSetter() != null) {
                    if (!topLevelDefinition) {
                        this.reportDuplicateDeclaration(ResolverErrorCode.DUPLICATE_MEMBER, fieldElement.getSetter());
                        this.reportDuplicateDeclaration(ResolverErrorCode.DUPLICATE_MEMBER, accessorElement);
                    }
                } else {
                    Type type;
                    fieldElement.setSetter(accessorElement);
                    List<VariableElement> parameters = accessorElement.getParameters();
                    if (parameters.size() != 1) {
                        this.resolutionError(fieldNode, ResolverErrorCode.EXPECTED_ONE_ARGUMENT, new Object[0]);
                        type = this.getTypeProvider().getDynamicType();
                    } else {
                        type = parameters.get(0).getType();
                    }
                    fieldElement.setType(type);
                }
            }
            return this.recordElement(fieldNode, fieldElement);
        }

        private void addField(EnclosingElement holder, FieldElement element) {
            if (holder != null) {
                this.checkUniqueName(holder, element);
                Elements.addField(holder, element);
            }
        }

        private void addMethod(EnclosingElement holder, MethodElement element) {
            this.checkUniqueName(holder, element);
            Elements.addMethod(holder, element);
        }

        private void addConstructor(ClassElement cls, MethodElement element) {
            this.checkUniqueName(cls, element);
            Elements.addConstructor(cls, (ConstructorElement)element);
        }

        private ElementKind getMethodKind(DartMethodDefinition method) {
            if (!ElementKind.of(this.currentHolder).equals((Object)ElementKind.CLASS)) {
                return ElementKind.METHOD;
            }
            if (method.getModifiers().isFactory()) {
                return ElementKind.CONSTRUCTOR;
            }
            Object name = method.getName();
            if (name instanceof DartIdentifier) {
                if (((DartIdentifier)name).getTargetName().equals(this.currentHolder.getName())) {
                    return ElementKind.CONSTRUCTOR;
                }
                return ElementKind.METHOD;
            }
            DartPropertyAccess property = (DartPropertyAccess)name;
            if (property.getQualifier() instanceof DartIdentifier) {
                DartIdentifier qualifier = (DartIdentifier)property.getQualifier();
                if (qualifier.getTargetName().equals(this.currentHolder.getName())) {
                    return ElementKind.CONSTRUCTOR;
                }
                this.resolutionError((DartNode)method.getName(), ResolverErrorCode.CANNOT_DECLARE_NON_FACTORY_CONSTRUCTOR, new Object[0]);
            } else if (property.getQualifier() instanceof DartParameterizedTypeNode) {
                DartParameterizedTypeNode paramNode = (DartParameterizedTypeNode)property.getQualifier();
                if (paramNode.getExpression() instanceof DartIdentifier) {
                    return ElementKind.CONSTRUCTOR;
                }
                this.resolutionError((DartNode)method.getName(), ResolverErrorCode.TOO_MANY_QUALIFIERS_FOR_METHOD, new Object[0]);
            } else {
                this.resolutionError((DartNode)method.getName(), ResolverErrorCode.TOO_MANY_QUALIFIERS_FOR_METHOD, new Object[0]);
            }
            return ElementKind.NONE;
        }

        private void checkModifiers(MethodElement element, DartMethodDefinition method) {
            Modifiers modifiers = method.getModifiers();
            boolean isNonFactoryConstructor = Elements.isNonFactoryConstructor(element);
            if (isNonFactoryConstructor) {
                if (modifiers.isStatic()) {
                    this.resolutionError((DartNode)method.getName(), ResolverErrorCode.CONSTRUCTOR_CANNOT_BE_STATIC, new Object[0]);
                }
                if (modifiers.isAbstract()) {
                    this.resolutionError((DartNode)method.getName(), ResolverErrorCode.CONSTRUCTOR_CANNOT_BE_ABSTRACT, new Object[0]);
                }
                if (modifiers.isConstant() && method.getFunction().getBody() != null) {
                    this.resolutionError((DartNode)method.getName(), ResolverErrorCode.CONST_CONSTRUCTOR_CANNOT_HAVE_BODY, new Object[0]);
                }
            }
            if (modifiers.isFactory()) {
                if (modifiers.isStatic()) {
                    this.resolutionError((DartNode)method.getName(), ResolverErrorCode.FACTORY_CANNOT_BE_STATIC, new Object[0]);
                }
                if (modifiers.isAbstract()) {
                    this.resolutionError((DartNode)method.getName(), ResolverErrorCode.FACTORY_CANNOT_BE_ABSTRACT, new Object[0]);
                }
                if (modifiers.isConstant()) {
                    this.resolutionError((DartNode)method.getName(), ResolverErrorCode.FACTORY_CANNOT_BE_CONST, new Object[0]);
                }
            }
        }

        private void checkConstructor(MethodElement element, DartMethodDefinition method) {
            if (Elements.isNonFactoryConstructor(element) && method.getFunction() != null && method.getFunction().getReturnTypeNode() != null) {
                this.resolutionError(method, ResolverErrorCode.CONSTRUCTOR_CANNOT_HAVE_RETURN_TYPE, new Object[0]);
            }
        }

        private void checkUniqueName(EnclosingElement holder, Element e) {
            Element other = this.lookupElementByName(holder, e.getName(), e.getModifiers());
            assert (e != other) : "forgot to call checkUniqueName() before adding to the class?";
            if (other != null) {
                boolean eIsConstructor;
                ElementKind eKind = ElementKind.of(e);
                ElementKind oKind = ElementKind.of(other);
                boolean oIsConstructor = oKind.equals((Object)ElementKind.CONSTRUCTOR);
                if (oIsConstructor != (eIsConstructor = eKind.equals((Object)ElementKind.CONSTRUCTOR))) {
                    return;
                }
                if (oIsConstructor && eIsConstructor && ((ConstructorElement)e).getConstructorType() != ((ConstructorElement)other).getConstructorType()) {
                    return;
                }
                boolean eIsOperator = e.getModifiers().isOperator();
                boolean oIsOperator = other.getModifiers().isOperator();
                if (oIsOperator != eIsOperator) {
                    return;
                }
                boolean oIsMethod = oKind.equals((Object)ElementKind.METHOD);
                boolean eIsMethod = eKind.equals((Object)ElementKind.METHOD);
                if (oIsOperator && eIsMethod || oIsMethod && eIsOperator) {
                    return;
                }
                this.reportDuplicateDeclaration(ResolverErrorCode.DUPLICATE_MEMBER, other);
                this.reportDuplicateDeclaration(ResolverErrorCode.DUPLICATE_MEMBER, e);
            }
        }

        private Element lookupElementByName(EnclosingElement holder, String name, Modifiers modifiers) {
            Element element = holder.lookupLocalElement(name);
            if (element == null && ElementKind.of(holder).equals((Object)ElementKind.CLASS)) {
                ClassElement cls = (ClassElement)holder;
                String ctorName = name.equals(holder.getName()) ? "" : name;
                for (ConstructorElement e : cls.getConstructors()) {
                    if (!e.getName().equals(ctorName)) continue;
                    return e;
                }
            }
            return element;
        }

        void resolutionError(DartNode node, ErrorCode errorCode, Object ... arguments) {
            MemberBuilder.this.topLevelContext.onError(node, errorCode, arguments);
        }

        private void reportDuplicateDeclaration(ErrorCode errorCode, Element element) {
            DartNode node = element.getNode();
            if (node instanceof DartDeclaration) {
                Object nameNode = ((DartDeclaration)node).getName();
                this.resolutionError((DartNode)nameNode, errorCode, nameNode);
            }
        }
    }
}

