/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.resolver;

import com.google.dart.compiler.DartCompilationError;
import com.google.dart.compiler.DartCompilerListener;
import com.google.dart.compiler.parser.DartScanner;
import com.google.dart.compiler.resolver.ClassElement;
import com.google.dart.compiler.resolver.CoreTypeProvider;
import com.google.dart.compiler.resolver.ResolverErrorCode;
import com.google.dart.compiler.resolver.Scope;
import com.google.dart.compiler.type.DynamicType;
import com.google.dart.compiler.type.InterfaceType;
import com.google.dart.compiler.type.Type;
import com.google.dart.compiler.type.Types;
import java.util.Arrays;

public class CoreTypeProviderImplementation
implements CoreTypeProvider {
    private final InterfaceType intType;
    private final InterfaceType doubleType;
    private final InterfaceType numType;
    private final InterfaceType boolType;
    private final InterfaceType stringType;
    private final InterfaceType functionType;
    private final InterfaceType arrayType;
    private final DynamicType dynamicType;
    private final Type voidType;
    private final Type nullType;
    private final InterfaceType fallThroughError;
    private final InterfaceType mapType;
    private final InterfaceType mapLiteralType;
    private final InterfaceType objectArrayType;
    private final InterfaceType objectType;
    private final InterfaceType isolateType;
    private final InterfaceType stringImplementation;
    private final InterfaceType iteratorType;

    public CoreTypeProviderImplementation(Scope scope, DartCompilerListener listener) {
        this.intType = CoreTypeProviderImplementation.getType("int", scope, listener);
        this.doubleType = CoreTypeProviderImplementation.getType("double", scope, listener);
        this.boolType = CoreTypeProviderImplementation.getType("bool", scope, listener);
        this.numType = CoreTypeProviderImplementation.getType("num", scope, listener);
        this.stringType = CoreTypeProviderImplementation.getType("String", scope, listener);
        this.functionType = CoreTypeProviderImplementation.getType("Function", scope, listener);
        this.arrayType = CoreTypeProviderImplementation.getType("List", scope, listener);
        this.dynamicType = Types.newDynamicType();
        this.voidType = Types.newVoidType();
        this.nullType = this.dynamicType;
        this.fallThroughError = CoreTypeProviderImplementation.getType("FallThroughError", scope, listener);
        this.mapType = CoreTypeProviderImplementation.getType("Map", scope, listener);
        this.mapLiteralType = CoreTypeProviderImplementation.getType("LinkedHashMapImplementation", scope, listener);
        this.objectArrayType = CoreTypeProviderImplementation.getType(new String[]{"ListImplementation", "GrowableObjectArray"}, scope, listener);
        this.objectType = CoreTypeProviderImplementation.getType("Object", scope, listener);
        this.isolateType = CoreTypeProviderImplementation.getType("Isolate", scope, listener);
        this.stringImplementation = CoreTypeProviderImplementation.getType(new String[]{"StringImplementation", "OneByteString"}, scope, listener);
        this.iteratorType = CoreTypeProviderImplementation.getType("Iterator", scope, listener);
    }

    private static InterfaceType getType(String name, Scope scope, DartCompilerListener listener) {
        ClassElement element = (ClassElement)scope.findElement(scope.getLibrary(), name);
        if (element == null) {
            DartCompilationError error = new DartCompilationError(null, DartScanner.Location.NONE, ResolverErrorCode.CANNOT_BE_RESOLVED, name);
            listener.onError(error);
            return Types.newDynamicType();
        }
        return element.getType();
    }

    private static InterfaceType getType(String[] names, Scope scope, DartCompilerListener listener) {
        ClassElement element = null;
        for (String name : names) {
            element = (ClassElement)scope.findElement(scope.getLibrary(), name);
            if (element != null) break;
        }
        if (element == null) {
            DartCompilationError error = new DartCompilationError(null, DartScanner.Location.NONE, ResolverErrorCode.CANNOT_BE_RESOLVED, names[0]);
            listener.onError(error);
            return Types.newDynamicType();
        }
        return element.getType();
    }

    @Override
    public InterfaceType getIntType() {
        return this.intType;
    }

    @Override
    public InterfaceType getDoubleType() {
        return this.doubleType;
    }

    @Override
    public InterfaceType getBoolType() {
        return this.boolType;
    }

    @Override
    public InterfaceType getStringType() {
        return this.stringType;
    }

    @Override
    public InterfaceType getFunctionType() {
        return this.functionType;
    }

    @Override
    public InterfaceType getArrayType(Type elementType) {
        return this.arrayType.subst(Arrays.asList(elementType), this.arrayType.getElement().getTypeParameters());
    }

    @Override
    public InterfaceType getArrayLiteralType(Type elementType) {
        return this.objectArrayType.subst(Arrays.asList(elementType), this.objectArrayType.getElement().getTypeParameters());
    }

    @Override
    public DynamicType getDynamicType() {
        return this.dynamicType;
    }

    @Override
    public Type getVoidType() {
        return this.voidType;
    }

    @Override
    public Type getNullType() {
        return this.nullType;
    }

    @Override
    public InterfaceType getFallThroughError() {
        return this.fallThroughError;
    }

    @Override
    public InterfaceType getMapType(Type key, Type value) {
        return this.mapType.subst(Arrays.asList(key, value), this.mapType.getElement().getTypeParameters());
    }

    @Override
    public InterfaceType getMapLiteralType(Type key, Type value) {
        return this.mapLiteralType.subst(Arrays.asList(key, value), this.mapLiteralType.getElement().getTypeParameters());
    }

    @Override
    public InterfaceType getObjectArrayType() {
        return this.objectArrayType;
    }

    @Override
    public InterfaceType getObjectType() {
        return this.objectType;
    }

    @Override
    public InterfaceType getNumType() {
        return this.numType;
    }

    @Override
    public InterfaceType getStringImplementationType() {
        return this.stringImplementation;
    }

    @Override
    public InterfaceType getIsolateType() {
        return this.isolateType;
    }

    @Override
    public InterfaceType getIteratorType(Type elementType) {
        return this.iteratorType.subst(Arrays.asList(elementType), this.iteratorType.getElement().getTypeParameters());
    }
}

