/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.resolver;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.dart.compiler.DartCompilationError;
import com.google.dart.compiler.DartCompilationPhase;
import com.google.dart.compiler.DartCompilerContext;
import com.google.dart.compiler.ErrorCode;
import com.google.dart.compiler.InternalCompilerException;
import com.google.dart.compiler.ast.DartArrayLiteral;
import com.google.dart.compiler.ast.DartBinaryExpression;
import com.google.dart.compiler.ast.DartBooleanLiteral;
import com.google.dart.compiler.ast.DartDoubleLiteral;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartField;
import com.google.dart.compiler.ast.DartFunction;
import com.google.dart.compiler.ast.DartFunctionObjectInvocation;
import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartIntegerLiteral;
import com.google.dart.compiler.ast.DartInvocation;
import com.google.dart.compiler.ast.DartMapLiteral;
import com.google.dart.compiler.ast.DartMapLiteralEntry;
import com.google.dart.compiler.ast.DartMethodDefinition;
import com.google.dart.compiler.ast.DartMethodInvocation;
import com.google.dart.compiler.ast.DartNewExpression;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartNodeTraverser;
import com.google.dart.compiler.ast.DartParameter;
import com.google.dart.compiler.ast.DartParenthesizedExpression;
import com.google.dart.compiler.ast.DartPropertyAccess;
import com.google.dart.compiler.ast.DartRedirectConstructorInvocation;
import com.google.dart.compiler.ast.DartStringInterpolation;
import com.google.dart.compiler.ast.DartStringLiteral;
import com.google.dart.compiler.ast.DartSuperConstructorInvocation;
import com.google.dart.compiler.ast.DartSuperExpression;
import com.google.dart.compiler.ast.DartThisExpression;
import com.google.dart.compiler.ast.DartUnaryExpression;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.ast.DartUnqualifiedInvocation;
import com.google.dart.compiler.ast.DartVariable;
import com.google.dart.compiler.ast.DartVariableStatement;
import com.google.dart.compiler.ast.Modifiers;
import com.google.dart.compiler.common.Symbol;
import com.google.dart.compiler.resolver.ConstructorElement;
import com.google.dart.compiler.resolver.CoreTypeProvider;
import com.google.dart.compiler.resolver.Element;
import com.google.dart.compiler.resolver.ElementKind;
import com.google.dart.compiler.resolver.ResolverErrorCode;
import com.google.dart.compiler.type.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompileTimeConstantAnalyzer {
    public Set<Symbol> visitedSymbols = Sets.newHashSet();
    public Map<DartNode, Type> inferredTypes = Maps.newHashMap();
    private final DartCompilerContext context;
    private final Type boolType;
    private final Type doubleType;
    private final Type intType;
    private final Type numType;
    private final Type stringType;
    private final Type dynamicType;

    public CompileTimeConstantAnalyzer(CoreTypeProvider typeProvider, DartCompilerContext context) {
        this.context = context;
        this.boolType = typeProvider.getBoolType();
        this.doubleType = typeProvider.getDoubleType();
        this.intType = typeProvider.getIntType();
        this.numType = typeProvider.getNumType();
        this.stringType = typeProvider.getStringType();
        this.dynamicType = typeProvider.getDynamicType();
    }

    private void checkConstantExpression(DartExpression expression) {
        if (expression != null) {
            expression.accept(new ExpressionVisitor());
        }
    }

    public void exec(DartUnit unit) {
        unit.accept(new FindCompileTimeConstantExpressionsVisitor());
    }

    public static class Phase
    implements DartCompilationPhase {
        @Override
        public DartUnit exec(DartUnit unit, DartCompilerContext context, CoreTypeProvider typeProvider) {
            new CompileTimeConstantAnalyzer(typeProvider, context).exec(unit);
            return unit;
        }
    }

    private class FindCompileTimeConstantExpressionsVisitor
    extends DartNodeTraverser<Void> {
        private FindCompileTimeConstantExpressionsVisitor() {
        }

        @Override
        public Void visitField(DartField node) {
            CompileTimeConstantAnalyzer.this.checkConstantExpression(node.getValue());
            return null;
        }

        @Override
        public Void visitMethodDefinition(DartMethodDefinition node) {
            DartFunction functionNode = node.getFunction();
            List<DartParameter> parameters = functionNode.getParams();
            for (DartParameter parameter : parameters) {
                CompileTimeConstantAnalyzer.this.checkConstantExpression(parameter.getDefaultExpr());
            }
            return null;
        }

        @Override
        public Void visitNewExpression(DartNewExpression node) {
            if (node.isConst()) {
                for (DartExpression arg : node.getArgs()) {
                    CompileTimeConstantAnalyzer.this.checkConstantExpression(arg);
                }
            }
            return null;
        }

        @Override
        public Void visitParameter(DartParameter node) {
            CompileTimeConstantAnalyzer.this.checkConstantExpression(node.getDefaultExpr());
            return null;
        }

        @Override
        public Void visitVariableStatement(DartVariableStatement node) {
            for (DartVariable variable : node.getVariables()) {
                Modifiers modifiers = node.getModifiers();
                if (!modifiers.isStatic() || !modifiers.isFinal() || variable.getValue() == null) continue;
                CompileTimeConstantAnalyzer.this.checkConstantExpression(variable.getValue());
            }
            return null;
        }

        @Override
        public Void visitRedirectConstructorInvocation(DartRedirectConstructorInvocation node) {
            return null;
        }

        @Override
        public Void visitSuperConstructorInvocation(DartSuperConstructorInvocation node) {
            return null;
        }
    }

    private class ExpressionVisitor
    extends DartNodeTraverser<Void> {
        private ExpressionVisitor() {
        }

        private boolean checkBoolean(DartNode x, Type type) {
            if (!type.equals(CompileTimeConstantAnalyzer.this.boolType)) {
                CompileTimeConstantAnalyzer.this.context.onError(new DartCompilationError(x, (ErrorCode)ResolverErrorCode.EXPECTED_CONSTANT_EXPRESSION_BOOLEAN, type.toString()));
                return false;
            }
            return true;
        }

        private boolean checkInt(DartNode x, Type type) {
            if (!type.equals(CompileTimeConstantAnalyzer.this.intType)) {
                CompileTimeConstantAnalyzer.this.context.onError(new DartCompilationError(x, (ErrorCode)ResolverErrorCode.EXPECTED_CONSTANT_EXPRESSION_INT, type.toString()));
                return false;
            }
            return true;
        }

        private boolean checkNumber(DartNode x, Type type) {
            if (!(type.equals(CompileTimeConstantAnalyzer.this.numType) || type.equals(CompileTimeConstantAnalyzer.this.intType) || type.equals(CompileTimeConstantAnalyzer.this.doubleType))) {
                CompileTimeConstantAnalyzer.this.context.onError(new DartCompilationError(x, (ErrorCode)ResolverErrorCode.EXPECTED_CONSTANT_EXPRESSION_NUMBER, type.toString()));
                return false;
            }
            return true;
        }

        private boolean checkNumberBooleanOrStringType(DartNode x, Type type) {
            if (!(type.equals(CompileTimeConstantAnalyzer.this.intType) || type.equals(CompileTimeConstantAnalyzer.this.boolType) || type.equals(CompileTimeConstantAnalyzer.this.numType) || type.equals(CompileTimeConstantAnalyzer.this.doubleType) || type.equals(CompileTimeConstantAnalyzer.this.stringType))) {
                CompileTimeConstantAnalyzer.this.context.onError(new DartCompilationError(x, (ErrorCode)ResolverErrorCode.EXPECTED_CONSTANT_EXPRESSION_STRING_NUMBER_BOOL, type.toString()));
                return false;
            }
            return true;
        }

        private void expectedConstant(DartNode x) {
            CompileTimeConstantAnalyzer.this.context.onError(new DartCompilationError(x, (ErrorCode)ResolverErrorCode.EXPECTED_CONSTANT_EXPRESSION, new Object[0]));
        }

        private Type getMostSpecificType(DartNode node) {
            if (node != null) {
                Element element = (Element)node.getSymbol();
                Type type = CompileTimeConstantAnalyzer.this.inferredTypes.get(node);
                if (type != null) {
                    return type;
                }
                if (element != null && (type = element.getType()) != null) {
                    return type;
                }
            }
            return CompileTimeConstantAnalyzer.this.dynamicType;
        }

        private void rememberInferredType(DartNode x, Type type) {
            if (type != null && !type.equals(CompileTimeConstantAnalyzer.this.dynamicType)) {
                CompileTimeConstantAnalyzer.this.inferredTypes.put(x, type);
            }
        }

        @Override
        public Void visitArrayLiteral(DartArrayLiteral x) {
            if (!x.isConst()) {
                this.expectedConstant(x);
            } else {
                for (DartExpression expr : x.getExpressions()) {
                    expr.accept(this);
                }
            }
            return null;
        }

        @Override
        public Void visitBinaryExpression(DartBinaryExpression x) {
            x.visitChildren(this);
            DartExpression lhs = x.getArg1();
            DartExpression rhs = x.getArg2();
            Type lhsType = this.getMostSpecificType(lhs);
            Type rhsType = this.getMostSpecificType(rhs);
            if (lhsType == null) {
                lhsType = CompileTimeConstantAnalyzer.this.dynamicType;
            }
            if (rhsType == null) {
                rhsType = CompileTimeConstantAnalyzer.this.dynamicType;
            }
            switch (x.getOperator()) {
                case NE: 
                case EQ: 
                case NE_STRICT: 
                case EQ_STRICT: {
                    if (!this.checkNumberBooleanOrStringType(lhs, lhsType) || !this.checkNumberBooleanOrStringType(rhs, rhsType)) break;
                    this.rememberInferredType(x, CompileTimeConstantAnalyzer.this.boolType);
                    break;
                }
                case AND: 
                case OR: {
                    if (!this.checkBoolean(lhs, lhsType) || !this.checkBoolean(rhs, rhsType)) break;
                    this.rememberInferredType(x, CompileTimeConstantAnalyzer.this.boolType);
                    break;
                }
                case BIT_NOT: 
                case TRUNC: 
                case BIT_XOR: 
                case BIT_AND: 
                case BIT_OR: 
                case SAR: 
                case SHL: {
                    if (!this.checkInt(lhs, lhsType) || !this.checkInt(rhs, rhsType)) break;
                    this.rememberInferredType(x, CompileTimeConstantAnalyzer.this.intType);
                    break;
                }
                case ADD: 
                case SUB: 
                case MUL: 
                case DIV: 
                case MOD: {
                    if (!this.checkNumber(lhs, lhsType) || !this.checkNumber(rhs, rhsType)) break;
                    this.rememberInferredType(x, CompileTimeConstantAnalyzer.this.numType);
                    break;
                }
                case LT: 
                case GT: 
                case LTE: 
                case GTE: {
                    if (!this.checkNumber(lhs, lhsType) || !this.checkNumber(rhs, rhsType)) break;
                    this.rememberInferredType(x, CompileTimeConstantAnalyzer.this.boolType);
                    break;
                }
                default: {
                    this.expectedConstant(x);
                }
            }
            return null;
        }

        @Override
        public Void visitBooleanLiteral(DartBooleanLiteral x) {
            this.rememberInferredType(x, CompileTimeConstantAnalyzer.this.boolType);
            return null;
        }

        @Override
        public Void visitDoubleLiteral(DartDoubleLiteral x) {
            this.rememberInferredType(x, CompileTimeConstantAnalyzer.this.doubleType);
            return null;
        }

        @Override
        public Void visitField(DartField x) {
            x.visitChildren(this);
            if (x.getType() == null || x.getType().equals(CompileTimeConstantAnalyzer.this.dynamicType)) {
                Type type = this.getMostSpecificType(x.getValue());
                this.rememberInferredType(x, type);
            }
            return null;
        }

        @Override
        public Void visitFunction(DartFunction x) {
            this.expectedConstant(x);
            return null;
        }

        @Override
        public Void visitFunctionObjectInvocation(DartFunctionObjectInvocation x) {
            this.expectedConstant(x);
            return null;
        }

        @Override
        public Void visitIdentifier(DartIdentifier x) {
            x.visitChildren(this);
            Element element = x.getSymbol();
            switch (ElementKind.of(element)) {
                case CLASS: 
                case PARAMETER: 
                case LIBRARY: {
                    break;
                }
                case FIELD: 
                case VARIABLE: {
                    if (element != null && CompileTimeConstantAnalyzer.this.visitedSymbols.contains(element)) {
                        CompileTimeConstantAnalyzer.this.context.onError(new DartCompilationError(x, (ErrorCode)ResolverErrorCode.CIRCULAR_REFERENCE, new Object[0]));
                        this.rememberInferredType(x, this.getMostSpecificType(x));
                        return null;
                    }
                    CompileTimeConstantAnalyzer.this.visitedSymbols.add(element);
                    if (!element.getModifiers().isConstant()) {
                        this.expectedConstant(x);
                    }
                    DartNode identifierNode = element.getNode();
                    this.visit(Lists.newArrayList((Object[])new DartNode[]{identifierNode}));
                    CompileTimeConstantAnalyzer.this.visitedSymbols.remove(element);
                    switch (ElementKind.of(element)) {
                        case FIELD: {
                            this.rememberInferredType(x, this.getMostSpecificType(identifierNode));
                        }
                    }
                    break;
                }
                case CONSTRUCTOR: {
                    if (!element.getModifiers().isConstant()) {
                        this.expectedConstant(x);
                    }
                    this.rememberInferredType(x, this.getMostSpecificType(x));
                    break;
                }
                case NONE: {
                    Type type = this.getMostSpecificType(x);
                    if (CompileTimeConstantAnalyzer.this.dynamicType.equals(type)) {
                        this.expectedConstant(x);
                    }
                    this.rememberInferredType(x, type);
                    break;
                }
                case METHOD: {
                    this.expectedConstant(x);
                    return null;
                }
                default: {
                    throw new InternalCompilerException("Unexpected element " + x.toString() + " kind: " + (Object)((Object)ElementKind.of(element)) + " evaluating type for compile-time constant expression.");
                }
            }
            return null;
        }

        @Override
        public Void visitIntegerLiteral(DartIntegerLiteral x) {
            this.rememberInferredType(x, CompileTimeConstantAnalyzer.this.intType);
            return null;
        }

        @Override
        public Void visitInvocation(DartInvocation x) {
            this.expectedConstant(x);
            return null;
        }

        @Override
        public Void visitMapLiteral(DartMapLiteral x) {
            if (!x.isConst()) {
                this.expectedConstant(x);
            } else {
                for (DartMapLiteralEntry entry : x.getEntries()) {
                    entry.accept(this);
                }
            }
            return null;
        }

        @Override
        public Void visitMethodInvocation(DartMethodInvocation x) {
            this.expectedConstant(x);
            return null;
        }

        @Override
        public Void visitNewExpression(DartNewExpression x) {
            if (!x.isConst()) {
                this.expectedConstant(x);
            } else {
                for (DartExpression arg : x.getArgs()) {
                    arg.accept(this);
                }
            }
            this.rememberInferredType(x, x.getConstructor().getType());
            return null;
        }

        @Override
        public Void visitParenthesizedExpression(DartParenthesizedExpression x) {
            x.visitChildren(this);
            Type type = this.getMostSpecificType(x.getExpression());
            this.rememberInferredType(x, type);
            return null;
        }

        @Override
        public Void visitPropertyAccess(DartPropertyAccess x) {
            x.visitChildren(this);
            switch (ElementKind.of(x.getQualifier().getSymbol())) {
                case CLASS: 
                case LIBRARY: 
                case NONE: {
                    break;
                }
                default: {
                    this.expectedConstant(x);
                    return null;
                }
            }
            Element element = x.getName().getSymbol();
            if (element != null && !element.getModifiers().isConstant()) {
                this.expectedConstant(x);
            }
            Type type = this.getMostSpecificType(x.getName());
            this.rememberInferredType(x, type);
            return null;
        }

        @Override
        public Void visitRedirectConstructorInvocation(DartRedirectConstructorInvocation x) {
            ConstructorElement element = x.getSymbol();
            if (element != null && !element.getModifiers().isConstant()) {
                this.expectedConstant(x);
            }
            x.visitChildren(this);
            return null;
        }

        @Override
        public Void visitStringInterpolation(DartStringInterpolation x) {
            this.expectedConstant(x);
            return null;
        }

        @Override
        public Void visitStringLiteral(DartStringLiteral x) {
            this.rememberInferredType(x, CompileTimeConstantAnalyzer.this.stringType);
            return null;
        }

        @Override
        public Void visitSuperExpression(DartSuperExpression x) {
            if (!x.getSymbol().getModifiers().isConstant()) {
                this.expectedConstant(x);
            }
            return null;
        }

        @Override
        public Void visitThisExpression(DartThisExpression x) {
            this.expectedConstant(x);
            return null;
        }

        @Override
        public Void visitUnaryExpression(DartUnaryExpression x) {
            x.visitChildren(this);
            Type type = this.getMostSpecificType(x.getArg());
            switch (x.getOperator()) {
                case NOT: {
                    if (!this.checkBoolean(x, type)) break;
                    this.rememberInferredType(x, CompileTimeConstantAnalyzer.this.boolType);
                    break;
                }
                case SUB: {
                    if (!this.checkNumber(x, type)) break;
                    this.rememberInferredType(x, CompileTimeConstantAnalyzer.this.numType);
                    break;
                }
                case BIT_NOT: {
                    if (!this.checkInt(x, type)) break;
                    this.rememberInferredType(x, CompileTimeConstantAnalyzer.this.intType);
                    break;
                }
                default: {
                    this.expectedConstant(x);
                }
            }
            return null;
        }

        @Override
        public Void visitSuperConstructorInvocation(DartSuperConstructorInvocation x) {
            x.visitChildren(this);
            return null;
        }

        @Override
        public Void visitUnqualifiedInvocation(DartUnqualifiedInvocation x) {
            this.expectedConstant(x);
            return null;
        }
    }
}

