/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.parser;

import com.google.dart.compiler.DartCompilationError;
import com.google.dart.compiler.DartCompilerListener;
import com.google.dart.compiler.DartSource;
import com.google.dart.compiler.Source;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.common.HasSourceInfo;
import com.google.dart.compiler.metrics.CompilerMetrics;
import com.google.dart.compiler.parser.DartScanner;
import com.google.dart.compiler.parser.ParserContext;
import com.google.dart.compiler.parser.Token;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Stack;

public class DartScannerParserContext
implements ParserContext {
    private DartScanner scanner;
    private Deque<DartScanner.State> stateStack = new ArrayDeque<DartScanner.State>();
    private Deque<DartScanner.Position> positionStack = new ArrayDeque<DartScanner.Position>();
    private Source source;
    private DartCompilerListener listener;
    private final CompilerMetrics compilerMetrics;

    public DartScannerParserContext(Source source, String sourceCode, DartCompilerListener listener) {
        this(source, sourceCode, listener, null);
    }

    public DartScannerParserContext(Source source, String sourceCode, DartCompilerListener listener, CompilerMetrics compilerMetrics) {
        this.source = source;
        this.scanner = this.createScanner(sourceCode);
        this.listener = listener;
        this.compilerMetrics = compilerMetrics;
    }

    @Override
    public void begin() {
        this.stateStack.push(this.scanner.getState());
        this.positionStack.push(this.getBeginLocation(0));
    }

    private DartScanner.Position getBeginLocation(int n) {
        DartScanner.Location tokenLocation = this.scanner.peekTokenLocation(n);
        return tokenLocation != null ? tokenLocation.getBegin() : new DartScanner.Position(0, 1, 1);
    }

    private DartScanner.Position getEndLocation() {
        DartScanner.Location tokenLocation = this.scanner.getTokenLocation();
        return tokenLocation != null ? tokenLocation.getEnd() : new DartScanner.Position(0, 1, 1);
    }

    @Override
    public <T> T done(T result) {
        DartScanner.State oldState = this.stateStack.pop();
        DartScanner.State newState = this.stateStack.peek();
        if (newState != null && oldState.rollbackTokens != null) {
            if (newState.rollbackTokens != null) {
                oldState.rollbackTokens.addAll(newState.rollbackTokens);
            }
            newState.rollbackTokens = oldState.rollbackTokens;
        }
        this.setSourcePosition(result, this.positionStack.pop());
        if (result instanceof DartUnit && this.compilerMetrics != null) {
            this.compilerMetrics.unitParsed(this.scanner.getCharCount(), this.scanner.getNonCommentCharCount(), this.scanner.getLineCount(), this.scanner.getNonCommentLineCount());
        }
        return result;
    }

    private <T> void setSourcePosition(T result, DartScanner.Position startPos) {
        if (result instanceof HasSourceInfo) {
            HasSourceInfo node = (HasSourceInfo)result;
            int start = startPos.getPos();
            int end = this.getEndLocation().getPos();
            if (start != -1 && end < start) {
                end = start;
            }
            node.setSourceLocation(this.source, startPos.getLine(), startPos.getCol(), start, end - start);
        }
    }

    @Override
    public <T> T doneWithoutConsuming(T result) {
        this.setSourcePosition(result, this.positionStack.peek());
        return result;
    }

    @Override
    public void error(DartCompilationError dartError) {
        this.listener.onError(dartError);
    }

    @Override
    public void unitAboutToCompile(DartSource source, boolean diet) {
        this.listener.unitAboutToCompile(source, diet);
    }

    @Override
    public void advance() {
        this.scanner.next();
    }

    @Override
    public Token getCurrentToken() {
        return this.scanner.getToken();
    }

    @Override
    public Token peek(int steps) {
        return this.scanner.peek(steps);
    }

    @Override
    public void rollback() {
        DartScanner.State oldState = this.stateStack.pop();
        this.scanner.restoreState(oldState);
        if (oldState.rollbackTokens != null) {
            while (!oldState.rollbackTokens.isEmpty()) {
                DartScanner.State.RollbackToken token = oldState.rollbackTokens.pop();
                this.scanner.setAbsolutePeek(token.absoluteOffset, token.replacedToken);
            }
        }
        this.positionStack.pop();
    }

    @Override
    public String getTokenString() {
        return this.scanner.getTokenValue();
    }

    @Override
    public String peekTokenString(int steps) {
        return this.scanner.peekTokenValue(steps);
    }

    @Override
    public void replaceNextToken(Token token) {
        DartScanner.State state = this.stateStack.peek();
        DartScanner.State.RollbackToken oldToken = new DartScanner.State.RollbackToken(this.scanner.getOffset() + 1, this.scanner.peek(0));
        if (state.rollbackTokens == null) {
            state.rollbackTokens = new Stack();
        }
        state.rollbackTokens.push(oldToken);
        this.scanner.setPeek(0, token);
    }

    @Override
    public DartScanner.Location getTokenLocation() {
        return this.scanner.getTokenLocation();
    }

    protected DartScanner createScanner(String sourceCode) {
        return new DartScanner(sourceCode);
    }

    @Override
    public Source getSource() {
        return this.source;
    }
}

