/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.parser;

import com.google.dart.compiler.metrics.DartEventType;
import com.google.dart.compiler.metrics.Tracer;
import com.google.dart.compiler.parser.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class DartScanner {
    private static final int NUM_LOOKAHEAD = 2;
    private int commentLineCount;
    private int commentCharCount;
    private int lastCommentStart;
    private int lastCommentStop;
    private String source;
    private InternalState internalState;

    private static boolean isDecimalDigit(int c) {
        return c >= 48 && c <= 57;
    }

    private static boolean isHexDigit(int c) {
        return DartScanner.isDecimalDigit(c) || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    private static boolean isIdentifierPart(int c) {
        return DartScanner.isIdentifierStart(c) || DartScanner.isDecimalDigit(c);
    }

    private static boolean isIdentifierStart(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 95 || c == 36;
    }

    private static boolean isLineTerminator(int c) {
        return c == 13 || c == 10;
    }

    private static boolean isWhiteSpace(int c) {
        return c == 32 || c == 9;
    }

    public DartScanner(String source) {
        this(source, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DartScanner(String source, int start) {
        Tracer.TraceEvent logEvent = Tracer.canTrace() ? Tracer.start(DartEventType.SCANNER, new String[0]) : null;
        try {
            int i;
            this.source = source;
            this.internalState = new InternalState();
            this.internalState.tokens = new ArrayList(source.length() / 2);
            this.internalState.nextLookaheadPos = new Position(start, 1, 1);
            for (i = 0; i < this.internalState.lookaheadPos.length; ++i) {
                ((InternalState)this.internalState).lookaheadPos[i] = new Position(start, 1, 1);
            }
            for (i = 0; i < 2; ++i) {
                this.advance();
            }
            this.scanFile();
        }
        finally {
            Tracer.end(logEvent, new String[0]);
        }
    }

    public int getNonCommentLineCount() {
        return this.getLineCount() - this.commentLineCount;
    }

    public int getLineCount() {
        int lineCount = this.internalState.nextLookaheadPos.line;
        if (this.isEos()) {
            --lineCount;
        }
        return lineCount;
    }

    public int getCharCount() {
        return this.internalState.nextLookaheadPos.pos;
    }

    public int getNonCommentCharCount() {
        return this.getCharCount() - this.commentCharCount;
    }

    public String getPeekTokenValue(int n) {
        assert (0 <= n && this.internalState.currentOffset + n + 1 < this.internalState.tokens.size());
        return ((TokenData)((InternalState)this.internalState).tokens.get((int)(this.internalState.currentOffset + n + 1))).value;
    }

    public State getState() {
        return new State(this.internalState.currentOffset);
    }

    public int getOffset() {
        return this.internalState.currentOffset;
    }

    public Token getToken() {
        return ((TokenData)((InternalState)this.internalState).tokens.get((int)this.internalState.currentOffset)).token;
    }

    public Location getTokenLocation() {
        return ((TokenData)((InternalState)this.internalState).tokens.get((int)this.internalState.currentOffset)).location;
    }

    public Location peekTokenLocation(int n) {
        if (this.internalState.currentOffset + n + 1 < this.internalState.tokens.size()) {
            return ((TokenData)((InternalState)this.internalState).tokens.get((int)(this.internalState.currentOffset + n + 1))).location;
        }
        return ((TokenData)((InternalState)this.internalState).tokens.get((int)(((InternalState)this.internalState).tokens.size() - 1))).location;
    }

    public String getTokenValue() {
        return ((TokenData)((InternalState)this.internalState).tokens.get((int)this.internalState.currentOffset)).value;
    }

    public String peekTokenValue(int n) {
        if (this.internalState.currentOffset + n + 1 < this.internalState.tokens.size()) {
            return ((TokenData)((InternalState)this.internalState).tokens.get((int)(this.internalState.currentOffset + n + 1))).value;
        }
        return null;
    }

    public Token next() {
        if (this.internalState.currentOffset + 1 < this.internalState.tokens.size()) {
            ++this.internalState.currentOffset;
        }
        return this.getToken();
    }

    public Token peek(int n) {
        if (this.internalState.currentOffset + n + 1 < this.internalState.tokens.size()) {
            return ((TokenData)((InternalState)this.internalState).tokens.get((int)(this.internalState.currentOffset + n + 1))).token;
        }
        return Token.EOS;
    }

    public void restoreState(State oldState) {
        this.internalState.currentOffset = oldState.baseOffset;
    }

    public void setPeek(int n, Token token) {
        assert (0 <= n && this.internalState.currentOffset + n + 1 < this.internalState.tokens.size());
        ((TokenData)((InternalState)this.internalState).tokens.get((int)(this.internalState.currentOffset + n + 1))).token = token;
    }

    public void setAbsolutePeek(int n, Token token) {
        assert (0 <= n && n < this.internalState.tokens.size());
        ((TokenData)((InternalState)this.internalState).tokens.get((int)n)).token = token;
    }

    public String toString() {
        if (this.internalState == null) {
            return super.toString();
        }
        return this.internalState.toString();
    }

    protected void recordCommentLocation(int start, int stop, int line, int col) {
    }

    private void advance() {
        for (int i = 0; i < 1; ++i) {
            ((InternalState)this.internalState).lookahead[i] = this.internalState.lookahead[i + 1];
            ((InternalState)this.internalState).lookaheadPos[i] = this.internalState.lookaheadPos[i + 1].clone();
        }
        if (this.internalState.nextLookaheadPos.pos < this.source.length()) {
            int ch;
            ((InternalState)this.internalState).lookahead[1] = ch = this.source.codePointAt(this.internalState.nextLookaheadPos.pos);
            ((InternalState)this.internalState).lookaheadPos[1] = this.internalState.nextLookaheadPos.clone();
            this.internalState.nextLookaheadPos.advance(ch == 10);
        } else {
            ((InternalState)this.internalState).lookahead[1] = -1;
            ((InternalState)this.internalState).lookaheadPos[1] = new Position(this.source.length(), this.internalState.nextLookaheadPos.line, this.internalState.nextLookaheadPos.col);
            this.internalState.nextLookaheadPos = new Position(this.source.length(), this.internalState.nextLookaheadPos.line + 1, 1);
        }
    }

    private void commentLocation(int start, int stop, int startLine, int endLine, int col) {
        if (start <= this.lastCommentStart && stop <= this.lastCommentStop) {
            return;
        }
        this.lastCommentStart = start;
        this.lastCommentStop = stop;
        this.commentLineCount += endLine - startLine + 1;
        this.commentCharCount += stop - start + 1;
        this.recordCommentLocation(start, stop, startLine, col);
    }

    private boolean is(int c) {
        return this.internalState.lookahead[0] == c;
    }

    private boolean isEos() {
        return this.internalState.lookahead[0] < 0;
    }

    private int lookahead(int n) {
        assert (0 <= n && n < 2);
        return this.internalState.lookahead[n];
    }

    private Position position() {
        return this.internalState.lookaheadPos[0];
    }

    private void scanFile() {
        Token token;
        this.internalState.lastToken = new TokenData();
        this.internalState.tokens.add(this.internalState.lastToken);
        do {
            Position begin;
            this.internalState.lastToken = new TokenData();
            do {
                this.skipWhiteSpace();
                begin = this.position();
            } while ((token = this.scanToken()) == Token.COMMENT);
            Position end = this.position();
            ((InternalState)this.internalState).lastToken.token = token;
            ((InternalState)this.internalState).lastToken.location = new Location(begin, end);
            this.internalState.tokens.add(this.internalState.lastToken);
        } while (token != Token.EOS);
    }

    private Token scanIdentifier(boolean allowDollars) {
        String result;
        int nextChar;
        assert (DartScanner.isIdentifierStart(this.lookahead(0)));
        Position begin = this.position();
        while (DartScanner.isIdentifierPart(nextChar = this.lookahead(0)) && (allowDollars || nextChar != 36)) {
            this.advance();
        }
        int size = this.position().pos - begin.pos;
        ((InternalState)this.internalState).lastToken.value = result = this.source.substring(begin.pos, begin.pos + size);
        return Token.lookup(result);
    }

    private Token scanNumber() {
        boolean isDouble = false;
        assert (DartScanner.isDecimalDigit(this.lookahead(0)) || this.is(46));
        Position begin = this.position();
        while (DartScanner.isDecimalDigit(this.lookahead(0))) {
            this.advance();
        }
        if (this.is(46) && DartScanner.isDecimalDigit(this.lookahead(1))) {
            isDouble = true;
            this.advance();
            while (DartScanner.isDecimalDigit(this.lookahead(0))) {
                this.advance();
            }
        }
        if (this.isE()) {
            isDouble = true;
            this.advance();
            if (this.is(43) || this.is(45)) {
                this.advance();
            }
            if (!DartScanner.isDecimalDigit(this.lookahead(0))) {
                return Token.ILLEGAL;
            }
            while (DartScanner.isDecimalDigit(this.lookahead(0))) {
                this.advance();
            }
        } else if (DartScanner.isIdentifierStart(this.lookahead(0))) {
            return Token.ILLEGAL;
        }
        int size = this.position().pos - begin.pos;
        ((InternalState)this.internalState).lastToken.value = this.source.substring(begin.pos, begin.pos + size);
        return isDouble ? Token.DOUBLE_LITERAL : Token.INTEGER_LITERAL;
    }

    private boolean isE() {
        return this.is(101) || this.is(69);
    }

    private Token scanHexNumber() {
        assert (DartScanner.isDecimalDigit(this.lookahead(0)) && (this.lookahead(1) == 120 || this.lookahead(1) == 88));
        this.advance();
        this.advance();
        Position begin = this.position();
        if (!DartScanner.isHexDigit(this.lookahead(0))) {
            return Token.ILLEGAL;
        }
        this.advance();
        while (DartScanner.isHexDigit(this.lookahead(0))) {
            this.advance();
        }
        if (DartScanner.isIdentifierStart(this.lookahead(0))) {
            return Token.ILLEGAL;
        }
        ((InternalState)this.internalState).lastToken.value = this.source.substring(begin.pos, this.position().pos);
        return Token.HEX_LITERAL;
    }

    private Token scanString(boolean isRaw) {
        int quote = this.lookahead(0);
        assert (this.is(39) || this.is(34));
        boolean multiLine = false;
        this.advance();
        if (this.lookahead(0) == quote && this.lookahead(1) == quote) {
            multiLine = true;
            this.advance();
            this.advance();
            if (this.is(10)) {
                this.advance();
            }
        }
        this.internalState.pushMode(InternalState.Mode.IN_STRING, quote, multiLine);
        if (isRaw) {
            return this.scanRawString();
        }
        return this.scanWithinString(true);
    }

    private Token scanRawString() {
        assert (this.internalState.getMode() == InternalState.Mode.IN_STRING);
        int quote = this.internalState.getQuote();
        boolean multiLine = this.internalState.isMultiLine();
        StringBuffer tokenValueBuffer = new StringBuffer();
        while (true) {
            if (this.isEos()) {
                this.internalState.popMode();
                return Token.ILLEGAL;
            }
            int c = this.lookahead(0);
            this.advance();
            if (c == quote) {
                if (!multiLine) break;
                if (this.lookahead(0) == quote && this.lookahead(1) == quote) {
                    this.advance();
                    this.advance();
                    break;
                }
            }
            tokenValueBuffer.appendCodePoint(c);
        }
        ((InternalState)this.internalState).lastToken.value = tokenValueBuffer.toString();
        this.internalState.popMode();
        return Token.STRING;
    }

    private Token scanWithinString(boolean start) {
        assert (this.internalState.getMode() == InternalState.Mode.IN_STRING);
        int quote = this.internalState.getQuote();
        boolean multiLine = this.internalState.isMultiLine();
        StringBuffer tokenValueBuffer = new StringBuffer();
        while (true) {
            if (this.isEos()) {
                this.internalState.resetModes();
                return Token.EOS;
            }
            int c = this.lookahead(0);
            if (c == quote) {
                this.advance();
                if (!multiLine) break;
                if (this.lookahead(0) == quote && this.lookahead(1) == quote) {
                    this.advance();
                    this.advance();
                    break;
                }
            } else {
                if (c == 10 && !multiLine) {
                    this.advance();
                    this.internalState.popMode();
                    return Token.ILLEGAL;
                }
                if (c == 92) {
                    this.advance();
                    if (this.isEos()) {
                        this.internalState.resetModes();
                        return Token.EOS;
                    }
                    c = this.lookahead(0);
                    this.advance();
                    switch (c) {
                        case 98: {
                            c = 8;
                            break;
                        }
                        case 102: {
                            c = 12;
                            break;
                        }
                        case 110: {
                            c = 10;
                            break;
                        }
                        case 114: {
                            c = 13;
                            break;
                        }
                        case 116: {
                            c = 9;
                            break;
                        }
                        case 118: {
                            c = 11;
                            break;
                        }
                        case 117: 
                        case 120: {
                            int len;
                            int n = len = c == 117 ? 4 : 2;
                            if (this.isEos()) {
                                this.internalState.resetModes();
                                return Token.EOS;
                            }
                            c = this.lookahead(0);
                            int unicodeCodePoint = 0;
                            if (c == 123) {
                                len = -1;
                                this.advance();
                                if (this.isEos()) {
                                    this.internalState.resetModes();
                                    return Token.EOS;
                                }
                                c = this.lookahead(0);
                            }
                            while (len != 0) {
                                this.advance();
                                int digit = Character.getNumericValue(c);
                                if (digit < 0 || digit > 15) {
                                    return Token.ILLEGAL;
                                }
                                unicodeCodePoint = unicodeCodePoint * 16 + digit;
                                c = this.lookahead(0);
                                if (len-- < 0 && c == 125) {
                                    this.advance();
                                    break;
                                }
                                if (this.isEos()) {
                                    this.internalState.resetModes();
                                    return Token.EOS;
                                }
                                if (len >= -6) continue;
                                return Token.ILLEGAL;
                            }
                            if (Character.isValidCodePoint(c = unicodeCodePoint) && (c >= 65536 || !Character.isHighSurrogate((char)c) && !Character.isLowSurrogate((char)c))) break;
                            return Token.ILLEGAL;
                        }
                    }
                } else {
                    if (c == 36) {
                        if (tokenValueBuffer.length() == 0) {
                            this.advance();
                            int nextChar = this.lookahead(0);
                            if (nextChar == 123) {
                                this.advance();
                                this.internalState.pushMode(InternalState.Mode.IN_STRING_EMBEDDED_EXPRESSION, quote, multiLine);
                            } else {
                                this.internalState.pushMode(InternalState.Mode.IN_STRING_EMBEDDED_EXPRESSION_IDENTIFIER, quote, multiLine);
                            }
                            return Token.STRING_EMBED_EXP_START;
                        }
                        ((InternalState)this.internalState).lastToken.value = tokenValueBuffer.toString();
                        return Token.STRING_SEGMENT;
                    }
                    this.advance();
                }
            }
            tokenValueBuffer.appendCodePoint(c);
        }
        ((InternalState)this.internalState).lastToken.value = tokenValueBuffer.toString();
        this.internalState.popMode();
        if (start) {
            return Token.STRING;
        }
        return Token.STRING_LAST_SEGMENT;
    }

    private Token scanToken() {
        switch (this.internalState.getMode()) {
            case IN_STRING: {
                return this.scanWithinString(false);
            }
            case IN_STRING_EMBEDDED_EXPRESSION_IDENTIFIER: {
                this.internalState.replaceMode(InternalState.Mode.IN_STRING_EMBEDDED_EXPRESSION_END);
                int c = this.lookahead(0);
                if (DartScanner.isIdentifierStart(c) && c != 36) {
                    boolean allowDollars = false;
                    return this.scanIdentifier(allowDollars);
                }
                this.internalState.popMode();
                if (!this.isEos()) {
                    ((InternalState)this.internalState).lastToken.value = String.valueOf(c);
                }
                return Token.ILLEGAL;
            }
            case IN_STRING_EMBEDDED_EXPRESSION_END: {
                this.internalState.popMode();
                return Token.STRING_EMBED_EXP_END;
            }
        }
        switch (this.lookahead(0)) {
            case 34: 
            case 39: {
                boolean isRaw = false;
                return this.scanString(isRaw);
            }
            case 60: {
                this.advance();
                if (this.is(61)) {
                    return this.select(Token.LTE);
                }
                if (this.is(60)) {
                    return this.select(61, Token.ASSIGN_SHL, Token.SHL);
                }
                return Token.LT;
            }
            case 62: {
                this.advance();
                if (this.is(61)) {
                    return this.select(Token.GTE);
                }
                if (this.is(62)) {
                    this.advance();
                    if (this.is(61)) {
                        return this.select(Token.ASSIGN_SAR);
                    }
                    if (this.is(62)) {
                        return this.select(61, Token.ASSIGN_SHR, Token.SHR);
                    }
                    return Token.SAR;
                }
                return Token.GT;
            }
            case 61: {
                this.advance();
                if (this.is(62)) {
                    return this.select(Token.ARROW);
                }
                if (this.is(61)) {
                    return this.select(61, Token.EQ_STRICT, Token.EQ);
                }
                return Token.ASSIGN;
            }
            case 33: {
                this.advance();
                if (this.is(61)) {
                    return this.select(61, Token.NE_STRICT, Token.NE);
                }
                return Token.NOT;
            }
            case 43: {
                this.advance();
                if (this.is(43)) {
                    return this.select(Token.INC);
                }
                if (this.is(61)) {
                    return this.select(Token.ASSIGN_ADD);
                }
                return Token.ADD;
            }
            case 45: {
                this.advance();
                if (this.is(45)) {
                    return this.select(Token.DEC);
                }
                if (this.is(61)) {
                    return this.select(Token.ASSIGN_SUB);
                }
                return Token.SUB;
            }
            case 42: {
                return this.select(61, Token.ASSIGN_MUL, Token.MUL);
            }
            case 37: {
                return this.select(61, Token.ASSIGN_MOD, Token.MOD);
            }
            case 47: {
                this.advance();
                if (this.is(47)) {
                    return this.skipSingleLineComment();
                }
                if (this.is(42)) {
                    return this.skipMultiLineComment();
                }
                if (this.is(61)) {
                    return this.select(Token.ASSIGN_DIV);
                }
                return Token.DIV;
            }
            case 38: {
                this.advance();
                if (this.is(38)) {
                    return this.select(Token.AND);
                }
                if (this.is(61)) {
                    return this.select(Token.ASSIGN_BIT_AND);
                }
                return Token.BIT_AND;
            }
            case 124: {
                this.advance();
                if (this.is(124)) {
                    return this.select(Token.OR);
                }
                if (this.is(61)) {
                    return this.select(Token.ASSIGN_BIT_OR);
                }
                return Token.BIT_OR;
            }
            case 94: {
                return this.select(61, Token.ASSIGN_BIT_XOR, Token.BIT_XOR);
            }
            case 46: {
                if (DartScanner.isDecimalDigit(this.lookahead(1))) {
                    return this.scanNumber();
                }
                this.advance();
                if (this.lookahead(0) == 46 && this.lookahead(1) == 46) {
                    this.advance();
                    this.advance();
                    return Token.ELLIPSIS;
                }
                return Token.PERIOD;
            }
            case 58: {
                return this.select(Token.COLON);
            }
            case 59: {
                return this.select(Token.SEMICOLON);
            }
            case 44: {
                return this.select(Token.COMMA);
            }
            case 40: {
                return this.select(Token.LPAREN);
            }
            case 41: {
                return this.select(Token.RPAREN);
            }
            case 91: {
                this.advance();
                if (this.is(93)) {
                    return this.select(61, Token.ASSIGN_INDEX, Token.INDEX);
                }
                return Token.LBRACK;
            }
            case 93: {
                return this.select(Token.RBRACK);
            }
            case 123: {
                this.internalState.openBrace();
                return this.select(Token.LBRACE);
            }
            case 125: {
                if (this.internalState.closeBrace()) {
                    this.internalState.popMode();
                    return this.select(Token.STRING_EMBED_EXP_END);
                }
                return this.select(Token.RBRACE);
            }
            case 63: {
                return this.select(Token.CONDITIONAL);
            }
            case 126: {
                this.advance();
                if (this.is(47)) {
                    if (this.lookahead(1) == 61) {
                        this.advance();
                        return this.select(Token.ASSIGN_TRUNC);
                    }
                    return this.select(Token.TRUNC);
                }
                return Token.BIT_NOT;
            }
            case 64: {
                this.advance();
                if (this.is(39) || this.is(34)) {
                    boolean isRaw = true;
                    return this.scanString(isRaw);
                }
                return this.select(Token.ILLEGAL);
            }
            case 35: {
                return this.scanDirective();
            }
        }
        if (DartScanner.isIdentifierStart(this.lookahead(0))) {
            boolean allowDollars = true;
            return this.scanIdentifier(allowDollars);
        }
        if (DartScanner.isDecimalDigit(this.lookahead(0))) {
            if (this.lookahead(0) == 48 && (this.lookahead(1) == 120 || this.lookahead(1) == 88)) {
                return this.scanHexNumber();
            }
            return this.scanNumber();
        }
        if (this.isEos()) {
            return Token.EOS;
        }
        return this.select(Token.ILLEGAL);
    }

    private Token scanDirective() {
        int ch;
        assert (this.is(35));
        Position currPos = this.position();
        int start = currPos.pos;
        int line = currPos.line;
        int col = currPos.col;
        if (start == 0 && this.lookahead(1) == 33) {
            while (!this.isEos() && !DartScanner.isLineTerminator(this.lookahead(0))) {
                this.advance();
            }
            int stop = this.internalState.lookaheadPos[0].pos;
            this.commentLocation(start, stop, line, this.internalState.lookaheadPos[0].line, col);
            return Token.COMMENT;
        }
        if (start > 0 && !DartScanner.isLineTerminator(this.source.codePointBefore(start))) {
            return this.select(Token.ILLEGAL);
        }
        this.advance();
        while ((ch = this.lookahead(0)) >= 97 && ch <= 122) {
            this.advance();
        }
        String syntax = this.source.substring(start, this.position().pos);
        Token token = Token.lookup(syntax);
        return token == Token.IDENTIFIER ? Token.ILLEGAL : token;
    }

    private Token select(int next, Token yes, Token no) {
        this.advance();
        if (this.lookahead(0) != next) {
            return no;
        }
        this.advance();
        return yes;
    }

    private Token select(Token token) {
        this.advance();
        return token;
    }

    private Token skipMultiLineComment() {
        assert (this.is(42));
        Position currPos = this.internalState.lookaheadPos[0];
        int start = currPos.pos - 1;
        int line = currPos.line;
        int col = currPos.col;
        int commentDepth = 1;
        this.advance();
        while (!this.isEos()) {
            int first = this.lookahead(0);
            this.advance();
            if (first == 42 && this.is(47)) {
                if (--commentDepth == 0) {
                    Token result = this.select(Token.COMMENT);
                    int stop = this.internalState.lookaheadPos[0].pos;
                    this.commentLocation(start, stop, line, this.internalState.lookaheadPos[0].line, col);
                    return result;
                }
                this.advance();
                continue;
            }
            if (first != 47 || !this.is(42)) continue;
            ++commentDepth;
            this.advance();
        }
        int stop = this.internalState.lookaheadPos[0].pos;
        this.commentLocation(start, stop, line, this.internalState.lookaheadPos[0].line, col);
        return Token.ILLEGAL;
    }

    private Token skipSingleLineComment() {
        assert (this.is(47));
        Position currPos = this.internalState.lookaheadPos[0];
        int start = currPos.pos - 1;
        int line = currPos.line;
        int col = currPos.col;
        this.advance();
        while (!this.isEos() && !DartScanner.isLineTerminator(this.lookahead(0))) {
            this.advance();
        }
        int stop = this.internalState.lookaheadPos[0].pos;
        this.commentLocation(start, stop, line, this.internalState.lookaheadPos[0].line, col);
        return Token.COMMENT;
    }

    private void skipWhiteSpace() {
        if (this.internalState.getMode() != InternalState.Mode.DEFAULT && this.internalState.getMode() != InternalState.Mode.IN_STRING_EMBEDDED_EXPRESSION) {
            return;
        }
        while (DartScanner.isLineTerminator(this.lookahead(0)) || DartScanner.isWhiteSpace(this.lookahead(0))) {
            this.advance();
        }
    }

    private static class TokenData
    implements Cloneable {
        Token token;
        Location location;
        String value;

        private TokenData() {
        }

        protected TokenData clone() {
            try {
                TokenData clone = (TokenData)super.clone();
                clone.location = this.location == null ? null : this.location.clone();
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        public String toString() {
            String str = this.token.toString();
            return this.value != null ? str + "(" + this.value + ")" : str;
        }
    }

    protected static class InternalState {
        private int[] lookahead = new int[2];
        private Position[] lookaheadPos = new Position[2];
        private Position nextLookaheadPos;
        private ArrayList<TokenData> tokens;
        private TokenData lastToken;
        int currentOffset = 0;
        private List<StringState> stringStateStack = new ArrayList<StringState>();

        public String toString() {
            StringBuilder ret = new StringBuilder();
            ret.append("currentOffset(");
            ret.append(this.currentOffset);
            ret.append(")");
            if (this.currentOffset > -1) {
                TokenData tok = this.tokens.get(this.currentOffset);
                ret.append(" = [");
                ret.append((Object)tok.token);
                if (tok.value != null) {
                    ret.append(" (" + tok.value + ")");
                }
                ret.append("], ");
            }
            ret.append("[");
            for (int i = 0; i < this.tokens.size(); ++i) {
                TokenData tok = this.tokens.get(i);
                ret.append((Object)tok.token);
                if (tok.value != null) {
                    ret.append(" (" + tok.value + ")");
                }
                if (i >= this.tokens.size() - 1) continue;
                ret.append(", ");
            }
            ret.append("]");
            if (this.getMode() != Mode.DEFAULT) {
                ret.append("(within string starting with ");
                ret.appendCodePoint(this.getQuote());
                if (this.isMultiLine()) {
                    ret.appendCodePoint(this.getQuote());
                    ret.appendCodePoint(this.getQuote());
                }
                ret.append(')');
            }
            return ret.toString();
        }

        protected Mode getMode() {
            return this.stringStateStack.isEmpty() ? Mode.DEFAULT : this.getCurrentState().getMode();
        }

        protected void openBrace() {
            if (!this.stringStateStack.isEmpty()) {
                this.getCurrentState().openBrace();
            }
        }

        protected boolean closeBrace() {
            if (!this.stringStateStack.isEmpty()) {
                return this.getCurrentState().closeBrace();
            }
            return false;
        }

        protected void popMode() {
            if (!this.stringStateStack.isEmpty()) {
                this.stringStateStack.remove(this.stringStateStack.size() - 1);
            }
        }

        protected void pushMode(Mode mode, int quote, boolean multiLine) {
            this.stringStateStack.add(new StringState(mode, quote, multiLine));
        }

        protected void replaceMode(Mode mode) {
            this.getCurrentState().setMode(mode);
        }

        public void resetModes() {
            this.stringStateStack.clear();
        }

        private int getQuote() {
            return this.getCurrentState().getQuote();
        }

        private StringState getCurrentState() {
            assert (!this.stringStateStack.isEmpty()) : "called with empty state stack";
            return this.stringStateStack.get(this.stringStateStack.size() - 1);
        }

        private boolean isMultiLine() {
            return this.getCurrentState().isMultiLine();
        }

        public static class StringState {
            private int bracesCount;
            private Mode mode;
            private final boolean multiLine;
            private final int quote;

            public StringState(Mode mode, int quote, boolean multiLine) {
                this.bracesCount = mode == Mode.IN_STRING_EMBEDDED_EXPRESSION ? 1 : 0;
                this.mode = mode;
                this.quote = quote;
                this.multiLine = multiLine;
            }

            public void openBrace() {
                if (this.mode == Mode.IN_STRING_EMBEDDED_EXPRESSION) {
                    ++this.bracesCount;
                }
            }

            public boolean closeBrace() {
                if (this.mode == Mode.IN_STRING_EMBEDDED_EXPRESSION) {
                    return --this.bracesCount == 0;
                }
                return false;
            }

            public Mode getMode() {
                return this.mode;
            }

            public int getQuote() {
                return this.quote;
            }

            public boolean isMultiLine() {
                return this.multiLine;
            }

            public void setMode(Mode mode) {
                this.mode = mode;
            }

            public String toString() {
                StringBuilder buf = new StringBuilder();
                buf.append((Object)this.mode).append("/quote=").appendCodePoint(this.quote);
                if (this.multiLine) {
                    buf.append("/multiline");
                }
                return buf.toString();
            }
        }

        static enum Mode {
            DEFAULT,
            IN_STRING,
            IN_STRING_EMBEDDED_EXPRESSION,
            IN_STRING_EMBEDDED_EXPRESSION_IDENTIFIER,
            IN_STRING_EMBEDDED_EXPRESSION_END;

        }
    }

    public static class State {
        Stack<RollbackToken> rollbackTokens = null;
        final int baseOffset;

        State(int baseOffset) {
            this.baseOffset = baseOffset;
        }

        public String toString() {
            return "ofs=" + this.baseOffset;
        }

        static class RollbackToken {
            public final int absoluteOffset;
            final Token replacedToken;

            public RollbackToken(int tokenOffset, Token token) {
                this.absoluteOffset = tokenOffset;
                this.replacedToken = token;
            }
        }
    }

    public static class Location
    implements Cloneable {
        public static final Location NONE = null;
        private Position begin;
        private Position end;

        public Location(Position begin, Position end) {
            this.begin = begin;
            this.end = end;
        }

        public Location(Position begin) {
            this.begin = this.end = begin;
        }

        public Location clone() {
            try {
                Location clone = (Location)super.clone();
                clone.begin = this.begin.clone();
                clone.end = this.end.clone();
                return clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        public Position getBegin() {
            return this.begin;
        }

        public Position getEnd() {
            return this.end;
        }

        public String toString() {
            return this.begin.toString() + "::" + this.end.toString();
        }
    }

    public static class Position
    implements Cloneable {
        private int pos;
        private int line;
        private int col;

        public Position(int pos, int line, int col) {
            this.pos = pos;
            this.line = line;
            this.col = col;
        }

        public Position clone() {
            try {
                return (Position)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError((Object)e);
            }
        }

        public int getPos() {
            return this.pos;
        }

        public int getLine() {
            return this.line;
        }

        public int getCol() {
            return this.col;
        }

        public void advance(boolean isNewline) {
            ++this.pos;
            if (isNewline) {
                this.col = 1;
                ++this.line;
            } else {
                ++this.col;
            }
        }

        public Position getAdvancedColumns(int cols) {
            return new Position(this.pos + cols, this.line, this.col + cols);
        }

        public String toString() {
            return this.line + "," + this.col + "@" + this.pos;
        }
    }
}

