/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.parser;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.CharStreams;
import com.google.dart.compiler.DartCompilationError;
import com.google.dart.compiler.DartCompilerListener;
import com.google.dart.compiler.DartSource;
import com.google.dart.compiler.ErrorCode;
import com.google.dart.compiler.InternalCompilerException;
import com.google.dart.compiler.LibrarySource;
import com.google.dart.compiler.Source;
import com.google.dart.compiler.ast.DartArrayAccess;
import com.google.dart.compiler.ast.DartArrayLiteral;
import com.google.dart.compiler.ast.DartAssertion;
import com.google.dart.compiler.ast.DartBinaryExpression;
import com.google.dart.compiler.ast.DartBlock;
import com.google.dart.compiler.ast.DartBooleanLiteral;
import com.google.dart.compiler.ast.DartBreakStatement;
import com.google.dart.compiler.ast.DartCase;
import com.google.dart.compiler.ast.DartCatchBlock;
import com.google.dart.compiler.ast.DartClass;
import com.google.dart.compiler.ast.DartConditional;
import com.google.dart.compiler.ast.DartContinueStatement;
import com.google.dart.compiler.ast.DartDeclaration;
import com.google.dart.compiler.ast.DartDefault;
import com.google.dart.compiler.ast.DartDoWhileStatement;
import com.google.dart.compiler.ast.DartDoubleLiteral;
import com.google.dart.compiler.ast.DartEmptyStatement;
import com.google.dart.compiler.ast.DartExprStmt;
import com.google.dart.compiler.ast.DartExpression;
import com.google.dart.compiler.ast.DartField;
import com.google.dart.compiler.ast.DartFieldDefinition;
import com.google.dart.compiler.ast.DartForInStatement;
import com.google.dart.compiler.ast.DartForStatement;
import com.google.dart.compiler.ast.DartFunction;
import com.google.dart.compiler.ast.DartFunctionExpression;
import com.google.dart.compiler.ast.DartFunctionObjectInvocation;
import com.google.dart.compiler.ast.DartFunctionTypeAlias;
import com.google.dart.compiler.ast.DartIdentifier;
import com.google.dart.compiler.ast.DartIfStatement;
import com.google.dart.compiler.ast.DartImportDirective;
import com.google.dart.compiler.ast.DartInitializer;
import com.google.dart.compiler.ast.DartIntegerLiteral;
import com.google.dart.compiler.ast.DartLabel;
import com.google.dart.compiler.ast.DartLibraryDirective;
import com.google.dart.compiler.ast.DartMapLiteral;
import com.google.dart.compiler.ast.DartMapLiteralEntry;
import com.google.dart.compiler.ast.DartMethodDefinition;
import com.google.dart.compiler.ast.DartMethodInvocation;
import com.google.dart.compiler.ast.DartNamedExpression;
import com.google.dart.compiler.ast.DartNativeBlock;
import com.google.dart.compiler.ast.DartNativeDirective;
import com.google.dart.compiler.ast.DartNewExpression;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartNullLiteral;
import com.google.dart.compiler.ast.DartParameter;
import com.google.dart.compiler.ast.DartParameterizedTypeNode;
import com.google.dart.compiler.ast.DartParenthesizedExpression;
import com.google.dart.compiler.ast.DartPropertyAccess;
import com.google.dart.compiler.ast.DartRedirectConstructorInvocation;
import com.google.dart.compiler.ast.DartResourceDirective;
import com.google.dart.compiler.ast.DartReturnStatement;
import com.google.dart.compiler.ast.DartSourceDirective;
import com.google.dart.compiler.ast.DartStatement;
import com.google.dart.compiler.ast.DartStringInterpolation;
import com.google.dart.compiler.ast.DartStringLiteral;
import com.google.dart.compiler.ast.DartSuperConstructorInvocation;
import com.google.dart.compiler.ast.DartSuperExpression;
import com.google.dart.compiler.ast.DartSwitchMember;
import com.google.dart.compiler.ast.DartSwitchStatement;
import com.google.dart.compiler.ast.DartSyntheticErrorExpression;
import com.google.dart.compiler.ast.DartSyntheticErrorStatement;
import com.google.dart.compiler.ast.DartThisExpression;
import com.google.dart.compiler.ast.DartThrowStatement;
import com.google.dart.compiler.ast.DartTryStatement;
import com.google.dart.compiler.ast.DartTypeExpression;
import com.google.dart.compiler.ast.DartTypeNode;
import com.google.dart.compiler.ast.DartTypeParameter;
import com.google.dart.compiler.ast.DartUnaryExpression;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.ast.DartUnqualifiedInvocation;
import com.google.dart.compiler.ast.DartVariable;
import com.google.dart.compiler.ast.DartVariableStatement;
import com.google.dart.compiler.ast.DartWhileStatement;
import com.google.dart.compiler.ast.LibraryNode;
import com.google.dart.compiler.ast.LibraryUnit;
import com.google.dart.compiler.ast.Modifiers;
import com.google.dart.compiler.common.SourceInfo;
import com.google.dart.compiler.parser.CompletionHooksParserBase;
import com.google.dart.compiler.parser.DartScanner;
import com.google.dart.compiler.parser.DartScannerParserContext;
import com.google.dart.compiler.parser.ParserContext;
import com.google.dart.compiler.parser.ParserErrorCode;
import com.google.dart.compiler.parser.ParserException;
import com.google.dart.compiler.parser.Token;
import com.google.dart.compiler.util.Lists;
import java.io.IOException;
import java.io.Reader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DartParser
extends CompletionHooksParserBase {
    private Set<Integer> errorHistory = new HashSet<Integer>();
    private Set<String> prefixes;
    private boolean isDietParse;
    private boolean isParsingInterface;
    private boolean isTopLevelAbstract;
    private DartScanner.Position topLevelAbstractModifierPosition;
    private boolean isParsingClass;
    final int MAX_DEFAULT_ERRORS = 100;
    private static final String ABSTRACT_KEYWORD = "abstract";
    private static final String ASSERT_KEYWORD = "assert";
    private static final String EXTENDS_KEYWORD = "extends";
    private static final String FACTORY_KEYWORD = "factory";
    private static final String GETTER_KEYWORD = "get";
    private static final String IMPLEMENTS_KEYWORD = "implements";
    private static final String INTERFACE_KEYWORD = "interface";
    private static final String NATIVE_KEYWORD = "native";
    private static final String NEGATE_KEYWORD = "negate";
    private static final String OPERATOR_KEYWORD = "operator";
    private static final String PREFIX_KEYWORD = "prefix";
    private static final String SETTER_KEYWORD = "set";
    private static final String STATIC_KEYWORD = "static";
    private static final String TYPEDEF_KEYWORD = "typedef";
    public static final String[] PSEUDO_KEYWORDS = new String[]{"abstract", "assert", "extends", "factory", "get", "implements", "interface", "negate", "native", "operator", "prefix", "set", "static", "typedef"};
    private boolean allowFunctionExpression = true;

    public DartParser(Source source, String sourceCode, DartCompilerListener listener) {
        this(new DartScannerParserContext(source, sourceCode, listener));
    }

    public DartParser(ParserContext ctx) {
        this(ctx, false);
    }

    public DartParser(ParserContext ctx, Set<String> prefixes) {
        this(ctx, false, prefixes);
    }

    public DartParser(ParserContext ctx, boolean isDietParse) {
        this(ctx, isDietParse, Collections.emptySet());
    }

    public DartParser(ParserContext ctx, boolean isDietParse, Set<String> prefixes) {
        super(ctx);
        this.isDietParse = isDietParse;
        this.prefixes = prefixes;
    }

    private DartParser(Source source, DartCompilerListener listener) throws IOException {
        this(source, source.getSourceReader(), listener);
    }

    private DartParser(Source source, Reader sourceReader, DartCompilerListener listener) throws IOException {
        this(new DartScannerParserContext(source, DartParser.read(sourceReader), listener));
    }

    public static DartParser getSourceParser(Source source, DartCompilerListener listener) throws IOException {
        return new DartParser(source, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String read(Reader reader) throws IOException {
        try {
            String string = CharStreams.toString((Readable)reader);
            return string;
        }
        finally {
            reader.close();
        }
    }

    private boolean setAllowFunctionExpression(boolean allow) {
        boolean old = this.allowFunctionExpression;
        this.allowFunctionExpression = allow;
        return old;
    }

    public DartUnit parseUnit(DartSource source) {
        this.beginCompilationUnit();
        this.ctx.unitAboutToCompile(source, this.isDietParse);
        DartUnit unit = new DartUnit(source);
        this.parseDirectives(unit);
        while (!this.EOS()) {
            try {
                DartNode node = null;
                this.beginTopLevelElement();
                this.isParsingInterface = false;
                this.isParsingClass = false;
                this.isTopLevelAbstract = false;
                this.topLevelAbstractModifierPosition = null;
                if (this.optionalPseudoKeyword(ABSTRACT_KEYWORD)) {
                    this.isTopLevelAbstract = true;
                    this.topLevelAbstractModifierPosition = this.position();
                }
                if (this.optional(Token.CLASS)) {
                    this.isParsingClass = true;
                    node = this.done(this.parseClass());
                } else if (this.optionalPseudoKeyword(INTERFACE_KEYWORD)) {
                    this.isParsingInterface = true;
                    node = this.done(this.parseClass());
                } else {
                    node = this.optionalPseudoKeyword(TYPEDEF_KEYWORD) ? (DartNode)this.done(this.parseFunctionTypeAlias()) : this.done(this.parseFieldOrMethod(false));
                }
                if (node == null) continue;
                unit.addTopLevelNode(node);
                if (!this.isTopLevelAbstract || this.isParsingClass) continue;
                DartScanner.Position abstractPositionEnd = this.topLevelAbstractModifierPosition.getAdvancedColumns(ABSTRACT_KEYWORD.length());
                DartScanner.Location location = new DartScanner.Location(this.topLevelAbstractModifierPosition, abstractPositionEnd);
                this.reportError(new DartCompilationError((Source)source, location, ParserErrorCode.ABSTRACT_TOP_LEVEL_ELEMENT, new Object[0]));
            }
            catch (ParserException e) {
                DartScanner.Location beginLocation = this.ctx.getTokenLocation();
                while (this.peek(0) != Token.EOS && !this.peekTopLevelKeyword(0)) {
                    this.next();
                }
                DartScanner.Location endLocation = this.ctx.getTokenLocation();
                this.reportError(new DartCompilationError(this.ctx.getSource(), new DartScanner.Location(beginLocation.getBegin(), endLocation.getEnd()), ParserErrorCode.SKIPPED_SOURCE, new Object[0]));
            }
        }
        this.expect(Token.EOS);
        return this.done(unit);
    }

    private boolean peekTopLevelKeyword(int n) {
        return this.peek(n) == Token.CLASS || this.peekPseudoKeyword(n, INTERFACE_KEYWORD) || this.peekPseudoKeyword(n, TYPEDEF_KEYWORD);
    }

    public LibraryUnit preProcessLibraryDirectives(LibrarySource source) {
        this.beginCompilationUnit();
        LibraryUnit libUnit = new LibraryUnit(source);
        if (this.peek(0) == Token.LIBRARY) {
            this.beginLibraryDirective();
            DartLibraryDirective libDirective = this.done(this.parseLibraryDirective());
            libUnit.setName(libDirective.getName().getValue());
        }
        while (this.peek(0) == Token.IMPORT) {
            this.beginImportDirective();
            DartImportDirective importDirective = this.done(this.parseImportDirective());
            LibraryNode importPath = importDirective.getPrefix() != null ? new LibraryNode(importDirective.getLibraryUri().getValue(), importDirective.getPrefix().getValue()) : new LibraryNode(importDirective.getLibraryUri().getValue());
            importPath.setSourceInfo(importDirective.getSourceInfo());
            libUnit.addImportPath(importPath);
        }
        while (this.peek(0) == Token.SOURCE) {
            this.beginSourceDirective();
            DartSourceDirective sourceDirective = this.done(this.parseSourceDirective());
            LibraryNode sourcePath = new LibraryNode(sourceDirective.getSourceUri().getValue());
            sourcePath.setSourceInfo(sourceDirective.getSourceInfo());
            libUnit.addSourcePath(sourcePath);
        }
        while (this.peek(0) == Token.RESOURCE) {
            this.beginResourceDirective();
            DartResourceDirective resourceDirective = this.done(this.parseResourceDirective());
            LibraryNode resourcePath = new LibraryNode(resourceDirective.getResourceUri().getValue());
            resourcePath.setSourceInfo(resourceDirective.getSourceInfo());
            libUnit.addResourcePath(resourcePath);
        }
        while (this.peek(0) == Token.NATIVE) {
            this.beginNativeDirective();
            DartNativeDirective nativeDirective = this.done(this.parseNativeDirective());
            LibraryNode nativePath = new LibraryNode(nativeDirective.getNativeUri().getValue());
            nativePath.setSourceInfo(nativeDirective.getSourceInfo());
            libUnit.addNativePath(nativePath);
        }
        libUnit.addSourcePath(libUnit.getSelfSourcePath());
        return this.done(libUnit);
    }

    private void parseDirectives(DartUnit unit) {
        if (this.peek(0) == Token.LIBRARY) {
            this.beginLibraryDirective();
            unit.addDirective(this.done(this.parseLibraryDirective()));
        }
        while (this.peek(0) == Token.IMPORT) {
            this.beginImportDirective();
            unit.addDirective(this.done(this.parseImportDirective()));
        }
        while (this.peek(0) == Token.SOURCE) {
            this.beginSourceDirective();
            unit.addDirective(this.done(this.parseSourceDirective()));
        }
        while (this.peek(0) == Token.RESOURCE) {
            this.beginResourceDirective();
            unit.addDirective(this.done(this.parseResourceDirective()));
        }
        while (this.peek(0) == Token.NATIVE) {
            this.beginResourceDirective();
            unit.addDirective(this.done(this.parseNativeDirective()));
        }
    }

    private DartLibraryDirective parseLibraryDirective() {
        this.expect(Token.LIBRARY);
        this.expect(Token.LPAREN);
        this.beginLiteral();
        this.expect(Token.STRING);
        DartStringLiteral libname = this.done(DartStringLiteral.get(this.ctx.getTokenString()));
        this.expectCloseParen();
        this.expect(Token.SEMICOLON);
        return new DartLibraryDirective(libname);
    }

    private DartImportDirective parseImportDirective() {
        this.expect(Token.IMPORT);
        this.expect(Token.LPAREN);
        this.beginLiteral();
        this.expect(Token.STRING);
        DartStringLiteral libUri = this.done(DartStringLiteral.get(this.ctx.getTokenString()));
        DartStringLiteral prefix = null;
        if (this.optional(Token.COMMA)) {
            if (!this.optionalPseudoKeyword(PREFIX_KEYWORD)) {
                this.reportError(this.position(), (ErrorCode)ParserErrorCode.EXPECTED_PREFIX_KEYWORD, new Object[0]);
            }
            this.expect(Token.COLON);
            this.beginLiteral();
            this.expect(Token.STRING);
            String id = this.ctx.getTokenString();
            if (id == null || !id.matches("[_a-zA-Z]([_A-Za-z0-9]*)")) {
                this.reportError(this.position(), (ErrorCode)ParserErrorCode.EXPECTED_PREFIX_IDENTIFIER, new Object[0]);
            }
            prefix = this.done(DartStringLiteral.get(this.ctx.getTokenString()));
        }
        this.expectCloseParen();
        this.expect(Token.SEMICOLON);
        return new DartImportDirective(libUri, prefix);
    }

    private DartSourceDirective parseSourceDirective() {
        this.expect(Token.SOURCE);
        this.expect(Token.LPAREN);
        this.beginLiteral();
        this.expect(Token.STRING);
        DartStringLiteral sourceUri = this.done(DartStringLiteral.get(this.ctx.getTokenString()));
        this.expectCloseParen();
        this.expect(Token.SEMICOLON);
        return new DartSourceDirective(sourceUri);
    }

    private DartResourceDirective parseResourceDirective() {
        this.expect(Token.RESOURCE);
        this.expect(Token.LPAREN);
        this.beginLiteral();
        this.expect(Token.STRING);
        DartStringLiteral resourceUri = this.done(DartStringLiteral.get(this.ctx.getTokenString()));
        this.expectCloseParen();
        this.expect(Token.SEMICOLON);
        return new DartResourceDirective(resourceUri);
    }

    private DartNativeDirective parseNativeDirective() {
        this.expect(Token.NATIVE);
        this.expect(Token.LPAREN);
        this.beginLiteral();
        this.expect(Token.STRING);
        DartStringLiteral nativeUri = this.done(DartStringLiteral.get(this.ctx.getTokenString()));
        this.expect(Token.RPAREN);
        this.expect(Token.SEMICOLON);
        return new DartNativeDirective(nativeUri);
    }

    private List<DartTypeParameter> parseTypeParameters() {
        ArrayList<DartTypeParameter> types = new ArrayList<DartTypeParameter>();
        this.expect(Token.LT);
        do {
            DartTypeParameter typeParameter = this.parseTypeParameter();
            types.add(typeParameter);
        } while (this.optional(Token.COMMA));
        this.expect(Token.GT);
        return types;
    }

    private DartTypeParameter parseTypeParameter() {
        this.beginTypeParameter();
        DartIdentifier name = this.parseIdentifier();
        DartTypeNode bound = null;
        if (this.peek(0) != Token.EOS && this.peek(0) != Token.COMMA && this.peek(0) != Token.GT) {
            if (this.optionalPseudoKeyword(EXTENDS_KEYWORD)) {
                bound = this.parseTypeAnnotation();
            } else {
                if (this.peekTopLevelKeyword(0)) {
                    throw new ParserException();
                }
                if (this.peek(0) == Token.IDENTIFIER && (this.peek(1) == Token.COMMA || this.peek(1) == Token.GT)) {
                    this.next();
                    this.reportError(this.position(), (ErrorCode)ParserErrorCode.EXPECTED_EXTENDS, new Object[0]);
                } else if (this.peek(0) == Token.IDENTIFIER && this.peek(1) == Token.IDENTIFIER && (this.peek(2) == Token.COMMA || this.peek(2) == Token.GT)) {
                    this.next();
                    this.reportError(this.position(), (ErrorCode)ParserErrorCode.EXPECTED_EXTENDS, new Object[0]);
                    bound = this.parseTypeAnnotation();
                } else {
                    this.next();
                    this.reportError(this.position(), (ErrorCode)ParserErrorCode.EXPECTED_EXTENDS, new Object[0]);
                    throw new ParserException();
                }
            }
        }
        return this.done(new DartTypeParameter(name, bound));
    }

    private List<DartTypeParameter> parseTypeParametersOpt() {
        return this.peek(0) == Token.LT ? this.parseTypeParameters() : Collections.emptyList();
    }

    private DartDeclaration<?> parseClass() {
        this.beginClassBody();
        Modifiers modifiers = Modifiers.NONE;
        if (this.isTopLevelAbstract) {
            modifiers = modifiers.makeAbstract();
        }
        DartIdentifier name = this.parseIdentifier();
        List<DartTypeParameter> typeParameters = this.parseTypeParametersOpt();
        DartTypeNode superType = null;
        List<DartTypeNode> interfaces = null;
        if (this.isParsingInterface) {
            if (this.optionalPseudoKeyword(EXTENDS_KEYWORD)) {
                interfaces = this.parseTypeAnnotationList();
            }
        } else {
            if (this.optionalPseudoKeyword(EXTENDS_KEYWORD)) {
                superType = this.parseTypeAnnotation();
            }
            if (this.optionalPseudoKeyword(IMPLEMENTS_KEYWORD)) {
                interfaces = this.parseTypeAnnotationList();
            }
        }
        DartParameterizedTypeNode defaultClass = null;
        if (this.isParsingInterface && (this.optionalDeprecatedFactory() || this.optional(Token.DEFAULT))) {
            DartExpression qualified = this.parseQualified();
            List<DartTypeParameter> defaultTypeParameters = this.parseTypeParametersOpt();
            defaultClass = this.doneWithoutConsuming(new DartParameterizedTypeNode(qualified, defaultTypeParameters));
        }
        DartStringLiteral nativeName = null;
        if (!this.isParsingInterface && this.optionalPseudoKeyword(NATIVE_KEYWORD)) {
            this.beginLiteral();
            if (this.expect(Token.STRING)) {
                nativeName = this.done(DartStringLiteral.get(this.ctx.getTokenString()));
            }
            if (superType != null) {
                this.reportError(this.position(), (ErrorCode)ParserErrorCode.EXTENDED_NATIVE_CLASS, new Object[0]);
            }
        }
        ArrayList<DartNode> members = new ArrayList<DartNode>();
        if (this.optional(Token.LBRACE)) {
            while (!this.match(Token.RBRACE) && !this.EOS()) {
                DartNode member = this.parseFieldOrMethod(true);
                if (member == null) continue;
                members.add(member);
            }
            this.expectCloseBrace();
        } else {
            this.reportErrorWithoutAdvancing(ParserErrorCode.EXPECTED_CLASS_DECLARATION_LBRACE);
        }
        if (this.isParsingInterface) {
            return this.done(new DartClass(name, superType, interfaces, members, typeParameters, defaultClass));
        }
        return this.done(new DartClass(name, nativeName, superType, interfaces, members, typeParameters, modifiers));
    }

    private boolean optionalDeprecatedFactory() {
        if (this.optionalPseudoKeyword(FACTORY_KEYWORD)) {
            this.reportError(this.position(), (ErrorCode)ParserErrorCode.DEPRECATED_USE_OF_FACTORY_KEYWORD, new Object[0]);
            return true;
        }
        return false;
    }

    private List<DartTypeNode> parseTypeAnnotationList() {
        ArrayList<DartTypeNode> result = new ArrayList<DartTypeNode>();
        do {
            result.add(this.parseTypeAnnotation());
        } while (this.optional(Token.COMMA));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isFunctionTypeAliasName() {
        this.beginFunctionTypeInterface();
        try {
            if (this.peek(0) == Token.IDENTIFIER && this.peek(1) == Token.LPAREN) {
                boolean bl = true;
                return bl;
            }
            if (this.peek(0) == Token.IDENTIFIER && this.peek(1) == Token.LT) {
                this.consume(Token.IDENTIFIER);
                if (this.isTypeParameter() && this.peek(0) == Token.LPAREN) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rollback();
        }
    }

    private boolean isTypeParameter() {
        if (this.peek(0) == Token.LT) {
            this.consume(Token.LT);
            int nestingLevel = 1;
            while (nestingLevel > 0) {
                switch (this.peek(0)) {
                    case LT: {
                        ++nestingLevel;
                        break;
                    }
                    case GT: {
                        --nestingLevel;
                        break;
                    }
                    case SAR: {
                        nestingLevel -= 2;
                        break;
                    }
                    case SHR: {
                        nestingLevel -= 3;
                        break;
                    }
                    case COMMA: 
                    case IDENTIFIER: {
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                this.next();
                if (nestingLevel >= 0) continue;
                return false;
            }
        }
        return true;
    }

    private DartFunctionTypeAlias parseFunctionTypeAlias() {
        this.beginFunctionTypeInterface();
        DartTypeNode returnType = null;
        if (this.peek(0) == Token.VOID) {
            returnType = this.parseVoidType();
        } else if (!this.isFunctionTypeAliasName()) {
            returnType = this.parseTypeAnnotation();
        }
        DartIdentifier name = this.parseIdentifier();
        List<DartTypeParameter> typeParameters = this.parseTypeParametersOpt();
        List<DartParameter> params = this.parseFormalParameterList();
        this.expect(Token.SEMICOLON);
        this.validateNoDefaultParameterValues(params, ParserErrorCode.DEFAULT_VALUE_CAN_NOT_BE_SPECIFIED_IN_TYPEDEF);
        return this.done(new DartFunctionTypeAlias(name, returnType, params, typeParameters));
    }

    private DartNode parseFieldOrMethod(boolean allowStatic) {
        DartNode member;
        this.beginClassMember();
        Modifiers modifiers = Modifiers.NONE;
        if (this.optionalPseudoKeyword(STATIC_KEYWORD)) {
            if (!allowStatic) {
                this.reportError(this.position(), (ErrorCode)ParserErrorCode.TOP_LEVEL_IS_STATIC, new Object[0]);
            } else {
                if (this.isParsingInterface && this.peek(0) != Token.FINAL) {
                    this.reportError(this.position(), (ErrorCode)ParserErrorCode.NON_FINAL_STATIC_MEMBER_IN_INTERFACE, new Object[0]);
                }
                modifiers = modifiers.makeStatic();
            }
        } else if (this.optionalPseudoKeyword(ABSTRACT_KEYWORD)) {
            if (this.isParsingInterface) {
                this.reportError(this.position(), (ErrorCode)ParserErrorCode.ABSTRACT_MEMBER_IN_INTERFACE, new Object[0]);
            }
            modifiers = modifiers.makeAbstract();
        } else if (this.optionalPseudoKeyword(FACTORY_KEYWORD)) {
            if (this.isParsingInterface) {
                this.reportError(this.position(), (ErrorCode)ParserErrorCode.FACTORY_MEMBER_IN_INTERFACE, new Object[0]);
            }
            modifiers = modifiers.makeFactory();
        }
        if (this.match(Token.VAR) || this.match(Token.FINAL)) {
            if (modifiers.isAbstract()) {
                this.reportError(this.position(), (ErrorCode)ParserErrorCode.DISALLOWED_ABSTRACT_KEYWORD, new Object[0]);
            } else if (modifiers.isFactory()) {
                this.reportError(this.position(), (ErrorCode)ParserErrorCode.DISALLOWED_FACTORY_KEYWORD, new Object[0]);
            }
        }
        if (modifiers.isFactory()) {
            if (!allowStatic) {
                this.reportError(this.position(), (ErrorCode)ParserErrorCode.DISALLOWED_FACTORY_KEYWORD, new Object[0]);
                modifiers = modifiers.removeFactory();
            }
            DartMethodDefinition factoryNode = this.parseFactory(modifiers);
            Object actualName = factoryNode.getName();
            if (!allowStatic && !(actualName instanceof DartIdentifier)) {
                DartIdentifier replacementName = new DartIdentifier(((DartNode)actualName).toString());
                factoryNode.setName(replacementName);
            }
            return this.done(factoryNode);
        }
        switch (this.peek(0)) {
            case VAR: {
                this.consume(Token.VAR);
                member = this.parseFieldDeclaration(modifiers, null);
                this.expectStatmentTerminator();
                break;
            }
            case CONST: {
                this.consume(Token.CONST);
                modifiers = modifiers.makeConstant();
                member = this.done(this.parseMethod(modifiers, null));
                break;
            }
            case FINAL: {
                this.consume(Token.FINAL);
                modifiers = modifiers.makeFinal();
                DartTypeNode type = null;
                if (this.peek(1) != Token.COMMA && this.peek(1) != Token.ASSIGN && this.peek(1) != Token.SEMICOLON) {
                    type = this.parseTypeAnnotation();
                }
                member = this.parseFieldDeclaration(modifiers, type);
                this.expectStatmentTerminator();
                break;
            }
            case IDENTIFIER: {
                if (this.looksLikeMethodOrAccessorDefinition()) {
                    member = this.parseMethodOrAccessor(modifiers, null);
                    break;
                }
            }
            case VOID: {
                DartTypeNode type;
                boolean isVoidType = this.peek(0) == Token.VOID;
                DartTypeNode dartTypeNode = type = isVoidType ? this.parseVoidType() : this.parseTypeAnnotation();
                if (this.peek(1) == Token.SEMICOLON || this.peek(1) == Token.COMMA || this.peek(1) == Token.ASSIGN) {
                    if (modifiers.isAbstract()) {
                        this.reportError(this.position(), (ErrorCode)ParserErrorCode.INVALID_FIELD_DECLARATION, new Object[0]);
                    }
                    member = this.parseFieldDeclaration(modifiers, type);
                    if (isVoidType) {
                        this.reportError(type, (ErrorCode)ParserErrorCode.VOID_FIELD, new Object[0]);
                    }
                    this.expectStatmentTerminator();
                    break;
                }
                member = this.parseMethodOrAccessor(modifiers, type);
                break;
            }
            default: {
                this.done(null);
                this.reportUnexpectedToken(this.position(), null, this.next());
                member = null;
            }
        }
        return member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean looksLikeMethodOrAccessorDefinition() {
        assert (this.peek(0).equals((Object)Token.IDENTIFIER));
        this.beginMethodName();
        try {
            if (this.peekPseudoKeyword(0, GETTER_KEYWORD) || this.peekPseudoKeyword(0, SETTER_KEYWORD) || this.peekPseudoKeyword(0, OPERATOR_KEYWORD)) {
                boolean bl = true;
                return bl;
            }
            this.consume(Token.IDENTIFIER);
            if (this.peek(0).equals((Object)Token.PERIOD) && this.peek(1).equals((Object)Token.IDENTIFIER)) {
                this.consume(Token.PERIOD);
                this.consume(Token.IDENTIFIER);
                if (this.peek(0).equals((Object)Token.PERIOD) && this.peek(1).equals((Object)Token.IDENTIFIER)) {
                    this.consume(Token.PERIOD);
                    this.consume(Token.IDENTIFIER);
                }
            }
            boolean bl = this.peek(0).equals((Object)Token.LPAREN);
            return bl;
        }
        finally {
            this.rollback();
        }
    }

    private DartMethodDefinition parseFactory(Modifiers modifiers) {
        DartFunction function;
        this.beginMethodName();
        DartExpression name = this.parseQualified();
        if (this.optional(Token.PERIOD)) {
            name = this.doneWithoutConsuming(new DartPropertyAccess(name, this.parseIdentifier()));
        }
        this.done(name);
        List<DartParameter> formals = this.parseFormalParameterList();
        if (this.peekPseudoKeyword(0, NATIVE_KEYWORD)) {
            modifiers = modifiers.makeNative();
            function = new DartFunction(formals, this.parseNativeBlock(modifiers), null);
        } else {
            function = new DartFunction(formals, this.parseFunctionStatementBody(true), null);
        }
        this.doneWithoutConsuming(function);
        return DartMethodDefinition.create(name, function, modifiers, null);
    }

    private DartIdentifier parseVoidIdentifier() {
        this.beginIdentifier();
        this.expect(Token.VOID);
        return this.done(new DartIdentifier(Token.VOID.getSyntax()));
    }

    private DartTypeNode parseVoidType() {
        this.beginTypeAnnotation();
        return this.done(new DartTypeNode(this.parseVoidIdentifier()));
    }

    private DartMethodDefinition parseMethod(Modifiers modifiers, DartTypeNode returnType) {
        DartExpression name = null;
        if (modifiers.isFactory()) {
            if (modifiers.isAbstract()) {
                this.reportError(this.position(), (ErrorCode)ParserErrorCode.FACTORY_CANNOT_BE_ABSTRACT, new Object[0]);
            }
            if (modifiers.isStatic()) {
                this.reportError(this.position(), (ErrorCode)ParserErrorCode.FACTORY_CANNOT_BE_STATIC, new Object[0]);
            }
        }
        int arity = -1;
        if (this.optionalPseudoKeyword(OPERATOR_KEYWORD)) {
            if (modifiers.isStatic()) {
                this.reportError(this.position(), (ErrorCode)ParserErrorCode.OPERATOR_CANNOT_BE_STATIC, new Object[0]);
            }
            modifiers = modifiers.makeOperator();
            this.beginOperatorName();
            Token operation = this.next();
            if (operation.isUserDefinableOperator()) {
                name = this.done(new DartIdentifier(operation.getSyntax()));
                if (operation == Token.ASSIGN_INDEX) {
                    arity = 2;
                } else if (operation.isBinaryOperator()) {
                    arity = 1;
                } else if (operation == Token.INDEX) {
                    arity = 1;
                } else {
                    assert (operation.isUnaryOperator());
                    arity = 0;
                }
            } else if (operation == Token.IDENTIFIER && this.ctx.getTokenString().equals(NEGATE_KEYWORD)) {
                name = this.done(new DartIdentifier(NEGATE_KEYWORD));
                arity = 0;
            } else {
                this.reportUnexpectedToken(this.position(), Token.COMMENT, operation);
                this.done(null);
            }
        } else {
            this.beginMethodName();
            if (this.optionalPseudoKeyword(GETTER_KEYWORD)) {
                name = this.parseIdentifier();
                modifiers = modifiers.makeGetter();
                arity = 0;
            } else if (this.optionalPseudoKeyword(SETTER_KEYWORD)) {
                name = this.parseIdentifier();
                modifiers = modifiers.makeSetter();
                arity = 1;
            } else {
                name = this.parseIdentifier();
            }
            if (this.optional(Token.PERIOD)) {
                name = this.doneWithoutConsuming(new DartPropertyAccess(name, this.parseIdentifier()));
                if (this.currentlyParsingToplevel()) {
                    this.reportError(name, (ErrorCode)ParserErrorCode.FUNCTION_NAME_EXPECTED_IDENTIFIER, new Object[0]);
                }
                if (this.optional(Token.PERIOD)) {
                    name = this.doneWithoutConsuming(new DartPropertyAccess(name, this.parseIdentifier()));
                }
            }
            this.done(null);
        }
        List<DartParameter> parameters = this.parseFormalParameterList();
        if (arity != -1) {
            if (parameters.size() != arity) {
                this.reportError(this.position(), (ErrorCode)ParserErrorCode.ILLEGAL_NUMBER_OF_PARAMETERS, new Object[0]);
            }
            for (DartParameter parameter : parameters) {
                if (!parameter.getModifiers().isNamed()) continue;
                this.reportError(parameter, (ErrorCode)ParserErrorCode.NAMED_PARAMETER_NOT_ALLOWED, new Object[0]);
            }
        }
        if (this.isParsingInterface) {
            this.validateNoDefaultParameterValues(parameters, ParserErrorCode.DEFAULT_VALUE_CAN_NOT_BE_SPECIFIED_IN_INTERFACE);
        }
        if (modifiers.isAbstract()) {
            this.validateNoDefaultParameterValues(parameters, ParserErrorCode.DEFAULT_VALUE_CAN_NOT_BE_SPECIFIED_IN_ABSTRACT);
        }
        ArrayList<DartInitializer> initializers = new ArrayList<DartInitializer>();
        if (this.match(Token.COLON) && !this.isParsingInterface && !modifiers.isFactory()) {
            this.parseInitializers(initializers);
            boolean isRedirectedConstructor = this.validateInitializers(parameters, initializers);
            if (isRedirectedConstructor) {
                modifiers = modifiers.makeRedirectedConstructor();
            }
        }
        DartBlock body = null;
        if (!this.optional(Token.SEMICOLON)) {
            if (this.peekPseudoKeyword(0, NATIVE_KEYWORD)) {
                modifiers = modifiers.makeNative();
                body = this.parseNativeBlock(modifiers);
            } else {
                body = this.parseFunctionStatementBody(true);
            }
        }
        DartFunction function = this.doneWithoutConsuming(new DartFunction(parameters, body, returnType));
        return DartMethodDefinition.create(name, function, modifiers, initializers);
    }

    private DartBlock parseNativeBlock(Modifiers modifiers) {
        this.beginNativeBody();
        if (!this.optionalPseudoKeyword(NATIVE_KEYWORD)) {
            throw new AssertionError();
        }
        if (this.optional(Token.SEMICOLON)) {
            return this.done(new DartNativeBlock());
        }
        if (this.match(Token.LBRACE) || this.match(Token.ARROW)) {
            if (!modifiers.isStatic()) {
                this.reportError(this.position(), (ErrorCode)ParserErrorCode.EXPORTED_FUNCTIONS_MUST_BE_STATIC, new Object[0]);
            }
            return this.done(this.parseFunctionStatementBody(true));
        }
        this.parseString();
        this.expect(Token.SEMICOLON);
        return this.done(new DartNativeBlock());
    }

    private DartNode parseMethodOrAccessor(Modifiers modifiers, DartTypeNode returnType) {
        DartMethodDefinition method = this.done(this.parseMethod(modifiers, returnType));
        if (method.getFunction().getBody() != null) {
            if (this.isParsingInterface) {
                this.reportError(new DartCompilationError((SourceInfo)method.getName(), (ErrorCode)ParserErrorCode.INTERFACE_METHOD_WITH_BODY, new Object[0]));
            }
            if (method.getModifiers().isAbstract()) {
                this.reportError(new DartCompilationError((SourceInfo)method.getName(), (ErrorCode)ParserErrorCode.ABSTRACT_METHOD_WITH_BODY, new Object[0]));
            }
        }
        if (method.getModifiers().isGetter() || method.getModifiers().isSetter()) {
            DartField field = new DartField((DartIdentifier)method.getName(), method.getModifiers().makeAbstractField(), method, null);
            field.setSourceInfo(method);
            DartFieldDefinition fieldDefinition = new DartFieldDefinition(null, Lists.create(field));
            fieldDefinition.setSourceInfo(field);
            return fieldDefinition;
        }
        return method;
    }

    private void parseInitializers(List<DartInitializer> initializers) {
        this.expect(Token.COLON);
        do {
            this.beginInitializer();
            if (this.match(Token.SUPER)) {
                this.beginSuperInitializer();
                this.expect(Token.SUPER);
                DartIdentifier constructor = null;
                if (this.optional(Token.PERIOD)) {
                    constructor = this.parseIdentifier();
                }
                DartSuperConstructorInvocation superInvocation = new DartSuperConstructorInvocation(constructor, this.parseArguments());
                initializers.add(this.done(new DartInitializer(null, this.done(superInvocation))));
                continue;
            }
            boolean hasThisPrefix = this.optional(Token.THIS);
            if (hasThisPrefix) {
                if (this.match(Token.LPAREN)) {
                    this.parseRedirectedConstructorInvocation(null, initializers);
                    continue;
                }
                this.expect(Token.PERIOD);
            }
            DartIdentifier name = this.parseIdentifier();
            if (hasThisPrefix && this.match(Token.LPAREN)) {
                this.parseRedirectedConstructorInvocation(name, initializers);
                continue;
            }
            this.expect(Token.ASSIGN);
            boolean save = this.setAllowFunctionExpression(false);
            DartExpression initExpr = this.parseExpression();
            this.setAllowFunctionExpression(save);
            initializers.add(this.done(new DartInitializer(name, initExpr)));
        } while (this.optional(Token.COMMA));
    }

    private void parseRedirectedConstructorInvocation(DartIdentifier name, List<DartInitializer> initializers) {
        DartRedirectConstructorInvocation redirConstructor = new DartRedirectConstructorInvocation(name, this.parseArguments());
        initializers.add(this.done(new DartInitializer(null, this.doneWithoutConsuming(redirConstructor))));
    }

    private boolean validateInitializers(List<DartParameter> parameters, List<DartInitializer> initializers) {
        DartInitializer redirectInitializer = null;
        boolean firstMultipleRedirectReported = false;
        DartInitializer superInitializer = null;
        boolean firstMultipleSuperReported = false;
        for (DartInitializer initializer : initializers) {
            if (!initializer.isInvocation()) continue;
            DartExpression initializerInvocation = initializer.getValue();
            if (initializerInvocation instanceof DartSuperConstructorInvocation) {
                if (superInitializer != null) {
                    if (!firstMultipleSuperReported) {
                        this.reportError(superInitializer, (ErrorCode)ParserErrorCode.SUPER_CONSTRUCTOR_MULTIPLE, new Object[0]);
                        firstMultipleSuperReported = true;
                    }
                    this.reportError(initializer, (ErrorCode)ParserErrorCode.SUPER_CONSTRUCTOR_MULTIPLE, new Object[0]);
                } else {
                    superInitializer = initializer;
                }
            }
            if (!(initializerInvocation instanceof DartRedirectConstructorInvocation)) continue;
            if (redirectInitializer != null) {
                if (!firstMultipleRedirectReported) {
                    this.reportError(redirectInitializer, (ErrorCode)ParserErrorCode.REDIRECTING_CONSTRUCTOR_MULTIPLE, new Object[0]);
                    firstMultipleRedirectReported = true;
                }
                this.reportError(initializer, (ErrorCode)ParserErrorCode.REDIRECTING_CONSTRUCTOR_MULTIPLE, new Object[0]);
                continue;
            }
            redirectInitializer = initializer;
        }
        if (redirectInitializer != null) {
            boolean shouldRedirectInvocationReported = false;
            for (DartParameter parameter : parameters) {
                DartPropertyAccess propertyAccess;
                if (!(parameter.getName() instanceof DartPropertyAccess) || !((propertyAccess = (DartPropertyAccess)parameter.getName()).getQualifier() instanceof DartThisExpression)) continue;
                shouldRedirectInvocationReported = true;
                this.reportError(parameter, (ErrorCode)ParserErrorCode.REDIRECTING_CONSTRUCTOR_PARAM, new Object[0]);
            }
            for (DartInitializer initializer : initializers) {
                if (initializer.getValue() instanceof DartRedirectConstructorInvocation) continue;
                shouldRedirectInvocationReported = true;
                this.reportError(initializer, (ErrorCode)ParserErrorCode.REDIRECTING_CONSTRUCTOR_OTHER, new Object[0]);
            }
            if (shouldRedirectInvocationReported) {
                this.reportError(redirectInitializer, (ErrorCode)ParserErrorCode.REDIRECTING_CONSTRUCTOR_ITSELF, new Object[0]);
            }
        }
        return redirectInitializer != null;
    }

    private DartFieldDefinition parseFieldDeclaration(Modifiers modifiers, DartTypeNode type) {
        if (this.isParsingInterface) {
            modifiers = modifiers.makeFinal();
        }
        ArrayList<DartField> fields = new ArrayList<DartField>();
        do {
            this.beginVariableDeclaration();
            DartIdentifier name = this.parseIdentifier();
            DartExpression value = null;
            if (this.optional(Token.ASSIGN)) {
                value = this.parseExpression();
            }
            fields.add(this.done(new DartField(name, modifiers, null, value)));
        } while (this.optional(Token.COMMA));
        return this.done(new DartFieldDefinition(type, fields));
    }

    private List<DartParameter> parseFormalParameterList() {
        this.beginFormalParameterList();
        ArrayList<DartParameter> params = new ArrayList<DartParameter>();
        this.expect(Token.LPAREN);
        boolean done = this.optional(Token.RPAREN);
        boolean isNamed = false;
        while (!done) {
            if (!isNamed && this.optional(Token.LBRACK)) {
                isNamed = true;
            }
            DartParameter param = this.parseFormalParameter(isNamed);
            params.add(param);
            done = this.optional(Token.RBRACK);
            if (done) {
                this.expectCloseParen();
            } else {
                done = this.optional(Token.RPAREN);
            }
            if (done) continue;
            done = !this.expect(Token.COMMA);
        }
        return this.done(params);
    }

    private DartParameter parseFormalParameter(boolean isNamed) {
        this.beginFormalParameter();
        DartExpression paramName = null;
        DartTypeNode type = null;
        DartExpression defaultExpr = null;
        List<DartParameter> functionParams = null;
        boolean hasVar = false;
        Modifiers modifiers = Modifiers.NONE;
        if (isNamed) {
            modifiers = modifiers.makeNamed();
        }
        if (this.optional(Token.FINAL)) {
            modifiers = modifiers.makeFinal();
        } else if (this.optional(Token.VAR)) {
            hasVar = true;
        }
        boolean isVoidType = false;
        if (!hasVar) {
            boolean bl = isVoidType = this.peek(0) == Token.VOID;
            if (isVoidType) {
                type = this.parseVoidType();
            } else if (this.peek(0) != Token.ELLIPSIS && this.peek(1) != Token.COMMA && this.peek(1) != Token.RPAREN && this.peek(1) != Token.RBRACK && this.peek(1) != Token.ASSIGN && this.peek(1) != Token.LPAREN && this.peek(0) != Token.THIS) {
                type = this.parseTypeAnnotation();
            }
        }
        paramName = this.parseParameterName();
        if (this.peek(0) == Token.LPAREN) {
            if (modifiers.isFinal()) {
                this.reportError(this.position(), (ErrorCode)ParserErrorCode.FUNCTION_TYPED_PARAMETER_IS_FINAL, new Object[0]);
            }
            if (hasVar) {
                this.reportError(this.position(), (ErrorCode)ParserErrorCode.FUNCTION_TYPED_PARAMETER_IS_VAR, new Object[0]);
            }
            functionParams = this.parseFormalParameterList();
            this.validateNoDefaultParameterValues(functionParams, ParserErrorCode.DEFAULT_VALUE_CAN_NOT_BE_SPECIFIED_IN_CLOSURE);
        } else if (isVoidType) {
            this.reportError(type, (ErrorCode)ParserErrorCode.VOID_PARAMETER, new Object[0]);
        }
        switch (this.peek(0)) {
            case COMMA: 
            case RPAREN: 
            case RBRACK: {
                break;
            }
            case ASSIGN: {
                if (isNamed) {
                    this.consume(Token.ASSIGN);
                    defaultExpr = this.parseExpression();
                    break;
                }
                this.reportError(this.position(), (ErrorCode)ParserErrorCode.DEFAULT_POSITIONAL_PARAMETER, new Object[0]);
                break;
            }
            default: {
                this.reportUnexpectedToken(this.position(), null, this.peek(0));
            }
        }
        return this.done(new DartParameter(paramName, type, functionParams, defaultExpr, modifiers));
    }

    private DartExpression parseParameterName() {
        this.beginParameterName();
        if (this.optional(Token.THIS)) {
            this.beginThisExpression();
            this.expect(Token.PERIOD);
            return this.done(new DartPropertyAccess(this.done(DartThisExpression.get()), this.parseIdentifier()));
        }
        return this.done(this.parseIdentifier());
    }

    private void validateNoDefaultParameterValues(List<DartParameter> parameters, ErrorCode errorCode) {
        for (DartParameter parameter : parameters) {
            DartExpression defaultExpr = parameter.getDefaultExpr();
            if (defaultExpr == null) continue;
            this.reportError(defaultExpr, errorCode, new Object[0]);
        }
    }

    @VisibleForTesting
    public DartExpression parseExpression() {
        this.beginExpression();
        DartExpression result = this.parseConditionalExpression();
        Token token = this.peek(0);
        if (token.isAssignmentOperator()) {
            this.ensureAssignable(result);
            this.consume(token);
            result = this.done(new DartBinaryExpression(token, result, this.parseExpression()));
        } else {
            this.done(null);
        }
        return result;
    }

    private DartExpression parseExpressionList() {
        this.beginExpressionList();
        DartExpression result = this.parseExpression();
        while (this.optional(Token.COMMA)) {
            result = new DartBinaryExpression(Token.COMMA, result, this.parseExpression());
            if (!this.match(Token.COMMA)) continue;
            result = this.doneWithoutConsuming(result);
        }
        return this.done(result);
    }

    private DartExpression parseBinaryExpression(int precedence) {
        assert (precedence >= 4);
        this.beginBinaryExpression();
        DartExpression result = this.parseUnaryExpression();
        block0: for (int level = this.peek(0).getPrecedence(); level >= precedence; --level) {
            while (this.peek(0).getPrecedence() == level) {
                DartExpression right;
                Token token = this.next();
                if (token == Token.IS) {
                    this.beginTypeExpression();
                    if (this.optional(Token.NOT)) {
                        this.beginTypeExpression();
                        DartTypeExpression typeExpression = this.done(new DartTypeExpression(this.parseTypeAnnotation()));
                        right = this.done(new DartUnaryExpression(Token.NOT, typeExpression, true));
                    } else {
                        right = this.done(new DartTypeExpression(this.parseTypeAnnotation()));
                    }
                } else {
                    right = this.parseBinaryExpression(level + 1);
                }
                result = this.doneWithoutConsuming(new DartBinaryExpression(token, result, right));
                if (token != Token.IS && !token.isRelationalOperator() && !token.isEqualityOperator()) continue;
                if (!this.match(token)) continue block0;
                this.reportError(this.position(), (ErrorCode)ParserErrorCode.INVALID_OPERATOR_CHAINING, token.toString().toLowerCase());
                continue block0;
            }
        }
        this.done(null);
        return result;
    }

    private List<DartExpression> parseArguments() {
        ArrayList<DartExpression> arguments = new ArrayList<DartExpression>();
        this.expect(Token.LPAREN);
        block4: while (!(this.match(Token.RPAREN) || this.match(Token.EOS) || this.match(Token.SEMICOLON))) {
            DartExpression expression;
            this.beginParameter();
            if (this.peek(1) == Token.COLON) {
                DartIdentifier name = this.parseIdentifier();
                this.expect(Token.COLON);
                expression = new DartNamedExpression(name, this.parseExpression());
            } else {
                expression = this.parseExpression();
            }
            arguments.add(this.done(expression));
            switch (this.peek(0)) {
                case COMMA: {
                    this.consume(Token.COMMA);
                    continue block4;
                }
                case RPAREN: {
                    continue block4;
                }
            }
            Token actual = this.peek(0);
            this.ctx.advance();
            this.reportError(this.ctx.getTokenLocation().getEnd(), (ErrorCode)ParserErrorCode.EXPECTED_COMMA_OR_RIGHT_PAREN, new Object[]{actual});
        }
        this.expectCloseParen();
        return arguments;
    }

    private DartExpression parseConditionalExpression() {
        this.beginConditionalExpression();
        DartExpression result = this.parseBinaryExpression(4);
        if (this.peek(0) != Token.CONDITIONAL) {
            return this.done(result);
        }
        this.consume(Token.CONDITIONAL);
        DartExpression yes = this.parseExpression();
        this.expect(Token.COLON);
        DartExpression no = this.parseExpression();
        return this.done(new DartConditional(result, yes, no));
    }

    private DartExpression parseString() {
        switch (this.peek(0)) {
            case STRING: {
                return this.parseLiteral();
            }
            case STRING_SEGMENT: 
            case STRING_EMBED_EXP_START: {
                return this.parseStringInterpolation();
            }
        }
        DartExpression expression = this.parseExpression();
        this.reportError(this.position(), (ErrorCode)ParserErrorCode.EXPECTED_STRING_LITERAL, new Object[0]);
        return expression;
    }

    private DartExpression parseLiteral() {
        this.beginLiteral();
        switch (this.peek(0)) {
            case NULL_LITERAL: {
                this.consume(Token.NULL_LITERAL);
                return this.done(DartNullLiteral.get());
            }
            case TRUE_LITERAL: {
                this.consume(Token.TRUE_LITERAL);
                return this.done(DartBooleanLiteral.get(true));
            }
            case FALSE_LITERAL: {
                this.consume(Token.FALSE_LITERAL);
                return this.done(DartBooleanLiteral.get(false));
            }
            case INTEGER_LITERAL: {
                this.consume(Token.INTEGER_LITERAL);
                String number = this.ctx.getTokenString();
                return this.done(DartIntegerLiteral.get(new BigInteger(number)));
            }
            case DOUBLE_LITERAL: {
                this.consume(Token.DOUBLE_LITERAL);
                String number = this.ctx.getTokenString();
                return this.done(DartDoubleLiteral.get(Double.parseDouble(number)));
            }
            case HEX_LITERAL: {
                this.consume(Token.HEX_LITERAL);
                String number = this.ctx.getTokenString();
                return this.done(DartIntegerLiteral.get(new BigInteger(number, 16)));
            }
            case STRING: {
                this.consume(Token.STRING);
                return this.done(DartStringLiteral.get(this.ctx.getTokenString()));
            }
            case LBRACE: {
                return this.done(this.parseMapLiteral(false, null));
            }
            case INDEX: {
                this.expect(this.peek(0));
                return this.done(new DartArrayLiteral(false, null, new ArrayList<DartExpression>()));
            }
            case LBRACK: {
                return this.done(this.parseArrayLiteral(false, null));
            }
            case IDENTIFIER: 
            case VOID: {
                return this.done(this.parseIdentifier());
            }
            case SEMICOLON: {
                this.startLookahead();
                this.next();
                this.reportUnexpectedToken(this.position(), null, Token.SEMICOLON);
                this.rollback();
                return this.done(new DartSyntheticErrorExpression(""));
            }
        }
        Token unexpected = this.peek(0);
        String unexpectedString = this.ctx.getTokenString();
        if (unexpectedString == null && unexpected != Token.EOS) {
            unexpectedString = unexpected.getSyntax();
        }
        this.next();
        this.reportUnexpectedToken(this.position(), null, unexpected);
        StringBuilder tokenStr = new StringBuilder();
        if (unexpectedString != null) {
            tokenStr.append(unexpectedString);
        }
        return this.done(new DartSyntheticErrorExpression(tokenStr.toString()));
    }

    private DartExpression parseMapLiteral(boolean isConst, List<DartTypeNode> typeArguments) {
        this.beginMapLiteral();
        this.expect(Token.LBRACE);
        boolean save = this.setAllowFunctionExpression(true);
        ArrayList<DartMapLiteralEntry> entries = new ArrayList<DartMapLiteralEntry>();
        block4: while (!this.match(Token.RBRACE) && !this.match(Token.EOS)) {
            DartMapLiteralEntry entry = this.parseMapLiteralEntry();
            if (entry != null) {
                entries.add(entry);
            }
            switch (this.peek(0)) {
                case COMMA: {
                    this.consume(Token.COMMA);
                    continue block4;
                }
                case RBRACE: {
                    continue block4;
                }
            }
            if (entry == null) {
                this.ctx.advance();
            }
            this.reportError(this.position(), (ErrorCode)ParserErrorCode.EXPECTED_COMMA_OR_RIGHT_BRACE, new Object[0]);
        }
        this.expectCloseBrace();
        this.setAllowFunctionExpression(save);
        return this.done(new DartMapLiteral(isConst, typeArguments, entries));
    }

    private DartMapLiteralEntry parseMapLiteralEntry() {
        this.beginMapLiteralEntry();
        DartExpression keyExpr = this.parseString();
        if (keyExpr == null) {
            return this.done(null);
        }
        DartExpression value = this.expect(Token.COLON) ? this.parseExpression() : (DartExpression)this.doneWithoutConsuming(DartNullLiteral.get());
        return this.done(new DartMapLiteralEntry(keyExpr, value));
    }

    private DartExpression parseArrayLiteral(boolean isConst, List<DartTypeNode> typeArguments) {
        this.beginArrayLiteral();
        this.expect(Token.LBRACK);
        boolean save = this.setAllowFunctionExpression(true);
        ArrayList<DartExpression> exprs = new ArrayList<DartExpression>();
        while (!this.match(Token.RBRACK) && !this.EOS()) {
            exprs.add(this.parseExpression());
            if (this.optional(Token.COMMA)) continue;
        }
        this.expect(Token.RBRACK);
        this.setAllowFunctionExpression(save);
        return this.done(new DartArrayLiteral(isConst, typeArguments, exprs));
    }

    private DartExpression parsePostfixExpression() {
        DartExpression receiver;
        this.beginPostfixExpression();
        DartExpression result = receiver = this.doneWithoutConsuming(this.parsePrimaryExpression());
        while ((receiver = result) != (result = this.doneWithoutConsuming(this.parseSelectorExpression(receiver)))) {
        }
        Token token = this.peek(0);
        if (token.isCountOperator()) {
            this.ensureAssignable(result);
            this.consume(token);
            result = this.doneWithoutConsuming(new DartUnaryExpression(token, result, false));
        }
        return this.done(result);
    }

    private DartExpression tryParseTypedCompoundLiteral(boolean isConst) {
        this.beginLiteral();
        List<DartTypeNode> typeArguments = this.parseTypeArgumentsOpt();
        switch (this.peek(0)) {
            case INDEX: {
                this.beginArrayLiteral();
                this.consume(Token.INDEX);
                return this.done(this.done(new DartArrayLiteral(isConst, null, new ArrayList<DartExpression>())));
            }
            case LBRACK: {
                return this.done(this.parseArrayLiteral(isConst, typeArguments));
            }
            case LBRACE: {
                return this.done(this.parseMapLiteral(isConst, typeArguments));
            }
        }
        if (typeArguments != null) {
            this.rollback();
            return null;
        }
        return this.done(null);
    }

    private DartExpression parseStringInterpolation() {
        if (this.peek(0) == Token.STRING_LAST_SEGMENT) {
            throw new InternalCompilerException("Invariant broken");
        }
        this.beginStringInterpolation();
        DartStringInterpolationBuilder builder = new DartStringInterpolationBuilder();
        boolean inString = true;
        block6: while (inString) {
            String errorText;
            switch (this.peek(0)) {
                case STRING_SEGMENT: {
                    this.beginStringSegment();
                    this.consume(Token.STRING_SEGMENT);
                    builder.addString(this.done(DartStringLiteral.get(this.ctx.getTokenString())));
                    continue block6;
                }
                case STRING_LAST_SEGMENT: {
                    this.beginStringSegment();
                    this.consume(Token.STRING_LAST_SEGMENT);
                    builder.addString(this.done(DartStringLiteral.get(this.ctx.getTokenString())));
                    inString = false;
                    continue block6;
                }
                case STRING_EMBED_EXP_START: {
                    this.consume(Token.STRING_EMBED_EXP_START);
                    if (this.peek(0) == Token.ILLEGAL) {
                        this.reportError(this.position(), (ErrorCode)ParserErrorCode.UNEXPECTED_TOKEN_IN_STRING_INTERPOLATION, new Object[]{this.next()});
                        builder.addExpression(new DartSyntheticErrorExpression(""));
                        continue block6;
                    }
                    builder.addExpression(this.parseExpression());
                    Token lookAhead = this.peek(0);
                    String lookAheadString = this.getPeekTokenValue(0);
                    if (this.expect(Token.STRING_EMBED_EXP_END)) continue block6;
                    String errorText2 = null;
                    if (lookAheadString != null && lookAheadString.length() > 0) {
                        errorText2 = lookAheadString;
                    } else if (lookAhead.getSyntax() != null && lookAhead.getSyntax().length() > 0) {
                        errorText2 = lookAhead.getSyntax();
                    }
                    if (errorText2 != null) {
                        builder.addExpression(new DartSyntheticErrorExpression(errorText2));
                    }
                    inString = Token.STRING_LAST_SEGMENT != lookAhead;
                    continue block6;
                }
                case EOS: {
                    this.reportError(this.position(), (ErrorCode)ParserErrorCode.INCOMPLETE_STRING_LITERAL, new Object[0]);
                    inString = false;
                    continue block6;
                }
            }
            String string = errorText = this.getPeekTokenValue(0) != null && this.getPeekTokenValue(0).length() > 0 ? this.getPeekTokenValue(0) : null;
            if (errorText != null) {
                builder.addExpression(new DartSyntheticErrorExpression(this.getPeekTokenValue(0)));
            }
            this.reportError(this.position(), (ErrorCode)ParserErrorCode.UNEXPECTED_TOKEN_IN_STRING_INTERPOLATION, new Object[]{this.next()});
        }
        return builder.buildInterpolation();
    }

    private DartTypeNode parseReturnType() {
        if (this.peek(0) == Token.VOID) {
            return this.parseVoidType();
        }
        return this.parseTypeAnnotation();
    }

    private boolean isReturnType() {
        this.beginReturnType();
        if (this.optional(Token.VOID)) {
            this.done(null);
            return true;
        }
        if (!this.optional(Token.IDENTIFIER)) {
            this.rollback();
            return false;
        }
        if (this.optional(Token.PERIOD) && !this.optional(Token.IDENTIFIER)) {
            this.rollback();
            return false;
        }
        if (this.optional(Token.LT)) {
            int count = 1;
            block9: while (count > 0) {
                switch (this.next()) {
                    case EOS: {
                        this.rollback();
                        return false;
                    }
                    case LT: {
                        ++count;
                        continue block9;
                    }
                    case GT: {
                        --count;
                        continue block9;
                    }
                    case SHL: {
                        count += 2;
                        continue block9;
                    }
                    case SHR: {
                        count -= 3;
                        continue block9;
                    }
                    case SAR: {
                        count -= 2;
                        continue block9;
                    }
                    case COMMA: 
                    case IDENTIFIER: {
                        continue block9;
                    }
                }
                this.rollback();
                return false;
            }
            if (count < 0) {
                this.rollback();
                return false;
            }
        }
        this.done(null);
        return true;
    }

    @VisibleForTesting
    boolean looksLikeFunctionExpression() {
        if (!this.allowFunctionExpression) {
            return false;
        }
        return this.looksLikeFunctionDeclarationOrExpression();
    }

    private DartExpression parseFunctionExpressionWithReturnType() {
        this.beginFunctionLiteral();
        DartIdentifier[] namePtr = new DartIdentifier[1];
        DartFunction function = this.parseFunctionDeclarationOrExpression(namePtr, false);
        if (function == null) {
            this.rollback();
            return null;
        }
        return this.done(new DartFunctionExpression(namePtr[0], this.doneWithoutConsuming(function), false));
    }

    private DartFunction parseFunctionDeclarationOrExpression(DartIdentifier[] namePtr, boolean isDeclaration) {
        DartTypeNode returnType = null;
        namePtr[0] = null;
        switch (this.peek(0)) {
            case LPAREN: {
                break;
            }
            case IDENTIFIER: {
                if (this.peek(1) == Token.LPAREN) {
                    namePtr[0] = this.parseIdentifier();
                    break;
                }
            }
            case VOID: {
                returnType = this.parseReturnType();
                if (this.peek(0) != Token.IDENTIFIER) break;
                namePtr[0] = this.parseIdentifier();
                break;
            }
            default: {
                return null;
            }
        }
        List<DartParameter> params = this.parseFormalParameterList();
        DartBlock body = this.parseFunctionStatementBody(isDeclaration);
        DartFunction function = new DartFunction(params, body, returnType);
        this.doneWithoutConsuming(function);
        if (isDeclaration && namePtr[0] == null) {
            this.reportError(function, (ErrorCode)ParserErrorCode.MISSING_FUNCTION_NAME, new Object[0]);
        }
        return function;
    }

    private DartExpression parsePrimaryExpression() {
        if (this.looksLikeFunctionExpression()) {
            return this.parseFunctionExpressionWithReturnType();
        }
        switch (this.peek(0)) {
            case THIS: {
                this.beginThisExpression();
                this.consume(Token.THIS);
                return this.done(DartThisExpression.get());
            }
            case SUPER: {
                this.beginSuperExpression();
                this.consume(Token.SUPER);
                return this.done(this.parseAssignableSelector(this.doneWithoutConsuming(DartSuperExpression.get())));
            }
            case NEW: {
                this.beginNewExpression();
                this.consume(Token.NEW);
                return this.done(this.parseConstructorInvocation(false));
            }
            case CONST: {
                this.beginConstExpression();
                this.consume(Token.CONST);
                DartExpression literal = this.tryParseTypedCompoundLiteral(true);
                if (literal != null) {
                    return this.done(literal);
                }
                return this.done(this.parseConstructorInvocation(true));
            }
            case LPAREN: {
                this.beginParenthesizedExpression();
                this.consume(Token.LPAREN);
                this.beginExpression();
                boolean save = this.setAllowFunctionExpression(true);
                DartExpression expression = this.done(this.parseExpression());
                this.setAllowFunctionExpression(save);
                this.expectCloseParen();
                return this.done(new DartParenthesizedExpression(expression));
            }
            case LT: {
                this.beginLiteral();
                DartExpression literal = this.tryParseTypedCompoundLiteral(false);
                if (literal == null) {
                    this.reportError(this.position(), (ErrorCode)ParserErrorCode.EXPECTED_ARRAY_OR_MAP_LITERAL, new Object[0]);
                }
                return this.done(literal);
            }
            case STRING_SEGMENT: 
            case STRING_EMBED_EXP_START: 
            case STRING_LAST_SEGMENT: {
                return this.parseStringInterpolation();
            }
        }
        return this.parseLiteral();
    }

    private DartExpression parseConstructorInvocation(boolean isConst) {
        DartNode constructor;
        ArrayList<DartTypeNode> parts = new ArrayList<DartTypeNode>();
        this.beginConstructor();
        do {
            this.beginConstructorNamePart();
            parts.add(this.done(new DartTypeNode(this.parseIdentifier(), this.parseTypeArgumentsOpt())));
        } while (this.optional(Token.PERIOD));
        assert (parts.size() > 0);
        switch (parts.size()) {
            case 1: {
                constructor = (DartNode)this.doneWithoutConsuming(parts.get(0));
                break;
            }
            case 2: {
                boolean hasPrefix = false;
                DartTypeNode part1 = (DartTypeNode)parts.get(0);
                DartTypeNode part2 = (DartTypeNode)parts.get(1);
                if (this.prefixes.contains(((DartIdentifier)part1.getIdentifier()).getTargetName())) {
                    hasPrefix = true;
                }
                if (!part2.getTypeArguments().isEmpty()) {
                    hasPrefix = true;
                }
                if (hasPrefix) {
                    constructor = this.doneWithoutConsuming(this.toPrefixedType(parts));
                    break;
                }
                DartIdentifier identifier = this.ensureIdentifier(part2);
                constructor = this.doneWithoutConsuming(new DartPropertyAccess(this.doneWithoutConsuming(part1), identifier));
                break;
            }
            default: {
                if (parts.size() > 3) {
                    this.reportError((DartNode)parts.get(3), (ErrorCode)ParserErrorCode.EXPECTED_LEFT_PAREN, new Object[0]);
                }
                DartTypeNode typeNode = this.doneWithoutConsuming(this.toPrefixedType(parts));
                DartIdentifier identifier = this.ensureIdentifier((DartTypeNode)parts.get(2));
                constructor = this.doneWithoutConsuming(new DartPropertyAccess(typeNode, identifier));
                break;
            }
        }
        return this.done(new DartNewExpression(constructor, this.parseArguments(), isConst));
    }

    private DartIdentifier ensureIdentifier(DartTypeNode node) {
        List<DartTypeNode> typeArguments = node.getTypeArguments();
        if (!typeArguments.isEmpty()) {
            this.reportError(typeArguments.get(0), (ErrorCode)ParserErrorCode.UNEXPECTED_TYPE_ARGUMENT, new Object[0]);
        }
        return (DartIdentifier)node.getIdentifier();
    }

    private DartTypeNode toPrefixedType(List<DartTypeNode> parts) {
        DartIdentifier part1 = this.ensureIdentifier(parts.get(0));
        DartTypeNode part2 = parts.get(1);
        DartIdentifier identifier = (DartIdentifier)part2.getIdentifier();
        DartPropertyAccess access = this.doneWithoutConsuming(new DartPropertyAccess(part1, identifier));
        return new DartTypeNode(access, part2.getTypeArguments());
    }

    private DartExpression parseSelectorExpression(DartExpression receiver) {
        DartExpression expression = this.tryParseAssignableSelector(receiver);
        if (expression != null) {
            return expression;
        }
        if (this.peek(0) == Token.LPAREN) {
            this.beginSelectorExpression();
            boolean save = this.setAllowFunctionExpression(true);
            List<DartExpression> args = this.parseArguments();
            this.setAllowFunctionExpression(save);
            if (receiver instanceof DartIdentifier) {
                return this.done(new DartUnqualifiedInvocation((DartIdentifier)receiver, args));
            }
            return this.done(new DartFunctionObjectInvocation(receiver, args));
        }
        return receiver;
    }

    private DartExpression tryParseAssignableSelector(DartExpression receiver) {
        switch (this.peek(0)) {
            case PERIOD: {
                this.consume(Token.PERIOD);
                switch (this.peek(0)) {
                    case SEMICOLON: 
                    case RBRACE: {
                        this.reportError(this.position(), (ErrorCode)ParserErrorCode.EXPECTED_IDENTIFIER, new Object[0]);
                        DartIdentifier error = this.doneWithoutConsuming(new DartIdentifier(""));
                        return this.doneWithoutConsuming(new DartPropertyAccess(receiver, error));
                    }
                }
                DartIdentifier name = this.parseIdentifier();
                if (this.peek(0) == Token.LPAREN) {
                    boolean save = this.setAllowFunctionExpression(true);
                    DartMethodInvocation expr = this.doneWithoutConsuming(new DartMethodInvocation(receiver, name, this.parseArguments()));
                    this.setAllowFunctionExpression(save);
                    return expr;
                }
                return this.doneWithoutConsuming(new DartPropertyAccess(receiver, name));
            }
            case LBRACK: {
                this.consume(Token.LBRACK);
                DartExpression key = this.parseExpression();
                this.expect(Token.RBRACK);
                return this.doneWithoutConsuming(new DartArrayAccess(receiver, key));
            }
        }
        return null;
    }

    private DartExpression parseAssignableSelector(DartExpression receiver) {
        DartExpression expression = this.tryParseAssignableSelector(receiver);
        if (expression == null) {
            this.reportError(this.position(), (ErrorCode)ParserErrorCode.EXPECTED_PERIOD_OR_LEFT_BRACKET, new Object[0]);
            expression = receiver;
        }
        return expression;
    }

    private DartBlock parseBlock() {
        DartStatement newStatement;
        if (this.isDietParse) {
            this.expect(Token.LBRACE);
            DartBlock emptyBlock = new DartBlock(new ArrayList<DartStatement>());
            int nesting = 1;
            while (nesting > 0) {
                Token token = this.next();
                switch (token) {
                    case LBRACE: {
                        ++nesting;
                        break;
                    }
                    case RBRACE: {
                        --nesting;
                        break;
                    }
                    case EOS: {
                        return emptyBlock;
                    }
                }
            }
            return emptyBlock;
        }
        this.beginBlock();
        ArrayList<DartStatement> statements = new ArrayList<DartStatement>();
        this.expect(Token.LBRACE);
        while (!this.match(Token.RBRACE) && !this.EOS() && (newStatement = this.parseStatement()) != null) {
            statements.add(newStatement);
        }
        this.expectCloseBrace();
        return this.done(new DartBlock(statements));
    }

    private DartBlock parseFunctionStatementBody(boolean requireSemicolonForArrow) {
        if (this.isDietParse) {
            this.expect(Token.LBRACE);
            DartBlock emptyBlock = new DartBlock(new ArrayList<DartStatement>());
            int nesting = 1;
            while (nesting > 0) {
                Token token = this.next();
                switch (token) {
                    case LBRACE: {
                        ++nesting;
                        break;
                    }
                    case RBRACE: {
                        --nesting;
                        break;
                    }
                    case EOS: {
                        return emptyBlock;
                    }
                }
            }
            return emptyBlock;
        }
        this.beginFunctionStatementBody();
        if (this.optional(Token.ARROW)) {
            DartExpression expr = this.parseExpression();
            if (requireSemicolonForArrow) {
                this.expect(Token.SEMICOLON);
            }
            return this.done(this.makeReturnBlock(expr));
        }
        return this.done(this.parseBlock());
    }

    private DartBlock makeReturnBlock(DartExpression returnVal) {
        ArrayList<DartStatement> statements = new ArrayList<DartStatement>();
        statements.add(new DartReturnStatement(returnVal));
        return new DartBlock(statements);
    }

    private List<DartVariable> parseInitializedVariableList() {
        ArrayList<DartVariable> idents = new ArrayList<DartVariable>();
        do {
            this.beginVariableDeclaration();
            DartIdentifier name = this.parseIdentifier();
            DartExpression value = null;
            if (this.isParsingInterface) {
                this.expect(Token.ASSIGN);
                value = this.parseExpression();
            } else if (this.optional(Token.ASSIGN)) {
                value = this.parseExpression();
            }
            idents.add(this.done(new DartVariable(name, value)));
        } while (this.optional(Token.COMMA));
        return idents;
    }

    private DartBreakStatement parseBreakStatement() {
        this.beginBreakStatement();
        this.expect(Token.BREAK);
        DartIdentifier label = null;
        if (this.match(Token.IDENTIFIER)) {
            label = this.parseIdentifier();
        }
        this.expectStatmentTerminator();
        return this.done(new DartBreakStatement(label));
    }

    private DartContinueStatement parseContinueStatement() {
        this.beginContinueStatement();
        this.expect(Token.CONTINUE);
        DartIdentifier label = null;
        if (this.peek(0) == Token.IDENTIFIER) {
            label = this.parseIdentifier();
        }
        this.expectStatmentTerminator();
        return this.done(new DartContinueStatement(label));
    }

    private DartReturnStatement parseReturnStatement() {
        this.beginReturnStatement();
        this.expect(Token.RETURN);
        DartExpression value = null;
        if (this.peek(0) != Token.SEMICOLON) {
            value = this.parseExpression();
        }
        this.expectStatmentTerminator();
        return this.done(new DartReturnStatement(value));
    }

    private DartThrowStatement parseThrowStatement() {
        this.beginThrowStatement();
        this.expect(Token.THROW);
        DartExpression exception = null;
        if (this.peek(0) != Token.SEMICOLON) {
            exception = this.parseExpression();
        }
        this.expectStatmentTerminator();
        return this.done(new DartThrowStatement(exception));
    }

    @VisibleForTesting
    public DartStatement parseStatement() {
        if (this.peek(0) == Token.IDENTIFIER && this.peek(1) == Token.COLON) {
            this.beginLabel();
            DartIdentifier label = this.parseIdentifier();
            this.expect(Token.COLON);
            DartStatement statement = this.parseNonLabelledStatement();
            return this.done(new DartLabel(label, statement));
        }
        return this.parseNonLabelledStatement();
    }

    private DartStatement parseNonLabelledStatement() {
        if (this.looksLikeFunctionDeclarationOrExpression()) {
            return this.parseFunctionDeclaration();
        }
        switch (this.peek(0)) {
            case IF: {
                return this.parseIfStatement();
            }
            case SWITCH: {
                return this.parseSwitchStatement();
            }
            case WHILE: {
                return this.parseWhileStatement();
            }
            case DO: {
                return this.parseDoWhileStatement();
            }
            case FOR: {
                return this.parseForStatement();
            }
            case VAR: {
                this.beginVarDeclaration();
                this.consume(Token.VAR);
                List<DartVariable> vars = this.parseInitializedVariableList();
                this.expectStatmentTerminator();
                return this.done(new DartVariableStatement(vars, null));
            }
            case FINAL: {
                this.beginFinalDeclaration();
                this.consume(this.peek(0));
                DartTypeNode type = null;
                if (this.peek(1) == Token.IDENTIFIER || this.peek(1) == Token.LT) {
                    type = this.parseTypeAnnotation();
                }
                List<DartVariable> vars = this.parseInitializedVariableList();
                this.expectStatmentTerminator();
                return this.done(new DartVariableStatement(vars, type, Modifiers.NONE.makeFinal()));
            }
            case LBRACE: {
                return this.parseBlock();
            }
            case CONTINUE: {
                return this.parseContinueStatement();
            }
            case BREAK: {
                return this.parseBreakStatement();
            }
            case RETURN: {
                return this.parseReturnStatement();
            }
            case THROW: {
                return this.parseThrowStatement();
            }
            case TRY: {
                return this.parseTryStatement();
            }
            case SEMICOLON: {
                this.beginEmptyStatement();
                this.consume(Token.SEMICOLON);
                return this.done(new DartEmptyStatement());
            }
            case RBRACE: {
                this.beginEmptyStatement();
                return this.done(this.parseErrorStatement());
            }
            case IDENTIFIER: {
                if (this.peek(1) != Token.LT && this.peek(1) != Token.IDENTIFIER && (this.peek(1) != Token.PERIOD || this.peek(2) != Token.IDENTIFIER)) break;
                this.beginTypeFunctionOrVariable();
                DartTypeNode type = this.tryTypeAnnotation();
                if (type != null && this.peek(0) == Token.IDENTIFIER) {
                    List<DartVariable> vars = this.parseInitializedVariableList();
                    this.expect(Token.SEMICOLON);
                    return this.done(new DartVariableStatement(vars, type));
                }
                this.rollback();
            }
        }
        return this.parseExpressionStatement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean looksLikeFunctionDeclarationOrExpression() {
        this.beginMethodName();
        try {
            if (this.peek(0) == Token.IDENTIFIER && this.peek(1) == Token.LPAREN) {
                this.consume(Token.IDENTIFIER);
            } else if (this.isReturnType() && !this.optional(Token.IDENTIFIER)) {
                boolean bl = false;
                return bl;
            }
            if (!this.optional(Token.LPAREN)) {
                boolean bl = false;
                return bl;
            }
            int count = 1;
            while (count != 0) {
                switch (this.next()) {
                    case EOS: {
                        boolean bl = false;
                        return bl;
                    }
                    case LPAREN: {
                        ++count;
                        break;
                    }
                    case RPAREN: {
                        --count;
                    }
                }
            }
            boolean bl = this.peek(0) == Token.ARROW || this.peek(0) == Token.LBRACE;
            return bl;
        }
        finally {
            this.rollback();
        }
    }

    private DartStatement parseFunctionDeclaration() {
        this.beginFunctionDeclaration();
        DartIdentifier[] namePtr = new DartIdentifier[1];
        DartFunction function = this.parseFunctionDeclarationOrExpression(namePtr, true);
        return this.done(new DartExprStmt(this.doneWithoutConsuming(new DartFunctionExpression(namePtr[0], this.doneWithoutConsuming(function), true))));
    }

    private DartStatement parseExpressionStatement() {
        this.beginExpressionStatement();
        if (this.peek(1) == Token.LPAREN && this.optionalPseudoKeyword(ASSERT_KEYWORD)) {
            this.consume(Token.LPAREN);
            DartExpression expression = this.parseConditionalExpression();
            this.expectCloseParen();
            this.expectStatmentTerminator();
            return this.done(new DartAssertion(expression));
        }
        DartExpression expression = this.parseExpression();
        this.expectStatmentTerminator();
        return this.done(new DartExprStmt(expression));
    }

    private void expectCloseParen() {
        int parenCount = 1;
        switch (this.peek(0)) {
            case RPAREN: {
                this.expect(Token.RPAREN);
                return;
            }
            case LBRACE: 
            case SEMICOLON: 
            case EOS: {
                this.reportErrorWithoutAdvancing(ParserErrorCode.UNEXPECTED_TOKEN);
                return;
            }
            case LPAREN: {
                ++parenCount;
            }
        }
        this.reportErrorWithoutAdvancing(ParserErrorCode.UNEXPECTED_TOKEN);
        block11: while (parenCount > 0) {
            switch (this.peek(0)) {
                case RPAREN: {
                    this.expect(Token.RPAREN);
                    --parenCount;
                    continue block11;
                }
                case LPAREN: {
                    this.expect(Token.LPAREN);
                    ++parenCount;
                    continue block11;
                }
                case EOS: {
                    this.reportErrorWithoutAdvancing(ParserErrorCode.UNEXPECTED_TOKEN);
                    return;
                }
                case LBRACE: 
                case SEMICOLON: {
                    return;
                }
            }
            this.next();
        }
    }

    private void expectCloseBrace() {
        int braceCount = 1;
        switch (this.peek(0)) {
            case RBRACE: {
                this.expect(Token.RBRACE);
                return;
            }
            case SEMICOLON: 
            case EOS: {
                this.reportErrorWithoutAdvancing(ParserErrorCode.UNEXPECTED_TOKEN);
                return;
            }
            case LBRACE: {
                ++braceCount;
            }
        }
        this.reportErrorWithoutAdvancing(ParserErrorCode.UNEXPECTED_TOKEN);
        while (braceCount > 0) {
            switch (this.next()) {
                case RBRACE: {
                    --braceCount;
                    break;
                }
                case LBRACE: {
                    ++braceCount;
                    break;
                }
                case EOS: {
                    return;
                }
            }
        }
    }

    private DartStatement parseErrorStatement() {
        StringBuilder buf = new StringBuilder();
        boolean done = false;
        int braceCount = 1;
        while (!done) {
            buf.append(this.getPeekTokenValue(0));
            this.next();
            switch (this.peek(0)) {
                case RBRACE: {
                    if (--braceCount != 0) break;
                    done = true;
                    break;
                }
                case LBRACE: {
                    ++braceCount;
                    break;
                }
                case SEMICOLON: 
                case EOS: {
                    done = true;
                }
            }
        }
        return new DartSyntheticErrorStatement(buf.toString());
    }

    protected void expectStatmentTerminator() {
        Token token = this.peek(0);
        int braceCount = 1;
        switch (token) {
            case SEMICOLON: {
                this.expect(Token.SEMICOLON);
                return;
            }
            case RBRACE: 
            case EOS: {
                this.reportErrorWithoutAdvancing(ParserErrorCode.EXPECTED_SEMICOLON);
                return;
            }
            case LBRACE: {
                ++braceCount;
            }
        }
        this.expect(Token.SEMICOLON);
        block11: while (true) {
            switch (this.peek(0)) {
                case EOS: {
                    return;
                }
                case SEMICOLON: {
                    if (braceCount < 2) {
                        return;
                    }
                    this.next();
                    continue block11;
                }
                case RBRACE: {
                    if (--braceCount != 0) continue block11;
                    return;
                }
                case LBRACE: {
                    ++braceCount;
                }
            }
            this.next();
        }
    }

    private void reportErrorWithoutAdvancing(ErrorCode errCode) {
        this.startLookahead();
        Token actual = this.peek(0);
        this.next();
        this.reportError(this.position(), errCode, new Object[]{actual});
        this.rollback();
    }

    private DartWhileStatement parseWhileStatement() {
        this.beginWhileStatement();
        this.expect(Token.WHILE);
        this.expect(Token.LPAREN);
        DartExpression condition = this.parseExpression();
        this.expectCloseParen();
        DartStatement body = this.parseStatement();
        return this.done(new DartWhileStatement(condition, body));
    }

    private DartDoWhileStatement parseDoWhileStatement() {
        this.beginDoStatement();
        this.expect(Token.DO);
        DartStatement body = this.parseStatement();
        this.expect(Token.WHILE);
        this.expect(Token.LPAREN);
        DartExpression condition = this.parseExpression();
        this.expectCloseParen();
        this.expectStatmentTerminator();
        return this.done(new DartDoWhileStatement(condition, body));
    }

    private DartStatement parseForStatement() {
        this.beginForStatement();
        this.expect(Token.FOR);
        this.expect(Token.LPAREN);
        DartStatement setup = null;
        if (this.peek(0) != Token.SEMICOLON) {
            this.beginForInitialization();
            Modifiers modifiers = Modifiers.NONE;
            if (this.optional(Token.VAR)) {
                setup = this.done(new DartVariableStatement(this.parseInitializedVariableList(), null, modifiers));
            } else {
                if (this.optional(Token.FINAL)) {
                    modifiers = modifiers.makeFinal();
                }
                DartTypeNode type = this.peek(1) == Token.IDENTIFIER || this.peek(1) == Token.LT ? this.tryTypeAnnotation() : null;
                setup = modifiers.isFinal() || type != null ? (DartStatement)this.done(new DartVariableStatement(this.parseInitializedVariableList(), type, modifiers)) : (DartStatement)this.done(new DartExprStmt(this.parseExpression()));
            }
        }
        if (this.optional(Token.IN)) {
            if (setup instanceof DartVariableStatement) {
                DartExpression initializer;
                DartVariableStatement variableStatement = (DartVariableStatement)setup;
                List<DartVariable> variables = variableStatement.getVariables();
                if (variables.size() != 1) {
                    this.reportError(variables.get(1), (ErrorCode)ParserErrorCode.FOR_IN_WITH_MULTIPLE_VARIABLES, new Object[0]);
                }
                if ((initializer = variables.get(0).getValue()) != null) {
                    this.reportError(initializer, (ErrorCode)ParserErrorCode.FOR_IN_WITH_VARIABLE_INITIALIZER, new Object[0]);
                }
            } else {
                DartExpression expression = ((DartExprStmt)setup).getExpression();
                if (!(expression instanceof DartIdentifier)) {
                    this.reportError(setup, (ErrorCode)ParserErrorCode.FOR_IN_WITH_COMPLEX_VARIABLE, new Object[0]);
                }
            }
            DartExpression iterable = this.parseExpression();
            this.expectCloseParen();
            DartStatement body = this.parseStatement();
            return this.done(new DartForInStatement(setup, iterable, body));
        }
        if (this.optional(Token.SEMICOLON)) {
            DartExpression condition = null;
            if (this.peek(0) != Token.SEMICOLON) {
                condition = this.parseExpression();
            }
            this.expect(Token.SEMICOLON);
            DartExpression next = null;
            if (this.peek(0) != Token.RPAREN) {
                next = this.parseExpressionList();
            }
            this.expectCloseParen();
            DartStatement body = this.parseStatement();
            return this.done(new DartForStatement(setup, condition, next, body));
        }
        this.reportUnexpectedToken(this.position(), null, this.peek(0));
        return this.done(this.parseErrorStatement());
    }

    private DartIfStatement parseIfStatement() {
        this.beginIfStatement();
        this.expect(Token.IF);
        this.expect(Token.LPAREN);
        DartExpression condition = this.parseExpression();
        this.expectCloseParen();
        DartStatement yes = this.parseStatement();
        DartStatement no = null;
        if (this.optional(Token.ELSE)) {
            no = this.parseStatement();
        }
        return this.done(new DartIfStatement(condition, yes, no));
    }

    private List<DartStatement> parseCaseStatements() {
        ArrayList<DartStatement> statements = new ArrayList<DartStatement>();
        DartStatement statement = null;
        do {
            switch (this.peek(0)) {
                case RBRACE: 
                case EOS: 
                case CASE: 
                case DEFAULT: {
                    return statements;
                }
            }
            statement = this.parseStatement();
            if (statement == null) {
                return statements;
            }
            statements.add(statement);
        } while (!statement.isAbruptCompletingStatement());
        return statements;
    }

    private DartSwitchMember parseCaseMember(DartLabel label) {
        this.expect(Token.CASE);
        DartExpression caseExpr = this.parseExpression();
        this.expect(Token.COLON);
        return this.done(new DartCase(caseExpr, label, this.parseCaseStatements()));
    }

    private DartSwitchMember parseDefaultMember(DartLabel label) {
        this.expect(Token.DEFAULT);
        this.expect(Token.COLON);
        return this.done(new DartDefault(label, this.parseCaseStatements()));
    }

    private DartStatement parseSwitchStatement() {
        this.beginSwitchStatement();
        this.expect(Token.SWITCH);
        this.expect(Token.LPAREN);
        DartExpression expr = this.parseExpression();
        this.expectCloseParen();
        ArrayList<DartSwitchMember> members = new ArrayList<DartSwitchMember>();
        this.expect(Token.LBRACE);
        boolean done = this.optional(Token.RBRACE);
        while (!done) {
            DartLabel label = null;
            this.beginSwitchMember();
            if (this.peek(0) == Token.IDENTIFIER) {
                this.beginLabel();
                DartIdentifier identifier = this.parseIdentifier();
                this.expect(Token.COLON);
                label = this.done(new DartLabel(identifier, null));
            }
            if (this.peek(0) == Token.CASE) {
                members.add(this.parseCaseMember(label));
                continue;
            }
            if (this.optional(Token.RBRACE)) {
                if (label != null) {
                    this.reportError(this.position(), (ErrorCode)ParserErrorCode.EXPECTED_CASE_OR_DEFAULT, new Object[0]);
                }
                done = true;
                this.done(null);
                continue;
            }
            if (this.peek(0) != Token.EOS) {
                members.add(this.parseDefaultMember(label));
            }
            this.expectCloseBrace();
            done = true;
        }
        return this.done(new DartSwitchStatement(expr, members));
    }

    private DartParameter parseCatchParameter() {
        this.beginCatchParameter();
        DartTypeNode type = null;
        Modifiers modifiers = Modifiers.NONE;
        boolean isDeclared = false;
        if (this.optional(Token.VAR)) {
            isDeclared = true;
        } else {
            if (this.optional(Token.FINAL)) {
                modifiers = modifiers.makeFinal();
                isDeclared = true;
            }
            if (this.peek(1) != Token.COMMA && this.peek(1) != Token.RPAREN) {
                type = this.parseTypeAnnotation();
                isDeclared = true;
            }
        }
        DartIdentifier name = this.parseIdentifier();
        if (!isDeclared) {
            this.reportError(name, (ErrorCode)ParserErrorCode.EXPECTED_VAR_FINAL_OR_TYPE, new Object[0]);
        }
        return this.done(new DartParameter(name, type, null, null, modifiers));
    }

    private DartTryStatement parseTryStatement() {
        this.beginTryStatement();
        this.expect(Token.TRY);
        DartBlock tryBlock = this.parseBlock();
        ArrayList<DartCatchBlock> catches = new ArrayList<DartCatchBlock>();
        while (this.optional(Token.CATCH)) {
            this.beginCatchClause();
            this.expect(Token.LPAREN);
            DartParameter exception = this.parseCatchParameter();
            DartParameter stackTrace = null;
            if (this.optional(Token.COMMA)) {
                stackTrace = this.parseCatchParameter();
            }
            this.expectCloseParen();
            DartBlock block = this.parseBlock();
            catches.add(this.done(new DartCatchBlock(block, exception, stackTrace)));
        }
        DartBlock finallyBlock = null;
        if (this.optional(Token.FINALLY)) {
            finallyBlock = this.parseBlock();
        }
        if (catches.size() == 0 && finallyBlock == null) {
            this.reportError(new DartCompilationError(tryBlock.getSource(), new DartScanner.Location(this.position()), ParserErrorCode.CATCH_OR_FINALLY_EXPECTED, new Object[0]));
        }
        return this.done(new DartTryStatement(tryBlock, catches, finallyBlock));
    }

    private DartExpression parseUnaryExpression() {
        this.optional(Token.ADD);
        Token token = this.peek(0);
        if (token.isUnaryOperator() || token == Token.SUB) {
            this.beginUnaryExpression();
            this.consume(token);
            DartExpression unary = this.parseUnaryExpression();
            if (token.isCountOperator()) {
                this.ensureAssignable(unary);
            }
            return this.done(new DartUnaryExpression(token, unary, true));
        }
        return this.parsePostfixExpression();
    }

    private DartTypeNode parseTypeAnnotation() {
        this.beginTypeAnnotation();
        return this.done(new DartTypeNode(this.parseQualified(), this.parseTypeArgumentsOpt()));
    }

    private List<DartTypeNode> parseTypeArguments() {
        this.consume(Token.LT);
        ArrayList<DartTypeNode> arguments = new ArrayList<DartTypeNode>();
        do {
            arguments.add(this.parseTypeAnnotation());
        } while (this.optional(Token.COMMA));
        if (!this.tryParameterizedTypeEnd()) {
            this.expect(Token.GT);
        }
        return arguments;
    }

    private List<DartTypeNode> parseTypeArgumentsOpt() {
        return this.peek(0) == Token.LT ? this.parseTypeArguments() : Collections.emptyList();
    }

    private DartExpression parseQualified() {
        this.beginQualifiedIdentifier();
        DartExpression qualified = this.parseIdentifier();
        if (this.optional(Token.PERIOD)) {
            qualified = new DartPropertyAccess(qualified, this.parseIdentifier());
        }
        return this.done(qualified);
    }

    private boolean tryParameterizedTypeEnd() {
        switch (this.peek(0)) {
            case GT: {
                this.consume(Token.GT);
                return true;
            }
            case SAR: {
                this.setPeek(0, Token.GT);
                return true;
            }
            case SHR: {
                this.setPeek(0, Token.SAR);
                return true;
            }
        }
        return false;
    }

    private DartTypeNode tryTypeAnnotation() {
        if (this.peek(0) != Token.IDENTIFIER) {
            return null;
        }
        ArrayList<DartTypeNode> typeArguments = new ArrayList<DartTypeNode>();
        this.beginTypeAnnotation();
        DartExpression qualified = this.parseQualified();
        if (this.optional(Token.LT)) {
            DartTypeNode argument;
            if (this.peek(0) != Token.IDENTIFIER) {
                this.rollback();
                return null;
            }
            this.beginTypeArguments();
            DartExpression qualified2 = this.parseQualified();
            switch (this.peek(0)) {
                case LT: {
                    argument = this.done(new DartTypeNode(qualified2, this.parseTypeArguments()));
                    break;
                }
                case GT: 
                case SAR: 
                case SHR: 
                case COMMA: {
                    argument = this.done(new DartTypeNode(qualified2, Collections.<DartTypeNode>emptyList()));
                    break;
                }
                default: {
                    this.done(null);
                    this.rollback();
                    return null;
                }
            }
            typeArguments.add(argument);
            while (this.optional(Token.COMMA)) {
                typeArguments.add(this.parseTypeAnnotation());
            }
            if (!this.tryParameterizedTypeEnd()) {
                this.expect(Token.GT);
            }
        }
        return this.done(new DartTypeNode(qualified, typeArguments));
    }

    private DartIdentifier parseIdentifier() {
        this.beginIdentifier();
        this.expect(Token.IDENTIFIER);
        String token = this.ctx.getTokenString();
        return this.done(new DartIdentifier(token != null ? token : ""));
    }

    public DartExpression parseEntryPoint() {
        this.beginEntryPoint();
        DartExpression entry = this.parseIdentifier();
        while (!this.EOS()) {
            this.expect(Token.PERIOD);
            entry = this.doneWithoutConsuming(new DartPropertyAccess(entry, this.parseIdentifier()));
        }
        return this.done(entry);
    }

    private void ensureAssignable(DartExpression expression) {
        if (expression != null && !expression.isAssignable()) {
            this.reportError(this.position(), (ErrorCode)ParserErrorCode.ILLEGAL_ASSIGNMENT_TO_NON_ASSIGNABLE, new Object[0]);
        }
    }

    private void reportError(DartCompilationError dartError) {
        if (this.errorHistory.size() <= 100 && !this.errorHistory.contains(dartError.hashCode())) {
            this.ctx.error(dartError);
            this.errorHistory.add(dartError.hashCode());
        }
    }

    private void reportError(DartNode node, ErrorCode errorCode, Object ... arguments) {
        this.reportError(new DartCompilationError(node, errorCode, arguments));
    }

    private boolean currentlyParsingToplevel() {
        return !this.isParsingInterface && !this.isTopLevelAbstract && !this.isParsingClass;
    }

    private class DartStringInterpolationBuilder {
        private List<DartStringLiteral> strings = new ArrayList<DartStringLiteral>();
        private List<DartExpression> expressions = new ArrayList<DartExpression>();
        private LastSeenNode lastSeen = LastSeenNode.NONE;

        DartStringInterpolationBuilder() {
        }

        void addString(DartStringLiteral string) {
            if (this.lastSeen == LastSeenNode.STRING) {
                this.expressions.add(new DartSyntheticErrorExpression());
            }
            this.strings.add(string);
            this.lastSeen = LastSeenNode.STRING;
        }

        void addExpression(DartExpression expression) {
            switch (this.lastSeen) {
                case EXPRESSION: 
                case NONE: {
                    this.strings.add(DartStringLiteral.get(""));
                    break;
                }
            }
            this.expressions.add(expression);
            this.lastSeen = LastSeenNode.EXPRESSION;
        }

        DartStringInterpolation buildInterpolation() {
            if (this.strings.size() == this.expressions.size()) {
                this.strings.add(DartStringLiteral.get(""));
            }
            return new DartStringInterpolation(this.strings, this.expressions);
        }
    }

    private static enum LastSeenNode {
        NONE,
        STRING,
        EXPRESSION;

    }
}

