/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.parser;

import com.google.dart.compiler.parser.AbstractParser;
import com.google.dart.compiler.parser.ParserContext;

public abstract class CompletionHooksParserBase
extends AbstractParser {
    private TerminationGuard guard = new TerminationGuard();

    public CompletionHooksParserBase(ParserContext ctx) {
        super(ctx);
    }

    protected void beginArrayLiteral() {
        this.begin();
    }

    protected void beginBinaryExpression() {
        this.begin();
    }

    protected void beginBlock() {
        this.begin();
    }

    protected void beginBreakStatement() {
        this.begin();
    }

    protected void beginCatchClause() {
        this.begin();
    }

    protected void beginCatchParameter() {
        this.begin();
    }

    protected void beginClassBody() {
        this.begin();
    }

    protected void beginClassMember() {
        this.begin();
    }

    protected void beginCompilationUnit() {
        this.begin();
    }

    protected void beginConditionalExpression() {
        this.begin();
    }

    protected void beginConstExpression() {
        this.begin();
    }

    protected void beginConstructor() {
        this.begin();
    }

    protected void beginConstructorNamePart() {
        this.begin();
    }

    protected void beginContinueStatement() {
        this.begin();
    }

    protected void beginDoStatement() {
        this.begin();
    }

    protected void beginEmptyStatement() {
        this.begin();
    }

    protected void beginEntryPoint() {
        this.begin();
    }

    protected void beginExpression() {
        this.begin();
    }

    protected void beginExpressionList() {
        this.begin();
    }

    protected void beginExpressionStatement() {
        this.begin();
    }

    protected void beginFieldInitializerOrRedirectedConstructor() {
        this.begin();
    }

    protected void beginFinalDeclaration() {
        this.begin();
    }

    protected void beginForInitialization() {
        this.begin();
    }

    protected void beginFormalParameter() {
        this.begin();
    }

    protected void beginFormalParameterList() {
        this.begin();
    }

    protected void beginForStatement() {
        this.begin();
    }

    protected void beginFunctionDeclaration() {
        this.begin();
    }

    protected void beginFunctionLiteral() {
        this.begin();
    }

    protected void beginFunctionStatementBody() {
        this.begin();
    }

    protected void beginFunctionTypeInterface() {
        this.begin();
    }

    protected void beginIdentifier() {
        this.begin();
    }

    protected void beginIfStatement() {
        this.begin();
    }

    protected void beginImportDirective() {
        this.begin();
    }

    protected void beginInitializer() {
        this.begin();
    }

    protected void beginTypeExpression() {
        this.begin();
    }

    protected void beginLabel() {
        this.begin();
    }

    protected void beginLibraryDirective() {
        this.begin();
    }

    protected void beginLiteral() {
        this.begin();
    }

    protected void beginMapLiteral() {
        this.begin();
    }

    protected void beginMapLiteralEntry() {
        this.begin();
    }

    protected void beginMethodName() {
        this.begin();
    }

    protected void beginNativeBody() {
        this.begin();
    }

    protected void beginNativeDirective() {
        this.begin();
    }

    protected void beginNewExpression() {
        this.begin();
    }

    protected void beginOperatorName() {
        this.begin();
    }

    protected void beginParameter() {
        this.begin();
    }

    protected void beginParameterName() {
        this.begin();
    }

    protected void beginParenthesizedExpression() {
        this.begin();
    }

    protected void beginPostfixExpression() {
        this.begin();
    }

    protected void beginQualifiedIdentifier() {
        this.begin();
    }

    protected void beginResourceDirective() {
        this.begin();
    }

    protected void beginReturnStatement() {
        this.begin();
    }

    protected void beginReturnType() {
        this.begin();
    }

    protected void beginSelectorExpression() {
        this.begin();
    }

    protected void beginSourceDirective() {
        this.begin();
    }

    protected void beginSpreadExpression() {
        this.begin();
    }

    protected void beginStringInterpolation() {
        this.begin();
    }

    protected void beginStringSegment() {
        this.begin();
    }

    protected void beginSuperExpression() {
        this.begin();
    }

    protected void beginSuperInitializer() {
        this.begin();
    }

    protected void beginSwitchMember() {
        this.begin();
    }

    protected void beginSwitchStatement() {
        this.begin();
    }

    protected void beginThisExpression() {
        this.begin();
    }

    protected void beginThrowStatement() {
        this.begin();
    }

    protected void beginTopLevelElement() {
        this.begin();
    }

    protected void beginTryStatement() {
        this.begin();
    }

    protected void beginTypeAnnotation() {
        this.begin();
    }

    protected void beginTypeArguments() {
        this.begin();
    }

    protected void beginTypeFunctionOrVariable() {
        this.begin();
    }

    protected void beginTypeParameter() {
        this.begin();
    }

    protected void beginUnaryExpression() {
        this.begin();
    }

    protected void beginVarDeclaration() {
        this.begin();
    }

    protected void beginVariableDeclaration() {
        this.begin();
    }

    protected void beginWhileStatement() {
        this.begin();
    }

    protected <T> T done(T result) {
        return this.ctx.done(result);
    }

    protected <T> T doneWithoutConsuming(T result) {
        return this.ctx.doneWithoutConsuming(result);
    }

    protected void rollback() {
        this.ctx.rollback();
    }

    protected void startLookahead() {
        this.begin();
    }

    private void begin() {
        assert (this.guard.assertProgress());
        this.ctx.begin();
    }

    private class TerminationGuard {
        private static final int THRESHOLD = 100;
        private int maxPositionRange = Integer.MIN_VALUE;
        private int minPositionRange = Integer.MAX_VALUE;
        private int threshold = 100;

        private TerminationGuard() {
        }

        public boolean assertProgress() {
            int currentPosition = CompletionHooksParserBase.this.position().getPos();
            if (currentPosition > this.maxPositionRange) {
                this.minPositionRange = this.maxPositionRange;
                this.maxPositionRange = currentPosition;
                this.threshold = 100;
            } else if (currentPosition < this.minPositionRange) {
                this.minPositionRange = currentPosition;
                this.threshold = 100;
            }
            if (this.threshold-- <= 0) {
                StringBuilder sb = new StringBuilder();
                sb.append("Parser failed to make progress after many tries. File a bug and attach this callstack and error output.\n");
                sb.append("Scanner State: ");
                sb.append(CompletionHooksParserBase.this.ctx.toString());
                sb.append("\n");
                sb.append("Input range [");
                sb.append(this.minPositionRange);
                sb.append(",");
                sb.append(this.maxPositionRange);
                sb.append("]\n");
                throw new AssertionError((Object)sb.toString());
            }
            return true;
        }
    }
}

