/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.parser;

import com.google.dart.compiler.DartCompilerListener;
import com.google.dart.compiler.DartSource;
import com.google.dart.compiler.Source;
import com.google.dart.compiler.ast.DartComment;
import com.google.dart.compiler.ast.DartDeclaration;
import com.google.dart.compiler.ast.DartNode;
import com.google.dart.compiler.ast.DartNodeTraverser;
import com.google.dart.compiler.ast.DartUnit;
import com.google.dart.compiler.metrics.CompilerMetrics;
import com.google.dart.compiler.parser.DartParser;
import com.google.dart.compiler.parser.DartScanner;
import com.google.dart.compiler.parser.DartScannerParserContext;
import com.google.dart.compiler.parser.ParserContext;
import com.google.dart.compiler.util.DartSourceString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class CommentPreservingParser
extends DartParser {
    private CommentParserContext context;
    private boolean onlyDartDoc;

    public static CommentParserContext createContext(Source source, String code, DartCompilerListener listener) {
        return new CommentParserContext(source, code, listener);
    }

    public static CommentParserContext createContext(Source source, String code, DartCompilerListener listener, CompilerMetrics metrics) {
        return new CommentParserContext(source, code, listener, metrics);
    }

    public CommentPreservingParser(String code) {
        this(code, null, false);
    }

    public CommentPreservingParser(String code, DartCompilerListener listener, boolean onlyDartDoc) {
        this((ParserContext)CommentPreservingParser.createContext(null, code, listener), onlyDartDoc);
    }

    public CommentPreservingParser(ParserContext context, boolean onlyDartDoc) {
        super(context, onlyDartDoc);
        this.context = (CommentParserContext)context;
        this.onlyDartDoc = onlyDartDoc;
    }

    @Override
    public DartUnit parseUnit(DartSource input) {
        DartUnit unit = super.parseUnit(input);
        String sourceString = this.context.source;
        DartSourceString source = new DartSourceString(null, sourceString);
        for (int[] loc : this.context.getCommentLocs()) {
            DartComment.Style style = this.getCommentStyle(sourceString, loc[0]);
            if (this.onlyDartDoc && style != DartComment.Style.DART_DOC) continue;
            unit.addComment(new DartComment(source, loc[0], loc[1] - loc[0], loc[2], loc[3], style));
        }
        List<DartComment> comments = unit.getComments();
        if (comments != null) {
            this.assignDartComments(unit, comments);
        }
        return unit;
    }

    private void assignDartComments(DartUnit unit, List<DartComment> comments) {
        final ArrayList astNodes = new ArrayList();
        unit.accept(new DartNodeTraverser<DartNode>(){

            @Override
            public DartNode visitDeclaration(DartDeclaration<?> node) {
                astNodes.add(node);
                return (DartNode)super.visitNode(node);
            }
        });
        ArrayList<DartComment> nodes = new ArrayList<DartComment>();
        nodes.addAll(comments);
        nodes.addAll(astNodes);
        Collections.sort(nodes, new Comparator<DartNode>(){

            @Override
            public int compare(DartNode node1, DartNode node2) {
                return node1.getSourceStart() - node2.getSourceStart();
            }
        });
        for (int i = 0; i < nodes.size(); ++i) {
            DartDeclaration decl;
            DartNode next;
            DartComment comment;
            DartNode node = (DartNode)nodes.get(i);
            if (!(node instanceof DartComment) || !(comment = (DartComment)node).isDartDoc() || i + 1 >= nodes.size() || !((next = (DartNode)nodes.get(i + 1)) instanceof DartDeclaration) || this.commentContainedBySibling(comment, decl = (DartDeclaration)next)) continue;
            decl.setDartDoc(comment);
        }
    }

    private boolean commentContainedBySibling(DartComment comment, DartDeclaration<?> node) {
        for (DartNode child : this.getChildren(node.getParent())) {
            if (child == node || child instanceof DartComment || !this.isContainedBy(comment, child)) continue;
            return true;
        }
        return false;
    }

    private List<DartNode> getChildren(DartNode parent) {
        final ArrayList<DartNode> children = new ArrayList<DartNode>();
        parent.visitChildren(new DartNodeTraverser<DartNode>(){

            @Override
            public DartNode visitNode(DartNode node) {
                children.add(node);
                return null;
            }
        });
        return children;
    }

    private boolean isContainedBy(DartNode node, DartNode containedByNode) {
        int nodeEnd = node.getSourceStart() + node.getSourceLength();
        int containedByEnd = containedByNode.getSourceStart() + containedByNode.getSourceLength();
        return node.getSourceStart() >= containedByNode.getSourceStart() && nodeEnd <= containedByEnd;
    }

    private DartComment.Style getCommentStyle(String sourceString, int commentStart) {
        if (sourceString.charAt(commentStart + 1) == '/') {
            return DartComment.Style.END_OF_LINE;
        }
        if (sourceString.charAt(commentStart + 2) == '*') {
            return DartComment.Style.DART_DOC;
        }
        return DartComment.Style.BLOCK;
    }

    private static class CommentParserContext
    extends DartScannerParserContext {
        private List<int[]> commentLocs;
        private String source;

        CommentParserContext(Source source, String code, DartCompilerListener listener) {
            super(source, code, listener);
            this.source = code;
        }

        CommentParserContext(Source source, String code, DartCompilerListener listener, CompilerMetrics metrics) {
            super(source, code, listener, metrics);
            this.source = code;
        }

        List<int[]> getCommentLocs() {
            return this.commentLocs;
        }

        @Override
        protected DartScanner createScanner(String sourceCode) {
            this.commentLocs = new ArrayList<int[]>();
            return new CommentScanner(sourceCode);
        }

        private class CommentScanner
        extends DartScanner {
            CommentScanner(String sourceCode) {
                super(sourceCode);
            }

            @Override
            protected void recordCommentLocation(int start, int stop, int line, int col) {
                int[] loc;
                int size = CommentParserContext.this.commentLocs.size();
                if (size > 0 && start <= (loc = (int[])CommentParserContext.this.commentLocs.get(size - 1))[0] && stop <= loc[1]) {
                    return;
                }
                CommentParserContext.this.commentLocs.add(new int[]{start, stop, line, col});
            }
        }
    }
}

