/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.compiler.common;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MapMaker;
import com.google.dart.compiler.common.Name;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.concurrent.ConcurrentMap;

final class NameFactory {
    private final ConcurrentMap<Object, RealKey> map = new MapMaker().makeMap();
    private final ReferenceQueue<Name> queue = new ReferenceQueue();

    NameFactory() {
    }

    public Name of(char[] data) {
        this.cleanUp();
        int hashCode = Name.computeHashCode(data, 0, data.length);
        FakeKey fakeKey = new FakeKey(data, hashCode);
        Name result = this.get(fakeKey);
        if (result == null) {
            result = this.put(new Name(data, hashCode));
        }
        return result;
    }

    public Name of(char[] data, int offset, int length) {
        this.cleanUp();
        int hashCode = Name.computeHashCode(data, offset, length);
        FakeKey fakeKey = new FakeKey(data, offset, length, hashCode);
        Name result = this.get(fakeKey);
        if (result == null) {
            char[] copy = new char[length];
            System.arraycopy(data, offset, copy, 0, length);
            result = this.put(new Name(copy, hashCode));
        }
        return result;
    }

    @VisibleForTesting
    void cleanUp() {
        RealKey item;
        while ((item = (RealKey)this.queue.poll()) != null) {
            this.map.remove(item);
        }
    }

    @VisibleForTesting
    WeakReference<Name> getRefFor(Name name) {
        return (WeakReference)this.map.get(new FakeKey(name.data, name.hashCode()));
    }

    @VisibleForTesting
    int numEntries() {
        return this.map.size();
    }

    private Name get(FakeKey fakeKey) {
        RealKey realKey = (RealKey)this.map.get(fakeKey);
        if (realKey != null) {
            return (Name)realKey.get();
        }
        return null;
    }

    private Name put(Name name) {
        RealKey sneakyRef;
        Name canonical;
        RealKey realKey = new RealKey(name, this.queue);
        do {
            if ((sneakyRef = this.map.putIfAbsent(realKey, realKey)) != null) continue;
            return name;
        } while ((canonical = (Name)sneakyRef.get()) == null);
        return canonical;
    }

    private static final class RealKey
    extends WeakReference<Name> {
        private final int hashCode;

        public RealKey(Name name, ReferenceQueue<Name> queue) {
            super(name, queue);
            this.hashCode = name.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof FakeKey) {
                Name referent = (Name)this.get();
                if (referent == null) {
                    return false;
                }
                return ((FakeKey)obj).equalsName(referent);
            }
            if (obj instanceof RealKey) {
                Name referent = (Name)this.get();
                if (referent == null) {
                    return false;
                }
                Name otherReferent = (Name)((RealKey)obj).get();
                if (otherReferent == null) {
                    return false;
                }
                return Arrays.equals(referent.data, otherReferent.data);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            Name referent = (Name)this.get();
            return "RealKey(" + referent + ")";
        }
    }

    private static final class FakeKey {
        private final char[] data;
        private final int hashCode;
        private final int length;
        private final int offset;

        public FakeKey(char[] data, int hashCode) {
            this(data, 0, data.length, hashCode);
        }

        public FakeKey(char[] data, int offset, int length, int hashCode) {
            this.data = data;
            this.offset = offset;
            this.length = length;
            this.hashCode = hashCode;
        }

        public boolean equals(Object obj) {
            Name name = (Name)((RealKey)obj).get();
            if (name == null) {
                return false;
            }
            return this.equalsName(name);
        }

        public boolean equalsName(Name name) {
            if (this.length != name.data.length) {
                return false;
            }
            int itMine = this.offset;
            int itTheirs = 0;
            int endMine = this.offset + this.length;
            while (itMine < endMine) {
                if (this.data[itMine++] == name.data[itTheirs++]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "FakeKey(" + String.valueOf(this.data, this.offset, this.length) + ")";
        }
    }
}

